/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DateColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateAddScalarCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffScalarCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateSubColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateSubColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateSubScalarCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorGenericDateExpressions {
    private Charset utf8 = StandardCharsets.UTF_8;
    private HiveConf hiveConf = new HiveConf();
    private int size = 200;
    private Random random = new Random();
    private SimpleDateFormat formatter = TestVectorGenericDateExpressions.getFormatter();
    private List<PrimitiveObjectInspector.PrimitiveCategory> dateTimestampStringTypes = Arrays.asList(PrimitiveObjectInspector.PrimitiveCategory.DATE, PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, PrimitiveObjectInspector.PrimitiveCategory.STRING);

    private static SimpleDateFormat getFormatter() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter;
    }

    private long newRandom(int i) {
        return this.random.nextInt(i);
    }

    private LongColumnVector newRandomLongColumnVector(int range, int size) {
        LongColumnVector vector = new LongColumnVector(size);
        for (int i = 0; i < size; ++i) {
            vector.vector[i] = this.random.nextInt(range);
        }
        return vector;
    }

    private TypeInfo primitiveCategoryToTypeInfo(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case DATE: {
                return TypeInfoFactory.dateTypeInfo;
            }
            case STRING: {
                return TypeInfoFactory.stringTypeInfo;
            }
            case TIMESTAMP: {
                return TypeInfoFactory.timestampTypeInfo;
            }
        }
        throw new RuntimeException("Unexpected primitive category " + primitiveCategory);
    }

    private TimestampColumnVector toTimestamp(LongColumnVector date) {
        TimestampColumnVector vector = new TimestampColumnVector(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (date.isNull[i]) {
                vector.isNull[i] = true;
                vector.noNulls = false;
                continue;
            }
            vector.set(i, this.toTimestamp(date.vector[i]));
        }
        return vector;
    }

    private Timestamp toTimestamp(long date) {
        return new Timestamp(DateWritableV2.daysToMillis((int)((int)date)));
    }

    private BytesColumnVector toString(LongColumnVector date) {
        BytesColumnVector bcv = new BytesColumnVector(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (date.isNull[i]) {
                bcv.isNull[i] = true;
                bcv.noNulls = false;
                continue;
            }
            bcv.vector[i] = this.toString(date.vector[i]);
            bcv.start[i] = 0;
            bcv.length[i] = bcv.vector[i].length;
        }
        return bcv;
    }

    private byte[] toString(long date) {
        String formatted = this.formatter.format(new Date(DateWritableV2.daysToMillis((int)((int)date))));
        return formatted.getBytes(this.utf8);
    }

    private void validateDateAdd(VectorizedRowBatch batch, PrimitiveObjectInspector.PrimitiveCategory colType1, long scalar2, boolean isPositive, LongColumnVector date1) throws HiveException {
        Object udf = isPositive ? new VectorUDFDateAddColScalar(0, scalar2, 1) : new VectorUDFDateSubColScalar(0, scalar2, 1);
        udf.setInputTypeInfos(new TypeInfo[]{this.primitiveCategoryToTypeInfo(colType1), TypeInfoFactory.voidTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[1];
        try {
            for (int i = 0; i < this.size; ++i) {
                String expected = isPositive ? new String(this.toString(date1.vector[i] + scalar2), this.utf8) : new String(this.toString(date1.vector[i] - scalar2), this.utf8);
                if (date1.isNull[i]) {
                    Assert.assertTrue((boolean)output.isNull[i]);
                    continue;
                }
                String actual = new String(this.toString(output.vector[i]));
                Assert.assertEquals((String)("expectedLen:" + expected.length() + " actualLen:" + actual.length()), (Object)expected, (Object)actual);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ColumnVector castTo(LongColumnVector date, PrimitiveObjectInspector.PrimitiveCategory type) {
        switch (type) {
            case DATE: {
                return date;
            }
            case TIMESTAMP: {
                return this.toTimestamp(date);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return this.toString(date);
            }
        }
        throw new Error("Unsupported input type " + type.name());
    }

    private void testDateAddColScalar(PrimitiveObjectInspector.PrimitiveCategory colType1, boolean isPositive) throws HiveException {
        LongColumnVector date1 = this.newRandomLongColumnVector(10000, this.size);
        ColumnVector col1 = this.castTo(date1, colType1);
        long scalar2 = this.newRandom(1000);
        LongColumnVector output = new LongColumnVector(this.size);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
        batch.cols[0] = col1;
        batch.cols[1] = output;
        this.validateDateAdd(batch, colType1, scalar2, isPositive, date1);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.validateDateAdd(batch, colType1, scalar2, isPositive, date1);
    }

    @Test
    public void testDateAddColScalar() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory colType1 : this.dateTimestampStringTypes) {
            this.testDateAddColScalar(colType1, true);
        }
        VectorUDFDateAddColScalar udf = new VectorUDFDateAddColScalar(0, 0L, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo, TypeInfoFactory.timestampTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        byte[] bytes = "error".getBytes(this.utf8);
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    @Test
    public void testDateSubColScalar() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory colType1 : this.dateTimestampStringTypes) {
            this.testDateAddColScalar(colType1, false);
        }
        VectorUDFDateSubColScalar udf = new VectorUDFDateSubColScalar(0, 0L, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo, TypeInfoFactory.timestampTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        byte[] bytes = "error".getBytes(this.utf8);
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    private void validateDateAdd(VectorizedRowBatch batch, long scalar1, LongColumnVector date2, PrimitiveObjectInspector.PrimitiveCategory colType1, boolean isPositive) throws HiveException {
        VectorUDFDateAddScalarCol udf;
        block15: {
            block14: {
                udf = null;
                if (!isPositive) break block14;
                switch (colType1) {
                    case DATE: {
                        udf = new VectorUDFDateAddScalarCol((Object)scalar1, 0, 1);
                        break block15;
                    }
                    case TIMESTAMP: {
                        udf = new VectorUDFDateAddScalarCol((Object)this.toTimestamp(scalar1), 0, 1);
                        break block15;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        udf = new VectorUDFDateAddScalarCol((Object)this.toString(scalar1), 0, 1);
                        break block15;
                    }
                    default: {
                        throw new Error("Invalid input type: " + colType1.name());
                    }
                }
            }
            switch (colType1) {
                case DATE: {
                    udf = new VectorUDFDateSubScalarCol((Object)scalar1, 0, 1);
                    break;
                }
                case TIMESTAMP: {
                    udf = new VectorUDFDateSubScalarCol((Object)this.toTimestamp(scalar1), 0, 1);
                    break;
                }
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    udf = new VectorUDFDateSubScalarCol((Object)this.toString(scalar1), 0, 1);
                    break;
                }
                default: {
                    throw new Error("Invalid input type: " + colType1.name());
                }
            }
        }
        udf.setInputTypeInfos(new TypeInfo[]{this.primitiveCategoryToTypeInfo(colType1), TypeInfoFactory.voidTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[1];
        try {
            for (int i = 0; i < date2.vector.length; ++i) {
                String expected = isPositive ? new String(this.toString(scalar1 + date2.vector[i]), this.utf8) : new String(this.toString(scalar1 - date2.vector[i]), this.utf8);
                if (date2.isNull[i]) {
                    Assert.assertTrue((boolean)output.isNull[i]);
                    continue;
                }
                Assert.assertEquals((Object)expected, (Object)new String(this.toString(output.vector[i])));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void testDateAddScalarCol(PrimitiveObjectInspector.PrimitiveCategory colType1, boolean isPositive) throws HiveException {
        LongColumnVector date2 = this.newRandomLongColumnVector(10000, this.size);
        long scalar1 = this.newRandom(1000);
        LongColumnVector output = new LongColumnVector(this.size);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
        batch.cols[0] = date2;
        batch.cols[1] = output;
        this.validateDateAdd(batch, scalar1, date2, colType1, isPositive);
        TestVectorizedRowBatch.addRandomNulls((ColumnVector)date2);
        batch.cols[0] = date2;
        this.validateDateAdd(batch, scalar1, date2, colType1, isPositive);
    }

    @Test
    public void testDateAddScalarCol() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory scalarType1 : this.dateTimestampStringTypes) {
            this.testDateAddScalarCol(scalarType1, true);
        }
        VectorUDFDateAddScalarCol udf = new VectorUDFDateAddScalarCol((Object)"error".getBytes(this.utf8), 0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo, TypeInfoFactory.timestampTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new LongColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    @Test
    public void testDateSubScalarCol() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory scalarType1 : this.dateTimestampStringTypes) {
            this.testDateAddScalarCol(scalarType1, false);
        }
        VectorUDFDateSubScalarCol udf = new VectorUDFDateSubScalarCol((Object)"error".getBytes(this.utf8), 0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo, TypeInfoFactory.timestampTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new LongColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    private void validateDateAdd(VectorizedRowBatch batch, LongColumnVector date1, LongColumnVector date2, PrimitiveObjectInspector.PrimitiveCategory colType1, boolean isPositive) throws HiveException {
        Object udf = isPositive ? new VectorUDFDateAddColCol(0, 1, 2) : new VectorUDFDateSubColCol(0, 1, 2);
        udf.setInputTypeInfos(new TypeInfo[]{this.primitiveCategoryToTypeInfo(colType1), TypeInfoFactory.voidTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[2];
        try {
            for (int i = 0; i < date2.vector.length; ++i) {
                String expected = isPositive ? new String(this.toString(date1.vector[i] + date2.vector[i]), this.utf8) : new String(this.toString(date1.vector[i] - date2.vector[i]), this.utf8);
                if (date1.isNull[i] || date2.isNull[i]) {
                    Assert.assertTrue((boolean)output.isNull[i]);
                    continue;
                }
                Assert.assertEquals((Object)expected, (Object)new String(this.toString(output.vector[i])));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void testDateAddColCol(PrimitiveObjectInspector.PrimitiveCategory colType1, boolean isPositive) throws HiveException {
        LongColumnVector date1 = this.newRandomLongColumnVector(10000, this.size);
        LongColumnVector days2 = this.newRandomLongColumnVector(1000, this.size);
        ColumnVector col1 = this.castTo(date1, colType1);
        LongColumnVector output = new LongColumnVector(this.size);
        VectorizedRowBatch batch = new VectorizedRowBatch(3, this.size);
        batch.cols[0] = col1;
        batch.cols[1] = days2;
        batch.cols[2] = output;
        this.validateDateAdd(batch, date1, days2, colType1, isPositive);
        TestVectorizedRowBatch.addRandomNulls((ColumnVector)date1);
        batch.cols[0] = this.castTo(date1, colType1);
        this.validateDateAdd(batch, date1, days2, colType1, isPositive);
        TestVectorizedRowBatch.addRandomNulls((ColumnVector)days2);
        batch.cols[1] = days2;
        this.validateDateAdd(batch, date1, days2, colType1, isPositive);
    }

    @Test
    public void testDateAddColCol() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory colType1 : this.dateTimestampStringTypes) {
            this.testDateAddColCol(colType1, true);
        }
        VectorUDFDateAddColCol udf = new VectorUDFDateAddColCol(0, 1, 2);
        VectorizedRowBatch batch = new VectorizedRowBatch(3, 1);
        byte[] bytes = "error".getBytes(this.utf8);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo, TypeInfoFactory.timestampTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        batch.cols[2] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[2].isNull[0], (Object)true);
    }

    @Test
    public void testDateSubColCol() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory colType1 : this.dateTimestampStringTypes) {
            this.testDateAddColCol(colType1, false);
        }
        VectorUDFDateSubColCol udf = new VectorUDFDateSubColCol(0, 1, 2);
        VectorizedRowBatch batch = new VectorizedRowBatch(3, 1);
        byte[] bytes = "error".getBytes(this.utf8);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo, TypeInfoFactory.timestampTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        batch.cols[2] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[2].isNull[0], (Object)true);
    }

    private void validateDateDiff(VectorizedRowBatch batch, long scalar1, PrimitiveObjectInspector.PrimitiveCategory scalarType1, PrimitiveObjectInspector.PrimitiveCategory colType2, LongColumnVector date2) throws HiveException {
        VectorUDFDateDiffScalarCol udf = null;
        switch (scalarType1) {
            case DATE: {
                udf = new VectorUDFDateDiffScalarCol((Object)scalar1, 0, 1);
                break;
            }
            case TIMESTAMP: {
                udf = new VectorUDFDateDiffScalarCol((Object)this.toTimestamp(scalar1), 0, 1);
                break;
            }
            case STRING: {
                udf = new VectorUDFDateDiffScalarCol((Object)this.toString(scalar1), 0, 1);
            }
        }
        udf.setInputTypeInfos(new TypeInfo[]{this.primitiveCategoryToTypeInfo(scalarType1), this.primitiveCategoryToTypeInfo(colType2)});
        udf.transientInit((Configuration)this.hiveConf);
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[1];
        for (int i = 0; i < date2.vector.length; ++i) {
            Assert.assertEquals((long)(scalar1 - date2.vector[i]), (long)output.vector[i]);
        }
    }

    @Test
    public void testDateDiffScalarCol() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory scalarType1 : this.dateTimestampStringTypes) {
            for (PrimitiveObjectInspector.PrimitiveCategory colType2 : this.dateTimestampStringTypes) {
                LongColumnVector date2 = this.newRandomLongColumnVector(10000, this.size);
                LongColumnVector output = new LongColumnVector(this.size);
                ColumnVector col2 = this.castTo(date2, colType2);
                VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
                batch.cols[0] = col2;
                batch.cols[1] = output;
                long scalar1 = this.newRandom(1000);
                this.validateDateDiff(batch, scalar1, scalarType1, colType2, date2);
                TestVectorizedRowBatch.addRandomNulls((ColumnVector)date2);
                batch.cols[0] = this.castTo(date2, colType2);
                this.validateDateDiff(batch, scalar1, scalarType1, colType2, date2);
            }
        }
        byte[] bytes = "error".getBytes(this.utf8);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        VectorUDFDateDiffScalarCol udf = new VectorUDFDateDiffScalarCol((Object)new Timestamp(0L), 0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo, TypeInfoFactory.stringTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
        udf = new VectorUDFDateDiffScalarCol((Object)bytes, 0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo, TypeInfoFactory.timestampTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        batch.cols[0] = new LongColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    private void validateDateDiff(VectorizedRowBatch batch, LongColumnVector date1, long scalar2, PrimitiveObjectInspector.PrimitiveCategory colType1, PrimitiveObjectInspector.PrimitiveCategory scalarType2) throws HiveException {
        VectorUDFDateDiffColScalar udf = null;
        switch (scalarType2) {
            case DATE: {
                udf = new VectorUDFDateDiffColScalar(0, (Object)scalar2, 1);
                break;
            }
            case TIMESTAMP: {
                udf = new VectorUDFDateDiffColScalar(0, (Object)this.toTimestamp(scalar2), 1);
                break;
            }
            case STRING: {
                udf = new VectorUDFDateDiffColScalar(0, (Object)this.toString(scalar2), 1);
            }
        }
        udf.setInputTypeInfos(new TypeInfo[]{this.primitiveCategoryToTypeInfo(colType1), this.primitiveCategoryToTypeInfo(scalarType2)});
        udf.transientInit((Configuration)this.hiveConf);
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[1];
        for (int i = 0; i < date1.vector.length; ++i) {
            Assert.assertEquals((long)(date1.vector[i] - scalar2), (long)output.vector[i]);
        }
    }

    @Test
    public void testDateDiffColScalar() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory colType1 : this.dateTimestampStringTypes) {
            for (PrimitiveObjectInspector.PrimitiveCategory scalarType2 : this.dateTimestampStringTypes) {
                LongColumnVector date1 = this.newRandomLongColumnVector(10000, this.size);
                LongColumnVector output = new LongColumnVector(this.size);
                VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
                batch.cols[0] = this.castTo(date1, colType1);
                batch.cols[1] = output;
                long scalar2 = this.newRandom(1000);
                this.validateDateDiff(batch, date1, scalar2, colType1, scalarType2);
                TestVectorizedRowBatch.addRandomNulls((ColumnVector)date1);
                batch.cols[0] = this.castTo(date1, colType1);
                this.validateDateDiff(batch, date1, scalar2, colType1, scalarType2);
            }
        }
        byte[] bytes = "error".getBytes(this.utf8);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        VectorUDFDateDiffColScalar udf = new VectorUDFDateDiffColScalar(0, (Object)0L, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo, TypeInfoFactory.stringTypeInfo});
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
        udf = new VectorUDFDateDiffColScalar(0, (Object)bytes, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo, TypeInfoFactory.stringTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        batch.cols[0] = new LongColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateDiffColScalarWithTz() throws HiveException {
        TimeZone originalTz = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT+8"));
            DateColumnVector dateColumnVector = new DateColumnVector(1);
            dateColumnVector.fill(LocalDate.parse("2021-07-06").toEpochDay());
            byte[] scalarDateBytes = "2021-07-01".getBytes(this.utf8);
            VectorUDFDateDiffColScalar udf = new VectorUDFDateDiffColScalar(0, (Object)scalarDateBytes, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.dateTypeInfo, TypeInfoFactory.stringTypeInfo});
            udf.transientInit((Configuration)this.hiveConf);
            VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
            batch.cols[0] = dateColumnVector;
            LongColumnVector outputVector = new LongColumnVector(1);
            batch.cols[1] = outputVector;
            udf.evaluate(batch);
            Assert.assertEquals((long)5L, (long)outputVector.vector[0]);
        }
        finally {
            TimeZone.setDefault(originalTz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateDiffScalarColWithTz() throws HiveException {
        TimeZone originalTz = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT+8"));
            byte[] scalarDateBytes = "2021-07-01".getBytes(this.utf8);
            DateColumnVector dateColumnVector = new DateColumnVector(1);
            dateColumnVector.fill(LocalDate.parse("2021-07-06").toEpochDay());
            VectorUDFDateDiffScalarCol udf = new VectorUDFDateDiffScalarCol((Object)scalarDateBytes, 0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo, TypeInfoFactory.dateTypeInfo});
            udf.transientInit((Configuration)this.hiveConf);
            VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
            batch.cols[0] = dateColumnVector;
            LongColumnVector outputVector = new LongColumnVector(1);
            batch.cols[1] = outputVector;
            udf.evaluate(batch);
            Assert.assertEquals((long)-5L, (long)outputVector.vector[0]);
        }
        finally {
            TimeZone.setDefault(originalTz);
        }
    }

    @Test
    public void testDateDiffColColWithTz() throws HiveException {
        TimeZone originalTz = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT+8"));
            this.testDateDiffColCol();
        }
        finally {
            TimeZone.setDefault(originalTz);
        }
    }

    private void validateDateDiff(VectorizedRowBatch batch, LongColumnVector date1, LongColumnVector date2, PrimitiveObjectInspector.PrimitiveCategory colType1, PrimitiveObjectInspector.PrimitiveCategory colType2) throws HiveException {
        VectorUDFDateDiffColCol udf = new VectorUDFDateDiffColCol(0, 1, 2);
        udf.setInputTypeInfos(new TypeInfo[]{this.primitiveCategoryToTypeInfo(colType1), this.primitiveCategoryToTypeInfo(colType2)});
        udf.transientInit((Configuration)this.hiveConf);
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[2];
        for (int i = 0; i < date1.vector.length; ++i) {
            if (date1.isNull[i] || date2.isNull[i]) {
                Assert.assertTrue((boolean)output.isNull[i]);
                continue;
            }
            Assert.assertEquals((long)(date1.vector[i] - date2.vector[i]), (long)output.vector[i]);
        }
    }

    @Test
    public void testDateDiffColCol() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory colType1 : this.dateTimestampStringTypes) {
            for (PrimitiveObjectInspector.PrimitiveCategory colType2 : this.dateTimestampStringTypes) {
                LongColumnVector date1 = this.newRandomLongColumnVector(10000, this.size);
                LongColumnVector date2 = this.newRandomLongColumnVector(10000, this.size);
                LongColumnVector output = new LongColumnVector(this.size);
                VectorizedRowBatch batch = new VectorizedRowBatch(3, this.size);
                batch.cols[0] = this.castTo(date1, colType1);
                batch.cols[1] = this.castTo(date2, colType2);
                batch.cols[2] = output;
                this.validateDateDiff(batch, date1, date2, colType1, colType2);
                TestVectorizedRowBatch.addRandomNulls((ColumnVector)date1);
                batch.cols[0] = this.castTo(date1, colType1);
                this.validateDateDiff(batch, date1, date2, colType1, colType2);
                TestVectorizedRowBatch.addRandomNulls((ColumnVector)date2);
                batch.cols[1] = this.castTo(date2, colType2);
                this.validateDateDiff(batch, date1, date2, colType1, colType2);
            }
        }
        VectorUDFDateDiffColCol udf = new VectorUDFDateDiffColCol(0, 1, 2);
        VectorizedRowBatch batch = new VectorizedRowBatch(3, 1);
        byte[] bytes = "error".getBytes(this.utf8);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo, TypeInfoFactory.timestampTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new TimestampColumnVector(1);
        batch.cols[2] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[2].isNull[0], (Object)true);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo, TypeInfoFactory.stringTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        batch.cols[0] = new TimestampColumnVector(1);
        batch.cols[1] = new BytesColumnVector(1);
        batch.cols[2] = new LongColumnVector(1);
        bcv = (BytesColumnVector)batch.cols[1];
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[2].isNull[0], (Object)true);
    }

    private void validateDate(VectorizedRowBatch batch, PrimitiveObjectInspector.PrimitiveCategory colType, LongColumnVector date) throws HiveException {
        VectorUDFDateString udf;
        if (colType == PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            udf = new VectorUDFDateString(0, 1);
        } else if (colType == PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP) {
            udf = new VectorUDFDateTimestamp(0, 1);
        } else {
            throw new RuntimeException("Unexpected column type " + colType);
        }
        udf.setInputTypeInfos(new TypeInfo[]{this.primitiveCategoryToTypeInfo(colType)});
        udf.transientInit((Configuration)this.hiveConf);
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[1];
        for (int i = 0; i < this.size; ++i) {
            String actual = output.isNull[i] ? null : new String(this.toString(output.vector[i]));
            if (date.isNull[i]) {
                Assert.assertTrue((boolean)output.isNull[i]);
                continue;
            }
            String expected = this.formatter.format(new Date(DateWritableV2.daysToMillis((int)((int)date.vector[i]))));
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testDate() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory colType : this.dateTimestampStringTypes) {
            if (colType == PrimitiveObjectInspector.PrimitiveCategory.DATE) continue;
            LongColumnVector date = this.newRandomLongColumnVector(10000, this.size);
            LongColumnVector output = new LongColumnVector(this.size);
            VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
            batch.cols[0] = this.castTo(date, colType);
            batch.cols[1] = output;
            this.validateDate(batch, colType, date);
            TestVectorizedRowBatch.addRandomNulls((ColumnVector)date);
            batch.cols[0] = this.castTo(date, colType);
            this.validateDate(batch, colType, date);
        }
        VectorUDFDateString udf = new VectorUDFDateString(0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        byte[] bytes = "error".getBytes(this.utf8);
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }

    private void validateToDate(VectorizedRowBatch batch, PrimitiveObjectInspector.PrimitiveCategory colType, LongColumnVector date) throws HiveException {
        CastStringToDate udf;
        if (colType == PrimitiveObjectInspector.PrimitiveCategory.STRING || colType == PrimitiveObjectInspector.PrimitiveCategory.CHAR || colType == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) {
            udf = new CastStringToDate(0, 1);
        } else if (colType == PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP) {
            udf = new CastTimestampToDate(0, 1);
        } else {
            throw new RuntimeException("Unexpected column type " + colType);
        }
        udf.setInputTypeInfos(new TypeInfo[]{this.primitiveCategoryToTypeInfo(colType)});
        udf.transientInit((Configuration)this.hiveConf);
        udf.evaluate(batch);
        LongColumnVector output = (LongColumnVector)batch.cols[1];
        for (int i = 0; i < this.size; ++i) {
            long actual = output.vector[i];
            if (date.isNull[i]) {
                Assert.assertTrue((boolean)output.isNull[i]);
                continue;
            }
            long expected = date.vector[i];
            Assert.assertEquals((long)expected, (long)actual);
        }
    }

    @Test
    public void testToDate() throws HiveException {
        for (PrimitiveObjectInspector.PrimitiveCategory type : Arrays.asList(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, PrimitiveObjectInspector.PrimitiveCategory.STRING)) {
            LongColumnVector date = this.newRandomLongColumnVector(10000, this.size);
            LongColumnVector output = new LongColumnVector(this.size);
            VectorizedRowBatch batch = new VectorizedRowBatch(2, this.size);
            batch.cols[0] = this.castTo(date, type);
            batch.cols[1] = output;
            this.validateToDate(batch, type, date);
            TestVectorizedRowBatch.addRandomNulls((ColumnVector)date);
            batch.cols[0] = this.castTo(date, type);
            this.validateToDate(batch, type, date);
        }
        CastStringToDate udf = new CastStringToDate(0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        udf.transientInit((Configuration)this.hiveConf);
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        batch.cols[0] = new BytesColumnVector(1);
        batch.cols[1] = new LongColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
        byte[] bytes = "error".getBytes(this.utf8);
        bcv.vector[0] = bytes;
        bcv.start[0] = 0;
        bcv.length[0] = bytes.length;
        udf.evaluate(batch);
        Assert.assertEquals((Object)batch.cols[1].isNull[0], (Object)true);
    }
}

