/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateAdd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateSub;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorDateAddSub {
    @Test
    public void testDate() throws Exception {
        Random random = new Random(12882L);
        this.doDateAddSubTests(random, "date", "smallint", true);
        this.doDateAddSubTests(random, "date", "smallint", false);
        this.doDateAddSubTests(random, "date", "int", true);
        this.doDateAddSubTests(random, "date", "int", false);
    }

    @Test
    public void testTimestamp() throws Exception {
        Random random = new Random(12882L);
        this.doDateAddSubTests(random, "timestamp", "smallint", true);
        this.doDateAddSubTests(random, "timestamp", "smallint", false);
        this.doDateAddSubTests(random, "timestamp", "int", true);
        this.doDateAddSubTests(random, "timestamp", "int", false);
    }

    @Test
    public void testStringFamily() throws Exception {
        Random random = new Random(12882L);
        this.doDateAddSubTests(random, "string", "smallint", true);
        this.doDateAddSubTests(random, "string", "smallint", false);
        this.doDateAddSubTests(random, "string", "int", true);
        this.doDateAddSubTests(random, "string", "int", false);
        this.doDateAddSubTests(random, "char(20)", "int", true);
        this.doDateAddSubTests(random, "char(20)", "int", false);
        this.doDateAddSubTests(random, "varchar(20)", "int", true);
        this.doDateAddSubTests(random, "varchar(20)", "int", false);
    }

    private void doDateAddSubTests(Random random, String dateTimeStringTypeName, String integerTypeName, boolean isAdd) throws Exception {
        for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
            this.doDateAddSubTestsWithDiffColumnScalar(random, dateTimeStringTypeName, integerTypeName, columnScalarMode, isAdd);
        }
    }

    private Object smallerRange(Random random, PrimitiveObjectInspector.PrimitiveCategory integerPrimitiveCategory, boolean wantWritable) {
        switch (integerPrimitiveCategory) {
            case SHORT: {
                short newRandomShort = (short)random.nextInt(20000);
                if (wantWritable) {
                    return new ShortWritable(newRandomShort);
                }
                return newRandomShort;
            }
            case INT: {
                int newRandomInt = random.nextInt(40000);
                if (wantWritable) {
                    return new IntWritable(newRandomInt);
                }
                return newRandomInt;
            }
        }
        throw new RuntimeException("Unsupported integer category " + integerPrimitiveCategory);
    }

    private void doDateAddSubTestsWithDiffColumnScalar(Random random, String dateTimeStringTypeName, String integerTypeName, ColumnScalarMode columnScalarMode, boolean isAdd) throws Exception {
        int i;
        ExprNodeConstantDesc col2Expr;
        ExprNodeConstantDesc col1Expr;
        TypeInfo dateTimeStringTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)dateTimeStringTypeName);
        PrimitiveObjectInspector.PrimitiveCategory dateTimeStringPrimitiveCategory = ((PrimitiveTypeInfo)dateTimeStringTypeInfo).getPrimitiveCategory();
        boolean isStringFamily = dateTimeStringPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.STRING || dateTimeStringPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.CHAR || dateTimeStringPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR;
        TypeInfo integerTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)integerTypeName);
        PrimitiveObjectInspector.PrimitiveCategory integerPrimitiveCategory = ((PrimitiveTypeInfo)integerTypeInfo).getPrimitiveCategory();
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        int columnNum = 1;
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.COLUMN_SCALAR) {
            if (!isStringFamily) {
                generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(dateTimeStringTypeInfo));
            } else {
                generationSpecList.add(VectorRandomRowSource.GenerationSpec.createStringFamilyOtherTypeValue(dateTimeStringTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo));
            }
            explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
            String columnName = "col" + columnNum++;
            col1Expr = new ExprNodeColumnDesc(dateTimeStringTypeInfo, columnName, "table", false);
            columns.add(columnName);
        } else {
            Object scalar1Object = !isStringFamily ? VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)dateTimeStringTypeInfo) : VectorRandomRowSource.randomStringFamilyOtherTypeValue(random, dateTimeStringTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo, false);
            col1Expr = new ExprNodeConstantDesc(dateTimeStringTypeInfo, scalar1Object);
        }
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.SCALAR_COLUMN) {
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(integerTypeInfo));
            explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
            String columnName = "col" + columnNum++;
            col2Expr = new ExprNodeColumnDesc(integerTypeInfo, columnName, "table", false);
            columns.add(columnName);
        } else {
            Object scalar2Object = VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)integerTypeInfo);
            scalar2Object = this.smallerRange(random, integerPrimitiveCategory, false);
            col2Expr = new ExprNodeConstantDesc(integerTypeInfo, scalar2Object);
        }
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        children.add((ExprNodeDesc)col2Expr);
        String[] columnNames = columns.toArray(new String[0]);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, true, explicitDataTypePhysicalVariationList);
        Object[][] randomRows = rowSource.randomRows(100000);
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.SCALAR_COLUMN) {
            for (int i2 = 0; i2 < randomRows.length; ++i2) {
                Object[] row = randomRows[i2];
                if (row[columnNum - 2] == null) continue;
                row[columnNum - 2] = this.smallerRange(random, integerPrimitiveCategory, true);
            }
        }
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        String[] outputScratchTypeNames = new String[]{"date"};
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, outputScratchTypeNames, null);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[DateAddSubTestMode.count][];
        block5: for (i = 0; i < DateAddSubTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            GenericUDFDateAdd udf = isAdd ? new GenericUDFDateAdd() : new GenericUDFDateSub();
            ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.dateTypeInfo, (GenericUDF)udf, children);
            DateAddSubTestMode dateAddSubTestMode = DateAddSubTestMode.values()[i];
            switch (dateAddSubTestMode) {
                case ROW_MODE: {
                    this.doRowDateAddSubTest(dateTimeStringTypeInfo, integerTypeInfo, columns, children, isAdd, exprDesc, randomRows, columnScalarMode, (ObjectInspector)rowSource.rowStructObjectInspector(), resultObjects);
                    continue block5;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    this.doVectorDateAddSubTest(dateTimeStringTypeInfo, integerTypeInfo, columns, rowSource.typeInfos(), children, isAdd, exprDesc, dateAddSubTestMode, columnScalarMode, batchSource, batchContext, resultObjects);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + dateAddSubTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < DateAddSubTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " " + DateAddSubTestMode.values()[v] + " isAdd " + isAdd + " " + columnScalarMode + " result is NULL " + (vectorResult == null) + " does not match row-mode expected result is NULL " + (expectedResult == null) + " row values " + Arrays.toString(randomRows[i])));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " " + DateAddSubTestMode.values()[v] + " isAdd " + isAdd + " " + columnScalarMode + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i])));
            }
        }
    }

    private void doRowDateAddSubTest(TypeInfo dateTimeStringTypeInfo, TypeInfo integerTypeInfo, List<String> columns, List<ExprNodeDesc> children, boolean isAdd, ExprNodeGenericFuncDesc exprDesc, Object[][] randomRows, ColumnScalarMode columnScalarMode, ObjectInspector rowInspector, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)TypeInfoFactory.dateTypeInfo);
        for (Object[] row : randomRows) {
            Object copyResult;
            Object result = evaluator.evaluate((Object)row);
            resultObjects[i] = copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, TypeInfo targetTypeInfo, Object[] resultObjects) {
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)targetTypeInfo);
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private void doVectorDateAddSubTest(TypeInfo dateTimeStringTypeInfo, TypeInfo integerTypeInfo, List<String> columns, TypeInfo[] typeInfos, List<ExprNodeDesc> children, boolean isAdd, ExprNodeGenericFuncDesc exprDesc, DateAddSubTestMode dateAddSubTestMode, ColumnScalarMode columnScalarMode, VectorRandomBatchSource batchSource, VectorizedRowBatchCtx batchContext, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (dateAddSubTestMode == DateAddSubTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        Object[] dataTypePhysicalVariations = new DataTypePhysicalVariation[2];
        Arrays.fill(dataTypePhysicalVariations, DataTypePhysicalVariation.NONE);
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (dateAddSubTestMode == DateAddSubTestMode.VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* dateTimeStringTypeInfo " + dateTimeStringTypeInfo.toString() + " dateAddSubTestMode " + dateAddSubTestMode + " columnScalarMode " + columnScalarMode + " vectorExpression " + vectorExpression.toString());
        }
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{TypeInfoFactory.dateTypeInfo}, new int[]{columns.size()});
        Object[] scrqtchRow = new Object[1];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, (TypeInfo)TypeInfoFactory.dateTypeInfo, resultObjects);
            rowIndex += batch.size;
        }
    }

    public static enum ColumnScalarMode {
        COLUMN_COLUMN,
        COLUMN_SCALAR,
        SCALAR_COLUMN;

        static final int count;

        static {
            count = ColumnScalarMode.values().length;
        }
    }

    public static enum DateAddSubTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = DateAddSubTestMode.values().length;
        }
    }
}

