/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="HIVE-25323")
public class TestVectorCastStatement {
    @Test
    public void testBoolean() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "boolean");
    }

    @Test
    public void testTinyInt() throws Exception {
        Random random = new Random(5371L);
        this.doIfTests(random, "tinyint");
    }

    @Test
    public void testSmallInt() throws Exception {
        Random random = new Random(2772L);
        this.doIfTests(random, "smallint");
    }

    @Test
    public void testInt() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "int");
    }

    @Test
    public void testBigInt() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "bigint");
    }

    @Test
    public void testString() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "string");
    }

    @Test
    public void testTimestamp() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "timestamp");
    }

    @Test
    public void testDate() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "date");
    }

    @Test
    public void testFloat() throws Exception {
        Random random = new Random(7322L);
        this.doIfTests(random, "float");
    }

    @Test
    public void testDouble() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "double");
    }

    @Test
    public void testChar() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "char(10)");
    }

    @Test
    public void testVarchar() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "varchar(15)");
    }

    @Test
    public void testDecimal() throws Exception {
        Random random = new Random(9300L);
        this.doIfTests(random, "decimal(38,18)");
        this.doIfTests(random, "decimal(38,0)");
        this.doIfTests(random, "decimal(20,8)");
        this.doIfTests(random, "decimal(10,4)");
    }

    private void doIfTests(Random random, String typeName) throws Exception {
        this.doIfTests(random, typeName, DataTypePhysicalVariation.NONE);
    }

    private void doIfTests(Random random, String typeName, DataTypePhysicalVariation dataTypePhysicalVariation) throws Exception {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        for (PrimitiveObjectInspector.PrimitiveCategory targetPrimitiveCategory : PrimitiveObjectInspector.PrimitiveCategory.values()) {
            if ((targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_YEAR_MONTH || targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME) && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.STRING || targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.VOID || targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMPLOCALTZ || targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN || primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.DATE && (targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.BYTE || targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.SHORT || targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.INT || targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.LONG || targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.FLOAT || targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.DOUBLE || targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) || primitiveCategory == targetPrimitiveCategory && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.CHAR && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.VARCHAR && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) continue;
            this.doIfTestOneCast(random, typeName, dataTypePhysicalVariation, targetPrimitiveCategory);
        }
    }

    private boolean needsValidDataTypeData(TypeInfo typeInfo) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        return primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.STRING && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.CHAR && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.VARCHAR && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.BINARY;
    }

    private void doIfTestOneCast(Random random, String typeName, DataTypePhysicalVariation dataTypePhysicalVariation, PrimitiveObjectInspector.PrimitiveCategory targetPrimitiveCategory) throws Exception {
        int i;
        int decimal64Scale;
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        boolean isDecimal64 = dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64;
        int n = decimal64Scale = isDecimal64 ? ((DecimalTypeInfo)typeInfo).getScale() : 0;
        String targetTypeName = targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.BYTE ? "tinyint" : (targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.SHORT ? "smallint" : (targetPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.LONG ? "bigint" : targetPrimitiveCategory.name().toLowerCase()));
        targetTypeName = VectorRandomRowSource.getDecoratedTypeName(random, targetTypeName);
        TypeInfo targetTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)targetTypeName);
        VectorRandomRowSource.GenerationSpec generationSpec = this.needsValidDataTypeData(targetTypeInfo) && (primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.STRING || primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.CHAR || primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) ? VectorRandomRowSource.GenerationSpec.createStringFamilyOtherTypeValue(typeInfo, targetTypeInfo) : VectorRandomRowSource.GenerationSpec.createSameType(typeInfo);
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        generationSpecList.add(generationSpec);
        explicitDataTypePhysicalVariationList.add(dataTypePhysicalVariation);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, true, explicitDataTypePhysicalVariationList);
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("col1");
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(typeInfo, "col1", "table", false);
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        String[] columnNames = columns.toArray(new String[0]);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[CastStmtTestMode.count][];
        block4: for (i = 0; i < CastStmtTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            CastStmtTestMode ifStmtTestMode = CastStmtTestMode.values()[i];
            switch (ifStmtTestMode) {
                case ROW_MODE: {
                    if (this.doRowCastTest(typeInfo, targetTypeInfo, columns, children, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), resultObjects)) continue block4;
                    return;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    if (this.doVectorCastTest(typeInfo, targetTypeInfo, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, ifStmtTestMode, batchSource, resultObjects)) continue block4;
                    return;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + ifStmtTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < CastStmtTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " sourceTypeName " + typeName + " targetTypeName " + targetTypeName + " " + CastStmtTestMode.values()[v] + " result is NULL " + (String)(vectorResult == null ? "YES" : "NO result " + vectorResult.toString()) + " does not match row-mode expected result is NULL " + (String)(expectedResult == null ? "YES" : "NO result " + expectedResult.toString()) + " row values " + Arrays.toString(randomRows[i])));
                    continue;
                }
                if (isDecimal64 && expectedResult instanceof LongWritable) {
                    HiveDecimalWritable expectedHiveDecimalWritable = new HiveDecimalWritable(0L);
                    expectedHiveDecimalWritable.deserialize64(((LongWritable)expectedResult).get(), decimal64Scale);
                    expectedResult = expectedHiveDecimalWritable;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " sourceTypeName " + typeName + " targetTypeName " + targetTypeName + " " + CastStmtTestMode.values()[v] + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i])));
            }
        }
    }

    private boolean doRowCastTest(TypeInfo typeInfo, TypeInfo targetTypeInfo, List<String> columns, List<ExprNodeDesc> children, Object[][] randomRows, ObjectInspector rowInspector, Object[] resultObjects) throws Exception {
        GenericUDF udf;
        try {
            udf = VectorizationContext.getGenericUDFForCast((TypeInfo)targetTypeInfo);
        }
        catch (HiveException e) {
            return false;
        }
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(targetTypeInfo, udf, children);
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        try {
            evaluator.initialize(rowInspector);
        }
        catch (HiveException e) {
            return false;
        }
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)targetTypeInfo);
        for (Object[] row : randomRows) {
            Object copyResult;
            Object result = evaluator.evaluate((Object)row);
            resultObjects[i] = copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        return true;
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            try {
                resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            }
            catch (Exception e) {
                System.out.println("here");
            }
            resultObjects[rowIndex++] = scrqtchRow[0];
        }
    }

    private boolean doVectorCastTest(TypeInfo typeInfo, TypeInfo targetTypeInfo, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, CastStmtTestMode castStmtTestMode, VectorRandomBatchSource batchSource, Object[] resultObjects) throws Exception {
        GenericUDF udf;
        try {
            udf = VectorizationContext.getGenericUDFForCast((TypeInfo)targetTypeInfo);
        }
        catch (HiveException e) {
            return false;
        }
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(targetTypeInfo, udf, children);
        HiveConf hiveConf = new HiveConf();
        if (castStmtTestMode == CastStmtTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (castStmtTestMode == CastStmtTestMode.VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* typeInfo " + typeInfo.toString() + " castStmtTestMode " + castStmtTestMode + " vectorExpression " + vectorExpression.toString());
        }
        VectorRandomRowSource rowSource = batchSource.getRowSource();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, vectorizationContext.getScratchColumnTypeNames(), vectorizationContext.getScratchDataTypePhysicalVariations());
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{targetTypeInfo}, new int[]{vectorExpression.getOutputColumnNum()});
        Object[] scrqtchRow = new Object[1];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, resultObjects);
            rowIndex += batch.size;
        }
        return true;
    }

    public static enum CastStmtTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = CastStmtTestMode.values().length;
        }
    }
}

