/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorBetweenIn {
    private static TypeInfo[] decimalTypeInfos = new TypeInfo[]{new DecimalTypeInfo(38, 18), new DecimalTypeInfo(25, 2), new DecimalTypeInfo(19, 4), new DecimalTypeInfo(18, 10), new DecimalTypeInfo(17, 3), new DecimalTypeInfo(12, 2), new DecimalTypeInfo(7, 1)};
    private static final BetweenInVariation[] structInVarations = new BetweenInVariation[]{BetweenInVariation.FILTER_IN, BetweenInVariation.PROJECTION_IN};

    @Test
    public void testTinyInt() throws Exception {
        Random random = new Random(5371L);
        this.doBetweenIn(random, "tinyint");
    }

    @Test
    public void testSmallInt() throws Exception {
        Random random = new Random(2772L);
        this.doBetweenIn(random, "smallint");
    }

    @Test
    public void testInt() throws Exception {
        Random random = new Random(12882L);
        this.doBetweenIn(random, "int");
    }

    @Test
    public void testBigInt() throws Exception {
        Random random = new Random(12882L);
        this.doBetweenIn(random, "bigint");
    }

    @Test
    public void testString() throws Exception {
        Random random = new Random(12882L);
        this.doBetweenIn(random, "string");
    }

    @Test
    public void testTimestamp() throws Exception {
        Random random = new Random(12882L);
        this.doBetweenIn(random, "timestamp");
    }

    @Test
    public void testDate() throws Exception {
        Random random = new Random(12882L);
        this.doBetweenIn(random, "date");
    }

    @Test
    public void testFloat() throws Exception {
        Random random = new Random(7322L);
        this.doBetweenIn(random, "float");
    }

    @Test
    public void testDouble() throws Exception {
        Random random = new Random(12882L);
        this.doBetweenIn(random, "double");
    }

    @Test
    public void testChar() throws Exception {
        Random random = new Random(12882L);
        this.doBetweenIn(random, "char(10)");
    }

    @Test
    public void testVarchar() throws Exception {
        Random random = new Random(12882L);
        this.doBetweenIn(random, "varchar(15)");
    }

    @Test
    public void testDecimal() throws Exception {
        Random random = new Random(9300L);
        this.doDecimalTests(random, false);
    }

    @Test
    public void testDecimal64() throws Exception {
        Random random = new Random(9300L);
        this.doDecimalTests(random, true);
    }

    @Test
    public void testStruct() throws Exception {
        Random random = new Random(9300L);
        this.doStructTests(random);
    }

    private void doDecimalTests(Random random, boolean tryDecimal64) throws Exception {
        for (TypeInfo typeInfo : decimalTypeInfos) {
            this.doBetweenIn(random, typeInfo.getTypeName(), tryDecimal64);
        }
    }

    private void doBetweenIn(Random random, String typeName) throws Exception {
        this.doBetweenIn(random, typeName, false);
    }

    private void doStructTests(Random random) throws Exception {
        String typeName = "struct";
        HashSet<String> allowedTypeNameSet = new HashSet<String>();
        allowedTypeNameSet.add("int");
        allowedTypeNameSet.add("bigint");
        allowedTypeNameSet.add("double");
        allowedTypeNameSet.add("string");
        for (BetweenInVariation betweenInVariation : structInVarations) {
            for (int i = 0; i < 4; ++i) {
                typeName = VectorRandomRowSource.getDecoratedTypeName(random, typeName, VectorRandomRowSource.SupportedTypes.ALL, allowedTypeNameSet, 0, 1);
                this.doBetweenStructInVariation(random, typeName, betweenInVariation);
            }
        }
    }

    private void doBetweenIn(Random random, String typeName, boolean tryDecimal64) throws Exception {
        for (BetweenInVariation betweenInVariation : BetweenInVariation.values()) {
            int subVariation = 0;
            while (this.doBetweenInVariation(random, typeName, tryDecimal64, betweenInVariation, subVariation)) {
                ++subVariation;
            }
        }
    }

    private boolean checkDecimal64(boolean tryDecimal64, TypeInfo typeInfo) {
        if (!tryDecimal64 || !(typeInfo instanceof DecimalTypeInfo)) {
            return false;
        }
        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
        boolean result = HiveDecimalWritable.isPrecisionDecimal64((int)decimalTypeInfo.getPrecision());
        return result;
    }

    private void removeValue(List<Object> valueList, Object value) {
        valueList.remove(value);
    }

    private boolean needsValidDataTypeData(TypeInfo typeInfo) {
        if (!(typeInfo instanceof PrimitiveTypeInfo)) {
            return false;
        }
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        return primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.STRING && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.CHAR && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.VARCHAR && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.BINARY;
    }

    private boolean doBetweenInVariation(Random random, String typeName, boolean tryDecimal64, BetweenInVariation betweenInVariation, int subVariation) throws Exception {
        ObjectInspector outputObjectInspector;
        GenericUDFBetween udf;
        boolean isInvert;
        ArrayList<Object> compareList;
        boolean isBetween;
        ArrayList<Object> valueList;
        ObjectInspector objectInspector;
        DataTypePhysicalVariation dataTypePhysicalVariation;
        TypeInfo typeInfo;
        block28: {
            Object max;
            ArrayList<Object> sortedList;
            int valueCount;
            block27: {
                typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
                boolean isDecimal64 = this.checkDecimal64(tryDecimal64, typeInfo);
                dataTypePhysicalVariation = isDecimal64 ? DataTypePhysicalVariation.DECIMAL_64 : DataTypePhysicalVariation.NONE;
                int decimal64Scale = isDecimal64 ? ((DecimalTypeInfo)typeInfo).getScale() : 0;
                objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
                valueCount = 10 + random.nextInt(10);
                valueList = new ArrayList<Object>(valueCount);
                for (int i = 0; i < valueCount; ++i) {
                    valueList.add(VectorRandomRowSource.randomWritable(random, typeInfo, objectInspector, dataTypePhysicalVariation, false));
                }
                isBetween = betweenInVariation == BetweenInVariation.FILTER_BETWEEN || betweenInVariation == BetweenInVariation.FILTER_NOT_BETWEEN || betweenInVariation == BetweenInVariation.PROJECTION_BETWEEN || betweenInVariation == BetweenInVariation.PROJECTION_NOT_BETWEEN;
                compareList = new ArrayList<Object>();
                sortedList = new ArrayList<Object>(valueCount);
                sortedList.addAll(valueList);
                Object exampleObject = valueList.get(0);
                WritableComparator writableComparator = WritableComparator.get(exampleObject.getClass());
                sortedList.sort((Comparator<Object>)writableComparator);
                if (!isBetween) break block27;
                isInvert = betweenInVariation == BetweenInVariation.FILTER_NOT_BETWEEN || betweenInVariation == BetweenInVariation.PROJECTION_NOT_BETWEEN;
                switch (subVariation) {
                    case 0: {
                        compareList.add(sortedList.get(0));
                        compareList.add(sortedList.get(valueCount - 1));
                        break block28;
                    }
                    case 1: {
                        compareList.add(sortedList.get(1));
                        compareList.add(sortedList.get(valueCount - 2));
                        break block28;
                    }
                    case 2: {
                        compareList.add(sortedList.get(valueCount - 2));
                        compareList.add(sortedList.get(valueCount - 1));
                        break block28;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        Object min = sortedList.get(5);
                        max = sortedList.get(6);
                        compareList.add(min);
                        compareList.add(max);
                        if (subVariation == 4) {
                            this.removeValue(valueList, min);
                        } else if (subVariation == 5) {
                            this.removeValue(valueList, max);
                        } else if (subVariation == 6) {
                            this.removeValue(valueList, min);
                            this.removeValue(valueList, max);
                        }
                        break block28;
                    }
                    default: {
                        return false;
                    }
                }
            }
            isInvert = false;
            switch (subVariation) {
                case 0: {
                    compareList.addAll(valueList);
                    break;
                }
                case 1: {
                    for (int i = 1; i < valueCount - 1; ++i) {
                        compareList.add(valueList.get(i));
                    }
                    break;
                }
                case 2: {
                    for (int i = 2; i < valueCount; i += 2) {
                        compareList.add(valueList.get(i));
                    }
                    break;
                }
                case 3: {
                    Object min = sortedList.get(5);
                    max = sortedList.get(6);
                    compareList.add(min);
                    compareList.add(max);
                    if (subVariation == 4) {
                        this.removeValue(valueList, min);
                        break;
                    }
                    if (subVariation == 5) {
                        this.removeValue(valueList, max);
                        break;
                    }
                    if (subVariation != 6) break;
                    this.removeValue(valueList, min);
                    this.removeValue(valueList, max);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        VectorRandomRowSource.GenerationSpec generationSpec = VectorRandomRowSource.GenerationSpec.createValueList(typeInfo, valueList);
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        generationSpecList.add(generationSpec);
        explicitDataTypePhysicalVariationList.add(dataTypePhysicalVariation);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, true, explicitDataTypePhysicalVariationList);
        ArrayList<String> columns = new ArrayList<String>();
        String col1Name = rowSource.columnNames().get(0);
        columns.add(col1Name);
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(typeInfo, col1Name, "table", false);
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        if (isBetween) {
            children.add((ExprNodeDesc)new ExprNodeConstantDesc((Object)isInvert));
        }
        children.add((ExprNodeDesc)col1Expr);
        for (Object e : compareList) {
            ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc(typeInfo, VectorRandomRowSource.getNonWritableObject(e, typeInfo, objectInspector));
            children.add((ExprNodeDesc)constDesc);
        }
        String[] columnNames = columns.toArray(new String[0]);
        Object[][] objectArray = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, objectArray, null);
        if (isBetween) {
            udf = new GenericUDFBetween();
            ObjectInspector[] argumentOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, objectInspector, objectInspector, objectInspector};
            outputObjectInspector = udf.initialize(argumentOIs);
        } else {
            int compareCount = compareList.size();
            udf = new GenericUDFIn();
            ObjectInspector[] argumentOIs = new ObjectInspector[compareCount];
            ConstantObjectInspector constantObjectInspector = (ConstantObjectInspector)((ExprNodeDesc)children.get(1)).getWritableObjectInspector();
            for (int i = 0; i < compareCount; ++i) {
                argumentOIs[i] = constantObjectInspector;
            }
            outputObjectInspector = udf.initialize(argumentOIs);
        }
        TypeInfo outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)udf, children);
        return this.executeTestModesAndVerify(typeInfo, betweenInVariation, compareList, columns, columnNames, children, (GenericUDF)udf, exprDesc, objectArray, rowSource, batchSource, outputTypeInfo, false);
    }

    private boolean doBetweenStructInVariation(Random random, String structTypeName, BetweenInVariation betweenInVariation) throws Exception {
        int i;
        StructTypeInfo structTypeInfo = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)structTypeName);
        ObjectInspector structObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)structTypeInfo);
        int valueCount = 10 + random.nextInt(10);
        ArrayList<Object> valueList = new ArrayList<Object>(valueCount);
        for (int i2 = 0; i2 < valueCount; ++i2) {
            valueList.add(VectorRandomRowSource.randomWritable(random, (TypeInfo)structTypeInfo, structObjectInspector, DataTypePhysicalVariation.NONE, false));
        }
        boolean isInvert = false;
        ArrayList<Object> compareList = new ArrayList<Object>();
        HashSet<Integer> includedSet = new HashSet<Integer>();
        int chooseLimit = 4 + random.nextInt(valueCount / 2);
        int chooseCount = 0;
        while (chooseCount < chooseLimit) {
            int index = random.nextInt(valueCount);
            if (includedSet.contains(index)) continue;
            includedSet.add(index);
            compareList.add(valueList.get(index));
            ++chooseCount;
        }
        VectorRandomRowSource.GenerationSpec structGenerationSpec = VectorRandomRowSource.GenerationSpec.createValueList((TypeInfo)structTypeInfo, valueList);
        ArrayList<VectorRandomRowSource.GenerationSpec> structGenerationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> structExplicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        structGenerationSpecList.add(structGenerationSpec);
        structExplicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
        VectorRandomRowSource structRowSource = new VectorRandomRowSource();
        structRowSource.initGenerationSpecSchema(random, structGenerationSpecList, 0, true, true, structExplicitDataTypePhysicalVariationList);
        Object[][] structRandomRows = structRowSource.randomRows(100000);
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        List fieldTypeInfoList = structTypeInfo.getAllStructFieldTypeInfos();
        int fieldCount = fieldTypeInfoList.size();
        for (int i3 = 0; i3 < fieldCount; ++i3) {
            VectorRandomRowSource.GenerationSpec generationSpec = VectorRandomRowSource.GenerationSpec.createOmitGeneration((TypeInfo)fieldTypeInfoList.get(i3));
            generationSpecList.add(generationSpec);
            explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
        }
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, true, explicitDataTypePhysicalVariationList);
        Object[][] randomRows = rowSource.randomRows(100000);
        int rowCount = randomRows.length;
        for (int r = 0; r < rowCount; ++r) {
            ArrayList fieldValueList = (ArrayList)structRandomRows[r][0];
            for (int f = 0; f < fieldCount; ++f) {
                randomRows[r][f] = fieldValueList.get(f);
            }
        }
        ArrayList<ObjectInspector> structUdfObjectInspectorList = new ArrayList<ObjectInspector>();
        ArrayList<ExprNodeColumnDesc> structUdfChildren = new ArrayList<ExprNodeColumnDesc>(fieldCount);
        List<String> rowColumnNameList = rowSource.columnNames();
        for (int i4 = 0; i4 < fieldCount; ++i4) {
            TypeInfo fieldTypeInfo = (TypeInfo)fieldTypeInfoList.get(i4);
            ExprNodeColumnDesc fieldExpr = new ExprNodeColumnDesc(fieldTypeInfo, rowColumnNameList.get(i4), "table", false);
            structUdfChildren.add(fieldExpr);
            ObjectInspector fieldObjectInspector = VectorRandomRowSource.getObjectInspector(fieldTypeInfo, DataTypePhysicalVariation.NONE);
            structUdfObjectInspectorList.add(fieldObjectInspector);
        }
        StandardStructObjectInspector structUdfObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(rowColumnNameList, structUdfObjectInspectorList);
        String structUdfTypeName = structUdfObjectInspector.getTypeName();
        TypeInfo structUdfTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)structUdfTypeName);
        String structFuncText = "struct";
        FunctionInfo fi = FunctionRegistry.getFunctionInfo((String)structFuncText);
        GenericUDF genericUDF = fi.getGenericUDF();
        ExprNodeGenericFuncDesc col1Expr = new ExprNodeGenericFuncDesc((ObjectInspector)structUdfObjectInspector, genericUDF, structFuncText, structUdfChildren);
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        for (i = 0; i < compareList.size(); ++i) {
            Object compareObject = compareList.get(i);
            ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc(structUdfTypeInfo, VectorRandomRowSource.getNonWritableObject(compareObject, structUdfTypeInfo, (ObjectInspector)structUdfObjectInspector));
            children.add((ExprNodeDesc)constDesc);
        }
        for (i = 0; i < fieldCount; ++i) {
            columns.add(rowColumnNameList.get(i));
        }
        String[] columnNames = columns.toArray(new String[0]);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        GenericUDFIn udf = new GenericUDFIn();
        int compareCount = compareList.size();
        ObjectInspector[] argumentOIs = new ObjectInspector[compareCount];
        for (int i5 = 0; i5 < compareCount; ++i5) {
            argumentOIs[i5] = structUdfObjectInspector;
        }
        ObjectInspector outputObjectInspector = udf.initialize(argumentOIs);
        TypeInfo outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)udf, children);
        return this.executeTestModesAndVerify(structUdfTypeInfo, betweenInVariation, compareList, columns, columnNames, children, (GenericUDF)udf, exprDesc, randomRows, rowSource, batchSource, outputTypeInfo, true);
    }

    private boolean executeTestModesAndVerify(TypeInfo typeInfo, BetweenInVariation betweenInVariation, List<Object> compareList, List<String> columns, String[] columnNames, List<ExprNodeDesc> children, GenericUDF udf, ExprNodeGenericFuncDesc exprDesc, Object[][] randomRows, VectorRandomRowSource rowSource, VectorRandomBatchSource batchSource, TypeInfo outputTypeInfo, boolean skipAdaptor) throws Exception {
        int i;
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[BetweenInTestMode.count][];
        block5: for (i = 0; i < BetweenInTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            BetweenInTestMode betweenInTestMode = BetweenInTestMode.values()[i];
            switch (betweenInTestMode) {
                case ROW_MODE: {
                    if (this.doRowCastTest(typeInfo, betweenInVariation, compareList, columns, children, udf, exprDesc, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), resultObjects)) continue block5;
                    return false;
                }
                case ADAPTOR: {
                    if (skipAdaptor) continue block5;
                }
                case VECTOR_EXPRESSION: {
                    if (this.doVectorBetweenInTest(typeInfo, betweenInVariation, compareList, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, udf, exprDesc, betweenInTestMode, batchSource, exprDesc.getWritableObjectInspector(), outputTypeInfo, resultObjects)) continue block5;
                    return false;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + betweenInTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < BetweenInTestMode.count; ++v) {
                BetweenInTestMode betweenInTestMode = BetweenInTestMode.values()[v];
                if (skipAdaptor) continue;
                Object vectorResult = resultObjectsArray[v][i];
                if (betweenInVariation.isFilter && expectedResult == null && vectorResult != null) {
                    boolean vectorBoolean = ((BooleanWritable)vectorResult).get();
                    if (!vectorBoolean) continue;
                    Assert.fail((String)("Row " + i + " typeName " + typeInfo.getTypeName() + " outputTypeName " + outputTypeInfo.getTypeName() + " " + betweenInVariation + " " + betweenInTestMode + " result is NOT NULL and true does not match row-mode expected result is NULL which means false here row values " + Arrays.toString(randomRows[i]) + " exprDesc " + exprDesc.toString()));
                    continue;
                }
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " sourceTypeName " + typeInfo.getTypeName() + " " + betweenInVariation + " " + betweenInTestMode + " result is NULL " + (String)(vectorResult == null ? "YES" : "NO result " + vectorResult.toString()) + " does not match row-mode expected result is NULL " + (String)(expectedResult == null ? "YES" : "NO result " + expectedResult.toString()) + " row values " + Arrays.toString(randomRows[i]) + " exprDesc " + exprDesc.toString()));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " sourceTypeName " + typeInfo.getTypeName() + " " + betweenInVariation + " " + betweenInTestMode + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i]) + " exprDesc " + exprDesc.toString()));
            }
        }
        return true;
    }

    private boolean doRowCastTest(TypeInfo typeInfo, BetweenInVariation betweenInVariation, List<Object> compareList, List<String> columns, List<ExprNodeDesc> children, GenericUDF udf, ExprNodeGenericFuncDesc exprDesc, Object[][] randomRows, ObjectInspector rowInspector, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        for (Object[] row : randomRows) {
            Object copyResult;
            Object result = evaluator.evaluate((Object)row);
            resultObjects[i] = copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        return true;
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, ObjectInspector objectInspector, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private boolean doVectorBetweenInTest(TypeInfo typeInfo, BetweenInVariation betweenInVariation, List<Object> compareList, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, GenericUDF udf, ExprNodeGenericFuncDesc exprDesc, BetweenInTestMode betweenInTestMode, VectorRandomBatchSource batchSource, ObjectInspector objectInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (betweenInTestMode == BetweenInTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        boolean isFilter = betweenInVariation.isFilter;
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc, isFilter ? VectorExpressionDescriptor.Mode.FILTER : VectorExpressionDescriptor.Mode.PROJECTION);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (betweenInTestMode == BetweenInTestMode.VECTOR_EXPRESSION) {
            String nameToCheck;
            String vecExprString = vectorExpression.toString();
            if (vectorExpression instanceof VectorUDFAdaptor) {
                System.out.println("*NO NATIVE VECTOR EXPRESSION* typeInfo " + typeInfo.toString() + " betweenInTestMode " + betweenInTestMode + " betweenInVariation " + betweenInVariation + " vectorExpression " + vecExprString);
            } else if (dataTypePhysicalVariations[0] == DataTypePhysicalVariation.DECIMAL_64 && !(nameToCheck = vectorExpression.getClass().getSimpleName()).contains("Decimal64")) {
                System.out.println("*EXPECTED DECIMAL_64 VECTOR EXPRESSION* typeInfo " + typeInfo.toString() + " betweenInTestMode " + betweenInTestMode + " betweenInVariation " + betweenInVariation + " vectorExpression " + vecExprString);
            }
        }
        VectorRandomRowSource rowSource = batchSource.getRowSource();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, vectorizationContext.getScratchColumnTypeNames(), vectorizationContext.getScratchDataTypePhysicalVariations());
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = null;
        Object[] scrqtchRow = null;
        if (!isFilter) {
            resultVectorExtractRow = new VectorExtractRow();
            int outputColumnNum = vectorExpression.getOutputColumnNum();
            resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{outputColumnNum});
            scrqtchRow = new Object[1];
        }
        boolean copySelectedInUse = false;
        int[] copySelected = new int[1024];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            int originalBatchSize = batch.size;
            if (isFilter) {
                copySelectedInUse = batch.selectedInUse;
                if (batch.selectedInUse) {
                    System.arraycopy(batch.selected, 0, copySelected, 0, originalBatchSize);
                }
            }
            vectorExpression.evaluate(batch);
            if (!isFilter) {
                this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, objectInspector, resultObjects);
            } else {
                int currentBatchSize = batch.size;
                if (copySelectedInUse && batch.selectedInUse) {
                    selectIndex = 0;
                    for (i = 0; i < originalBatchSize; ++i) {
                        boolean booleanResult;
                        int originalBatchIndex = copySelected[i];
                        if (selectIndex < currentBatchSize && batch.selected[selectIndex] == originalBatchIndex) {
                            booleanResult = true;
                            ++selectIndex;
                        } else {
                            booleanResult = false;
                        }
                        resultObjects[rowIndex + i] = new BooleanWritable(booleanResult);
                    }
                } else if (batch.selectedInUse) {
                    selectIndex = 0;
                    for (i = 0; i < originalBatchSize; ++i) {
                        boolean booleanResult;
                        if (selectIndex < currentBatchSize && batch.selected[selectIndex] == i) {
                            booleanResult = true;
                            ++selectIndex;
                        } else {
                            booleanResult = false;
                        }
                        resultObjects[rowIndex + i] = new BooleanWritable(booleanResult);
                    }
                } else if (currentBatchSize == 0) {
                    for (i = 0; i < originalBatchSize; ++i) {
                        resultObjects[rowIndex + i] = new BooleanWritable(false);
                    }
                } else {
                    for (i = 0; i < originalBatchSize; ++i) {
                        resultObjects[rowIndex + i] = new BooleanWritable(true);
                    }
                }
            }
            rowIndex += originalBatchSize;
        }
        return true;
    }

    public static enum BetweenInVariation {
        FILTER_BETWEEN,
        FILTER_NOT_BETWEEN,
        PROJECTION_BETWEEN,
        PROJECTION_NOT_BETWEEN,
        FILTER_IN,
        PROJECTION_IN;

        static final int count;
        final boolean isFilter = this.name().startsWith("FILTER");

        static {
            count = BetweenInVariation.values().length;
        }
    }

    public static enum BetweenInTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = BetweenInTestMode.values().length;
        }
    }
}

