/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorArithmetic {
    private static TypeInfo[] integerTypeInfos = new TypeInfo[]{TypeInfoFactory.byteTypeInfo, TypeInfoFactory.shortTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.longTypeInfo};
    private static TypeInfo[] floatingTypeInfos = new TypeInfo[]{TypeInfoFactory.doubleTypeInfo};
    private static TypeInfo[] decimalTypeInfos = new TypeInfo[]{new DecimalTypeInfo(38, 18), new DecimalTypeInfo(25, 2), new DecimalTypeInfo(19, 4), new DecimalTypeInfo(18, 10), new DecimalTypeInfo(17, 3), new DecimalTypeInfo(12, 2), new DecimalTypeInfo(7, 1)};
    private static TypeInfo[] intervalTypeInfos = new TypeInfo[]{TypeInfoFactory.intervalYearMonthTypeInfo, TypeInfoFactory.intervalDayTimeTypeInfo};

    public TestVectorArithmetic() {
        SessionState ss = new SessionState(new HiveConf());
        ss.getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "default");
        SessionState.setCurrentSessionState((SessionState)ss);
    }

    @Test
    public void testIntegers() throws Exception {
        Random random = new Random(7743L);
        this.doIntegerTests(random);
    }

    @Test
    public void testIntegerFloating() throws Exception {
        Random random = new Random(7743L);
        this.doIntegerFloatingTests(random);
    }

    @Test
    public void testFloating() throws Exception {
        Random random = new Random(7743L);
        this.doFloatingTests(random);
    }

    @Test
    public void testDecimal() throws Exception {
        Random random = new Random(7743L);
        this.doDecimalTests(random, false);
    }

    @Test
    public void testDecimal64() throws Exception {
        Random random = new Random(7743L);
        this.doDecimalTests(random, true);
    }

    @Test
    public void testInterval() throws Exception {
        Random random = new Random(7743L);
        this.doIntervalTests(random);
    }

    @Test
    public void testTimestampInterval() throws Exception {
        Random random = new Random(7743L);
        this.doAddSubTests(random, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.intervalYearMonthTypeInfo);
        this.doAddSubTests(random, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.intervalDayTimeTypeInfo);
        this.doSubTests(random, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.doAddTests(random, (TypeInfo)TypeInfoFactory.intervalYearMonthTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.doAddTests(random, (TypeInfo)TypeInfoFactory.intervalDayTimeTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
    }

    @Test
    public void testTimestampDate() throws Exception {
        Random random = new Random(7743L);
        this.doSubTests(random, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.doSubTests(random, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo);
    }

    @Test
    public void testDateInterval() throws Exception {
        Random random = new Random(7743L);
        this.doAddSubTests(random, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.intervalYearMonthTypeInfo);
        this.doAddSubTests(random, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.intervalDayTimeTypeInfo);
        this.doSubTests(random, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo);
        this.doAddTests(random, (TypeInfo)TypeInfoFactory.intervalYearMonthTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo);
        this.doAddTests(random, (TypeInfo)TypeInfoFactory.intervalDayTimeTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo);
    }

    private void doIntegerTests(Random random) throws Exception {
        for (TypeInfo typeInfo : integerTypeInfos) {
            for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
                this.doTestsWithDiffColumnScalar(random, typeInfo, typeInfo, columnScalarMode);
            }
        }
    }

    private void doIntegerFloatingTests(Random random) throws Exception {
        for (TypeInfo typeInfo1 : integerTypeInfos) {
            for (TypeInfo typeInfo2 : floatingTypeInfos) {
                for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
                    this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode);
                }
            }
        }
        for (TypeInfo typeInfo1 : floatingTypeInfos) {
            for (TypeInfo typeInfo2 : integerTypeInfos) {
                for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
                    this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode);
                }
            }
        }
    }

    private void doFloatingTests(Random random) throws Exception {
        for (TypeInfo typeInfo1 : floatingTypeInfos) {
            for (TypeInfo typeInfo2 : floatingTypeInfos) {
                for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
                    this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode);
                }
            }
        }
    }

    private void doDecimalTests(Random random, boolean tryDecimal64) throws Exception {
        for (TypeInfo typeInfo : decimalTypeInfos) {
            for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
                this.doTestsWithDiffColumnScalar(random, typeInfo, typeInfo, columnScalarMode, tryDecimal64);
            }
        }
    }

    private void doIntervalTests(Random random) throws Exception {
        for (TypeInfo typeInfo : intervalTypeInfos) {
            this.doAddSubTests(random, typeInfo, typeInfo);
        }
    }

    private TypeInfo getOutputTypeInfo(GenericUDF genericUdfClone, List<ObjectInspector> objectInspectorList) throws HiveException {
        ObjectInspector[] array = objectInspectorList.toArray(new ObjectInspector[objectInspectorList.size()]);
        ObjectInspector outputObjectInspector = genericUdfClone.initialize(array);
        return TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
    }

    private TypeInfo getDecimalScalarTypeInfo(Object scalarObject) {
        HiveDecimal dec = (HiveDecimal)scalarObject;
        int precision = dec.precision();
        int scale = dec.scale();
        return new DecimalTypeInfo(precision, scale);
    }

    private boolean checkDecimal64(boolean tryDecimal64, TypeInfo typeInfo) {
        if (!tryDecimal64 || !(typeInfo instanceof DecimalTypeInfo)) {
            return false;
        }
        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
        boolean result = HiveDecimalWritable.isPrecisionDecimal64((int)decimalTypeInfo.getPrecision());
        return result;
    }

    private void doAddTests(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2) throws Exception {
        for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
            this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode, Arithmetic.ADD, false);
        }
    }

    private void doSubTests(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2) throws Exception {
        for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
            this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode, Arithmetic.SUBTRACT, false);
        }
    }

    private void doAddSubTests(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2) throws Exception {
        this.doAddTests(random, typeInfo1, typeInfo2);
        this.doSubTests(random, typeInfo1, typeInfo2);
    }

    private void doTestsWithDiffColumnScalar(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2, ColumnScalarMode columnScalarMode) throws Exception {
        for (Arithmetic arithmetic : Arithmetic.values()) {
            this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode, arithmetic, false);
        }
    }

    private void doTestsWithDiffColumnScalar(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2, ColumnScalarMode columnScalarMode, boolean tryDecimal64) throws Exception {
        for (Arithmetic arithmetic : Arithmetic.values()) {
            this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode, arithmetic, tryDecimal64);
        }
    }

    private void doTestsWithDiffColumnScalar(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2, ColumnScalarMode columnScalarMode, Arithmetic arithmetic, boolean tryDecimal64) throws Exception {
        int i;
        ExprNodeConstantDesc col2Expr;
        ExprNodeConstantDesc col1Expr;
        String typeName1 = typeInfo1.getTypeName();
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory1 = ((PrimitiveTypeInfo)typeInfo1).getPrimitiveCategory();
        String typeName2 = typeInfo2.getTypeName();
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory2 = ((PrimitiveTypeInfo)typeInfo2).getPrimitiveCategory();
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        int columnNum = 1;
        Object scalar1Object = null;
        boolean decimal64Enable1 = this.checkDecimal64(tryDecimal64, typeInfo1);
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.COLUMN_SCALAR) {
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(typeInfo1));
            explicitDataTypePhysicalVariationList.add(decimal64Enable1 ? DataTypePhysicalVariation.DECIMAL_64 : DataTypePhysicalVariation.NONE);
            String columnName = "col" + columnNum++;
            col1Expr = new ExprNodeColumnDesc(typeInfo1, columnName, "table", false);
            columns.add(columnName);
        } else {
            scalar1Object = VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo1);
            if (typeInfo1 instanceof DecimalTypeInfo) {
                typeInfo1 = this.getDecimalScalarTypeInfo(scalar1Object);
            }
            col1Expr = new ExprNodeConstantDesc(typeInfo1, scalar1Object);
        }
        Object scalar2Object = null;
        boolean decimal64Enable2 = this.checkDecimal64(tryDecimal64, typeInfo2);
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.SCALAR_COLUMN) {
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(typeInfo2));
            explicitDataTypePhysicalVariationList.add(decimal64Enable2 ? DataTypePhysicalVariation.DECIMAL_64 : DataTypePhysicalVariation.NONE);
            String columnName = "col" + columnNum++;
            col2Expr = new ExprNodeColumnDesc(typeInfo2, columnName, "table", false);
            columns.add(columnName);
        } else {
            scalar2Object = VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo2);
            if (typeInfo2 instanceof DecimalTypeInfo) {
                typeInfo2 = this.getDecimalScalarTypeInfo(scalar2Object);
            }
            col2Expr = new ExprNodeConstantDesc(typeInfo2, scalar2Object);
        }
        ArrayList<ObjectInspector> objectInspectorList = new ArrayList<ObjectInspector>();
        objectInspectorList.add(VectorRandomRowSource.getObjectInspector(typeInfo1));
        objectInspectorList.add(VectorRandomRowSource.getObjectInspector(typeInfo2));
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        children.add((ExprNodeDesc)col2Expr);
        String[] columnNames = columns.toArray(new String[0]);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, true, explicitDataTypePhysicalVariationList);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        GenericUDFOPPlus genericUdf = switch (arithmetic) {
            case Arithmetic.ADD -> new GenericUDFOPPlus();
            case Arithmetic.SUBTRACT -> new GenericUDFOPMinus();
            case Arithmetic.MULTIPLY -> new GenericUDFOPMultiply();
            case Arithmetic.DIVIDE -> new GenericUDFOPDivide();
            case Arithmetic.MODULUS -> new GenericUDFOPMod();
            default -> throw new RuntimeException("Unexpected arithmetic " + arithmetic);
        };
        ObjectInspector[] objectInspectors = objectInspectorList.toArray(new ObjectInspector[objectInspectorList.size()]);
        ObjectInspector outputObjectInspector = null;
        try {
            outputObjectInspector = genericUdf.initialize(objectInspectors);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        TypeInfo outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(outputTypeInfo, (GenericUDF)genericUdf, children);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[ArithmeticTestMode.count][];
        block13: for (i = 0; i < ArithmeticTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            ArithmeticTestMode arithmeticTestMode = ArithmeticTestMode.values()[i];
            switch (arithmeticTestMode) {
                case ROW_MODE: {
                    this.doRowArithmeticTest(typeInfo1, typeInfo2, columns, children, exprDesc, arithmetic, randomRows, columnScalarMode, (ObjectInspector)rowSource.rowStructObjectInspector(), outputTypeInfo, resultObjects);
                    continue block13;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    this.doVectorArithmeticTest(typeInfo1, typeInfo2, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, exprDesc, arithmetic, arithmeticTestMode, columnScalarMode, batchSource, exprDesc.getWritableObjectInspector(), outputTypeInfo, resultObjects);
                    continue block13;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + arithmeticTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < ArithmeticTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " typeName1 " + typeName1 + " typeName2 " + typeName2 + " outputTypeName " + outputTypeInfo.getTypeName() + " " + arithmetic + " " + ArithmeticTestMode.values()[v] + " " + columnScalarMode + " result is NULL " + (vectorResult == null) + " does not match row-mode expected result is NULL " + (expectedResult == null) + (String)(columnScalarMode == ColumnScalarMode.SCALAR_COLUMN ? " scalar1 " + scalar1Object.toString() : "") + " row values " + Arrays.toString(randomRows[i]) + (String)(columnScalarMode == ColumnScalarMode.COLUMN_SCALAR ? " scalar2 " + scalar2Object.toString() : "")));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " typeName1 " + typeName1 + " typeName2 " + typeName2 + " outputTypeName " + outputTypeInfo.getTypeName() + " " + arithmetic + " " + ArithmeticTestMode.values()[v] + " " + columnScalarMode + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ")" + (String)(columnScalarMode == ColumnScalarMode.SCALAR_COLUMN ? " scalar1 " + scalar1Object.toString() : "") + " row values " + Arrays.toString(randomRows[i]) + (String)(columnScalarMode == ColumnScalarMode.COLUMN_SCALAR ? " scalar2 " + scalar2Object.toString() : "")));
            }
        }
    }

    private void doRowArithmeticTest(TypeInfo typeInfo1, TypeInfo typeInfo2, List<String> columns, List<ExprNodeDesc> children, ExprNodeGenericFuncDesc exprDesc, Arithmetic arithmetic, Object[][] randomRows, ColumnScalarMode columnScalarMode, ObjectInspector rowInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)outputTypeInfo);
        for (Object[] row : randomRows) {
            Object result = evaluator.evaluate((Object)row);
            Object copyResult = null;
            try {
                copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            }
            catch (Exception e) {
                Assert.fail((String)e.toString());
            }
            resultObjects[i] = copyResult;
        }
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, ObjectInspector objectInspector, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private void doVectorArithmeticTest(TypeInfo typeInfo1, TypeInfo typeInfo2, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, ExprNodeGenericFuncDesc exprDesc, Arithmetic arithmetic, ArithmeticTestMode arithmeticTestMode, ColumnScalarMode columnScalarMode, VectorRandomBatchSource batchSource, ObjectInspector objectInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (arithmeticTestMode == ArithmeticTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
            dataTypePhysicalVariations = null;
        }
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), dataTypePhysicalVariations == null ? null : Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (arithmeticTestMode == ArithmeticTestMode.VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* typeInfo1 " + typeInfo1.toString() + " typeInfo2 " + typeInfo2.toString() + " arithmeticTestMode " + arithmeticTestMode + " columnScalarMode " + columnScalarMode + " vectorExpression " + vectorExpression.toString());
        }
        String[] outputScratchTypeNames = vectorizationContext.getScratchColumnTypeNames();
        DataTypePhysicalVariation[] outputDataTypePhysicalVariations = vectorizationContext.getScratchDataTypePhysicalVariations();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, typeInfos, dataTypePhysicalVariations, null, 0, 0, null, outputScratchTypeNames, outputDataTypePhysicalVariations);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{vectorExpression.getOutputColumnNum()});
        Object[] scrqtchRow = new Object[1];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, objectInspector, resultObjects);
            rowIndex += batch.size;
        }
    }

    public static enum ColumnScalarMode {
        COLUMN_COLUMN,
        COLUMN_SCALAR,
        SCALAR_COLUMN;

        static final int count;

        static {
            count = ColumnScalarMode.values().length;
        }
    }

    public static enum Arithmetic {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MODULUS;

    }

    public static enum ArithmeticTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = ArithmeticTestMode.values().length;
        }
    }
}

