/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MurmurHashIntColIntCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MurmurHashStringColIntCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MurmurHashStringColStringCol;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.benchmark.vectorization.ColumnVectorGenUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestMurmurHashExpression {
    private Random rand = new Random(TestMurmurHashExpression.class.getName().getBytes().hashCode());
    private int SIZE = 1024;

    @Test
    public void testMurmurHashStringColIntCol() throws HiveException {
        BytesColumnVector cvString = (BytesColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (boolean)false, (boolean)false, (int)this.SIZE, (Random)this.rand);
        LongColumnVector cvInt = (LongColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), (boolean)false, (boolean)false, (int)this.SIZE, (Random)this.rand);
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvString;
        vrb.cols[1] = cvInt;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        new MurmurHashStringColIntCol(0, 1, 2).evaluate(vrb);
        for (int i = 0; i < this.SIZE; ++i) {
            Text t = new Text();
            t.set(cvString.vector[i], cvString.start[i], cvString.length[i]);
            Assert.assertEquals((long)ObjectInspectorUtils.getBucketHashCode((Object[])new Object[]{t, new LongWritable(cvInt.vector[i])}, (ObjectInspector[])new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector}), (long)((LongColumnVector)vrb.cols[2]).vector[i]);
        }
    }

    @Test
    public void testMurmurHashStringColStringCol() throws HiveException {
        BytesColumnVector cvString1 = (BytesColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (boolean)false, (boolean)false, (int)this.SIZE, (Random)this.rand);
        BytesColumnVector cvString2 = (BytesColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (boolean)false, (boolean)false, (int)this.SIZE, (Random)this.rand);
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvString1;
        vrb.cols[1] = cvString2;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        new MurmurHashStringColStringCol(0, 1, 2).evaluate(vrb);
        Assert.assertEquals((Object)false, (Object)vrb.cols[2].isRepeating);
        for (int i = 0; i < this.SIZE; ++i) {
            Text t1 = new Text();
            t1.set(cvString1.vector[i], cvString1.start[i], cvString1.length[i]);
            Text t2 = new Text();
            t2.set(cvString2.vector[i], cvString2.start[i], cvString2.length[i]);
            Assert.assertEquals((long)ObjectInspectorUtils.getBucketHashCode((Object[])new Object[]{t1, t2}, (ObjectInspector[])new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector}), (long)((LongColumnVector)vrb.cols[2]).vector[i]);
        }
    }

    @Test
    public void testMurmurHashIntColIntCol() throws HiveException {
        LongColumnVector cvInt1 = (LongColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), (boolean)false, (boolean)false, (int)this.SIZE, (Random)this.rand);
        LongColumnVector cvInt2 = (LongColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), (boolean)false, (boolean)false, (int)this.SIZE, (Random)this.rand);
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvInt1;
        vrb.cols[1] = cvInt2;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        new MurmurHashIntColIntCol(0, 1, 2).evaluate(vrb);
        Assert.assertEquals((Object)false, (Object)vrb.cols[2].isRepeating);
        for (int i = 0; i < this.SIZE; ++i) {
            Assert.assertEquals((long)ObjectInspectorUtils.getBucketHashCode((Object[])new Object[]{new LongWritable(cvInt1.vector[i]), new LongWritable(cvInt2.vector[i])}, (ObjectInspector[])new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector}), (long)((LongColumnVector)vrb.cols[2]).vector[i]);
        }
    }

    @Test
    public void testMurmurHashRepeating() throws HiveException {
        BytesColumnVector cvString1 = (BytesColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (boolean)false, (boolean)true, (int)this.SIZE, (Random)this.rand);
        BytesColumnVector cvString2 = (BytesColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (boolean)false, (boolean)true, (int)this.SIZE, (Random)this.rand);
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvString1;
        vrb.cols[1] = cvString2;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        new MurmurHashStringColStringCol(0, 1, 2).evaluate(vrb);
        Assert.assertEquals((Object)true, (Object)vrb.cols[2].isRepeating);
        Text t1 = new Text();
        t1.set(cvString1.vector[0], cvString1.start[0], cvString1.length[0]);
        Text t2 = new Text();
        t2.set(cvString2.vector[0], cvString2.start[0], cvString2.length[0]);
        Assert.assertEquals((long)ObjectInspectorUtils.getBucketHashCode((Object[])new Object[]{t1, t2}, (ObjectInspector[])new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector}), (long)((LongColumnVector)vrb.cols[2]).vector[0]);
    }

    @Test
    public void testMurmurHashRepeatingBothNulls() throws HiveException {
        BytesColumnVector cvString1 = (BytesColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (boolean)false, (boolean)true, (int)this.SIZE, (Random)this.rand);
        BytesColumnVector cvString2 = (BytesColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (boolean)false, (boolean)true, (int)this.SIZE, (Random)this.rand);
        cvString1.isNull[0] = true;
        cvString2.isNull[0] = true;
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvString1;
        vrb.cols[1] = cvString2;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        ((LongColumnVector)vrb.cols[2]).vector[1] = 1234L;
        new MurmurHashStringColStringCol(0, 1, 2).evaluate(vrb);
        Assert.assertEquals((Object)true, (Object)vrb.cols[2].isRepeating);
        Assert.assertEquals((long)0L, (long)((LongColumnVector)vrb.cols[2]).vector[0]);
        Assert.assertEquals((long)1234L, (long)((LongColumnVector)vrb.cols[2]).vector[1]);
    }

    @Test
    public void testMurmurHashWithNullsString() throws HiveException {
        BytesColumnVector cvString1 = (BytesColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (boolean)true, (boolean)false, (int)this.SIZE, (Random)this.rand);
        BytesColumnVector cvString2 = (BytesColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (boolean)true, (boolean)false, (int)this.SIZE, (Random)this.rand);
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvString1;
        vrb.cols[1] = cvString2;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        new MurmurHashStringColStringCol(0, 1, 2).evaluate(vrb);
        Assert.assertEquals((Object)false, (Object)vrb.cols[2].isRepeating);
        for (int i = 0; i < this.SIZE; ++i) {
            Text t1 = null;
            if (!cvString1.isNull[i]) {
                t1 = new Text();
                t1.set(cvString1.vector[i], cvString1.start[i], cvString1.length[i]);
            }
            Text t2 = null;
            if (!cvString2.isNull[i]) {
                t2 = new Text();
                t2.set(cvString2.vector[i], cvString2.start[i], cvString2.length[i]);
            }
            Assert.assertEquals((long)ObjectInspectorUtils.getBucketHashCode((Object[])new Object[]{t1, t2}, (ObjectInspector[])new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector}), (long)((LongColumnVector)vrb.cols[2]).vector[i]);
        }
    }

    @Test
    public void testMurmurHashWithNullsInt() throws HiveException {
        LongColumnVector cvInt1 = (LongColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), (boolean)true, (boolean)false, (int)this.SIZE, (Random)this.rand);
        LongColumnVector cvInt2 = (LongColumnVector)ColumnVectorGenUtil.generateColumnVector((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), (boolean)true, (boolean)false, (int)this.SIZE, (Random)this.rand);
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvInt1;
        vrb.cols[1] = cvInt2;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        new MurmurHashIntColIntCol(0, 1, 2).evaluate(vrb);
        Assert.assertEquals((Object)false, (Object)vrb.cols[2].isRepeating);
        for (int i = 0; i < this.SIZE; ++i) {
            Assert.assertEquals((long)ObjectInspectorUtils.getBucketHashCode((Object[])new Object[]{cvInt1.isNull[i] ? null : new LongWritable(cvInt1.vector[i]), cvInt2.isNull[i] ? null : new LongWritable(cvInt2.vector[i])}, (ObjectInspector[])new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector}), (long)((LongColumnVector)vrb.cols[2]).vector[i]);
        }
    }

    private BytesColumnVector createBytesColumnVector(Text value, boolean isRepeating) {
        BytesColumnVector bcv = new BytesColumnVector(this.SIZE);
        bcv.initBuffer(value.getLength());
        bcv.noNulls = true;
        bcv.isRepeating = isRepeating;
        byte[] bytes = value.copyBytes();
        if (isRepeating) {
            bcv.setRef(0, bytes, 0, value.getLength());
            for (int i = 1; i < this.SIZE; ++i) {
                bcv.length[i] = 10;
            }
        } else {
            for (int i = 0; i < this.SIZE; ++i) {
                bcv.setRef(i, bytes, 0, value.getLength());
            }
        }
        return bcv;
    }

    private LongColumnVector createLongColumnVector(long value, boolean isRepeating) {
        LongColumnVector lcv = new LongColumnVector(this.SIZE);
        lcv.noNulls = true;
        lcv.isRepeating = isRepeating;
        if (isRepeating) {
            lcv.vector[0] = value;
        } else {
            for (int i = 0; i < this.SIZE; ++i) {
                lcv.vector[i] = value;
            }
        }
        return lcv;
    }

    @Test
    public void testMurmurHashStringColStringColSingleRepeating() throws HiveException {
        Text text = new Text("Value");
        BytesColumnVector cvString1 = this.createBytesColumnVector(text, false);
        BytesColumnVector cvString2 = this.createBytesColumnVector(text, true);
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvString1;
        vrb.cols[1] = cvString2;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        new MurmurHashStringColStringCol(0, 1, 2).evaluate(vrb);
        Assert.assertFalse((boolean)vrb.cols[2].isRepeating);
        for (int i = 0; i < this.SIZE; ++i) {
            Assert.assertEquals((long)-452676736L, (long)((LongColumnVector)vrb.cols[2]).vector[i]);
        }
    }

    @Test
    public void testMurmurHashIntColIntColSingleRepeating() throws HiveException {
        long num = 7640254796529531955L;
        LongColumnVector cvLong1 = this.createLongColumnVector(num, false);
        LongColumnVector cvLong2 = this.createLongColumnVector(num, true);
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvLong1;
        vrb.cols[1] = cvLong2;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        new MurmurHashIntColIntCol(0, 1, 2).evaluate(vrb);
        Assert.assertFalse((boolean)vrb.cols[2].isRepeating);
        for (int i = 0; i < this.SIZE; ++i) {
            Assert.assertEquals((long)1533409056L, (long)((LongColumnVector)vrb.cols[2]).vector[i]);
        }
    }

    @Test
    public void testMurmurHashNonRepeatingStringColRepeatingIntCol() throws HiveException {
        Text text = new Text("Value");
        long num = 7640254796529531955L;
        BytesColumnVector cvString = this.createBytesColumnVector(text, false);
        LongColumnVector cvLong = this.createLongColumnVector(num, true);
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvString;
        vrb.cols[1] = cvLong;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        new MurmurHashStringColIntCol(0, 1, 2).evaluate(vrb);
        Assert.assertFalse((boolean)vrb.cols[2].isRepeating);
        for (int i = 0; i < this.SIZE; ++i) {
            Assert.assertEquals((long)1622654365L, (long)((LongColumnVector)vrb.cols[2]).vector[i]);
        }
    }

    @Test
    public void testMurmurHashRepeatingStringColNonRepeatingIntCol() throws HiveException {
        Text text = new Text("Value");
        long num = 7640254796529531955L;
        BytesColumnVector cvString = this.createBytesColumnVector(text, true);
        LongColumnVector cvLong = this.createLongColumnVector(num, false);
        VectorizedRowBatch vrb = new VectorizedRowBatch(3, this.SIZE);
        vrb.cols[0] = cvString;
        vrb.cols[1] = cvLong;
        vrb.cols[2] = new LongColumnVector(this.SIZE);
        new MurmurHashStringColIntCol(0, 1, 2).evaluate(vrb);
        Assert.assertFalse((boolean)vrb.cols[2].isRepeating);
        for (int i = 0; i < this.SIZE; ++i) {
            Assert.assertEquals((long)1622654365L, (long)((LongColumnVector)vrb.cols[2]).vector[i]);
        }
    }
}

