/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorTopNKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TopNKeyDesc;
import org.apache.hadoop.hive.ql.plan.VectorTopNKeyDesc;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestVectorTopNKeyOperator
extends TestVectorOperator {
    @Test
    public void testTopNHasSelectedSmallerThanBatchDoesNotThrowException() throws HiveException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("col1");
        TopNKeyDesc topNKeyDesc = new TopNKeyDesc();
        topNKeyDesc.setCheckEfficiencyNumBatches(1L);
        topNKeyDesc.setTopN(2);
        Operator filterOp = OperatorFactory.get((CompilationOpContext)new CompilationOpContext(), (OperatorDesc)topNKeyDesc);
        VectorizationContext vc = new VectorizationContext("name", columns);
        VectorTopNKeyOperator vfo = (VectorTopNKeyOperator)Vectorizer.vectorizeTopNKeyOperator((Operator)filterOp, (VectorizationContext)vc, (VectorTopNKeyDesc)new VectorTopNKeyDesc());
        vfo.initialize((Configuration)this.hiveConf, null);
        TestVectorOperator.FakeDataReader fdr = new TestVectorOperator.FakeDataReader(1024, 3, TestVectorOperator.FakeDataSampleType.Repeated);
        VectorizedRowBatch vrg = fdr.getNext();
        vrg.selected = new int[]{1, 2, 3, 4};
        Assertions.assertDoesNotThrow(() -> vfo.process((Object)vrg, 0));
    }
}

