/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorSelectOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorSelectDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorSelectOperator {
    @Test
    public void testSelectOperator() throws HiveException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("a");
        columns.add("b");
        columns.add("c");
        VectorizationContext vc = new VectorizationContext("name", columns);
        SelectDesc selDesc = new SelectDesc(false);
        ArrayList<Object> colList = new ArrayList<Object>();
        ExprNodeColumnDesc colDesc1 = new ExprNodeColumnDesc(Long.class, "a", "table", false);
        ExprNodeColumnDesc colDesc2 = new ExprNodeColumnDesc(Long.class, "b", "table", false);
        ExprNodeColumnDesc colDesc3 = new ExprNodeColumnDesc(Long.class, "c", "table", false);
        ExprNodeGenericFuncDesc plusDesc = new ExprNodeGenericFuncDesc();
        GenericUDFOPPlus gudf = new GenericUDFOPPlus();
        plusDesc.setGenericUDF((GenericUDF)gudf);
        ArrayList<ExprNodeColumnDesc> children = new ArrayList<ExprNodeColumnDesc>();
        children.add(colDesc1);
        children.add(colDesc2);
        plusDesc.setChildren(children);
        plusDesc.setTypeInfo((TypeInfo)TypeInfoFactory.longTypeInfo);
        colList.add(plusDesc);
        colList.add(colDesc3);
        selDesc.setColList(colList);
        ArrayList<String> outputColNames = new ArrayList<String>();
        outputColNames.add("_col0");
        outputColNames.add("_col1");
        selDesc.setOutputColumnNames(outputColNames);
        VectorSelectDesc vectorSelectDesc = new VectorSelectDesc();
        List selectColList = selDesc.getColList();
        VectorExpression[] vectorSelectExprs = new VectorExpression[selectColList.size()];
        for (int i = 0; i < selectColList.size(); ++i) {
            VectorExpression ve;
            ExprNodeDesc expr = (ExprNodeDesc)selectColList.get(i);
            vectorSelectExprs[i] = ve = vc.getVectorExpression(expr);
        }
        vectorSelectDesc.setSelectExpressions(vectorSelectExprs);
        vectorSelectDesc.setProjectedOutputColumns(new int[]{3, 2});
        ValidatorVectorSelectOperator vso = new ValidatorVectorSelectOperator(new CompilationOpContext(), (OperatorDesc)selDesc, vc, (VectorDesc)vectorSelectDesc);
        VectorizedRowBatch vrg = VectorizedRowGroupGenUtil.getVectorizedRowBatch(1024, 4, 17);
        vso.process(vrg, 0);
    }

    static class ValidatorVectorSelectOperator
    extends VectorSelectOperator {
        private static final long serialVersionUID = 1L;

        public ValidatorVectorSelectOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext ctxt, VectorDesc vectorDesc) throws HiveException {
            super(ctx, conf, ctxt, vectorDesc);
            this.initializeOp(null);
        }

        public void vectorForward(VectorizedRowBatch vrg) throws HiveException {
            int[] projections = vrg.projectedColumns;
            Assert.assertEquals((long)2L, (long)vrg.projectionSize);
            Assert.assertEquals((long)3L, (long)projections[0]);
            Assert.assertEquals((long)2L, (long)projections[1]);
            LongColumnVector out0 = (LongColumnVector)vrg.cols[projections[0]];
            LongColumnVector out1 = (LongColumnVector)vrg.cols[projections[1]];
            LongColumnVector in0 = (LongColumnVector)vrg.cols[0];
            LongColumnVector in1 = (LongColumnVector)vrg.cols[1];
            LongColumnVector in2 = (LongColumnVector)vrg.cols[2];
            LongColumnVector in3 = (LongColumnVector)vrg.cols[3];
            for (int i = 0; i < 1024; ++i) {
                Assert.assertEquals((long)(in0.vector[i] + in1.vector[i]), (long)out0.vector[i]);
                Assert.assertEquals((long)in3.vector[i], (long)out0.vector[i]);
                Assert.assertEquals((long)in2.vector[i], (long)out1.vector[i]);
            }
        }
    }
}

