/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;

public abstract class TestVectorOperator {
    protected HiveConf hiveConf = new HiveConf();

    public class FakeDataReader {
        private final int size;
        private final VectorizedRowBatch vrg;
        private int currentSize = 0;
        private final int len = 1024;

        public FakeDataReader(int size, int numCols, FakeDataSampleType fakeDataSampleType) {
            this.size = size;
            this.vrg = new VectorizedRowBatch(numCols, 1024);
            for (int i = 0; i < numCols; ++i) {
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.vrg.cols[i] = this.getLongVector(fakeDataSampleType);
            }
        }

        public VectorizedRowBatch getNext() {
            if (this.currentSize >= this.size) {
                this.vrg.size = 0;
            } else {
                this.vrg.size = 1024;
                this.currentSize += this.vrg.size;
                this.vrg.selectedInUse = false;
            }
            return this.vrg;
        }

        private LongColumnVector getLongVector(FakeDataSampleType fakeDataSampleType) {
            LongColumnVector lcv = new LongColumnVector(1024);
            switch (fakeDataSampleType) {
                case OrderedSequence: {
                    TestVectorizedRowBatch.setOrderedSequenceLongCol(lcv);
                    break;
                }
                case Random: {
                    TestVectorizedRowBatch.setRandomLongCol(lcv);
                    break;
                }
                case Repeated: {
                    TestVectorizedRowBatch.setRepeatingLongCol(lcv);
                }
            }
            return lcv;
        }
    }

    public static enum FakeDataSampleType {
        OrderedSequence,
        Random,
        Repeated;

    }
}

