/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.tez.ObjectCache;
import org.apache.hadoop.hive.ql.exec.vector.VectorLimitOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeVectorRowBatchFromObjectIterables;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorLimitDesc;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.common.objectregistry.ObjectRegistryImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorLimitOperator {
    private Random random = new Random(TestVectorLimitOperator.class.toString().hashCode());

    @Test
    public void testLimitLessThanBatchSize() throws HiveException {
        this.validateVectorLimitOperator(2, 5, 2);
    }

    @Test
    public void testLimitGreaterThanBatchSize() throws HiveException {
        this.validateVectorLimitOperator(100, 3, 3);
    }

    @Test
    public void testLimitWithZeroBatchSize() throws HiveException {
        this.validateVectorLimitOperator(5, 0, 0);
    }

    @Test
    public void testGlobalLimitReached() throws HiveException {
        this.testGlobalLimitReachedInDaemonOrContainer(true, 0, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(false, 0, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(true, 1, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(false, 1, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(true, 2, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(false, 2, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(true, 3, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(false, 3, 2);
    }

    private void testGlobalLimitReachedInDaemonOrContainer(boolean isDaemon, int offset, int limit) throws HiveException {
        int actualNumberOfElements = 4;
        LlapProxy.setDaemon((boolean)isDaemon);
        if (!isDaemon) {
            ObjectCache.setupObjectRegistry((ObjectRegistry)new ObjectRegistryImpl());
        }
        HiveConf conf = new HiveConf();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID, (String)("query-" + this.random.nextInt(10000)));
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, (String)"tez");
        conf.set("hive.tez.vertex.name", "Map 1");
        VectorLimitOperator lo1 = new VectorLimitOperator(new CompilationOpContext(), (OperatorDesc)new LimitDesc(offset, limit), null, (VectorDesc)new VectorLimitDesc());
        lo1.initialize((Configuration)conf, null);
        lo1.initializeOp((Configuration)conf);
        VectorLimitOperator lo2 = new VectorLimitOperator(new CompilationOpContext(), (OperatorDesc)new LimitDesc(offset, limit), null, (VectorDesc)new VectorLimitDesc());
        lo2.initialize((Configuration)conf, null);
        lo2.initializeOp((Configuration)conf);
        Assert.assertEquals((Object)"LIM_0", (Object)lo1.getOperatorId());
        Assert.assertEquals((Object)"LIM_0", (Object)lo2.getOperatorId());
        lo1.process((Object)this.getBatch(500).produceNextBatch(), 0);
        Assert.assertFalse((boolean)lo1.getDone());
        Assert.assertEquals((long)Math.min(limit + offset, actualNumberOfElements), (long)lo1.getCurrentCount().get());
        lo2.process((Object)this.getBatch(500).produceNextBatch(), 0);
        Assert.assertEquals((Object)(limit + offset <= actualNumberOfElements ? 1 : 0), (Object)lo2.getDone());
        lo1.process((Object)this.getBatch(500).produceNextBatch(), 0);
        Assert.assertTrue((boolean)lo1.getDone());
    }

    private void validateVectorLimitOperator(int limit, int batchSize, int expectedBatchSize) throws HiveException {
        FakeVectorRowBatchFromObjectIterables frboi = this.getBatch(batchSize);
        VectorizedRowBatch vrb = frboi.produceNextBatch();
        LimitDesc ld = new LimitDesc(limit);
        VectorLimitDesc vectorDesc = new VectorLimitDesc();
        VectorLimitOperator lo = new VectorLimitOperator(new CompilationOpContext(), (OperatorDesc)ld, null, (VectorDesc)vectorDesc);
        ObjectCache.setupObjectRegistry((ObjectRegistry)new ObjectRegistryImpl());
        lo.initialize(new Configuration(), null);
        lo.process((Object)vrb, 0);
        Assert.assertEquals((long)vrb.size, (long)expectedBatchSize);
    }

    private FakeVectorRowBatchFromObjectIterables getBatch(int batchSize) throws HiveException {
        FakeVectorRowBatchFromObjectIterables frboi = new FakeVectorRowBatchFromObjectIterables(batchSize, new String[]{"tinyint", "double"}, Arrays.asList(1, 2, 3, 4), Arrays.asList(323.0, 34.5, null, 89.3));
        return frboi;
    }
}

