/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperBase;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperGeneral;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorHashKeyWrapperBatch {
    @Test
    public void testVectorHashKeyWrapperBatch() throws HiveException {
        VectorExpression[] keyExpressions = new VectorExpression[]{new IdentityExpression(0)};
        TypeInfo[] typeInfos = new TypeInfo[]{TypeInfoFactory.timestampTypeInfo};
        VectorHashKeyWrapperBatch vhkwb = VectorHashKeyWrapperBatch.compileKeyWrapperBatch((VectorExpression[])keyExpressions, (TypeInfo[])typeInfos);
        VectorizedRowBatch batch = new VectorizedRowBatch(1);
        batch.selectedInUse = false;
        batch.size = 10;
        TimestampColumnVector timestampColVector = new TimestampColumnVector(1024);
        batch.cols[0] = timestampColVector;
        timestampColVector.reset();
        timestampColVector.noNulls = false;
        timestampColVector.isNull[0] = true;
        Timestamp scratch = new Timestamp(2039L);
        Timestamp ts0 = new Timestamp(2039L);
        scratch.setTime(ts0.getTime());
        scratch.setNanos(ts0.getNanos());
        timestampColVector.set(1, scratch);
        Timestamp ts1 = new Timestamp(33222L);
        scratch.setTime(ts1.getTime());
        scratch.setNanos(ts1.getNanos());
        timestampColVector.set(2, scratch);
        batch.size = 3;
        vhkwb.evaluateBatch(batch);
        VectorHashKeyWrapperBase[] vhkwArray = vhkwb.getVectorHashKeyWrappers();
        VectorHashKeyWrapperBase vhk = vhkwArray[0];
        Assert.assertTrue((boolean)vhk.isNull(0));
        vhk = vhkwArray[1];
        Assert.assertFalse((boolean)vhk.isNull(0));
        Assert.assertEquals((Object)vhk.getTimestamp(0), (Object)ts0);
        vhk = vhkwArray[2];
        Assert.assertFalse((boolean)vhk.isNull(0));
        Assert.assertEquals((Object)vhk.getTimestamp(0), (Object)ts1);
    }

    @Test
    public void testVectorHashKeyWrapperGeneralCopyKey() throws HiveException {
        VectorExpression[] keyExpressions = new VectorExpression[]{new IdentityExpression(0)};
        TypeInfo[] typeInfos = new TypeInfo[]{TypeInfoFactory.stringTypeInfo};
        VectorHashKeyWrapperBatch vhkwb = VectorHashKeyWrapperBatch.compileKeyWrapperBatch((VectorExpression[])keyExpressions, (TypeInfo[])typeInfos);
        VectorizedRowBatch batch = new VectorizedRowBatch(1);
        batch.selectedInUse = false;
        BytesColumnVector bytesColumnVector = new BytesColumnVector();
        bytesColumnVector.initBuffer(1024);
        batch.cols[0] = bytesColumnVector;
        byte[] contents = "education_reference".getBytes();
        bytesColumnVector.setVal(0, "system_management".getBytes());
        bytesColumnVector.setVal(1, "travel_transportation".getBytes());
        bytesColumnVector.setVal(2, contents);
        bytesColumnVector.setVal(3, "app_management".getBytes());
        batch.size = 4;
        vhkwb.evaluateBatch(batch);
        VectorHashKeyWrapperBase[] vhkwArray = vhkwb.getVectorHashKeyWrappers();
        VectorHashKeyWrapperGeneral hashKey2 = (VectorHashKeyWrapperGeneral)vhkwArray[2];
        VectorHashKeyWrapperGeneral hashKey1 = (VectorHashKeyWrapperGeneral)vhkwArray[1];
        Assert.assertTrue((boolean)StringExpr.equal((byte[])hashKey2.getBytes(0), (int)hashKey2.getByteStart(0), (int)hashKey2.getByteLength(0), (byte[])contents, (int)0, (int)contents.length));
        Assert.assertFalse((boolean)StringExpr.equal((byte[])hashKey2.getBytes(0), (int)hashKey2.getByteStart(0), (int)hashKey2.getByteLength(0), (byte[])hashKey1.getBytes(0), (int)hashKey1.getByteStart(0), (int)hashKey1.getByteLength(0)));
        hashKey2.copyKey((KeyWrapper)hashKey1);
        Assert.assertTrue((boolean)StringExpr.equal((byte[])hashKey2.getBytes(0), (int)hashKey2.getByteStart(0), (int)hashKey2.getByteLength(0), (byte[])contents, (int)0, (int)contents.length));
        Assert.assertTrue((boolean)StringExpr.equal((byte[])hashKey2.getBytes(0), (int)hashKey2.getByteStart(0), (int)hashKey2.getByteLength(0), (byte[])hashKey1.getBytes(0), (int)hashKey1.getByteStart(0), (int)hashKey1.getByteLength(0)));
    }
}

