/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestRetryable {
    @Mock
    UserGroupInformation userGroupInformation;
    MockedStatic<UserGroupInformation> userGroupInformationMockedStatic;

    @Before
    public void setup() throws IOException {
        this.userGroupInformationMockedStatic = Mockito.mockStatic(UserGroupInformation.class);
        Mockito.when((Object)UserGroupInformation.isSecurityEnabled()).thenReturn((Object)false);
        Mockito.when((Object)UserGroupInformation.getLoginUser()).thenReturn((Object)this.userGroupInformation);
        Mockito.when((Object)UserGroupInformation.getCurrentUser()).thenReturn((Object)this.userGroupInformation);
    }

    @After
    public void tearDown() {
        this.userGroupInformationMockedStatic.close();
    }

    @Test
    public void testRetrySuccessValidException() throws Throwable {
        Retryable retryable = Retryable.builder().withTotalDuration(10L).withInitialDelay(1L).withBackoff(1.0).withRetryOnException(NullPointerException.class).build();
        try {
            retryable.executeCallable((Callable)new Callable<Void>(){
                int count = 0;

                @Override
                public Void call() throws Exception {
                    if (this.count < 1) {
                        ++this.count;
                        throw new NullPointerException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testRetrySuccessValidExceptionList() throws Throwable {
        Retryable retryable = Retryable.builder().withTotalDuration(60L).withInitialDelay(1L).withBackoff(1.0).withRetryOnExceptionList(Arrays.asList(NullPointerException.class, IOException.class)).build();
        try {
            retryable.executeCallable((Callable)new Callable<Void>(){
                int count = 0;

                @Override
                public Void call() throws Exception {
                    if (this.count == 0) {
                        ++this.count;
                        throw new NullPointerException();
                    }
                    if (this.count == 1) {
                        ++this.count;
                        throw new IOException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testRetryFailureWithMaxDuration() throws Throwable {
        Retryable retryable = Retryable.builder().withTotalDuration(10L).withBackoff(10.0).withInitialDelay(1L).withRetryOnException(NullPointerException.class).build();
        try {
            retryable.executeCallable((Callable)new Callable<Void>(){
                int count = 0;

                @Override
                public Void call() throws Exception {
                    if (this.count < 2) {
                        ++this.count;
                        throw new NullPointerException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.assertEquals(NullPointerException.class, e.getClass());
        }
    }

    @Test
    public void testRetryFailureWithInitialDelay() throws Throwable {
        Retryable retryable = Retryable.builder().withTotalDuration(20L).withBackoff(10.0).withInitialDelay(10L).withMaxJitterValue(1).withRetryOnExceptionList(Arrays.asList(NullPointerException.class, IOException.class)).build();
        try {
            retryable.executeCallable((Callable)new Callable<Void>(){
                int count = 0;

                @Override
                public Void call() throws Exception {
                    if (this.count == 0) {
                        ++this.count;
                        throw new NullPointerException();
                    }
                    if (this.count == 1) {
                        ++this.count;
                        throw new IOException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.assertEquals(IOException.class, e.getClass());
        }
    }

    @Test
    public void testRetryFailureWithMaxRetryDelay() throws Throwable {
        Retryable retryable = Retryable.builder().withTotalDuration(20L).withBackoff(10.0).withInitialDelay(1L).withMaxJitterValue(1).withMaxRetryDelay(1L).withRetryOnExceptionList(Arrays.asList(NullPointerException.class, IOException.class)).build();
        try {
            retryable.executeCallable((Callable)new Callable<Void>(){
                int count = 0;

                @Override
                public Void call() throws Exception {
                    if (this.count == 0) {
                        ++this.count;
                        throw new NullPointerException();
                    }
                    if (this.count == 1) {
                        ++this.count;
                        throw new IOException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testRetryFailureWithBackoff() throws Throwable {
        Retryable retryable = Retryable.builder().withTotalDuration(20L).withBackoff(100.0).withInitialDelay(1L).withMaxJitterValue(1).withRetryOnException(NullPointerException.class).build();
        try {
            retryable.executeCallable((Callable)new Callable<Void>(){
                int count = 0;

                @Override
                public Void call() throws Exception {
                    if (this.count < 2) {
                        ++this.count;
                        throw new NullPointerException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.assertEquals(NullPointerException.class, e.getClass());
        }
    }

    @Test
    public void testRetrySuccessWithMaxDurationDifferentException() throws Throwable {
        Retryable retryable = Retryable.builder().withTotalDuration(30L).withBackoff(10.0).withInitialDelay(1L).withMaxJitterValue(1).withRetryOnExceptionList(Arrays.asList(NullPointerException.class, IOException.class)).build();
        try {
            retryable.executeCallable((Callable)new Callable<Void>(){
                int count = 0;

                @Override
                public Void call() throws Exception {
                    if (this.count == 0) {
                        ++this.count;
                        throw new NullPointerException();
                    }
                    if (this.count == 1) {
                        ++this.count;
                        throw new IOException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testRetrySuccessWithNonRetriableException() throws Throwable {
        Retryable retryable = Retryable.builder().withTotalDuration(30L).withBackoff(10.0).withInitialDelay(1L).withMaxJitterValue(1).withRetryOnException(IOException.class).withFailOnException(FileNotFoundException.class).build();
        try {
            retryable.executeCallable((Callable)new Callable<Void>(){
                int count = 0;

                @Override
                public Void call() throws Exception {
                    if (this.count == 0) {
                        ++this.count;
                        throw new FileNotFoundException();
                    }
                    if (this.count == 1) {
                        ++this.count;
                        throw new IOException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.assertEquals(FileNotFoundException.class, e.getClass());
        }
    }

    @Test
    public void testRetryFailureInValidException() throws Throwable {
        Retryable retryable = Retryable.builder().withTotalDuration(10L).withInitialDelay(1L).withBackoff(1.0).withRetryOnException(NullPointerException.class).build();
        try {
            retryable.executeCallable((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    throw new IOException();
                }
            });
        }
        catch (Exception e) {
            Assert.assertEquals(IOException.class, e.getClass());
        }
    }

    @Test
    public void testRetryFailureWithHiveConf() throws Throwable {
        HiveConf conf = new HiveConf(TestRetryable.class);
        conf.set(HiveConf.ConfVars.REPL_RETRY_INTIAL_DELAY.varname, "1s");
        conf.setFloat(HiveConf.ConfVars.REPL_RETRY_BACKOFF_COEFFICIENT.varname, 1.0f);
        conf.set(HiveConf.ConfVars.REPL_RETRY_TOTAL_DURATION.varname, "60s");
        conf.set(HiveConf.ConfVars.REPL_RETRY_JITTER.varname, "1s");
        conf.set(HiveConf.ConfVars.REPL_RETRY_MAX_DELAY_BETWEEN_RETRIES.varname, "30s");
        final long startTime = System.currentTimeMillis();
        final long totalTime = 60L;
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(NullPointerException.class).build();
        try {
            retryable.executeCallable((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TestRetryable.this.executeWithDelay(startTime, totalTime);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.assertEquals(NullPointerException.class, e.getClass());
        }
    }

    @Test
    public void testRetrySuccessSecureCallable() throws Throwable {
        Mockito.when((Object)((Boolean)this.userGroupInformation.doAs((PrivilegedExceptionAction)Mockito.any()))).thenCallRealMethod();
        Mockito.when((Object)UserGroupInformation.isSecurityEnabled()).thenReturn((Object)true);
        Retryable retryable = Retryable.builder().withTotalDuration(10L).withInitialDelay(1L).withBackoff(1.0).withRetryOnExceptionList(Arrays.asList(InterruptedException.class, IOException.class)).build();
        try {
            retryable.executeCallable(() -> true);
        }
        catch (Exception e) {
            Assert.fail();
        }
        ArgumentCaptor privilegedActionArgumentCaptor = ArgumentCaptor.forClass(PrivilegedExceptionAction.class);
        ((UserGroupInformation)Mockito.verify((Object)this.userGroupInformation, (VerificationMode)Mockito.times((int)1))).doAs((PrivilegedExceptionAction)privilegedActionArgumentCaptor.capture());
    }

    private void executeWithDelay(long startTime, long totalTime) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - startTime < totalTime * 1000L) {
            throw new NullPointerException();
        }
    }
}

