/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.tez.TezTotalOrderPartitioner;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Test;

public class TestTezTotalOrderPartitioner {
    public static final String PARTITIONER_PATH = "mapreduce.totalorderpartitioner.path";
    private static final String TEZ_RUNTIME_FRAMEWORK_PREFIX = "tez.runtime.framework.";
    public static final String TEZ_RUNTIME_NUM_EXPECTED_PARTITIONS = "tez.runtime.framework.num.expected.partitions";
    private static final int LENGTH_BYTES = 4;
    private static final HiveKey[] splitStrings = new HiveKey[]{new HiveKey("aabbb".getBytes()), new HiveKey("babbb".getBytes()), new HiveKey("daddd".getBytes()), new HiveKey("dddee".getBytes()), new HiveKey("ddhee".getBytes()), new HiveKey("dingo".getBytes()), new HiveKey("hijjj".getBytes()), new HiveKey("n".getBytes()), new HiveKey("yak".getBytes())};
    private static final ArrayList<Check<HiveKey>> testStrings = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Path writePartitionFile(String testname, Configuration conf, T[] splits) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path testdir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Path p = new Path(testdir, testname + "/_partition.lst");
        conf.set(PARTITIONER_PATH, p.toString());
        conf.setInt(TEZ_RUNTIME_NUM_EXPECTED_PARTITIONS, splits.length + 1);
        SequenceFile.Writer w = null;
        try {
            w = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)p), SequenceFile.Writer.keyClass(HiveKey.class), SequenceFile.Writer.valueClass(NullWritable.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
            for (int i = 0; i < splits.length; ++i) {
                w.append(splits[i], (Object)NullWritable.get());
            }
        }
        finally {
            if (null != w) {
                w.close();
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalOrderMemCmp() throws Exception {
        TezTotalOrderPartitioner partitioner = new TezTotalOrderPartitioner();
        Configuration conf = new Configuration();
        Path p = TestTezTotalOrderPartitioner.writePartitionFile("totalordermemcmp", conf, splitStrings);
        try {
            partitioner.configure(new JobConf(conf));
            NullWritable nw = NullWritable.get();
            for (Check<HiveKey> chk : testStrings) {
                Assert.assertEquals((String)((HiveKey)chk.data).toString(), (long)chk.part, (long)partitioner.getPartition((HiveKey)chk.data, (Object)nw, splitStrings.length + 1));
            }
        }
        finally {
            p.getFileSystem(conf).delete(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalOrderBinarySearch() throws Exception {
        TezTotalOrderPartitioner partitioner = new TezTotalOrderPartitioner();
        Configuration conf = new Configuration();
        Path p = TestTezTotalOrderPartitioner.writePartitionFile("totalorderbinarysearch", conf, splitStrings);
        conf.setBoolean("mapreduce.totalorderpartitioner.naturalorder", false);
        try {
            partitioner.configure(new JobConf(conf));
            NullWritable nw = NullWritable.get();
            for (Check<HiveKey> chk : testStrings) {
                Assert.assertEquals((String)((HiveKey)chk.data).toString(), (long)chk.part, (long)partitioner.getPartition((HiveKey)chk.data, (Object)nw, splitStrings.length + 1));
            }
        }
        finally {
            p.getFileSystem(conf).delete(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalOrderCustomComparator() throws Exception {
        TezTotalOrderPartitioner partitioner = new TezTotalOrderPartitioner();
        Configuration conf = new Configuration();
        HiveKey[] revSplitStrings = Arrays.copyOf(splitStrings, splitStrings.length);
        Arrays.sort(revSplitStrings, new ReverseHiveKeyComparator());
        Path p = TestTezTotalOrderPartitioner.writePartitionFile("totalordercustomcomparator", conf, revSplitStrings);
        conf.setBoolean("mapreduce.totalorderpartitioner.naturalorder", false);
        conf.setClass("mapreduce.job.output.key.comparator.class", ReverseHiveKeyComparator.class, RawComparator.class);
        ArrayList<Check<HiveKey>> revCheck = new ArrayList<Check<HiveKey>>();
        revCheck.add(new Check<HiveKey>(new HiveKey("aaaaa".getBytes()), 9));
        revCheck.add(new Check<HiveKey>(new HiveKey("aaabb".getBytes()), 9));
        revCheck.add(new Check<HiveKey>(new HiveKey("aabbb".getBytes()), 9));
        revCheck.add(new Check<HiveKey>(new HiveKey("aaaaa".getBytes()), 9));
        revCheck.add(new Check<HiveKey>(new HiveKey("babbb".getBytes()), 8));
        revCheck.add(new Check<HiveKey>(new HiveKey("baabb".getBytes()), 8));
        revCheck.add(new Check<HiveKey>(new HiveKey("yai".getBytes()), 1));
        revCheck.add(new Check<HiveKey>(new HiveKey("yak".getBytes()), 1));
        revCheck.add(new Check<HiveKey>(new HiveKey("z".getBytes()), 0));
        revCheck.add(new Check<HiveKey>(new HiveKey("ddngo".getBytes()), 4));
        revCheck.add(new Check<HiveKey>(new HiveKey("hi".getBytes()), 3));
        try {
            partitioner.configure(new JobConf(conf));
            NullWritable nw = NullWritable.get();
            for (Check check : revCheck) {
                Assert.assertEquals((String)((HiveKey)check.data).toString(), (long)check.part, (long)partitioner.getPartition((HiveKey)check.data, (Object)nw, splitStrings.length + 1));
            }
        }
        finally {
            p.getFileSystem(conf).delete(p, true);
        }
    }

    static {
        testStrings.add(new Check<HiveKey>(new HiveKey("aaaaa".getBytes()), 0));
        testStrings.add(new Check<HiveKey>(new HiveKey("aaabb".getBytes()), 0));
        testStrings.add(new Check<HiveKey>(new HiveKey("aabbb".getBytes()), 1));
        testStrings.add(new Check<HiveKey>(new HiveKey("aaaaa".getBytes()), 0));
        testStrings.add(new Check<HiveKey>(new HiveKey("babbb".getBytes()), 2));
        testStrings.add(new Check<HiveKey>(new HiveKey("baabb".getBytes()), 1));
        testStrings.add(new Check<HiveKey>(new HiveKey("yai".getBytes()), 8));
        testStrings.add(new Check<HiveKey>(new HiveKey("yak".getBytes()), 9));
        testStrings.add(new Check<HiveKey>(new HiveKey("z".getBytes()), 9));
        testStrings.add(new Check<HiveKey>(new HiveKey("ddngo".getBytes()), 5));
        testStrings.add(new Check<HiveKey>(new HiveKey("hi".getBytes()), 6));
    }

    static class Check<T> {
        T data;
        int part;

        Check(T data, int part) {
            this.data = data;
            this.part = part;
        }
    }

    public static class ReverseHiveKeyComparator
    implements RawComparator<HiveKey> {
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int c = -1 * WritableComparator.compareBytes((byte[])b1, (int)(s1 + 4), (int)(l1 - 4), (byte[])b2, (int)(s2 + 4), (int)(l2 - 4));
            return c;
        }

        public int compare(HiveKey o1, HiveKey o2) {
            return -o1.compareTo((BinaryComparable)o2);
        }
    }
}

