/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.junit.Assert;
import org.junit.Test;

public class TestTezSessionState {
    @Test
    public void testSymlinkedLocalFilesAreLocalizedOnce() throws Exception {
        Path jarPath = Files.createTempFile("jar", "", new FileAttribute[0]);
        Path symlinkPath = Paths.get(jarPath.toString() + ".symlink", new String[0]);
        Files.createSymbolicLink(symlinkPath, jarPath, new FileAttribute[0]);
        Files.write(jarPath, "testSymlinkedLocalFilesToBeLocalized".getBytes(), StandardOpenOption.APPEND);
        Assert.assertTrue((boolean)Files.isSymbolicLink(symlinkPath));
        HiveConf hiveConf = new HiveConf();
        hiveConf.set(HiveConf.ConfVars.HIVE_JAR_DIRECTORY.varname, "/tmp");
        TezSessionState sessionState = new TezSessionState(DagUtils.getInstance(), hiveConf);
        LocalResource l1 = sessionState.createJarLocalResource(jarPath.toUri().toString());
        LocalResource l2 = sessionState.createJarLocalResource(symlinkPath.toUri().toString());
        Assert.assertEquals((Object)l1.getResource().toPath(), (Object)l2.getResource().toPath());
    }
}

