/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManagerMetrics;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTezSessionPoolManagerMetrics {
    private static final int NO_OF_SESSIONS = 2;
    private static final double NO_OF_RUNNING_TASKS_PER_SESSION = 10.0;
    private static final double NO_OF_PENDING_TASKS_PER_SESSION = 100.0;

    @Test
    public void testRefreshMetrics() {
        TezSessionPoolManager poolManager = (TezSessionPoolManager)Mockito.mock(TezSessionPoolManager.class);
        List<TezSessionState> sessions = this.testSessions();
        Mockito.when((Object)poolManager.getSessions()).thenReturn(sessions);
        TezSessionPoolManagerMetrics metrics = new TezSessionPoolManagerMetrics(poolManager);
        metrics.refreshMetrics(new AtomicDouble(9.0), new AtomicDouble(1.0));
        Assert.assertEquals((double)9.0, (double)((Integer)metrics.runningTasksCount.value).intValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)((Integer)metrics.pendingTasksCount.value).intValue(), (double)1.0E-4);
        Assert.assertEquals((double)0.1, (double)((Double)metrics.taskBacklogRatio.value), (double)1.0E-4);
    }

    @Test
    public void testBasicMetricsUpdate() {
        TezSessionPoolManager poolManager = (TezSessionPoolManager)Mockito.mock(TezSessionPoolManager.class);
        List<TezSessionState> sessions = this.testSessions();
        Mockito.when((Object)poolManager.getSessions()).thenReturn(sessions);
        TezSessionPoolManagerMetrics metrics = new TezSessionPoolManagerMetrics(poolManager);
        metrics.collectMetrics();
        double expectedRunningTasks = 20.0;
        double expectedPendingTasks = 200.0;
        double expectedBacklog = expectedPendingTasks / (expectedRunningTasks + 1.0);
        Assert.assertEquals((double)expectedRunningTasks, (double)((Integer)metrics.runningTasksCount.value).intValue(), (double)1.0E-4);
        Assert.assertEquals((double)expectedPendingTasks, (double)((Integer)metrics.pendingTasksCount.value).intValue(), (double)1.0E-4);
        Assert.assertEquals((double)expectedBacklog, (double)((Double)metrics.taskBacklogRatio.value), (double)1.0E-4);
    }

    @Test
    public void testEmptyMetrics() {
        TezSessionPoolManager poolManager = (TezSessionPoolManager)Mockito.mock(TezSessionPoolManager.class);
        Mockito.when((Object)poolManager.getSessions()).thenReturn(new ArrayList());
        TezSessionPoolManagerMetrics metrics = new TezSessionPoolManagerMetrics(poolManager);
        metrics.collectMetrics();
        Assert.assertEquals((double)0.0, (double)((Integer)metrics.runningTasksCount.value).intValue(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)((Integer)metrics.pendingTasksCount.value).intValue(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)((Double)metrics.taskBacklogRatio.value), (double)1.0E-4);
    }

    @Test
    public void testMetricsBeforeFirstUpdateAndStart() {
        TezSessionPoolManager poolManager = (TezSessionPoolManager)Mockito.mock(TezSessionPoolManager.class);
        TezSessionPoolManagerMetrics metrics = new TezSessionPoolManagerMetrics(poolManager);
        Assert.assertEquals((double)0.0, (double)((Integer)metrics.runningTasksCount.value).intValue(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)((Integer)metrics.pendingTasksCount.value).intValue(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)((Double)metrics.taskBacklogRatio.value), (double)1.0E-4);
    }

    private List<TezSessionState> testSessions() {
        ArrayList<TezSessionState> sessions = new ArrayList<TezSessionState>();
        TezSessionState session = (TezSessionState)Mockito.mock(TezSessionState.class);
        Mockito.when((Object)session.getMetrics()).thenReturn(this.testMetrics());
        IntStream.range(0, 2).forEach(i -> sessions.add(session));
        return sessions;
    }

    private Map<String, Double> testMetrics() {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("tez_session_running_tasks", 10.0);
        metrics.put("tez_session_pending_tasks", 100.0);
        return metrics;
    }
}

