/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezUtils;
import org.apache.tez.runtime.api.ProcessorContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTezProcessor {
    @Test
    public void testCurrentUserCredentialsAreMergedOnInitialize() throws IOException {
        ProcessorContext processorContext = this.mockProcessorContext();
        TezProcessor tezProcessor = new TezProcessor(processorContext);
        Text tokenId = new Text("TOKEN_KIND");
        Token token = new Token("hello".getBytes(), null, new Text("TEST_TOKEN_KIND"), new Text("TEST_TOKEN_SERVICE"));
        UserGroupInformation.getCurrentUser().addToken(tokenId, token);
        tezProcessor.initialize();
        JobConf conf = tezProcessor.getConf();
        Assert.assertEquals((Object)token, (Object)conf.getCredentials().getToken(tokenId));
    }

    private ProcessorContext mockProcessorContext() throws IOException {
        JobConf conf = new JobConf();
        ProcessorContext processorContext = (ProcessorContext)Mockito.mock(ProcessorContext.class);
        Mockito.when((Object)processorContext.getUserPayload()).thenReturn((Object)TezUtils.createUserPayloadFromConf((Configuration)conf));
        Mockito.when((Object)processorContext.getTaskVertexName()).thenReturn((Object)"Map 1");
        Mockito.when((Object)processorContext.getTaskVertexIndex()).thenReturn((Object)0);
        Mockito.when((Object)processorContext.getTaskIndex()).thenReturn((Object)0);
        Mockito.when((Object)processorContext.getTaskAttemptNumber()).thenReturn((Object)0);
        Mockito.when((Object)processorContext.getApplicationId()).thenReturn((Object)ApplicationId.fromString((String)"application_123456_0"));
        return processorContext;
    }
}

