/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.tez.TezConfigurationFactory;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Test;

public class TestTezConfigurationFactory {
    private static final Field updatingResource;

    @Test
    public void testAddProgrammaticallyAddedTezOptsToDagConf() {
        HashMap dagConf = new HashMap();
        JobConf conf = new JobConf();
        conf.set("tez.generate.debug.artifacts", "true");
        TezConfigurationFactory.addProgrammaticallyAddedTezOptsToDagConf(dagConf, (JobConf)conf);
        Assert.assertTrue((String)"dagConfig should contain value for tez.generate.debug.artifacts", (boolean)dagConf.containsKey("tez.generate.debug.artifacts"));
        conf.clear();
        dagConf.clear();
        conf.set("tez.generate.debug.artifacts", "true", "tez-site.xml");
        TezConfigurationFactory.addProgrammaticallyAddedTezOptsToDagConf(dagConf, (JobConf)conf);
        Assert.assertFalse((String)"dagConfig should not contain value for xml sourced config tez.generate.debug.artifacts", (boolean)dagConf.containsKey("tez.generate.debug.artifacts"));
        conf.set("tez.am.launch.cmd-opts", "asdf");
        TezConfigurationFactory.addProgrammaticallyAddedTezOptsToDagConf(dagConf, (JobConf)conf);
        Assert.assertFalse((String)"dagConfig should not contain value for tez.am.launch.cmd-opts", (boolean)dagConf.containsKey("tez.am.launch.cmd-opts"));
        conf.set("hive.something", "asdf");
        TezConfigurationFactory.addProgrammaticallyAddedTezOptsToDagConf(dagConf, (JobConf)conf);
        Assert.assertFalse((String)"dagConfig should not contain value for a hive config", (boolean)dagConf.containsKey("hive.something"));
    }

    static {
        try {
            updatingResource = Configuration.class.getDeclaredField("updatingResource");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
        updatingResource.setAccessible(true);
    }
}

