/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.IncrementalIntDagCredentialSupplier;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.dag.api.DAG;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDagUtilsSecurityEnabled {
    @BeforeClass
    public static void setup() {
        System.setProperty("java.security.krb5.kdc", "");
        System.setProperty("java.security.krb5.realm", "FAKE.REALM");
        Configuration conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @AfterClass
    public static void clear() {
        System.clearProperty("java.security.krb5.kdc");
        System.clearProperty("java.security.krb5.realm");
        Configuration conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.SIMPLE, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @Test
    public void testAddCredentialsWithCredentialSupplierNewTokenAdded() {
        IncrementalIntDagCredentialSupplier supplier = new IncrementalIntDagCredentialSupplier();
        DagUtils dagUtils = new DagUtils(Collections.singletonList(supplier));
        DAG dag = DAG.create((String)"test_credentials_dag");
        dagUtils.addCredentials((BaseWork)Mockito.mock(MapWork.class), dag, null);
        Token newToken = dag.getCredentials().getToken(supplier.getTokenAlias());
        Assert.assertEquals((Object)String.valueOf(1), (Object)new String(newToken.getIdentifier()));
    }

    @Test
    public void testAddCredentialsWithCredentialSupplierTokenExistsNothingAdded() {
        IncrementalIntDagCredentialSupplier supplier = new IncrementalIntDagCredentialSupplier();
        DagUtils dagUtils = new DagUtils(Collections.singletonList(supplier));
        DAG dag = DAG.create((String)"test_credentials_dag");
        Token oldToken = new Token();
        dag.getCredentials().addToken(supplier.getTokenAlias(), oldToken);
        dagUtils.addCredentials((BaseWork)Mockito.mock(MapWork.class), dag, null);
        Token newToken = dag.getCredentials().getToken(supplier.getTokenAlias());
        Assert.assertEquals((Object)oldToken, (Object)newToken);
        Assert.assertEquals((long)0L, (long)supplier.tokenCalls);
    }
}

