/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.TestTezOutputCommitter;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDagUtils {
    @Test
    public void testCredentialsNotOverwritten() throws Exception {
        UserGroupInformation testUser = UserGroupInformation.createUserForTesting((String)"test_user", (String[])new String[0]);
        final DagUtils dagUtils = DagUtils.getInstance();
        Credentials originalCredentials = new Credentials();
        Text testTokenAlias = new Text("my_test_token");
        Token testToken = (Token)Mockito.mock(Token.class);
        originalCredentials.addToken(testTokenAlias, testToken);
        Credentials testUserCredentials = new Credentials();
        testUser.addCredentials(testUserCredentials);
        final BaseWork work = (BaseWork)Mockito.mock(BaseWork.class);
        final DAG dag = DAG.create((String)"test_credentials_dag");
        dag.setCredentials(originalCredentials);
        testUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                dagUtils.addCredentials(work, dag, null);
                return null;
            }
        });
        Token actualToken = dag.getCredentials().getToken(testTokenAlias);
        Assert.assertEquals((Object)testToken, (Object)actualToken);
    }

    @Test
    public void outputCommitterSetToDefaultIfNotPresent() throws IOException {
        DagUtils dagUtils = DagUtils.getInstance();
        HiveConf conf = new HiveConf();
        JobConf configuration = dagUtils.createConfiguration(conf);
        Assert.assertEquals((Object)HiveFileFormatUtils.NullOutputCommitter.class.getName(), (Object)configuration.get("mapred.output.committer.class"));
    }

    @Test
    public void outputCommitterNotOverriddenIfPresent() throws IOException {
        DagUtils dagUtils = DagUtils.getInstance();
        HiveConf conf = new HiveConf();
        conf.set("mapred.output.committer.class", TestTezOutputCommitter.CountingOutputCommitter.class.getName());
        JobConf configuration = dagUtils.createConfiguration(conf);
        Assert.assertEquals((Object)TestTezOutputCommitter.CountingOutputCommitter.class.getName(), (Object)configuration.get("mapred.output.committer.class"));
    }

    @Test
    public void testMapTezTaskEnvIsCopiedFromMrProperties() {
        DagUtils dagUtils = DagUtils.getInstance();
        Vertex map = Vertex.create((String)"mapWorkName", null);
        HiveConf conf = new HiveConf();
        Assert.assertNull(map.getTaskEnvironment().get("key"));
        conf.set("mapreduce.map.env", "key=value");
        map.setTaskEnvironment(dagUtils.getContainerEnvironment((Configuration)conf, true));
        Assert.assertEquals((Object)"value", map.getTaskEnvironment().get("key"));
    }

    @Test
    public void testReduceTezTaskEnvIsCopiedFromMrProperties() {
        DagUtils dagUtils = DagUtils.getInstance();
        Vertex reduce = Vertex.create((String)"reduceWorkName", null);
        HiveConf conf = new HiveConf();
        Assert.assertNull(reduce.getTaskEnvironment().get("key"));
        conf.set("mapreduce.reduce.env", "key=value");
        reduce.setTaskEnvironment(dagUtils.getContainerEnvironment((Configuration)conf, false));
        Assert.assertEquals((Object)"value", reduce.getTaskEnvironment().get("key"));
    }
}

