/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.util;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.repl.util.FileList;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestFileList {
    HiveConf conf = new HiveConf();
    private FSDataOutputStream outStream;
    private FSDataOutputStream testFileStream;
    final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestFileList.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    private Exception testException = new IOException("test");

    @Test
    public void testConcurrentAdd() throws Exception {
        FileList fileList = this.setupFileList(new boolean[0]);
        int numOfEntries = 1000;
        int numOfThreads = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(numOfThreads);
        for (int i = 1; i <= numOfEntries; ++i) {
            executorService.submit(() -> {
                try {
                    fileList.add("someEntry");
                }
                catch (IOException e) {
                    throw new RuntimeException("Unbale to add to file list.");
                }
            });
        }
        executorService.awaitTermination(1L, TimeUnit.MINUTES);
        fileList.close();
        ArgumentCaptor entryArgs = ArgumentCaptor.forClass(String.class);
        ((FSDataOutputStream)Mockito.verify((Object)this.testFileStream, (VerificationMode)Mockito.times((int)numOfEntries))).writeBytes((String)entryArgs.capture());
    }

    @Test
    public void testConcurrentAddWithAbort() throws Exception {
        FileList fileList = this.setupFileList(false, false, false);
        int numOfEntries = 1000;
        int numOfThreads = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(numOfThreads);
        String retryExhaustedMsg = ErrorMsg.REPL_RETRY_EXHAUSTED.format(this.testException.getMessage());
        for (int i = 1; i <= numOfEntries; ++i) {
            executorService.submit(() -> {
                try {
                    fileList.add("someEntry");
                }
                catch (IOException e) {
                    Assert.assertTrue((boolean)e.getMessage().contains(retryExhaustedMsg));
                }
            });
        }
        executorService.awaitTermination(1L, TimeUnit.MINUTES);
        fileList.close();
        ArgumentCaptor entryArgs = ArgumentCaptor.forClass(String.class);
        ((FSDataOutputStream)Mockito.verify((Object)this.outStream, (VerificationMode)Mockito.times((int)1))).writeBytes((String)entryArgs.capture());
    }

    @Test
    public void testWriteRetryCreateFailure() throws Exception {
        String testEntry = "someEntry";
        boolean retryOnCreate = true;
        FileList fileList = this.setupFileList(retryOnCreate);
        String retryExhaustedMsg = ErrorMsg.REPL_RETRY_EXHAUSTED.format(this.testException.getMessage());
        try {
            fileList.add(testEntry);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(retryExhaustedMsg));
        }
        ((FileList)Mockito.verify((Object)fileList, (VerificationMode)Mockito.atLeast((int)2))).getWriterCreateMode();
        ((FileList)Mockito.verify((Object)fileList, (VerificationMode)Mockito.times((int)0))).getWriterAppendMode();
    }

    @Test
    public void testWriteNoRetry() throws Exception {
        String testEntry = "someEntry";
        boolean retryOnCreate = false;
        boolean retryOnWrite = false;
        FileList fileList = this.setupFileList(retryOnCreate, retryOnWrite);
        String retryExhaustedMsg = ErrorMsg.REPL_RETRY_EXHAUSTED.format(this.testException.getMessage());
        try {
            fileList.add(testEntry);
        }
        catch (IOException e) {
            Assert.assertFalse((boolean)e.getMessage().contains(retryExhaustedMsg));
            Assert.assertTrue((boolean)e.getMessage().contains("test"));
        }
        ((FileList)Mockito.verify((Object)fileList, (VerificationMode)Mockito.times((int)1))).getWriterCreateMode();
        ((FSDataOutputStream)Mockito.verify((Object)this.outStream, (VerificationMode)Mockito.times((int)1))).writeBytes(Mockito.anyString());
        ((FileList)Mockito.verify((Object)fileList, (VerificationMode)Mockito.times((int)0))).getWriterAppendMode();
    }

    @Test
    public void testReadWithDuplicateEntries() throws Exception {
        this.conf = new HiveConf();
        String testEntry = "someEntry";
        int numUniqueEntries = 100;
        Path testFilePath = new Path(new Path(this.TEST_DATA_DIR), "testFile");
        FileList fileList = new FileList(testFilePath, this.conf);
        for (int i = 1; i <= numUniqueEntries; ++i) {
            String currentUniqueEntry = testEntry + i;
            for (int duplicateFactor = 0; duplicateFactor < i; ++duplicateFactor) {
                fileList.add(currentUniqueEntry);
            }
        }
        fileList.close();
        int currentCount = 1;
        while (fileList.hasNext()) {
            String entry = fileList.next();
            Assert.assertEquals((Object)(testEntry + currentCount), (Object)entry);
            ++currentCount;
        }
        Assert.assertEquals((long)(currentCount - 1), (long)numUniqueEntries);
    }

    @Test
    public void testReadWithAllDistinctEntries() throws Exception {
        this.conf = new HiveConf();
        String testEntry = "someEntry";
        int numUniqueEntries = 100;
        Path testFilePath = new Path(new Path(this.TEST_DATA_DIR), "testFile");
        FileList fileList = new FileList(testFilePath, this.conf);
        for (int i = 1; i <= numUniqueEntries; ++i) {
            String currentUniqueEntry = testEntry + i;
            fileList.add(currentUniqueEntry);
        }
        fileList.close();
        int currentCount = 1;
        while (fileList.hasNext()) {
            String entry = fileList.next();
            Assert.assertEquals((Object)(testEntry + currentCount), (Object)entry);
            ++currentCount;
        }
        Assert.assertEquals((long)(currentCount - 1), (long)numUniqueEntries);
    }

    @Test
    public void testWriteIntermediateRetry() throws Exception {
        String testEntry = "someEntry";
        boolean retryOnCreate = false;
        FileList fileList = this.setupFileList(retryOnCreate);
        String retryExhaustedMsg = ErrorMsg.REPL_RETRY_EXHAUSTED.format(this.testException.getMessage());
        try {
            fileList.add(testEntry);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(retryExhaustedMsg));
        }
        ((FileList)Mockito.verify((Object)fileList, (VerificationMode)Mockito.times((int)1))).getWriterCreateMode();
        ((FileList)Mockito.verify((Object)fileList, (VerificationMode)Mockito.atLeast((int)2))).getWriterAppendMode();
        ((FSDataOutputStream)Mockito.verify((Object)this.outStream, (VerificationMode)Mockito.atLeast((int)2))).writeBytes(Mockito.anyString());
    }

    private FileList setupFileList(boolean ... retryParams) throws Exception {
        HiveConf hiveConf = (HiveConf)Mockito.mock(HiveConf.class);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Path backingFile = (Path)Mockito.spy((Object)new Path("/tmp/backingFile"));
        FileList fileList = (FileList)Mockito.spy((Object)new FileList(backingFile, hiveConf));
        this.outStream = (FSDataOutputStream)Mockito.spy((Object)new FSDataOutputStream(null, null));
        Retryable retryable = Retryable.builder().withTotalDuration(60L).withInitialDelay(1L).withBackoff(1.0).withRetryOnException(IOException.class).build();
        if (retryParams.length == 0) {
            Path noRetryPath = new Path(new Path(this.TEST_DATA_DIR), "noRetry");
            this.testFileStream = (FSDataOutputStream)Mockito.spy((Object)noRetryPath.getFileSystem((Configuration)this.conf).create(noRetryPath));
            ((FileList)Mockito.doReturn((Object)retryable).when((Object)fileList)).buildRetryable();
            ((HiveConf)Mockito.doReturn((Object)true).when((Object)hiveConf)).getBoolVar(HiveConf.ConfVars.REPL_COPY_FILE_LIST_ITERATOR_RETRY);
            ((FileList)Mockito.doReturn((Object)this.testFileStream).when((Object)fileList)).initWriter();
        } else if (retryParams.length == 1) {
            ((HiveConf)Mockito.doReturn((Object)true).when((Object)hiveConf)).getBoolVar(HiveConf.ConfVars.REPL_COPY_FILE_LIST_ITERATOR_RETRY);
            ((FileList)Mockito.doReturn((Object)retryable).when((Object)fileList)).buildRetryable();
            ((Path)Mockito.doReturn((Object)mockFs).when((Object)backingFile)).getFileSystem((Configuration)hiveConf);
            if (retryParams[0]) {
                ((FileSystem)Mockito.doReturn((Object)false).when((Object)mockFs)).exists(backingFile);
                ((FileList)Mockito.doThrow((Throwable[])new Throwable[]{this.testException}).when((Object)fileList)).getWriterCreateMode();
            } else {
                Mockito.when((Object)mockFs.exists(backingFile)).thenReturn((Object)false).thenReturn((Object)true);
                ((FileList)Mockito.doReturn((Object)this.outStream).when((Object)fileList)).getWriterAppendMode();
                ((FileList)Mockito.doReturn((Object)this.outStream).when((Object)fileList)).getWriterCreateMode();
                ((FSDataOutputStream)Mockito.doThrow((Throwable[])new Throwable[]{this.testException}).when((Object)this.outStream)).writeBytes(Mockito.anyString());
            }
        } else if (retryParams.length == 2) {
            ((HiveConf)Mockito.doReturn((Object)false).when((Object)hiveConf)).getBoolVar(HiveConf.ConfVars.REPL_COPY_FILE_LIST_ITERATOR_RETRY);
            ((FileList)Mockito.doReturn((Object)this.outStream).when((Object)fileList)).getWriterCreateMode();
            ((FSDataOutputStream)Mockito.doThrow((Throwable[])new Throwable[]{this.testException}).when((Object)this.outStream)).writeBytes(Mockito.anyString());
        } else if (retryParams.length == 3) {
            ((HiveConf)Mockito.doReturn((Object)true).when((Object)hiveConf)).getBoolVar(HiveConf.ConfVars.REPL_COPY_FILE_LIST_ITERATOR_RETRY);
            ((FileList)Mockito.doReturn((Object)this.outStream).when((Object)fileList)).initWriter();
        }
        return fileList;
    }
}

