/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpTask;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.util.FileList;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.dump.ExportService;
import org.apache.hadoop.hive.ql.parse.repl.dump.HiveWrapper;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class TestReplDumpTask {
    protected static final Logger LOG = LoggerFactory.getLogger(TestReplDumpTask.class);
    @Mock
    private Hive hive;
    @Mock
    private HiveConf conf;
    @Mock
    private QueryState queryState;
    @Mock
    ReplicationMetricCollector metricCollector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TestException.class)
    public void removeDBPropertyToPreventRenameWhenBootstrapDumpOfTableFails() throws Exception {
        try (MockedStatic utilsMockedStatic = Mockito.mockStatic(Utils.class);){
            List<String> tableList = Arrays.asList("a1", "a2");
            String dbRandomKey = "akeytoberandom";
            ReplScope replScope = new ReplScope("default");
            utilsMockedStatic.when(() -> Utils.matchesDb((Hive)((Hive)ArgumentMatchers.same((Object)this.hive)), (String)((String)ArgumentMatchers.eq((Object)"default")))).thenReturn(Collections.singletonList("default"));
            utilsMockedStatic.when(() -> Utils.getAllTables((Hive)((Hive)ArgumentMatchers.same((Object)this.hive)), (String)((String)ArgumentMatchers.eq((Object)"default")), (ReplScope)((ReplScope)ArgumentMatchers.eq((Object)replScope)))).thenReturn(tableList);
            utilsMockedStatic.when(() -> Utils.setDbBootstrapDumpState((Hive)((Hive)ArgumentMatchers.same((Object)this.hive)), (String)((String)ArgumentMatchers.eq((Object)"default")))).thenReturn((Object)dbRandomKey);
            utilsMockedStatic.when(() -> Utils.matchesTbl((Hive)((Hive)ArgumentMatchers.same((Object)this.hive)), (String)((String)ArgumentMatchers.eq((Object)"default")), (ReplScope)((ReplScope)ArgumentMatchers.eq((Object)replScope)))).thenReturn(tableList);
            Mockito.when((Object)this.queryState.getConf()).thenReturn((Object)this.conf);
            Mockito.when((Object)this.conf.getLong("hive.repl.last.repl.id", -1L)).thenReturn((Object)1L);
            Mockito.when((Object)this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES)).thenReturn((Object)false);
            Mockito.when((Object)HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.REPL_BOOTSTRAP_DUMP_OPEN_TXN_TIMEOUT)).thenReturn((Object)"1h");
            StubReplDumpTask task = new StubReplDumpTask(){
                private int tableDumpCount;
                {
                    this.tableDumpCount = 0;
                }

                void dumpTable(ExportService exportService, String dbName, String tblName, String validTxnList, Path dbRootMetadata, Path dbRootData, long lastReplId, Hive hiveDb, HiveWrapper.Tuple<Table> tuple, FileList managedTableDirFileList, boolean dataCopyAtLoad) throws Exception {
                    ++this.tableDumpCount;
                    if (this.tableDumpCount > 1) {
                        throw new TestException();
                    }
                }

                HiveWrapper createHiveWrapper(Hive hiveDb, String dbName) {
                    return (HiveWrapper)Mockito.mock(HiveWrapper.class);
                }
            };
            task.initialize(this.queryState, null, null, null);
            ReplDumpWork replDumpWork = new ReplDumpWork(replScope, "", "");
            replDumpWork.setMetricCollector(this.metricCollector);
            task.setWork((Serializable)replDumpWork);
            try {
                task.bootStrapDump(new Path("mock"), new DumpMetaData(new Path("mock"), this.conf), (Path)Mockito.mock(Path.class), this.hive);
            }
            finally {
                Utils.resetDbBootstrapDumpState((Hive)((Hive)ArgumentMatchers.same((Object)this.hive)), (String)((String)ArgumentMatchers.eq((Object)"default")), (String)((String)ArgumentMatchers.eq((Object)dbRandomKey)));
            }
        }
    }

    private static class TestException
    extends Exception {
        private TestException() {
        }
    }

    class StubReplDumpTask
    extends ReplDumpTask {
        StubReplDumpTask() {
        }

        protected Hive getHive() {
            return TestReplDumpTask.this.hive;
        }

        long currentNotificationId(Hive hiveDb) {
            return Long.MAX_VALUE;
        }

        String getValidTxnListForReplDump(Hive hiveDb, long waitUntilTime) {
            return "";
        }

        List<EximUtil.DataCopyPath> dumpFunctionMetadata(String dbName, Path dbMetadataRoot, Path dbDataRoot, Hive hiveDb, boolean copyAtLoad) {
            return Collections.emptyList();
        }

        Path dumpDbMetadata(String dbName, Path metadataRoot, long lastReplId, Hive hiveDb) {
            return (Path)Mockito.mock(Path.class);
        }

        void dumpConstraintMetadata(String dbName, String tblName, Path dbRoot, Hive hiveDb, long tableId) {
        }
    }
}

