/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.AtlasLoadTask;
import org.apache.hadoop.hive.ql.exec.repl.AtlasLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasReplInfo;
import org.apache.hadoop.hive.ql.metadata.StringAppender;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.logging.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class TestAtlasLoadTask {
    private AtlasLoadTask atlasLoadTask;
    @Mock
    private HiveConf conf;
    @Mock
    private AtlasLoadWork work;
    @Mock
    private ReplicationMetricCollector metricCollector;

    @Test
    public void testAtlasLoadMetrics() throws Exception {
        Mockito.when((Object)this.work.getMetricCollector()).thenReturn((Object)this.metricCollector);
        this.atlasLoadTask = new AtlasLoadTask(this.conf, this.work);
        AtlasLoadTask atlasLoadTaskSpy = (AtlasLoadTask)Mockito.spy((Object)this.atlasLoadTask);
        Mockito.when((Object)this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL)).thenReturn((Object)true);
        Logger logger = LoggerFactory.getLogger((String)"ReplState");
        StringAppender appender = StringAppender.createStringAppender(null);
        appender.addToLogger(logger.getName(), Level.INFO);
        appender.start();
        AtlasReplInfo atlasReplInfo = new AtlasReplInfo("http://localhost:21000/atlas", "srcDB", "tgtDB", "srcCluster", "tgtCluster", new Path("hdfs://tmp"), null, this.conf);
        atlasReplInfo.setSrcFsUri("hdfs://srcFsUri:8020");
        atlasReplInfo.setTgtFsUri("hdfs:tgtFsUri:8020");
        ((AtlasLoadTask)Mockito.doReturn((Object)atlasReplInfo).when((Object)atlasLoadTaskSpy)).createAtlasReplInfo();
        int status = atlasLoadTaskSpy.execute();
        Assert.assertEquals((long)0L, (long)status);
        String logStr = appender.getOutput();
        Assert.assertEquals((long)2L, (long)StringUtils.countMatches((CharSequence)logStr, (CharSequence)"REPL::"));
        Assert.assertTrue((boolean)logStr.contains("ATLAS_LOAD_START"));
        Assert.assertTrue((boolean)logStr.contains("ATLAS_LOAD_END"));
        Assert.assertTrue((boolean)logStr.contains("{\"sourceDbName\":\"srcDB\",\"targetDbName\":\"tgtDB\",\"loadStartTime\":"));
        Assert.assertTrue((boolean)logStr.contains("{\"sourceDbName\":\"srcDB\",\"targetDbName\":\"tgtDB\",\"numOfEntities\":0,\"loadEndTime\""));
        appender.removeFromLogger(logger.getName());
    }
}

