/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.sun.jersey.api.client.ClientResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.atlas.AtlasBaseClient;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasServer;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.AtlasDumpTask;
import org.apache.hadoop.hive.ql.exec.repl.AtlasDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasReplInfo;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasRequestBuilder;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasRestClient;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasRestClientBuilder;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasRestClientImpl;
import org.apache.hadoop.hive.ql.metadata.StringAppender;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.logging.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class TestAtlasDumpTask {
    @Mock
    private AtlasRestClient atlasRestClient;
    private AtlasDumpTask atlasDumpTask;
    @Mock
    private HiveConf conf;
    @Mock
    private AtlasDumpWork work;
    @Mock
    private ReplicationMetricCollector metricCollector;

    @Test
    public void testAtlasDumpMetrics() throws Exception {
        Mockito.when((Object)this.work.getMetricCollector()).thenReturn((Object)this.metricCollector);
        Mockito.when((Object)this.conf.get(HiveConf.ConfVars.REPL_ATLAS_ENDPOINT.varname)).thenReturn((Object)"http://localhost:21000/atlas");
        Mockito.when((Object)this.conf.get(HiveConf.ConfVars.REPL_ATLAS_REPLICATED_TO_DB.varname)).thenReturn((Object)"tgtDb");
        Mockito.when((Object)this.conf.get(HiveConf.ConfVars.REPL_SOURCE_CLUSTER_NAME.varname)).thenReturn((Object)"srcCluster");
        Mockito.when((Object)this.conf.get(HiveConf.ConfVars.REPL_TARGET_CLUSTER_NAME.varname)).thenReturn((Object)"tgtCluster");
        Mockito.when((Object)this.conf.get("fs.defaultFS")).thenReturn((Object)"hdfs:tgtFsUri:8020");
        Mockito.when((Object)this.work.getStagingDir()).thenReturn((Object)new Path("hdfs://tmp:8020/staging"));
        Mockito.when((Object)this.work.getSrcDB()).thenReturn((Object)"srcDB");
        Mockito.when((Object)this.work.isBootstrap()).thenReturn((Object)true);
        this.atlasDumpTask = new AtlasDumpTask(this.atlasRestClient, this.conf, this.work);
        AtlasDumpTask atlasDumpTaskSpy = (AtlasDumpTask)Mockito.spy((Object)this.atlasDumpTask);
        Mockito.when((Object)this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL)).thenReturn((Object)true);
        Logger logger = LoggerFactory.getLogger((String)"ReplState");
        StringAppender appender = StringAppender.createStringAppender(null);
        appender.addToLogger(logger.getName(), Level.INFO);
        appender.start();
        ((AtlasDumpTask)Mockito.doReturn((Object)0L).when((Object)atlasDumpTaskSpy)).dumpAtlasMetaData((AtlasRequestBuilder)Mockito.any(AtlasRequestBuilder.class), (AtlasReplInfo)Mockito.any(AtlasReplInfo.class));
        ((AtlasDumpTask)Mockito.doNothing().when((Object)atlasDumpTaskSpy)).createDumpMetadata((AtlasReplInfo)Mockito.any(AtlasReplInfo.class), ((Long)Mockito.any(Long.class)).longValue());
        int status = atlasDumpTaskSpy.execute();
        Assert.assertEquals((long)0L, (long)status);
        String logStr = appender.getOutput();
        Assert.assertEquals((long)2L, (long)StringUtils.countMatches((CharSequence)logStr, (CharSequence)"REPL::"));
        Assert.assertTrue((boolean)logStr.contains("ATLAS_DUMP_START"));
        Assert.assertTrue((boolean)logStr.contains("ATLAS_DUMP_END"));
        Assert.assertTrue((boolean)logStr.contains("{\"dbName\":\"srcDB\",\"dumpStartTime"));
        Assert.assertTrue((boolean)logStr.contains("{\"dbName\":\"srcDB\",\"dumpEndTime\""));
        appender.removeFromLogger(logger.getName());
    }

    @Test
    public void testAtlasRestClientBuilder() throws SemanticException {
        try (MockedStatic userGroupInformationMockedStatic = Mockito.mockStatic(UserGroupInformation.class);){
            userGroupInformationMockedStatic.when(UserGroupInformation::getLoginUser).thenReturn(Mockito.mock(UserGroupInformation.class));
            AtlasRestClientBuilder atlasRestClientBuilder = new AtlasRestClientBuilder("http://localhost:31000");
            AtlasRestClient atlasClient = atlasRestClientBuilder.getClient(this.conf);
            Assert.assertNotNull((Object)atlasClient);
        }
    }

    @Test
    public void testRetryingClientTimeBased() throws SemanticException, IOException, AtlasServiceException {
        AtlasRestClientImpl atlasClient;
        AtlasClientV2 atlasClientV2 = (AtlasClientV2)Mockito.mock(AtlasClientV2.class);
        AtlasExportRequest exportRequest = (AtlasExportRequest)Mockito.mock(AtlasExportRequest.class);
        String exportResponseData = "dumpExportContent";
        ByteArrayInputStream exportedMetadataIS = new ByteArrayInputStream(exportResponseData.getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)atlasClientV2.exportData((AtlasExportRequest)ArgumentMatchers.any(AtlasExportRequest.class))).thenReturn((Object)exportedMetadataIS);
        Mockito.when((Object)exportRequest.toString()).thenReturn((Object)"dummyExportRequest");
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_TOTAL_DURATION, TimeUnit.SECONDS)).thenReturn((Object)60L);
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_INTIAL_DELAY, TimeUnit.SECONDS)).thenReturn((Object)1L);
        AtlasRestClientImpl atlasRestClientImpl = atlasClient = new AtlasRestClientImpl(atlasClientV2, this.conf);
        InputStream inputStream = atlasRestClientImpl.exportData(exportRequest);
        ArgumentCaptor expReqCaptor = ArgumentCaptor.forClass(AtlasExportRequest.class);
        ((AtlasClientV2)Mockito.verify((Object)atlasClientV2, (VerificationMode)Mockito.times((int)1))).exportData((AtlasExportRequest)expReqCaptor.capture());
        Assert.assertEquals((Object)((AtlasExportRequest)expReqCaptor.getValue()).toString(), (Object)"dummyExportRequest");
        byte[] exportResponseDataReadBytes = new byte[exportResponseData.length()];
        inputStream.read(exportResponseDataReadBytes);
        String exportResponseDataReadString = new String(exportResponseDataReadBytes, StandardCharsets.UTF_8);
        Assert.assertEquals((Object)exportResponseData, (Object)exportResponseDataReadString);
    }

    @Test
    public void testRetryingClientTimeBasedExhausted() throws AtlasServiceException {
        AtlasRestClientImpl atlasClient;
        AtlasClientV2 atlasClientV2 = (AtlasClientV2)Mockito.mock(AtlasClientV2.class);
        AtlasExportRequest exportRequest = (AtlasExportRequest)Mockito.mock(AtlasExportRequest.class);
        AtlasServiceException atlasServiceException = (AtlasServiceException)Mockito.mock(AtlasServiceException.class);
        Mockito.when((Object)atlasServiceException.getMessage()).thenReturn((Object)"import or export is in progress");
        Mockito.when((Object)atlasClientV2.exportData((AtlasExportRequest)ArgumentMatchers.any(AtlasExportRequest.class))).thenThrow(new Throwable[]{atlasServiceException});
        Mockito.when((Object)exportRequest.toString()).thenReturn((Object)"dummyExportRequest");
        this.setupConfForRetry();
        AtlasRestClientImpl atlasRestClientImpl = atlasClient = new AtlasRestClientImpl(atlasClientV2, this.conf);
        InputStream inputStream = null;
        try {
            inputStream = atlasRestClientImpl.exportData(exportRequest);
            Assert.fail((String)"Should have thrown SemanticException.");
        }
        catch (SemanticException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Retry exhausted for retryable error code"));
            Assert.assertTrue((atlasServiceException == ex.getCause() ? 1 : 0) != 0);
        }
        ArgumentCaptor expReqCaptor = ArgumentCaptor.forClass(AtlasExportRequest.class);
        ((AtlasClientV2)Mockito.verify((Object)atlasClientV2, (VerificationMode)Mockito.times((int)3))).exportData((AtlasExportRequest)expReqCaptor.capture());
        for (AtlasExportRequest atlasExportRequest : expReqCaptor.getAllValues()) {
            Assert.assertEquals((Object)atlasExportRequest.toString(), (Object)"dummyExportRequest");
        }
        Assert.assertTrue((inputStream == null ? 1 : 0) != 0);
    }

    @Test
    public void testAtlasServerEntity() throws AtlasServiceException, SemanticException {
        AtlasClientV2 atlasClientV2 = (AtlasClientV2)Mockito.mock(AtlasClientV2.class);
        AtlasServer atlasServer = (AtlasServer)Mockito.mock(AtlasServer.class);
        Mockito.when((Object)atlasClientV2.getServer(Mockito.anyString())).thenReturn((Object)atlasServer);
        AtlasRestClientImpl atlasClient = new AtlasRestClientImpl(atlasClientV2, this.conf);
        AtlasServer atlasServerRet = atlasClient.getServer("src", this.conf);
        Assert.assertTrue((atlasServer == atlasServerRet ? 1 : 0) != 0);
    }

    @Test
    public void testAtlasServerEntityNotFound() throws AtlasServiceException, SemanticException {
        this.setupConfForRetry();
        AtlasServiceException atlasServiceException = this.getAtlasServiceException(ClientResponse.Status.NOT_FOUND);
        AtlasClientV2 atlasClientV2 = (AtlasClientV2)Mockito.mock(AtlasClientV2.class);
        Mockito.when((Object)atlasClientV2.getServer(Mockito.anyString())).thenThrow(new Throwable[]{atlasServiceException});
        AtlasRestClientImpl atlasClient = new AtlasRestClientImpl(atlasClientV2, this.conf);
        AtlasServer atlasServerRet = atlasClient.getServer("src", this.conf);
        Assert.assertNull((Object)atlasServerRet);
        ArgumentCaptor getServerReqCaptor = ArgumentCaptor.forClass(String.class);
        ((AtlasClientV2)Mockito.verify((Object)atlasClientV2, (VerificationMode)Mockito.times((int)1))).getServer((String)getServerReqCaptor.capture());
    }

    @Test
    public void testAtlasServerEntityRetryExhausted() throws AtlasServiceException {
        this.setupConfForRetry();
        AtlasServiceException atlasServiceException = this.getAtlasServiceException(ClientResponse.Status.BAD_REQUEST);
        AtlasClientV2 atlasClientV2 = (AtlasClientV2)Mockito.mock(AtlasClientV2.class);
        Mockito.when((Object)atlasClientV2.getServer(Mockito.anyString())).thenThrow(new Throwable[]{atlasServiceException});
        AtlasRestClientImpl atlasClient = new AtlasRestClientImpl(atlasClientV2, this.conf);
        try {
            atlasClient.getServer("src", this.conf);
            Assert.fail((String)"Should have thrown SemanticException.");
        }
        catch (SemanticException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Retry exhausted for retryable error code"));
            Assert.assertTrue((atlasServiceException == ex.getCause() ? 1 : 0) != 0);
        }
        ArgumentCaptor getServerReqCaptor = ArgumentCaptor.forClass(String.class);
        ((AtlasClientV2)Mockito.verify((Object)atlasClientV2, (VerificationMode)Mockito.times((int)4))).getServer((String)getServerReqCaptor.capture());
    }

    @Test
    public void testAtlasClientTimeouts() throws Exception {
        try (MockedStatic userGroupInformationMockedStatic = Mockito.mockStatic(UserGroupInformation.class);
             MockedStatic configurationConverterMockedStatic = Mockito.mockStatic(ConfigurationConverter.class);){
            userGroupInformationMockedStatic.when(UserGroupInformation::getLoginUser).thenReturn(Mockito.mock(UserGroupInformation.class));
            configurationConverterMockedStatic.when(() -> ConfigurationConverter.getConfiguration((Properties)((Properties)ArgumentMatchers.any(Properties.class)))).thenCallRealMethod();
            Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_EXTERNAL_CLIENT_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS)).thenReturn((Object)20L);
            Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_ATLAS_CLIENT_READ_TIMEOUT, TimeUnit.MILLISECONDS)).thenReturn((Object)500L);
            AtlasRestClientBuilder atlasRestCleintBuilder = new AtlasRestClientBuilder("http://localhost:31000");
            AtlasRestClient atlasClient = atlasRestCleintBuilder.getClient(this.conf);
            Assert.assertNotNull((Object)atlasClient);
            ArgumentCaptor propsCaptor = ArgumentCaptor.forClass(Properties.class);
            configurationConverterMockedStatic.verify(() -> ConfigurationConverter.getConfiguration((Properties)((Properties)propsCaptor.capture())));
            Assert.assertEquals((Object)"20", (Object)((Properties)propsCaptor.getValue()).getProperty("atlas.client.connectTimeoutMSecs"));
            Assert.assertEquals((Object)"500", (Object)((Properties)propsCaptor.getValue()).getProperty("atlas.client.readTimeoutMSecs"));
        }
    }

    @Test
    public void testCreateExportRequest() throws Exception {
        List<String> listOfTable = Arrays.asList("t1", "t2");
        AtlasRequestBuilder atlasRequestBuilder = (AtlasRequestBuilder)Mockito.spy(AtlasRequestBuilder.class);
        ((AtlasRequestBuilder)Mockito.doReturn(listOfTable).when((Object)atlasRequestBuilder)).getFileAsList((Path)ArgumentMatchers.any(Path.class), (HiveConf)ArgumentMatchers.any(HiveConf.class));
        AtlasReplInfo atlasReplInfo = new AtlasReplInfo("http://localhost:31000", "srcDb", "tgtDb", "src", "tgt", new Path("/tmp/staging"), new Path("/tmp/list"), this.conf);
        AtlasExportRequest atlasExportRequest = atlasRequestBuilder.createExportRequest(atlasReplInfo);
        List itemsToExport = atlasExportRequest.getItemsToExport();
        Assert.assertEquals((long)2L, (long)itemsToExport.size());
        Assert.assertEquals((Object)"hive_table", (Object)((AtlasObjectId)itemsToExport.get(0)).getTypeName());
        Assert.assertEquals((Object)"srcdb.t1@src", ((AtlasObjectId)itemsToExport.get(0)).getUniqueAttributes().get("qualifiedName"));
        Assert.assertEquals((Object)"hive_table", (Object)((AtlasObjectId)itemsToExport.get(1)).getTypeName());
        Assert.assertEquals((Object)"srcdb.t2@src", ((AtlasObjectId)itemsToExport.get(1)).getUniqueAttributes().get("qualifiedName"));
    }

    @Test
    public void testGetFileAsListRetry() throws Exception {
        AtlasRequestBuilder atlasRequestBuilder = (AtlasRequestBuilder)Mockito.spy(AtlasRequestBuilder.class);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((AtlasRequestBuilder)Mockito.doReturn((Object)fs).when((Object)atlasRequestBuilder)).getFileSystem((Path)ArgumentMatchers.any(Path.class), (HiveConf)ArgumentMatchers.any(HiveConf.class));
        Mockito.when((Object)fs.getFileStatus((Path)ArgumentMatchers.any(Path.class))).thenThrow(new Throwable[]{new IOException("Unable to connect")});
        Path tableListPath = new Path("/tmp/list");
        AtlasReplInfo atlasReplInfo = new AtlasReplInfo("http://localhost:31000", "srcDb", "tgtDb", "src", "tgt", new Path("/tmp/staging"), tableListPath, this.conf);
        this.setupConfForRetry();
        try {
            atlasRequestBuilder.createExportRequest(atlasReplInfo);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)SemanticException.class.getName(), (Object)e.getClass().getName());
            Assert.assertTrue((boolean)e.getMessage().contains("Unable to connect"));
        }
        ArgumentCaptor getServerReqCaptor = ArgumentCaptor.forClass(Path.class);
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)4))).getFileStatus((Path)getServerReqCaptor.capture());
        List pathList = getServerReqCaptor.getAllValues();
        for (Path path : pathList) {
            Assert.assertTrue((boolean)tableListPath.equals((Object)path));
        }
    }

    private void setupConfForRetry() {
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_TOTAL_DURATION, TimeUnit.SECONDS)).thenReturn((Object)60L);
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_INTIAL_DELAY, TimeUnit.SECONDS)).thenReturn((Object)10L);
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_MAX_DELAY_BETWEEN_RETRIES, TimeUnit.SECONDS)).thenReturn((Object)20L);
        Mockito.when((Object)Float.valueOf(this.conf.getFloatVar(HiveConf.ConfVars.REPL_RETRY_BACKOFF_COEFFICIENT))).thenReturn((Object)Float.valueOf(2.0f));
    }

    public AtlasServiceException getAtlasServiceException(ClientResponse.Status status) {
        AtlasBaseClient.API api = new AtlasBaseClient.API("/api/atlas/admin", "POST", Response.Status.fromStatusCode((int)status.getStatusCode()));
        ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
        Mockito.when((Object)response.getStatus()).thenReturn((Object)status.getStatusCode());
        AtlasServiceException atlasServiceException = new AtlasServiceException(api, response);
        return atlasServiceException;
    }
}

