/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.ql.exec.persistence.PTFRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestPTFRowContainer {
    private static final String COL_NAMES = "x,y,z,a,b,v";
    private static final String COL_TYPES = "int,string,double,int,string,string";
    static AbstractSerDe serDe;
    static Configuration cfg;

    @BeforeClass
    public static void setupClass() throws SerDeException {
        cfg = new Configuration();
        serDe = new LazyBinarySerDe();
        Properties p = new Properties();
        p.setProperty("columns", COL_NAMES);
        p.setProperty("columns.types", COL_TYPES);
        serDe.initialize(cfg, p, null);
    }

    private PTFRowContainer<List<Object>> rowContainer(int blockSize) throws SerDeException, HiveException {
        PTFRowContainer rc = new PTFRowContainer(blockSize, cfg, null);
        rc.setSerDe(serDe, ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)serDe.getObjectInspector()));
        rc.setTableDesc(PTFRowContainer.createTableDesc((StructObjectInspector)((StructObjectInspector)serDe.getObjectInspector())));
        return rc;
    }

    private void runTest(int sz, int blockSize, String value) throws SerDeException, HiveException {
        int j;
        List<Text> row;
        int i;
        PTFRowContainer<List<Object>> rc = this.rowContainer(blockSize);
        for (i = 0; i < sz; ++i) {
            row = new ArrayList<Object>();
            row.add((Text)new IntWritable(i));
            row.add(new Text("abc " + i));
            row.add((Text)new DoubleWritable((double)i));
            row.add((Text)new IntWritable(i));
            row.add(new Text("def " + i));
            row.add(new Text(value));
            rc.addRow(row);
        }
        Assert.assertEquals((long)sz, (long)rc.rowCount());
        i = 0;
        row = new ArrayList();
        row = rc.first();
        while (row != null) {
            Assert.assertEquals((Object)("abc " + i), (Object)row.get(1).toString());
            ++i;
            row = rc.next();
        }
        row = rc.first();
        for (i = sz - 1; i >= 0; --i) {
            row = rc.getAt(i);
            Assert.assertEquals((Object)("abc " + i), (Object)row.get(1).toString());
        }
        Random r = new Random(1000L);
        for (i = 0; i < 100; ++i) {
            j = r.nextInt(sz);
            row = rc.getAt(j);
            Assert.assertEquals((Object)("abc " + j), (Object)row.get(1).toString());
        }
        for (i = 0; i < 100; ++i) {
            j = r.nextInt(sz);
            row = rc.getAt(j);
            Assert.assertEquals((Object)("abc " + j), (Object)row.get(1).toString());
            for (int k = j + 1; k < j + blockSize / 4 && k < sz; ++k) {
                row = rc.next();
                Assert.assertEquals((Object)("def " + k), (Object)row.get(4).toString());
            }
        }
    }

    private void runTest(int sz, int blockSize) throws SerDeException, HiveException {
        this.runTest(sz, blockSize, "");
    }

    @Test
    public void testLargeBlockSize() throws SerDeException, HiveException {
        this.runTest(100000, 25000);
    }

    @Test
    public void testSmallBlockSize() throws SerDeException, HiveException {
        this.runTest(10000, 5);
    }

    @Test
    public void testBlocksLargerThanSplit() throws SerDeException, HiveException, IOException {
        this.runTest(5, 2, new String(new char[(int)FileSystem.getLocal((Configuration)cfg).getDefaultBlockSize()]));
    }
}

