/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.DependencyCollectionTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestamp;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtilities {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    public static final Logger LOG = LoggerFactory.getLogger(TestUtilities.class);
    private static final int NUM_BUCKETS = 3;

    @Test
    public void testGetFileExtension() {
        JobConf jc = new JobConf();
        Assert.assertEquals((String)"No extension for uncompressed unknown format", (Object)"", (Object)Utilities.getFileExtension((JobConf)jc, (boolean)false, null));
        Assert.assertEquals((String)"No extension for compressed unknown format", (Object)"", (Object)Utilities.getFileExtension((JobConf)jc, (boolean)true, null));
        Assert.assertEquals((String)"No extension for uncompressed text format", (Object)"", (Object)Utilities.getFileExtension((JobConf)jc, (boolean)false, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        Assert.assertEquals((String)"Deflate for uncompressed text format", (Object)".deflate", (Object)Utilities.getFileExtension((JobConf)jc, (boolean)true, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        String extension = ".myext";
        jc.set("hive.output.file.extension", extension);
        Assert.assertEquals((String)"Custom extension for uncompressed unknown format", (Object)extension, (Object)Utilities.getFileExtension((JobConf)jc, (boolean)false, null));
        Assert.assertEquals((String)"Custom extension for compressed unknown format", (Object)extension, (Object)Utilities.getFileExtension((JobConf)jc, (boolean)true, null));
        Assert.assertEquals((String)"Custom extension for uncompressed text format", (Object)extension, (Object)Utilities.getFileExtension((JobConf)jc, (boolean)false, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        Assert.assertEquals((String)"Custom extension for uncompressed text format", (Object)extension, (Object)Utilities.getFileExtension((JobConf)jc, (boolean)true, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
    }

    @Test
    public void testSerializeTimestamp() {
        Timestamp ts = Timestamp.ofEpochMilli((long)1374554702000L, (int)123456);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((Object)ts);
        ArrayList<ExprNodeConstantDesc> children = new ArrayList<ExprNodeConstantDesc>(1);
        children.add(constant);
        ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, (GenericUDF)new GenericUDFFromUtcTimestamp(), children);
        Assert.assertEquals((Object)desc.getExprString(), (Object)SerializationUtilities.deserializeExpression((String)SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)desc)).getExprString());
    }

    @Test
    public void testGetDbTableName() throws HiveException {
        SessionState.start((HiveConf)new HiveConfForTest(this.getClass()));
        String curDefaultdb = SessionState.get().getCurrentDatabase();
        String tablename = "tab1";
        String[] dbtab = Utilities.getDbTableName((String)tablename);
        Assert.assertEquals((String)"db name", (Object)curDefaultdb, (Object)dbtab[0]);
        Assert.assertEquals((String)"table name", (Object)tablename, (Object)dbtab[1]);
        tablename = "dab1.tab1";
        dbtab = Utilities.getDbTableName((String)tablename);
        Assert.assertEquals((String)"db name", (Object)"dab1", (Object)dbtab[0]);
        Assert.assertEquals((String)"table name", (Object)"tab1", (Object)dbtab[1]);
        tablename = "dab1.tab1.meta1";
        dbtab = Utilities.getDbTableName((String)tablename);
        Assert.assertEquals((String)"db name", (Object)"dab1", (Object)dbtab[0]);
        Assert.assertEquals((String)"table name", (Object)"tab1", (Object)dbtab[1]);
        Assert.assertEquals((String)"metadata table name", (Object)"meta1", (Object)dbtab[2]);
        tablename = "dab1.tab1.x1.y";
        try {
            dbtab = Utilities.getDbTableName((String)tablename);
            Assert.fail((String)"exception was expected for invalid table name");
        }
        catch (HiveException ex) {
            Assert.assertEquals((Object)("Invalid table name " + tablename), (Object)ex.getMessage());
        }
    }

    @Test
    public void testReplaceTaskId() {
        String taskID = "000000";
        int bucketNum = 1;
        String newTaskID = Utilities.replaceTaskId((String)taskID, (int)bucketNum);
        Assert.assertEquals((Object)"000001", (Object)newTaskID);
        taskID = "(ds%3D1)000001";
        newTaskID = Utilities.replaceTaskId((String)taskID, (int)5);
        Assert.assertEquals((Object)"(ds%3D1)000005", (Object)newTaskID);
    }

    @Test
    public void testRemoveTempOrDuplicateFilesOnTezNoDp() throws Exception {
        List<Path> paths = this.runRemoveTempOrDuplicateFilesTestCase("tez", false);
        Assert.assertEquals((long)0L, (long)paths.size());
    }

    @Test
    public void testRemoveTempOrDuplicateFilesOnTezWithDp() throws Exception {
        List<Path> paths = this.runRemoveTempOrDuplicateFilesTestCase("tez", true);
        Assert.assertEquals((long)0L, (long)paths.size());
    }

    @Test
    public void testRemoveTempOrDuplicateFilesOnMrNoDp() throws Exception {
        List<Path> paths = this.runRemoveTempOrDuplicateFilesTestCase("mr", false);
        Assert.assertEquals((long)3L, (long)paths.size());
    }

    @Test
    public void testRemoveTempOrDuplicateFilesOnMrWithDp() throws Exception {
        List<Path> paths = this.runRemoveTempOrDuplicateFilesTestCase("mr", true);
        Assert.assertEquals((long)3L, (long)paths.size());
    }

    @Test
    public void testRenameFilesNotExists() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Path src = new Path("src");
        Path dest = new Path("dir");
        Mockito.when((Object)fs.exists(dest)).thenReturn((Object)false);
        Mockito.when((Object)fs.rename(src, dest)).thenReturn((Object)true);
        Utilities.renameOrMoveFiles((FileSystem)fs, (Path)src, (Path)dest);
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).rename(src, dest);
    }

    @Test
    public void testRenameFileExistsNonHive() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Path src = new Path("src");
        Path dest = new Path("dir1");
        Path finalPath = new Path(dest, "src_2");
        FileStatus status = new FileStatus();
        status.setPath(src);
        Mockito.when((Object)fs.listStatus(src)).thenReturn((Object)new FileStatus[]{status});
        Mockito.when((Object)fs.exists(dest)).thenReturn((Object)true);
        Mockito.when((Object)fs.exists(new Path(dest, "src"))).thenReturn((Object)true);
        Mockito.when((Object)fs.exists(new Path(dest, "src_1"))).thenReturn((Object)true);
        Mockito.when((Object)fs.rename(src, finalPath)).thenReturn((Object)true);
        Utilities.renameOrMoveFiles((FileSystem)fs, (Path)src, (Path)dest);
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).rename(src, finalPath);
    }

    @Test
    public void testRenameFileExistsHivePath() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Path src = new Path("00001_02");
        Path dest = new Path("dir1");
        Path finalPath = new Path(dest, "00001_02_copy_2");
        FileStatus status = new FileStatus();
        status.setPath(src);
        Mockito.when((Object)fs.listStatus(src)).thenReturn((Object)new FileStatus[]{status});
        Mockito.when((Object)fs.exists(dest)).thenReturn((Object)true);
        Mockito.when((Object)fs.exists(new Path(dest, "00001_02"))).thenReturn((Object)true);
        Mockito.when((Object)fs.exists(new Path(dest, "00001_02_copy_1"))).thenReturn((Object)true);
        Mockito.when((Object)fs.rename(src, finalPath)).thenReturn((Object)true);
        Utilities.renameOrMoveFiles((FileSystem)fs, (Path)src, (Path)dest);
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).rename(src, finalPath);
    }

    private List<Path> runRemoveTempOrDuplicateFilesTestCase(String executionEngine, boolean dPEnabled) throws Exception {
        HiveConfForTest hconf = new HiveConfForTest(this.getClass());
        hconf.set("fs.defaultFS", "hdfs://should-not-be-used/");
        hconf.set(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, executionEngine);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)hconf);
        DynamicPartitionCtx dpCtx = this.getDynamicPartitionCtx(dPEnabled);
        Path tempDirPath = this.setupTempDirWithSingleOutputFile((Configuration)hconf);
        FileSinkDesc conf = this.getFileSinkDesc(tempDirPath);
        hconf.setBoolean("mapreduce.map.speculative", false);
        hconf.setBoolean("mapreduce.reduce.speculative", false);
        List paths = Utilities.removeTempOrDuplicateFiles((FileSystem)localFs, (Path)tempDirPath, (DynamicPartitionCtx)dpCtx, (FileSinkDesc)conf, (Configuration)hconf, (boolean)false);
        String expectedScheme = tempDirPath.toUri().getScheme();
        String expectedAuthority = tempDirPath.toUri().getAuthority();
        this.assertPathsMatchSchemeAndAuthority(expectedScheme, expectedAuthority, paths);
        return paths;
    }

    private void assertPathsMatchSchemeAndAuthority(String expectedScheme, String expectedAuthority, List<Path> paths) {
        for (Path path : paths) {
            Assert.assertEquals((Object)path.toUri().getScheme().toLowerCase(), (Object)expectedScheme.toLowerCase());
            Assert.assertEquals((Object)path.toUri().getAuthority(), (Object)expectedAuthority);
        }
    }

    private DynamicPartitionCtx getDynamicPartitionCtx(boolean dPEnabled) {
        DynamicPartitionCtx dpCtx = null;
        if (dPEnabled) {
            dpCtx = (DynamicPartitionCtx)Mockito.mock(DynamicPartitionCtx.class);
            Mockito.when((Object)dpCtx.getNumDPCols()).thenReturn((Object)0);
            Mockito.when((Object)dpCtx.getNumBuckets()).thenReturn((Object)3);
        }
        return dpCtx;
    }

    private FileSinkDesc getFileSinkDesc(Path tempDirPath) {
        Table table = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)table.getNumBuckets()).thenReturn((Object)3);
        TableDesc tInfo = Utilities.getTableDesc((String)"s", (String)"string");
        FileSinkDesc conf = new FileSinkDesc(tempDirPath, tInfo, false);
        conf.setTable(table);
        return conf;
    }

    private Path setupTempDirWithSingleOutputFile(Configuration hconf) throws IOException {
        Path tempDirPath = new Path("file://" + this.temporaryFolder.newFolder().getAbsolutePath());
        Path taskOutputPath = new Path(tempDirPath, Utilities.getTaskId((Configuration)hconf));
        FileSystem.getLocal((Configuration)hconf).create(taskOutputPath).close();
        return tempDirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetInputPathsWithEmptyPartitions() throws Exception {
        String alias1Name = "alias1";
        String alias2Name = "alias2";
        MapWork mapWork1 = new MapWork();
        MapWork mapWork2 = new MapWork();
        JobConf jobConf = new JobConf();
        Configuration conf = new Configuration();
        Path nonExistentPath1 = new Path(UUID.randomUUID().toString());
        Path nonExistentPath2 = new Path(UUID.randomUUID().toString());
        PartitionDesc mockPartitionDesc = (PartitionDesc)Mockito.mock(PartitionDesc.class);
        TableDesc mockTableDesc = (TableDesc)Mockito.mock(TableDesc.class);
        Mockito.when((Object)mockTableDesc.isNonNative()).thenReturn((Object)false);
        Mockito.when((Object)mockTableDesc.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)mockPartitionDesc.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)mockPartitionDesc.getTableDesc()).thenReturn((Object)mockTableDesc);
        ((PartitionDesc)Mockito.doReturn(HiveSequenceFileOutputFormat.class).when((Object)mockPartitionDesc)).getOutputFileFormatClass();
        mapWork1.setPathToAliases(new LinkedHashMap(ImmutableMap.of((Object)nonExistentPath1, (Object)Lists.newArrayList((Object[])new String[]{alias1Name}))));
        mapWork1.setAliasToWork(new LinkedHashMap(ImmutableMap.of((Object)alias1Name, (Object)((Operator)Mockito.mock(Operator.class)))));
        mapWork1.setPathToPartitionInfo(new LinkedHashMap(ImmutableMap.of((Object)nonExistentPath1, (Object)mockPartitionDesc)));
        mapWork2.setPathToAliases(new LinkedHashMap(ImmutableMap.of((Object)nonExistentPath2, (Object)Lists.newArrayList((Object[])new String[]{alias2Name}))));
        mapWork2.setAliasToWork(new LinkedHashMap(ImmutableMap.of((Object)alias2Name, (Object)((Operator)Mockito.mock(Operator.class)))));
        mapWork2.setPathToPartitionInfo(new LinkedHashMap(ImmutableMap.of((Object)nonExistentPath2, (Object)mockPartitionDesc)));
        ArrayList inputPaths = new ArrayList();
        try {
            Path scratchDir = new Path(HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.LOCAL_SCRATCH_DIR));
            List inputPaths1 = Utilities.getInputPaths((JobConf)jobConf, (MapWork)mapWork1, (Path)scratchDir, (Context)((Context)Mockito.mock(Context.class)), (boolean)false);
            inputPaths.addAll(inputPaths1);
            Assert.assertEquals((long)inputPaths1.size(), (long)1L);
            Assert.assertNotEquals(inputPaths1.get(0), (Object)nonExistentPath1);
            Assert.assertTrue((boolean)((Path)inputPaths1.get(0)).getFileSystem(conf).exists((Path)inputPaths1.get(0)));
            Assert.assertFalse((boolean)nonExistentPath1.getFileSystem(conf).exists(nonExistentPath1));
            List inputPaths2 = Utilities.getInputPaths((JobConf)jobConf, (MapWork)mapWork2, (Path)scratchDir, (Context)((Context)Mockito.mock(Context.class)), (boolean)false);
            inputPaths.addAll(inputPaths2);
            Assert.assertEquals((long)inputPaths2.size(), (long)1L);
            Assert.assertNotEquals(inputPaths2.get(0), (Object)nonExistentPath2);
            Assert.assertTrue((boolean)((Path)inputPaths2.get(0)).getFileSystem(conf).exists((Path)inputPaths2.get(0)));
            Assert.assertFalse((boolean)nonExistentPath2.getFileSystem(conf).exists(nonExistentPath2));
        }
        finally {
            for (Path path : inputPaths) {
                File file = new File(path.toString());
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetInputPathsWithMultipleThreadsAndEmptyPartitions() throws Exception {
        int numPartitions = 15;
        JobConf jobConf = new JobConf();
        jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, Runtime.getRuntime().availableProcessors() * 2);
        MapWork mapWork = new MapWork();
        Path testTablePath = new Path("testTable");
        Path[] testPartitionsPaths = new Path[numPartitions];
        PartitionDesc mockPartitionDesc = (PartitionDesc)Mockito.mock(PartitionDesc.class);
        TableDesc mockTableDesc = (TableDesc)Mockito.mock(TableDesc.class);
        Mockito.when((Object)mockTableDesc.isNonNative()).thenReturn((Object)false);
        Mockito.when((Object)mockTableDesc.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)mockPartitionDesc.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)mockPartitionDesc.getTableDesc()).thenReturn((Object)mockTableDesc);
        ((PartitionDesc)Mockito.doReturn(HiveSequenceFileOutputFormat.class).when((Object)mockPartitionDesc)).getOutputFileFormatClass();
        for (int i = 0; i < numPartitions; ++i) {
            String testPartitionName = "p=" + i;
            testPartitionsPaths[i] = new Path(testTablePath, "p=" + i);
            mapWork.getPathToAliases().put(testPartitionsPaths[i], Lists.newArrayList((Object[])new String[]{testPartitionName}));
            mapWork.getAliasToWork().put(testPartitionName, (Operator)Mockito.mock(Operator.class));
            mapWork.getPathToPartitionInfo().put(testPartitionsPaths[i], mockPartitionDesc);
        }
        LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
        try {
            fs.mkdirs(testTablePath);
            List inputPaths = Utilities.getInputPaths((JobConf)jobConf, (MapWork)mapWork, (Path)new Path(HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.LOCAL_SCRATCH_DIR)), (Context)((Context)Mockito.mock(Context.class)), (boolean)false);
            Assert.assertEquals((long)inputPaths.size(), (long)numPartitions);
            for (int i = 0; i < numPartitions; ++i) {
                Assert.assertNotEquals(inputPaths.get(i), (Object)testPartitionsPaths[i]);
            }
            Assert.assertEquals((long)mapWork.getPathToAliases().size(), (long)numPartitions);
            Assert.assertEquals((long)mapWork.getPathToPartitionInfo().size(), (long)numPartitions);
            Assert.assertEquals((long)mapWork.getAliasToWork().size(), (long)numPartitions);
            for (Map.Entry entry : mapWork.getPathToAliases().entrySet()) {
                Assert.assertNotNull(entry.getKey());
                Assert.assertNotNull(entry.getValue());
                Assert.assertEquals((long)((List)entry.getValue()).size(), (long)1L);
                Assert.assertTrue((boolean)((Path)entry.getKey()).getFileSystem(new Configuration()).exists((Path)entry.getKey()));
            }
        }
        finally {
            if (fs.exists(testTablePath)) {
                fs.delete(testTablePath, true);
            }
        }
    }

    @Test
    public void testGetMaxExecutorsForInputListing() {
        Configuration conf = new Configuration();
        boolean ZERO_EXECUTORS = false;
        boolean ONE_EXECUTOR = true;
        int TWO_EXECUTORS = 2;
        boolean ZERO_THREADS = false;
        boolean ONE_THREAD = true;
        int TWO_THREADS = 2;
        boolean ZERO_LOCATIONS = false;
        boolean ONE_LOCATION = true;
        int TWO_LOCATIONS = 2;
        int THREE_LOCATIONS = 3;
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 1);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        conf.setInt("mapred.dfsclient.parallelism.max", 0);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        conf.setInt("mapred.dfsclient.parallelism.max", 1);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        conf.setInt("mapred.dfsclient.parallelism.max", 2);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        conf.setInt("mapred.dfsclient.parallelism.max", 1);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
    }

    @Test
    public void testGetInputPathsWithASingleThread() throws Exception {
        int NUM_PARTITIONS = 5;
        JobConf jobConf = new JobConf();
        jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 1);
        this.runTestGetInputPaths(jobConf, 5);
    }

    @Test
    public void testGetInputPathsWithMultipleThreads() throws Exception {
        int NUM_PARTITIONS = 5;
        JobConf jobConf = new JobConf();
        jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        this.runTestGetInputPaths(jobConf, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestGetInputPaths(JobConf jobConf, int numOfPartitions) throws Exception {
        MapWork mapWork = new MapWork();
        Path scratchDir = new Path(HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.LOCAL_SCRATCH_DIR));
        LinkedHashMap<Path, ArrayList> pathToAliasTable = new LinkedHashMap<Path, ArrayList>();
        String testTableName = "testTable";
        Path testTablePath = new Path(testTableName);
        Path[] testPartitionsPaths = new Path[numOfPartitions];
        for (int i = 0; i < numOfPartitions; ++i) {
            String testPartitionName = "p=" + i;
            testPartitionsPaths[i] = new Path(testTablePath, "p=" + i);
            pathToAliasTable.put(testPartitionsPaths[i], Lists.newArrayList((Object[])new String[]{testPartitionName}));
            mapWork.getAliasToWork().put(testPartitionName, (Operator)Mockito.mock(Operator.class));
        }
        mapWork.setPathToAliases(pathToAliasTable);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
        try {
            fs.mkdirs(testTablePath);
            for (int i = 0; i < numOfPartitions; ++i) {
                fs.mkdirs(testPartitionsPaths[i]);
                fs.create(new Path(testPartitionsPaths[i], "test1.txt")).close();
            }
            List inputPaths = Utilities.getInputPaths((JobConf)jobConf, (MapWork)mapWork, (Path)scratchDir, (Context)((Context)Mockito.mock(Context.class)), (boolean)false);
            Assert.assertEquals((long)inputPaths.size(), (long)numOfPartitions);
            for (int i = 0; i < numOfPartitions; ++i) {
                Assert.assertEquals(inputPaths.get(i), (Object)testPartitionsPaths[i]);
            }
        }
        finally {
            if (fs.exists(testTablePath)) {
                fs.delete(testTablePath, true);
            }
        }
    }

    @Test
    public void testGetInputPathsPool() throws IOException, ExecutionException, InterruptedException {
        ArrayList<Path> pathsToAdd = new ArrayList<Path>();
        Path path = new Path("dummy-path");
        pathsToAdd.add(path);
        pathsToAdd.add(path);
        pathsToAdd.add(path);
        ExecutorService pool = (ExecutorService)Mockito.mock(ExecutorService.class);
        Future mockFuture = (Future)Mockito.mock(Future.class);
        Mockito.when(mockFuture.get()).thenReturn((Object)path);
        Mockito.when(pool.submit((Callable)ArgumentMatchers.any(Callable.class))).thenReturn((Object)mockFuture);
        Utilities.getInputPathsWithPool((JobConf)((JobConf)Mockito.mock(JobConf.class)), (MapWork)((MapWork)Mockito.mock(MapWork.class)), (Path)((Path)Mockito.mock(Path.class)), (Context)((Context)Mockito.mock(Context.class)), (boolean)false, pathsToAdd, (ExecutorService)pool);
        ((ExecutorService)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)3))).submit((Callable)ArgumentMatchers.any(Callable.class));
        ((ExecutorService)Mockito.verify((Object)pool)).shutdown();
        ((ExecutorService)Mockito.verify((Object)pool)).shutdownNow();
    }

    @Test
    public void testGetInputPathsPoolAndFailure() throws IOException, ExecutionException, InterruptedException {
        ArrayList<Path> pathsToAdd = new ArrayList<Path>();
        Path path = new Path("dummy-path");
        pathsToAdd.add(path);
        pathsToAdd.add(path);
        pathsToAdd.add(path);
        ExecutorService pool = (ExecutorService)Mockito.mock(ExecutorService.class);
        Future mockFuture = (Future)Mockito.mock(Future.class);
        Mockito.when(mockFuture.get()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when(pool.submit((Callable)ArgumentMatchers.any(Callable.class))).thenReturn((Object)mockFuture);
        Exception e = null;
        try {
            Utilities.getInputPathsWithPool((JobConf)((JobConf)Mockito.mock(JobConf.class)), (MapWork)((MapWork)Mockito.mock(MapWork.class)), (Path)((Path)Mockito.mock(Path.class)), (Context)((Context)Mockito.mock(Context.class)), (boolean)false, pathsToAdd, (ExecutorService)pool);
        }
        catch (Exception thrownException) {
            e = thrownException;
        }
        Assert.assertNotNull((Object)e);
        ((ExecutorService)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)3))).submit((Callable)ArgumentMatchers.any(Callable.class));
        ((ExecutorService)Mockito.verify((Object)pool)).shutdownNow();
    }

    private Task<?> getDependencyCollectionTask() {
        return TaskFactory.get((Serializable)new DependencyCollectionWork());
    }

    private List<Task<?>> getTestDiamondTaskGraph(Task<?> providedTask) {
        Task<?> root = this.getDependencyCollectionTask();
        Task<?> DTa = this.getDependencyCollectionTask();
        Task<?> DTb = this.getDependencyCollectionTask();
        Task<?> DTc = this.getDependencyCollectionTask();
        Task<?> DTd = this.getDependencyCollectionTask();
        Task<?> DTe = this.getDependencyCollectionTask();
        root.addDependentTask(DTa);
        root.addDependentTask(DTb);
        root.addDependentTask(DTc);
        DTa.addDependentTask(DTd);
        DTb.addDependentTask(DTd);
        DTc.addDependentTask(DTd);
        DTd.addDependentTask(providedTask);
        providedTask.addDependentTask(DTe);
        ArrayList retVals = new ArrayList();
        retVals.add(root);
        return retVals;
    }

    @Test
    public void testGetTasksHaveNoRepeats() {
        CountingWrappingTask mrTask = new CountingWrappingTask((Task<?>)new ExecDriver());
        CountingWrappingTask tezTask = new CountingWrappingTask((Task<?>)new TezTask());
        Assert.assertEquals((String)"No repeated MRTasks from Utilities.getMRTasks", (long)1L, (long)Utilities.getMRTasks(this.getTestDiamondTaskGraph((Task<?>)mrTask)).size());
        Assert.assertEquals((String)"No repeated TezTasks from Utilities.getTezTasks", (long)1L, (long)Utilities.getTezTasks(this.getTestDiamondTaskGraph((Task<?>)tezTask)).size());
        Assert.assertEquals((String)"MRTasks should have been visited only once", (long)2L, (long)mrTask.getDepCallCount());
        Assert.assertEquals((String)"TezTasks should have been visited only once", (long)2L, (long)tezTask.getDepCallCount());
    }

    private static Task<MapredWork> getMapredWork() {
        return TaskFactory.get(MapredWork.class);
    }

    @Test
    public void testGetTasksRecursion() {
        Task<MapredWork> rootTask = TestUtilities.getMapredWork();
        Task<MapredWork> child1 = TestUtilities.getMapredWork();
        Task<MapredWork> child2 = TestUtilities.getMapredWork();
        Task<MapredWork> child11 = TestUtilities.getMapredWork();
        rootTask.addDependentTask(child1);
        rootTask.addDependentTask(child2);
        child1.addDependentTask(child11);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Task[]{rootTask, child1, child2, child11}), (Object)Utilities.getMRTasks(this.getTestDiamondTaskGraph(rootTask)));
    }

    @Test
    public void testSelectManifestFilesOnlyOneAttemptId() {
        FileStatus[] manifestFiles = this.generateTestNotEmptyFileStatuses("000000_0.manifest", "000001_0.manifest", "000002_0.manifest", "000003_0.manifest");
        Set<String> expectedPathes = this.getExpectedPathes("000000_0.manifest", "000001_0.manifest", "000002_0.manifest", "000003_0.manifest");
        List foundManifestFiles = Utilities.selectManifestFiles((FileStatus[])manifestFiles);
        Set<String> resultPathes = this.getResultPathes(foundManifestFiles);
        Assert.assertEquals(expectedPathes, resultPathes);
    }

    @Test
    public void testSelectManifestFilesMultipleAttemptIds() {
        FileStatus[] manifestFiles = this.generateTestNotEmptyFileStatuses("000000_1.manifest", "000000_0.manifest", "000000_3.manifest", "000000_2.manifest", "000003_0.manifest", "000003_1.manifest", "000003_2.manifest");
        Set<String> expectedPathes = this.getExpectedPathes("000000_3.manifest", "000003_2.manifest");
        List foundManifestFiles = Utilities.selectManifestFiles((FileStatus[])manifestFiles);
        Set<String> resultPathes = this.getResultPathes(foundManifestFiles);
        Assert.assertEquals(expectedPathes, resultPathes);
    }

    @Test
    public void testSelectManifestFilesWithEmptyManifests() {
        HashSet<String> emptyFiles = new HashSet<String>();
        emptyFiles.add("000001_0.manifest");
        emptyFiles.add("000001_2.manifest");
        emptyFiles.add("000002_2.manifest");
        FileStatus[] manifestFiles = this.generateTestNotEmptyFileStatuses(emptyFiles, "000001_1.manifest", "000001_0.manifest", "000001_3.manifest", "000001_2.manifest", "000002_0.manifest", "000002_1.manifest", "000002_2.manifest");
        Set<String> expectedPathes = this.getExpectedPathes("000001_3.manifest", "000002_1.manifest");
        List foundManifestFiles = Utilities.selectManifestFiles((FileStatus[])manifestFiles);
        Set<String> resultPathes = this.getResultPathes(foundManifestFiles);
        Assert.assertEquals(expectedPathes, resultPathes);
    }

    @Test
    public void testSelectManifestFilesWithWrongManifestNames() {
        FileStatus[] manifestFiles = this.generateTestNotEmptyFileStatuses("000004_0.manifest", "000005.manifest", "000004_1.manifest", "000006.manifest", "000007_0.wrong", "000008_1", "000004_2.manifest");
        Set<String> expectedPathes = this.getExpectedPathes("000005.manifest", "000006.manifest", "000004_2.manifest");
        List foundManifestFiles = Utilities.selectManifestFiles((FileStatus[])manifestFiles);
        Set<String> resultPathes = this.getResultPathes(foundManifestFiles);
        Assert.assertEquals(expectedPathes, resultPathes);
    }

    @Test
    public void testSetPermissionsOnExistingDir() throws IOException {
        File tmpDir = Files.createTempDir();
        Path path = new Path(tmpDir.getPath());
        HiveConf conf = new HiveConf(this.getClass());
        FileSystem fs = path.getFileSystem((Configuration)conf);
        fs.setPermission(path, new FsPermission(448));
        Utilities.ensurePathIsWritable((Path)path, (HiveConf)conf);
        Assert.assertEquals((long)475L, (long)fs.getFileStatus(path).getPermission().toShort());
        fs.setPermission(path, new FsPermission(493));
        Utilities.ensurePathIsWritable((Path)path, (HiveConf)conf);
        Assert.assertEquals((long)511L, (long)fs.getFileStatus(path).getPermission().toShort());
    }

    private FileStatus[] generateTestNotEmptyFileStatuses(String ... fileNames) {
        return this.generateTestNotEmptyFileStatuses((Set<String>)null, fileNames);
    }

    private FileStatus[] generateTestNotEmptyFileStatuses(Set<String> emptyFiles, String ... fileNames) {
        FileStatus[] manifestFiles = new FileStatus[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            long len = 10000L;
            if (emptyFiles != null && emptyFiles.contains(fileNames[i])) {
                len = 0L;
            }
            manifestFiles[i] = new FileStatus(len, false, 0, 250L, 123456L, new Path("/sometestpath/" + fileNames[i]));
        }
        return manifestFiles;
    }

    private Set<String> getExpectedPathes(String ... fileNames) {
        HashSet<String> expectedPathes = new HashSet<String>();
        for (String fileName : fileNames) {
            expectedPathes.add("/sometestpath/" + fileName);
        }
        return expectedPathes;
    }

    private Set<String> getResultPathes(List<Path> foundManifestFiles) {
        HashSet<String> resultPathes = new HashSet<String>();
        for (Path path : foundManifestFiles) {
            resultPathes.add(path.toString());
        }
        return resultPathes;
    }

    public class CountingWrappingTask
    extends DependencyCollectionTask {
        int count = 0;
        Task<?> wrappedDep = null;

        public CountingWrappingTask(Task<?> dep) {
            this.wrappedDep = dep;
            super.addDependentTask(this.wrappedDep);
        }

        public boolean addDependentTask(Task<?> dependent) {
            return this.wrappedDep.addDependentTask(dependent);
        }

        public List<Task<?>> getDependentTasks() {
            ++this.count;
            System.err.println("YAH:getDepTasks got called!");
            new Exception().printStackTrace(System.err);
            LOG.info("YAH!getDepTasks", (Throwable)new Exception());
            return super.getDependentTasks();
        }

        public int getDepCallCount() {
            return this.count;
        }

        public String getName() {
            return "COUNTER_TASK";
        }

        public String toString() {
            return this.getName() + "_" + this.wrappedDep.toString();
        }
    }
}

