/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorPartitionDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestSerializationUtilities {
    @Test
    public void testEveryPropertiesAreSerialized() throws Exception {
        MapWork mapWork = this.doSerDeser(null);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk1", true);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk2", true);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "rawDataSize", true);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "serialization.ddl", true);
    }

    @Test
    public void testRegexFilterAll() throws Exception {
        MapWork mapWork = this.doSerDeser(this.getConfWithSkipConfig(".*"));
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk1", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk2", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "rawDataSize", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "serialization.ddl", false);
    }

    @Test
    public void testRegexFilterSomeProps() throws Exception {
        MapWork mapWork = this.doSerDeser(this.getConfWithSkipConfig("impala_intermediate_stats_chunk.*"));
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk1", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk2", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "rawDataSize", true);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "serialization.ddl", true);
    }

    @Test
    public void testString() throws Exception {
        MapWork mapWork = this.doSerDeser(this.getConfWithSkipConfig("rawDataSize"));
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk1", true);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk2", true);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "rawDataSize", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "serialization.ddl", true);
    }

    @Test
    public void testStringAndBadRegex() throws Exception {
        MapWork mapWork = this.doSerDeser(this.getConfWithSkipConfig("impala_intermediate_stats_chunk,rawDataSize"));
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk1", true);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk2", true);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "rawDataSize", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "serialization.ddl", true);
    }

    @Test
    public void testStringRegexMixed() throws Exception {
        MapWork mapWork = this.doSerDeser(this.getConfWithSkipConfig("impala_intermediate_stats_chunk.*,rawDataSize,.*ddl"));
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk1", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk2", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "rawDataSize", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "serialization.ddl", false);
    }

    @Test
    public void testSkippingAppliesToAllPartitions() throws Exception {
        MapWork mapWork = this.doSerDeser(this.getConfWithSkipConfig("impala_intermediate_stats_chunk.*,rawDataSize,.*ddl"));
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk1", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "impala_intermediate_stats_chunk2", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "rawDataSize", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=0", "serialization.ddl", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=1", "impala_intermediate_stats_chunk1", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=1", "impala_intermediate_stats_chunk2", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=1", "rawDataSize", false);
        this.assertPartitionDescPropertyPresence(mapWork, "/warehouse/test_table/p=1", "serialization.ddl", false);
    }

    @Test
    public void testUnsupportedDeserialization() throws Exception {
        ArrayList<Long> invalidExpr = new ArrayList<Long>();
        invalidExpr.add(1L);
        byte[] buf = SerializationUtilities.serializeObjectWithTypeInformation(invalidExpr);
        try {
            SerializationUtilities.deserializeObjectWithTypeInformation((byte[])buf, (boolean)true);
            Assert.fail((String)"Should throw exception as the input is not a valid filter");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ExprNodeGenericFuncDesc validExpr = ExprNodeGenericFuncDesc.newInstance((GenericUDF)new GenericUDFOPNull(), Arrays.asList(new ExprNodeColumnDesc(new ColumnInfo("_c0", (TypeInfo)TypeInfoFactory.stringTypeInfo, "a", false))));
        buf = SerializationUtilities.serializeObjectWithTypeInformation((Serializable)validExpr);
        ExprNodeDesc desc = (ExprNodeDesc)SerializationUtilities.deserializeObjectWithTypeInformation((byte[])buf, (boolean)true);
        Assert.assertTrue((boolean)ExprNodeDescUtils.isSame((ExprNodeDesc)validExpr, (ExprNodeDesc)desc));
    }

    private MapWork doSerDeser(Configuration configuration) throws Exception, IOException {
        MapWork mapWork = TestSerializationUtilities.mockMapWorkWithSomePartitionDescProperties();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializationUtilities.serializePlan((Object)mapWork, (OutputStream)baos, (Configuration)configuration);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        MapWork mapWorkDeserialized = (MapWork)SerializationUtilities.deserializePlan((InputStream)bais, MapWork.class);
        baos.close();
        ((InputStream)bais).close();
        return mapWorkDeserialized;
    }

    private Configuration getConfWithSkipConfig(String value) {
        Configuration configuration = new Configuration();
        HiveConf.setVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PLAN_MAPWORK_SERIALIZATION_SKIP_PROPERTIES, (String)value);
        return configuration;
    }

    private void assertPartitionDescPropertyPresence(MapWork mapWork, String partitionPath, String prop, boolean isPresent) {
        String value = ((PartitionDesc)mapWork.getPathToPartitionInfo().get(new Path(partitionPath))).getProperties().getProperty(prop);
        Assert.assertTrue((String)String.format("'%s' is%ssupposed to be present", prop, isPresent ? " " : " not "), (boolean)(isPresent ? value != null : value == null));
    }

    private static MapWork mockMapWorkWithSomePartitionDescProperties() throws Exception {
        String tableName = "test_table";
        int numPartitions = 2;
        Path root = new Path("/warehouse", "test_table");
        String[] partPath = new String[numPartitions];
        StringBuilder buffer = new StringBuilder();
        for (int p = 0; p < numPartitions; ++p) {
            partPath[p] = new Path(root, "p=" + p).toString();
            if (p != 0) {
                buffer.append(',');
            }
            buffer.append(partPath[p]);
        }
        Properties tblProps = new Properties();
        TableDesc tbl = new TableDesc(OrcInputFormat.class, OrcOutputFormat.class, tblProps);
        MapWork mapWork = new MapWork();
        LinkedHashMap aliasMap = new LinkedHashMap();
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(tableName);
        LinkedHashMap<Path, PartitionDesc> partMap = new LinkedHashMap<Path, PartitionDesc>();
        for (int p = 0; p < numPartitions; ++p) {
            Path path = new Path(partPath[p]);
            aliasMap.put(path, aliases);
            LinkedHashMap partSpec = new LinkedHashMap();
            PartitionDesc part = new PartitionDesc(tbl, partSpec);
            part.setVectorPartitionDesc(VectorPartitionDesc.createVectorizedInputFileFormat((String)"MockInputFileFormatClassName", (boolean)false, null));
            part.getProperties().put("impala_intermediate_stats_chunk1", "asdfghjk12345678");
            part.getProperties().put("impala_intermediate_stats_chunk2", "asdfghjk12345678");
            part.getProperties().put("rawDataSize", "10");
            part.getProperties().put("serialization.ddl", "asdf");
            partMap.put(path, part);
        }
        mapWork.setPathToAliases(aliasMap);
        mapWork.setPathToPartitionInfo(partMap);
        return mapWork;
    }
}

