/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.PartitionKeySampler;
import org.junit.Assert;
import org.junit.Test;

public class TestPartitionKeySampler {
    private static final byte[] tmp100 = "100".getBytes();
    private static final byte[] tmp200 = "200".getBytes();
    private static final byte[] tmp300 = "300".getBytes();
    private static final byte[] tmp400 = "400".getBytes();

    @Test
    public void test() throws Throwable {
        byte[][] sampled = new byte[][]{tmp100, tmp100, tmp100, tmp100, tmp100, tmp100, tmp100, tmp100, tmp100, tmp100};
        this.assertKeys(sampled, new byte[][]{tmp100});
        sampled = new byte[][]{tmp100, tmp100, tmp100, tmp100, tmp100, tmp100, tmp100, tmp100, tmp200, tmp200};
        this.assertKeys(sampled, tmp100, tmp200);
        sampled = new byte[][]{tmp100, tmp100, tmp100, tmp100, tmp200, tmp200, tmp200, tmp300, tmp300, tmp300};
        this.assertKeys(sampled, tmp100, tmp200, tmp300);
        sampled = new byte[][]{tmp100, tmp200, tmp200, tmp200, tmp200, tmp200, tmp200, tmp300, tmp300, tmp400};
        this.assertKeys(sampled, tmp200, tmp300, tmp400);
        sampled = new byte[][]{tmp100, tmp200, tmp300, tmp400, tmp400, tmp400, tmp400, tmp400, tmp400, tmp400};
        this.assertKeys(sampled, new byte[][]{tmp400});
    }

    private void assertKeys(byte[][] sampled, byte[] ... expected) {
        byte[][] keys = PartitionKeySampler.toPartitionKeys((byte[][])sampled, (int)4);
        Assert.assertEquals((long)expected.length, (long)keys.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((boolean)Arrays.equals(expected[i], keys[i]));
        }
    }
}

