/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.plan.CommonMergeJoinDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestOperatorUtils {
    TestOperatorUtils() {
    }

    @Test
    void testHasMoreGBYsReturnsFalseWhenLimitIs0() {
        CompilationOpContext context = new CompilationOpContext();
        Operator filter = OperatorFactory.get((CompilationOpContext)context, FilterDesc.class);
        Operator limit = OperatorFactory.get((CompilationOpContext)context, LimitDesc.class);
        filter.setParentOperators(Collections.singletonList(limit));
        Operator select = OperatorFactory.get((CompilationOpContext)context, SelectDesc.class);
        limit.setParentOperators(Collections.singletonList(select));
        Operator rs = OperatorFactory.get((CompilationOpContext)context, ReduceSinkDesc.class);
        select.setParentOperators(Collections.singletonList(rs));
        Assertions.assertFalse((boolean)OperatorUtils.hasMoreOperatorsThan((Operator)filter, GroupByOperator.class, (int)0));
    }

    @Test
    void testHasMoreGBYsReturnsFalseWhenNoGBYInBranchAndLimitIsMoreThan0() {
        CompilationOpContext context = new CompilationOpContext();
        Operator filter = OperatorFactory.get((CompilationOpContext)context, FilterDesc.class);
        Operator limit = OperatorFactory.get((CompilationOpContext)context, LimitDesc.class);
        filter.setParentOperators(Collections.singletonList(limit));
        Operator select = OperatorFactory.get((CompilationOpContext)context, SelectDesc.class);
        limit.setParentOperators(Collections.singletonList(select));
        Operator rs = OperatorFactory.get((CompilationOpContext)context, ReduceSinkDesc.class);
        select.setParentOperators(Collections.singletonList(rs));
        Assertions.assertFalse((boolean)OperatorUtils.hasMoreOperatorsThan((Operator)filter, GroupByOperator.class, (int)1));
    }

    @Test
    void testHasMoreGBYsReturnsFalseWhenNumberOfGBYIsLessThanLimit() {
        CompilationOpContext context = new CompilationOpContext();
        Operator filter = OperatorFactory.get((CompilationOpContext)context, FilterDesc.class);
        Operator limit = OperatorFactory.get((CompilationOpContext)context, LimitDesc.class);
        filter.setParentOperators(Collections.singletonList(limit));
        Operator select = OperatorFactory.get((CompilationOpContext)context, SelectDesc.class);
        limit.setParentOperators(Collections.singletonList(select));
        Operator gby = OperatorFactory.get((CompilationOpContext)context, GroupByDesc.class);
        select.setParentOperators(Collections.singletonList(gby));
        Operator rs = OperatorFactory.get((CompilationOpContext)context, ReduceSinkDesc.class);
        gby.setParentOperators(Collections.singletonList(rs));
        Assertions.assertFalse((boolean)OperatorUtils.hasMoreOperatorsThan((Operator)filter, GroupByOperator.class, (int)1));
    }

    @Test
    void testHasMoreGBYsReturnsTrueWhenNumberOfGBYIsEqualsWithLimit() {
        CompilationOpContext context = new CompilationOpContext();
        Operator gby1 = OperatorFactory.get((CompilationOpContext)context, GroupByDesc.class);
        Operator select = OperatorFactory.get((CompilationOpContext)context, SelectDesc.class);
        gby1.setParentOperators(Collections.singletonList(select));
        Operator filter = OperatorFactory.get((CompilationOpContext)context, FilterDesc.class);
        select.setParentOperators(Collections.singletonList(filter));
        Operator gby2 = OperatorFactory.get((CompilationOpContext)context, GroupByDesc.class);
        filter.setParentOperators(Collections.singletonList(gby2));
        Operator rs = OperatorFactory.get((CompilationOpContext)context, ReduceSinkDesc.class);
        gby2.setParentOperators(Collections.singletonList(rs));
        Assertions.assertTrue((boolean)OperatorUtils.hasMoreOperatorsThan((Operator)gby1, GroupByOperator.class, (int)1));
    }

    @Test
    void testHasMoreGBYsReturnsFalseWhenNumberOfGBYIsEqualsWithLimitButHasAnRSInTheMiddle() {
        CompilationOpContext context = new CompilationOpContext();
        Operator gby1 = OperatorFactory.get((CompilationOpContext)context, GroupByDesc.class);
        Operator select = OperatorFactory.get((CompilationOpContext)context, SelectDesc.class);
        gby1.setParentOperators(Collections.singletonList(select));
        Operator rs = OperatorFactory.get((CompilationOpContext)context, ReduceSinkDesc.class);
        select.setParentOperators(Collections.singletonList(rs));
        Operator gby2 = OperatorFactory.get((CompilationOpContext)context, GroupByDesc.class);
        rs.setParentOperators(Collections.singletonList(gby2));
        Operator ts = OperatorFactory.get((CompilationOpContext)context, TableScanDesc.class);
        gby2.setParentOperators(Collections.singletonList(ts));
        Assertions.assertFalse((boolean)OperatorUtils.hasMoreOperatorsThan((Operator)gby1, GroupByOperator.class, (int)1));
    }

    @Test
    void testHasMoreGBYsReturnsTrueWhenBranchHasJoinAndNumberOfGBYIsEqualsWithLimit() {
        CompilationOpContext context = new CompilationOpContext();
        Operator gby1 = OperatorFactory.get((CompilationOpContext)context, GroupByDesc.class);
        Operator join = OperatorFactory.get((CompilationOpContext)context, CommonMergeJoinDesc.class);
        gby1.setParentOperators(Collections.singletonList(join));
        Operator filter = OperatorFactory.get((CompilationOpContext)context, FilterDesc.class);
        Operator gby2 = OperatorFactory.get((CompilationOpContext)context, GroupByDesc.class);
        filter.setParentOperators(Collections.singletonList(gby2));
        Operator rs = OperatorFactory.get((CompilationOpContext)context, ReduceSinkDesc.class);
        gby2.setParentOperators(Collections.singletonList(rs));
        Operator select = OperatorFactory.get((CompilationOpContext)context, SelectDesc.class);
        Operator rs2 = OperatorFactory.get((CompilationOpContext)context, ReduceSinkDesc.class);
        select.setParentOperators(Collections.singletonList(rs2));
        join.setParentOperators(Arrays.asList(filter, select));
        Assertions.assertTrue((boolean)OperatorUtils.hasMoreOperatorsThan((Operator)gby1, GroupByOperator.class, (int)1));
    }

    @Test
    void testHasMoreGBYsReturnsFalseWhenBranchHasJoinAndBothJoinBranchesHasLessGBYThanLimit() {
        CompilationOpContext context = new CompilationOpContext();
        Operator join = OperatorFactory.get((CompilationOpContext)context, CommonMergeJoinDesc.class);
        Operator filter = OperatorFactory.get((CompilationOpContext)context, FilterDesc.class);
        Operator gby1 = OperatorFactory.get((CompilationOpContext)context, GroupByDesc.class);
        filter.setParentOperators(Collections.singletonList(gby1));
        Operator rs = OperatorFactory.get((CompilationOpContext)context, ReduceSinkDesc.class);
        gby1.setParentOperators(Collections.singletonList(rs));
        Operator select = OperatorFactory.get((CompilationOpContext)context, SelectDesc.class);
        Operator gby2 = OperatorFactory.get((CompilationOpContext)context, GroupByDesc.class);
        select.setParentOperators(Collections.singletonList(gby2));
        Operator rs2 = OperatorFactory.get((CompilationOpContext)context, ReduceSinkDesc.class);
        gby2.setParentOperators(Collections.singletonList(rs2));
        join.setParentOperators(Arrays.asList(filter, select));
        Assertions.assertFalse((boolean)OperatorUtils.hasMoreOperatorsThan((Operator)join, GroupByOperator.class, (int)1));
    }
}

