/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.tez.ObjectCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.common.objectregistry.ObjectRegistryImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestLimitOperator {
    private static final Object fakeObjectToPass = new Object();
    private Random random = new Random(TestLimitOperator.class.toString().hashCode());

    @Test
    public void testGlobalLimitReached() throws HiveException {
        this.testGlobalLimitReachedInDaemonOrContainer(true, 0, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(false, 0, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(true, 1, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(false, 1, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(true, 2, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(false, 2, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(true, 3, 2);
        this.testGlobalLimitReachedInDaemonOrContainer(false, 3, 2);
    }

    private void testGlobalLimitReachedInDaemonOrContainer(boolean isDaemon, int offset, int limit) throws HiveException {
        int numProcessedElements = 0;
        LlapProxy.setDaemon((boolean)isDaemon);
        if (!isDaemon) {
            ObjectCache.setupObjectRegistry((ObjectRegistry)new ObjectRegistryImpl());
        }
        HiveConf conf = new HiveConf();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID, (String)("query-" + this.random.nextInt(10000)));
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, (String)"tez");
        conf.set("hive.tez.vertex.name", "Map 1");
        LimitOperator lo1 = new LimitOperator(new CompilationOpContext());
        lo1.setConf((OperatorDesc)new LimitDesc(offset, limit));
        lo1.initialize((Configuration)conf, null);
        lo1.initializeOp((Configuration)conf);
        LimitOperator lo2 = new LimitOperator(new CompilationOpContext());
        lo2.setConf((OperatorDesc)new LimitDesc(offset, limit));
        lo2.initialize((Configuration)conf, null);
        lo2.initializeOp((Configuration)conf);
        Assert.assertEquals((long)0L, (long)lo1.currCount);
        Assert.assertEquals((long)0L, (long)lo2.currCount);
        Assert.assertEquals((Object)"LIM_0", (Object)lo1.getOperatorId());
        Assert.assertEquals((Object)"LIM_0", (Object)lo2.getOperatorId());
        this.processRowNTimes(lo1, 2);
        Assert.assertEquals((Object)((numProcessedElements += 2) > limit + offset ? 1 : 0), (Object)lo1.getDone());
        Assert.assertEquals((long)Math.min(numProcessedElements, limit + offset), (long)lo1.getCurrentCount().get());
        Assert.assertEquals((long)lo1.getCurrentCount().get(), (long)lo1.currCount);
        this.processRowNTimes(lo1, 1);
        Assert.assertEquals((Object)(++numProcessedElements > limit + offset ? 1 : 0), (Object)lo1.getDone());
        Assert.assertEquals((long)Math.min(numProcessedElements, limit + offset), (long)lo1.getCurrentCount().get());
        Assert.assertEquals((long)lo1.getCurrentCount().get(), (long)lo1.currCount);
        this.processRowNTimes(lo1, 1);
        Assert.assertEquals((Object)(++numProcessedElements > limit + offset ? 1 : 0), (Object)lo1.getDone());
        Assert.assertEquals((long)Math.min(numProcessedElements, limit + offset), (long)lo1.getCurrentCount().get());
        Assert.assertEquals((long)lo1.getCurrentCount().get(), (long)lo1.currCount);
        Assert.assertEquals((long)Math.min(numProcessedElements, limit + offset), (long)lo2.getCurrentCount().get());
        Assert.assertEquals((long)0L, (long)lo2.currCount);
        Assert.assertEquals((Object)false, (Object)lo2.getDone());
        this.processRowNTimes(lo2, 1);
        boolean lo2DoneExpected = numProcessedElements > limit + offset + 1;
        Assert.assertEquals((Object)lo2DoneExpected, (Object)lo2.getDone());
        int lo2Count = lo2.currCount;
        Assert.assertEquals((long)(lo2DoneExpected ? 0L : 1L), (long)lo2.currCount);
        this.processRowNTimes(lo2, 1);
        if (!lo2DoneExpected) {
            ++numProcessedElements;
            if (lo2.getDone()) {
                Assert.assertEquals((long)lo2Count, (long)lo2.currCount);
            } else {
                Assert.assertEquals((long)(lo2Count + 1), (long)lo2.currCount);
            }
        } else {
            Assert.assertEquals((long)lo2Count, (long)lo2.currCount);
        }
        lo2DoneExpected = numProcessedElements > limit + offset + 1;
        Assert.assertEquals((Object)lo2DoneExpected, (Object)lo2.getDone());
    }

    private void processRowNTimes(LimitOperator op, int n) throws HiveException {
        for (int i = 0; i < n; ++i) {
            op.process(fakeObjectToPass, 0);
        }
    }
}

