/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.GetPartitionsFilterSpec;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetastoreException;
import org.apache.hadoop.hive.ql.exec.PartitionUtil;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestGetPartitionsWithSpecsInBatches {
    private final String catName = "hive";
    private final String dbName = "default";
    private final String tableName = "test_partition_batch";
    private static HiveConf hiveConf;
    private static HiveMetaStoreClient msc;
    private static Hive hive;
    private org.apache.hadoop.hive.metastore.api.Table table;
    private static final int NUM_PARTITIONS = 30;

    @BeforeClass
    public static void setupClass() throws HiveException {
        hiveConf = new HiveConfForTest(TestGetPartitionsWithSpecsInBatches.class);
        hiveConf.set("hive.security.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider");
        SessionState ss = SessionState.start((HiveConf)hiveConf);
        hive = ss.getHiveDb();
        try {
            msc = new HiveMetaStoreClient((Configuration)hiveConf);
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)e);
        }
    }

    @Before
    public void before() throws Exception {
        PartitionUtil.createPartitionedTable((IMetaStoreClient)msc, "hive", "default", "test_partition_batch");
        this.table = msc.getTable("hive", "default", "test_partition_batch");
        PartitionUtil.addPartitions((IMetaStoreClient)msc, "default", "test_partition_batch", this.table.getSd().getLocation(), hiveConf, 30);
    }

    @After
    public void after() {
        PartitionUtil.cleanUpTableQuietly((IMetaStoreClient)msc, "hive", "default", "test_partition_batch");
    }

    @Test
    public void testNumberOfGetPartitionCalls() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        hive.getAllPartitionsWithSpecsInBatches(hive.getTable("default", "test_partition_batch"), 10, 2, 0, new GetPartitionsRequest("default", "test_partition_batch", new GetProjectionsSpec(), new GetPartitionsFilterSpec()));
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)3))).getPartitionsWithSpecs((GetPartitionsRequest)req.capture());
        Assert.assertEquals((long)10L, (long)((GetPartitionsRequest)req.getValue()).getFilterSpec().getFiltersSize());
    }

    @Test
    public void testUnevenNumberOfGetPartitionCalls() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        ArrayList capturedRequests = new ArrayList();
        ((HiveMetaStoreClient)Mockito.doAnswer(invocation -> {
            GetPartitionsRequest request = (GetPartitionsRequest)invocation.getArgument(0);
            capturedRequests.add(new GetPartitionsRequest(request));
            return (GetPartitionsResponse)invocation.callRealMethod();
        }).when((Object)spyMSC)).getPartitionsWithSpecs((GetPartitionsRequest)Mockito.any(GetPartitionsRequest.class));
        hive.getAllPartitionsWithSpecsInBatches(hive.getTable("default", "test_partition_batch"), 19, 2, 0, new GetPartitionsRequest("default", "test_partition_batch", new GetProjectionsSpec(), new GetPartitionsFilterSpec()));
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)2))).getPartitionsWithSpecs((GetPartitionsRequest)req.capture());
        Assert.assertEquals((long)19L, (long)((GetPartitionsRequest)capturedRequests.get(0)).getFilterSpec().getFiltersSize());
        Assert.assertEquals((long)11L, (long)((GetPartitionsRequest)capturedRequests.get(1)).getFilterSpec().getFiltersSize());
    }

    @Test
    public void testSmallNumberOfPartitions() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        hive.getAllPartitionsWithSpecsInBatches(hive.getTable("default", "test_partition_batch"), 100, 2, 0, new GetPartitionsRequest("default", "test_partition_batch", new GetProjectionsSpec(), new GetPartitionsFilterSpec()));
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)1))).getPartitionsWithSpecs((GetPartitionsRequest)req.capture());
        Assert.assertEquals((long)30L, (long)((GetPartitionsRequest)req.getValue()).getFilterSpec().getFiltersSize());
    }

    @Test
    public void testRetriesExhaustedBatchSize() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        ArrayList capturedRequests = new ArrayList();
        ((HiveMetaStoreClient)Mockito.doAnswer(invocation -> {
            GetPartitionsRequest request = (GetPartitionsRequest)invocation.getArgument(0);
            capturedRequests.add(new GetPartitionsRequest(request));
            throw new MetaException("MetaException to test retries");
        }).when((Object)spyMSC)).getPartitionsWithSpecs((GetPartitionsRequest)Mockito.any(GetPartitionsRequest.class));
        try {
            hive.getAllPartitionsWithSpecsInBatches(hive.getTable("default", "test_partition_batch"), 30, 2, 0, new GetPartitionsRequest("default", "test_partition_batch", new GetProjectionsSpec(), new GetPartitionsFilterSpec()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)5))).getPartitionsWithSpecs((GetPartitionsRequest)req.capture());
        Assert.assertEquals((long)5L, (long)capturedRequests.size());
        Assert.assertEquals((long)30L, (long)((GetPartitionsRequest)capturedRequests.get(0)).getFilterSpec().getFiltersSize());
        Assert.assertEquals((long)15L, (long)((GetPartitionsRequest)capturedRequests.get(1)).getFilterSpec().getFiltersSize());
        Assert.assertEquals((long)7L, (long)((GetPartitionsRequest)capturedRequests.get(2)).getFilterSpec().getFiltersSize());
        Assert.assertEquals((long)3L, (long)((GetPartitionsRequest)capturedRequests.get(3)).getFilterSpec().getFiltersSize());
        Assert.assertEquals((long)1L, (long)((GetPartitionsRequest)capturedRequests.get(4)).getFilterSpec().getFiltersSize());
    }

    @Test
    public void testMaxRetriesReached() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        ArrayList capturedRequests = new ArrayList();
        ((HiveMetaStoreClient)Mockito.doAnswer(invocation -> {
            GetPartitionsRequest request = (GetPartitionsRequest)invocation.getArgument(0);
            capturedRequests.add(new GetPartitionsRequest(request));
            throw new MetaException("MetaException to test retries");
        }).when((Object)spyMSC)).getPartitionsWithSpecs((GetPartitionsRequest)Mockito.any(GetPartitionsRequest.class));
        try {
            hive.getAllPartitionsWithSpecsInBatches(hive.getTable("default", "test_partition_batch"), 30, 2, 2, new GetPartitionsRequest("default", "test_partition_batch", new GetProjectionsSpec(), new GetPartitionsFilterSpec()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)2))).getPartitionsWithSpecs((GetPartitionsRequest)req.capture());
        Assert.assertEquals((long)2L, (long)capturedRequests.size());
        Assert.assertEquals((long)30L, (long)((GetPartitionsRequest)capturedRequests.get(0)).getFilterSpec().getFiltersSize());
        Assert.assertEquals((long)15L, (long)((GetPartitionsRequest)capturedRequests.get(1)).getFilterSpec().getFiltersSize());
    }

    @Test
    public void testBatchingWhenException() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        ArrayList capturedRequests = new ArrayList();
        AtomicInteger invocationCount = new AtomicInteger();
        ((HiveMetaStoreClient)Mockito.doAnswer(invocation -> {
            invocationCount.getAndIncrement();
            GetPartitionsRequest request = (GetPartitionsRequest)invocation.getArgument(0);
            capturedRequests.add(new GetPartitionsRequest(request));
            if (invocationCount.get() == 1) {
                throw new MetaException();
            }
            return (GetPartitionsResponse)invocation.callRealMethod();
        }).when((Object)spyMSC)).getPartitionsWithSpecs((GetPartitionsRequest)Mockito.any(GetPartitionsRequest.class));
        hive.getAllPartitionsWithSpecsInBatches(hive.getTable("default", "test_partition_batch"), 30, 2, 5, new GetPartitionsRequest("default", "test_partition_batch", new GetProjectionsSpec(), new GetPartitionsFilterSpec()));
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)3))).getPartitionsWithSpecs((GetPartitionsRequest)req.capture());
        Assert.assertEquals((long)3L, (long)capturedRequests.size());
        Assert.assertEquals((long)30L, (long)((GetPartitionsRequest)capturedRequests.get(0)).getFilterSpec().getFiltersSize());
        Assert.assertEquals((long)15L, (long)((GetPartitionsRequest)capturedRequests.get(1)).getFilterSpec().getFiltersSize());
        Assert.assertEquals((long)15L, (long)((GetPartitionsRequest)capturedRequests.get(2)).getFilterSpec().getFiltersSize());
        HashSet partNames = new HashSet(((GetPartitionsRequest)capturedRequests.get(1)).getFilterSpec().getFilters());
        partNames.addAll(((GetPartitionsRequest)capturedRequests.get(2)).getFilterSpec().getFilters());
        assert (partNames.size() == 30);
        List partitionNames = hive.getPartitionNames(this.table.getDbName(), this.table.getTableName(), (short)-1);
        assert (partitionNames.size() == 30);
        partitionNames.forEach(partNames::remove);
        assert (partitionNames.size() == 30);
        assert (partNames.size() == 0);
    }

    @Test
    public void testBatchingWhenBatchSizeIsZero() throws MetaException {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        int batchSize = 0;
        try {
            Table t = hive.getTable("default", "test_partition_batch");
            new PartitionIterable(hive, new GetPartitionsRequest(t.getDbName(), t.getTableName(), new GetProjectionsSpec(), new GetPartitionsFilterSpec()), batchSize);
        }
        catch (HiveException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid batch size for partition iterable. Please use a batch size greater than 0"));
        }
        try {
            new org.apache.hadoop.hive.metastore.PartitionIterable((IMetaStoreClient)msc, this.table, batchSize).withProjectSpec(new GetPartitionsRequest("default", "test_partition_batch", new GetProjectionsSpec(), new GetPartitionsFilterSpec()));
        }
        catch (MetastoreException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid batch size for partition iterable. Please use a batch size greater than 0"));
        }
    }
}

