/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetastoreException;
import org.apache.hadoop.hive.ql.exec.PartitionUtil;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestGetPartitionInBatches {
    private final String catName = "hive";
    private final String dbName = "default";
    private final String tableName = "test_partition_batch";
    private static HiveConf hiveConf;
    private static HiveMetaStoreClient msc;
    private static Hive hive;
    private org.apache.hadoop.hive.metastore.api.Table table;
    private static final int NUM_PARTITIONS = 30;
    private static final boolean IS_AUTH_REQUIRED = false;
    private static final Map<String, String> PARTIAL_PARTITION_SPEC;

    @BeforeClass
    public static void setupClass() throws HiveException {
        hiveConf = new HiveConfForTest(TestGetPartitionInBatches.class);
        hiveConf.set("hive.security.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider");
        SessionState ss = SessionState.start((HiveConf)hiveConf);
        hive = ss.getHiveDb();
        try {
            msc = new HiveMetaStoreClient((Configuration)hiveConf);
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)e);
        }
    }

    @Before
    public void before() throws Exception {
        PartitionUtil.createPartitionedTable((IMetaStoreClient)msc, "hive", "default", "test_partition_batch");
        this.table = msc.getTable("hive", "default", "test_partition_batch");
        PartitionUtil.addPartitions((IMetaStoreClient)msc, "default", "test_partition_batch", this.table.getSd().getLocation(), hiveConf, 30);
    }

    @After
    public void after() throws Exception {
        PartitionUtil.cleanUpTableQuietly((IMetaStoreClient)msc, "hive", "default", "test_partition_batch");
    }

    @Test
    public void testNumberOfPartitionsRetrieved() throws HiveException {
        List numParts = hive.getPartitionNames("default", "test_partition_batch", (short)-1);
        Assert.assertEquals((long)numParts.size(), (long)30L);
        List partitions = hive.getPartitionsByNames(new Table(this.table), numParts.subList(0, 5), false);
        Assert.assertEquals((long)partitions.size(), (long)5L);
    }

    @Test
    public void testGetAllPartitionsOf() throws Exception {
        Set part = hive.getAllPartitionsOf(hive.getTable("default", "test_partition_batch"));
        Assert.assertEquals((long)part.size(), (long)30L);
    }

    @Test
    public void testNumberOfGetPartitionCalls() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch"), 10, 2, 0, PARTIAL_PARTITION_SPEC, false);
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsByNamesRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)3))).getPartitionsByNames((GetPartitionsByNamesRequest)req.capture());
        Assert.assertEquals((long)10L, (long)((GetPartitionsByNamesRequest)req.getValue()).getNames().size());
    }

    @Test
    public void testUnevenNumberOfGetPartitionCalls() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch"), 19, 2, 0, PARTIAL_PARTITION_SPEC, false);
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsByNamesRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)2))).getPartitionsByNames((GetPartitionsByNamesRequest)req.capture());
        List apds = req.getAllValues();
        Assert.assertEquals((long)19L, (long)((GetPartitionsByNamesRequest)apds.get(0)).getNames().size());
        Assert.assertEquals((long)11L, (long)((GetPartitionsByNamesRequest)apds.get(1)).getNames().size());
    }

    @Test
    public void testSmallNumberOfPartitions() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch"), 100, 2, 0, PARTIAL_PARTITION_SPEC, false);
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsByNamesRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)1))).getPartitionsByNames((GetPartitionsByNamesRequest)req.capture());
        Assert.assertEquals((long)30L, (long)((GetPartitionsByNamesRequest)req.getValue()).getNames().size());
    }

    @Test
    public void testRetriesExhaustedBatchSize() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        ((HiveMetaStoreClient)Mockito.doThrow(MetaException.class).when((Object)spyMSC)).getPartitionsByNames((GetPartitionsByNamesRequest)ArgumentMatchers.any());
        try {
            hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch"), 30, 2, 0, PARTIAL_PARTITION_SPEC, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsByNamesRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)5))).getPartitionsByNames((GetPartitionsByNamesRequest)req.capture());
        List apds = req.getAllValues();
        Assert.assertEquals((long)5L, (long)apds.size());
        Assert.assertEquals((long)30L, (long)((GetPartitionsByNamesRequest)apds.get(0)).getNames().size());
        Assert.assertEquals((long)15L, (long)((GetPartitionsByNamesRequest)apds.get(1)).getNames().size());
        Assert.assertEquals((long)7L, (long)((GetPartitionsByNamesRequest)apds.get(2)).getNames().size());
        Assert.assertEquals((long)3L, (long)((GetPartitionsByNamesRequest)apds.get(3)).getNames().size());
        Assert.assertEquals((long)1L, (long)((GetPartitionsByNamesRequest)apds.get(4)).getNames().size());
    }

    @Test
    public void testMaxRetriesReached() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        ((HiveMetaStoreClient)Mockito.doThrow(MetaException.class).when((Object)spyMSC)).getPartitionsByNames((GetPartitionsByNamesRequest)ArgumentMatchers.any());
        try {
            hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch"), 30, 2, 2, PARTIAL_PARTITION_SPEC, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsByNamesRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)2))).getPartitionsByNames((GetPartitionsByNamesRequest)req.capture());
        List apds = req.getAllValues();
        Assert.assertEquals((long)2L, (long)apds.size());
        Assert.assertEquals((long)30L, (long)((GetPartitionsByNamesRequest)apds.get(0)).getNames().size());
        Assert.assertEquals((long)15L, (long)((GetPartitionsByNamesRequest)apds.get(1)).getNames().size());
    }

    @Test
    public void testBatchingWhenException() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        ((HiveMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new MetaException()}).doCallRealMethod().when((Object)spyMSC)).getPartitionsByNames((GetPartitionsByNamesRequest)ArgumentMatchers.any());
        hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch"), 30, 2, 5, PARTIAL_PARTITION_SPEC, false);
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsByNamesRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)3))).getPartitionsByNames((GetPartitionsByNamesRequest)req.capture());
        List apds = req.getAllValues();
        Assert.assertEquals((long)3L, (long)apds.size());
        Assert.assertEquals((long)30L, (long)((GetPartitionsByNamesRequest)apds.get(0)).getNames().size());
        Assert.assertEquals((long)15L, (long)((GetPartitionsByNamesRequest)apds.get(1)).getNames().size());
        Assert.assertEquals((long)15L, (long)((GetPartitionsByNamesRequest)apds.get(2)).getNames().size());
        HashSet partNames = new HashSet(((GetPartitionsByNamesRequest)apds.get(1)).getNames());
        partNames.addAll(((GetPartitionsByNamesRequest)apds.get(2)).getNames());
        assert (partNames.size() == 30);
        List partitionNames = hive.getPartitionNames(this.table.getDbName(), this.table.getTableName(), (short)-1);
        assert (partitionNames.size() == 30);
        partitionNames.forEach(partNames::remove);
        assert (partitionNames.size() == 30);
        assert (partNames.size() == 0);
    }

    @Test
    public void testBatchingWhenBatchSizeIsZero() throws MetaException {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        int batchSize = 0;
        try {
            new PartitionIterable(hive, hive.getTable("default", "test_partition_batch"), null, batchSize);
        }
        catch (HiveException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid batch size for partition iterable. Please use a batch size greater than 0"));
        }
        try {
            new org.apache.hadoop.hive.metastore.PartitionIterable((IMetaStoreClient)msc, this.table, batchSize);
        }
        catch (MetastoreException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid batch size for partition iterable. Please use a batch size greater than 0"));
        }
    }

    static {
        PARTIAL_PARTITION_SPEC = null;
    }
}

