/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.PartitionUtil;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestGetPartitionAuthWithBatches {
    private final String catName = "hive";
    private final String dbName = "default";
    private final String tableName = "test_partition_batch_with_auth";
    private static HiveConf hiveConf;
    private static HiveMetaStoreClient msc;
    private static Hive hive;
    private org.apache.hadoop.hive.metastore.api.Table table;
    private static final int NUM_PARTITIONS = 30;
    private static final int DECAYING_FACTOR = 2;
    private static final int MAX_RETRIES = 0;
    private static final boolean IS_AUTH_REQUIRED = true;
    private static final String USER_NAME = "username";
    private static final List<String> GROUP_NAMES;
    private static final Map<String, String> PARTIAL_PARTITION_SPEC;

    @BeforeClass
    public static void setupClass() throws HiveException {
        hiveConf = new HiveConfForTest(TestGetPartitionAuthWithBatches.class);
        hiveConf.set("hive.security.authorization.enabled", "true");
        hiveConf.set("hive.security.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider");
        hive = Hive.get();
        SessionState.start((HiveConf)hiveConf);
        try {
            msc = new HiveMetaStoreClient((Configuration)hiveConf);
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)e);
        }
    }

    @Before
    public void before() throws Exception {
        PartitionUtil.createPartitionedTable((IMetaStoreClient)msc, "hive", "default", "test_partition_batch_with_auth");
        this.table = msc.getTable("hive", "default", "test_partition_batch_with_auth");
        PartitionUtil.addPartitions((IMetaStoreClient)msc, "default", "test_partition_batch_with_auth", this.table.getSd().getLocation(), hiveConf, 30);
    }

    @After
    public void after() throws Exception {
        PartitionUtil.cleanUpTableQuietly((IMetaStoreClient)msc, "hive", "default", "test_partition_batch_with_auth");
    }

    @Test
    public void testNumberOfPartitionsRetrieved() throws HiveException {
        List numParts = hive.getPartitionNames("default", "test_partition_batch_with_auth", (short)-1);
        Assert.assertEquals((long)numParts.size(), (long)30L);
        List partitions = hive.getPartitionsAuthByNames(new Table(this.table), numParts.subList(0, 5), USER_NAME, GROUP_NAMES);
        Assert.assertEquals((long)partitions.size(), (long)5L);
    }

    @Test
    public void testGetPartitionsAPI() throws Exception {
        List part = hive.getPartitions(hive.getTable("default", "test_partition_batch_with_auth"));
        Assert.assertEquals((long)part.size(), (long)30L);
    }

    @Test
    public void testGetPartitionsAPI2() throws Exception {
        List part = hive.getPartitions(hive.getTable("default", "test_partition_batch_with_auth"), new HashMap(), (short)-1);
        Assert.assertEquals((long)part.size(), (long)30L);
    }

    @Test
    public void testGetPartitionsAPI2limit() throws Exception {
        List part = hive.getPartitions(hive.getTable("default", "test_partition_batch_with_auth"), new HashMap(), (short)1);
        Assert.assertEquals((long)part.size(), (long)1L);
        List part1 = hive.getPartitions(hive.getTable("default", "test_partition_batch_with_auth"), new HashMap(), (short)10);
        Assert.assertEquals((long)part1.size(), (long)10L);
    }

    @Test
    public void testNumberOfGetPartitionCalls() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        int batchSize = 10;
        hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch_with_auth"), batchSize, 2, 0, PARTIAL_PARTITION_SPEC, true, USER_NAME, GROUP_NAMES);
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsPsWithAuthRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)3))).listPartitionsWithAuthInfoRequest((GetPartitionsPsWithAuthRequest)req.capture());
        req.getAllValues().forEach(part -> Assert.assertEquals((long)part.getPartNames().size(), (long)10L));
    }

    @Test
    public void testNumberOfGetPartitionCalls2() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        int batchSize = 10;
        hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch_with_auth"), batchSize, 2, 0, new HashMap(), true, USER_NAME, GROUP_NAMES);
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsPsWithAuthRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)3))).listPartitionsWithAuthInfoRequest((GetPartitionsPsWithAuthRequest)req.capture());
        req.getAllValues().forEach(part -> Assert.assertEquals((long)part.getPartNames().size(), (long)10L));
    }

    @Test
    public void testUnevenNumberOfGetPartitionCalls() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        int batchSize = 19;
        hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch_with_auth"), batchSize, 2, 0, PARTIAL_PARTITION_SPEC, true, USER_NAME, GROUP_NAMES);
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsPsWithAuthRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)2))).listPartitionsWithAuthInfoRequest((GetPartitionsPsWithAuthRequest)req.capture());
        List apds = req.getAllValues();
        Assert.assertEquals((long)19L, (long)((GetPartitionsPsWithAuthRequest)apds.get(0)).getPartNames().size());
        Assert.assertEquals((long)11L, (long)((GetPartitionsPsWithAuthRequest)apds.get(1)).getPartNames().size());
    }

    @Test
    public void testSmallNumberOfPartitions() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        int batchSize = 100;
        hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch_with_auth"), batchSize, 2, 0, PARTIAL_PARTITION_SPEC, true, USER_NAME, GROUP_NAMES);
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsPsWithAuthRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)1))).listPartitionsWithAuthInfoRequest((GetPartitionsPsWithAuthRequest)req.capture());
        Assert.assertEquals((long)30L, (long)((GetPartitionsPsWithAuthRequest)req.getValue()).getPartNames().size());
    }

    @Test
    public void testRetriesExhaustedBatchSize() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        ((HiveMetaStoreClient)Mockito.doThrow(MetaException.class).when((Object)spyMSC)).listPartitionsWithAuthInfoRequest((GetPartitionsPsWithAuthRequest)ArgumentMatchers.any());
        try {
            hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch_with_auth"), 30, 2, 0, PARTIAL_PARTITION_SPEC, true, USER_NAME, GROUP_NAMES);
        }
        catch (HiveException hiveException) {
            // empty catch block
        }
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsPsWithAuthRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)5))).listPartitionsWithAuthInfoRequest((GetPartitionsPsWithAuthRequest)req.capture());
        List apds = req.getAllValues();
        Assert.assertEquals((long)5L, (long)apds.size());
        Assert.assertEquals((long)30L, (long)((GetPartitionsPsWithAuthRequest)apds.get(0)).getPartNamesSize());
        Assert.assertEquals((long)15L, (long)((GetPartitionsPsWithAuthRequest)apds.get(1)).getPartNamesSize());
        Assert.assertEquals((long)7L, (long)((GetPartitionsPsWithAuthRequest)apds.get(2)).getPartNamesSize());
        Assert.assertEquals((long)3L, (long)((GetPartitionsPsWithAuthRequest)apds.get(3)).getPartNamesSize());
        Assert.assertEquals((long)1L, (long)((GetPartitionsPsWithAuthRequest)apds.get(4)).getPartNamesSize());
    }

    @Test
    public void testMaxRetriesReached() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        ((HiveMetaStoreClient)Mockito.doThrow(MetaException.class).when((Object)spyMSC)).listPartitionsWithAuthInfoRequest((GetPartitionsPsWithAuthRequest)ArgumentMatchers.any());
        int maxRetries = 2;
        try {
            hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch_with_auth"), 30, 2, maxRetries, PARTIAL_PARTITION_SPEC, true, USER_NAME, GROUP_NAMES);
        }
        catch (HiveException hiveException) {
            // empty catch block
        }
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsPsWithAuthRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)2))).listPartitionsWithAuthInfoRequest((GetPartitionsPsWithAuthRequest)req.capture());
        List apds = req.getAllValues();
        Assert.assertEquals((long)2L, (long)apds.size());
        Assert.assertEquals((long)30L, (long)((GetPartitionsPsWithAuthRequest)apds.get(0)).getPartNamesSize());
        Assert.assertEquals((long)15L, (long)((GetPartitionsPsWithAuthRequest)apds.get(1)).getPartNamesSize());
    }

    @Test
    public void testBatchingWhenException() throws Exception {
        HiveMetaStoreClient spyMSC = (HiveMetaStoreClient)Mockito.spy((Object)msc);
        hive.setMSC((IMetaStoreClient)spyMSC);
        ((HiveMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new MetaException()}).doCallRealMethod().when((Object)spyMSC)).listPartitionsWithAuthInfoRequest((GetPartitionsPsWithAuthRequest)ArgumentMatchers.any());
        int maxRetries = 5;
        hive.getAllPartitionsInBatches(hive.getTable("default", "test_partition_batch_with_auth"), 30, 2, maxRetries, PARTIAL_PARTITION_SPEC, true, USER_NAME, GROUP_NAMES);
        ArgumentCaptor req = ArgumentCaptor.forClass(GetPartitionsPsWithAuthRequest.class);
        ((HiveMetaStoreClient)Mockito.verify((Object)spyMSC, (VerificationMode)Mockito.times((int)3))).listPartitionsWithAuthInfoRequest((GetPartitionsPsWithAuthRequest)req.capture());
        List apds = req.getAllValues();
        Assert.assertEquals((long)3L, (long)apds.size());
        Assert.assertEquals((long)30L, (long)((GetPartitionsPsWithAuthRequest)apds.get(0)).getPartNamesSize());
        Assert.assertEquals((long)15L, (long)((GetPartitionsPsWithAuthRequest)apds.get(1)).getPartNamesSize());
        Assert.assertEquals((long)15L, (long)((GetPartitionsPsWithAuthRequest)apds.get(2)).getPartNamesSize());
        HashSet partNames = new HashSet(((GetPartitionsPsWithAuthRequest)apds.get(1)).getPartNames());
        partNames.addAll(((GetPartitionsPsWithAuthRequest)apds.get(2)).getPartNames());
        assert (partNames.size() == 30);
        List partitionNames = hive.getPartitionNames(this.table.getDbName(), this.table.getTableName(), (short)-1);
        assert (partitionNames.size() == 30);
        partitionNames.forEach(partNames::remove);
        assert (partitionNames.size() == 30);
        assert (partNames.size() == 0);
    }

    static {
        GROUP_NAMES = Arrays.asList("Grp1", "Grp2");
        PARTIAL_PARTITION_SPEC = null;
    }
}

