/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.InputEstimatorTestClass;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.ContentSummaryInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InputEstimator;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestGetInputSummary {
    private static final String TEST_TABLE_NAME = "testTable";
    private static final Path TEST_TABLE_PATH = new Path("testTable");
    private JobConf jobConf;
    private Properties properties;

    @Before
    public void setup() throws Exception {
        SessionState.start((HiveConf)new HiveConfForTest(this.getClass()));
        this.jobConf = new JobConf();
        this.properties = new Properties();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.jobConf);
        fs.delete(TEST_TABLE_PATH, true);
        fs.mkdirs(TEST_TABLE_PATH);
    }

    @After
    public void teardown() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.jobConf);
        fs.delete(TEST_TABLE_PATH, true);
    }

    @Test
    public void testGetInputSummaryPoolWithCache() throws Exception {
        int BYTES_PER_FILE = 5;
        List<Path> testPaths = Arrays.asList(new Path("p1/test.txt"), new Path("p2/test.txt"), new Path("p3/test.txt"), new Path("p4/test.txt"), new Path("p5/test.txt"));
        ContentSummary cs = new ContentSummary.Builder().directoryCount(10L).fileCount(10L).length(10L).build();
        LinkedHashMap<Path, ContentSummary> cache = new LinkedHashMap<Path, ContentSummary>();
        cache.put(new Path("p2"), cs);
        this.jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        ContentSummary summary = this.runTestGetInputSummary(this.jobConf, this.properties, testPaths, 5, HiveInputFormat.class, cache);
        long expectedLength = (long)((testPaths.size() - 1) * 5) + 10L;
        long expectedFileCount = (long)(testPaths.size() - 1) + 10L;
        long expectedDirCount = (long)(testPaths.size() - 1) + 10L;
        Assert.assertEquals((long)expectedLength, (long)summary.getLength());
        Assert.assertEquals((long)expectedFileCount, (long)summary.getFileCount());
        Assert.assertEquals((long)expectedDirCount, (long)summary.getDirectoryCount());
    }

    @Test
    public void testGetInputSummaryPoolWithCacheReuse() throws Exception {
        int BYTES_PER_FILE = 5;
        List<Path> testPaths1 = Arrays.asList(new Path("p1/test.txt"), new Path("p2/test.txt"), new Path("p3/test.txt"));
        List<Path> testPaths2 = Arrays.asList(new Path("p4/test.txt"), new Path("p5/test.txt"));
        this.jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        ContentSummary summary = this.runTestGetInputSummary(this.jobConf, this.properties, testPaths1, 5, HiveInputFormat.class, Collections.emptyMap());
        Assert.assertEquals((long)(testPaths1.size() * 5), (long)summary.getLength());
        Assert.assertEquals((long)testPaths1.size(), (long)summary.getFileCount());
        Assert.assertEquals((long)testPaths1.size(), (long)summary.getDirectoryCount());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.jobConf);
        for (Path path : testPaths1) {
            fs.delete(path, true);
        }
        summary = this.runTestGetInputSummary(this.jobConf, this.properties, CollectionUtils.union(testPaths1, testPaths2), 5, new HashSet<Path>(testPaths1), HiveInputFormat.class, Collections.emptyMap());
        Assert.assertEquals((long)((testPaths1.size() + testPaths2.size()) * 5), (long)summary.getLength());
        Assert.assertEquals((long)(testPaths1.size() + testPaths2.size()), (long)summary.getFileCount());
        Assert.assertEquals((long)(testPaths1.size() + testPaths2.size()), (long)summary.getDirectoryCount());
    }

    @Test
    public void testGetInputSummaryWithMultipleThreads() throws IOException {
        int BYTES_PER_FILE = 5;
        List<Path> testPaths = Arrays.asList(new Path("p1/test.txt"), new Path("p2/test.txt"), new Path("p3/test.txt"), new Path("p4/test.txt"), new Path("p5/test.txt"));
        this.jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        ContentSummary summary = this.runTestGetInputSummary(this.jobConf, this.properties, testPaths, 5, HiveInputFormat.class, Collections.emptyMap());
        Assert.assertEquals((long)(testPaths.size() * 5), (long)summary.getLength());
        Assert.assertEquals((long)testPaths.size(), (long)summary.getFileCount());
        Assert.assertEquals((long)testPaths.size(), (long)summary.getDirectoryCount());
        this.jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        this.jobConf.setInt("mapred.dfsclient.parallelism.max", 2);
        summary = this.runTestGetInputSummary(this.jobConf, this.properties, testPaths, 5, HiveInputFormat.class, Collections.emptyMap());
        Assert.assertEquals((long)(testPaths.size() * 5), (long)summary.getLength());
        Assert.assertEquals((long)testPaths.size(), (long)summary.getFileCount());
        Assert.assertEquals((long)testPaths.size(), (long)summary.getDirectoryCount());
    }

    @Test
    public void testGetInputSummaryWithInputEstimator() throws IOException, HiveException {
        int BYTES_PER_FILE = 10;
        int NUM_OF_ROWS = 5;
        List<Path> testPaths = Arrays.asList(new Path("p1/test.txt"), new Path("p2/test.txt"), new Path("p3/test.txt"), new Path("p4/test.txt"), new Path("p5/test.txt"));
        this.jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        this.properties.setProperty("storage_handler", InputEstimatorTestClass.class.getName());
        InputEstimatorTestClass.setEstimation(new InputEstimator.Estimation(5, 10L));
        ContentSummary summary = this.runTestGetInputSummary(this.jobConf, this.properties, testPaths, 20, HiveInputFormat.class, Collections.emptyMap());
        Assert.assertEquals((long)(testPaths.size() * 10), (long)summary.getLength());
        Assert.assertEquals((long)(testPaths.size() * -1), (long)summary.getFileCount());
        Assert.assertEquals((long)(testPaths.size() * -1), (long)summary.getDirectoryCount());
        this.jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        this.jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        this.properties.setProperty("storage_handler", InputEstimatorTestClass.class.getName());
        InputEstimatorTestClass.setEstimation(new InputEstimator.Estimation(5, 10L));
        summary = this.runTestGetInputSummary(this.jobConf, this.properties, testPaths, 20, HiveInputFormat.class, Collections.emptyMap());
        Assert.assertEquals((long)(testPaths.size() * 10), (long)summary.getLength());
        Assert.assertEquals((long)(testPaths.size() * -1), (long)summary.getFileCount());
        Assert.assertEquals((long)(testPaths.size() * -1), (long)summary.getDirectoryCount());
    }

    @Test
    public void testGetInputSummaryWithASingleThread() throws IOException {
        int BYTES_PER_FILE = 5;
        this.jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        List<Path> testPaths = Arrays.asList(new Path("p1/test.txt"), new Path("p2/test.txt"), new Path("p3/test.txt"), new Path("p4/test.txt"), new Path("p5/test.txt"));
        ContentSummary summary = this.runTestGetInputSummary(this.jobConf, this.properties, testPaths, 5, HiveInputFormat.class, Collections.emptyMap());
        Assert.assertEquals((long)(testPaths.size() * 5), (long)summary.getLength());
        Assert.assertEquals((long)testPaths.size(), (long)summary.getFileCount());
        Assert.assertEquals((long)testPaths.size(), (long)summary.getDirectoryCount());
    }

    @Test
    public void testGetInputSummaryWithContentSummaryInputFormat() throws IOException {
        int BYTES_PER_FILE = 10;
        List<Path> testPaths = Arrays.asList(new Path("p1/test.txt"), new Path("p2/test.txt"), new Path("p3/test.txt"), new Path("p4/test.txt"), new Path("p5/test.txt"));
        this.jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        ContentSummaryInputFormatTestClass.setContentSummary(new ContentSummary.Builder().length(10L).fileCount(2L).directoryCount(1L).build());
        ContentSummary summary = this.runTestGetInputSummary(this.jobConf, this.properties, testPaths, 20, ContentSummaryInputFormatTestClass.class, Collections.emptyMap());
        Assert.assertEquals((long)(testPaths.size() * 10), (long)summary.getLength());
        Assert.assertEquals((long)(testPaths.size() * 2), (long)summary.getFileCount());
        Assert.assertEquals((long)testPaths.size(), (long)summary.getDirectoryCount());
    }

    @Test
    public void testGetInputSummaryPool() throws ExecutionException, InterruptedException, IOException {
        ExecutorService pool = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when(pool.submit((Runnable)ArgumentMatchers.any(Runnable.class))).thenReturn((Object)((Future)Mockito.mock(Future.class)));
        HashSet<Path> pathNeedProcess = new HashSet<Path>();
        pathNeedProcess.add(new Path("dummy-path1"));
        pathNeedProcess.add(new Path("dummy-path2"));
        pathNeedProcess.add(new Path("dummy-path3"));
        Context context = new Context((Configuration)this.jobConf);
        Utilities.getInputSummaryWithPool((Context)context, pathNeedProcess, (MapWork)((MapWork)Mockito.mock(MapWork.class)), (long[])new long[3], (ExecutorService)pool);
        ((ExecutorService)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)3))).submit((Runnable)ArgumentMatchers.any(Runnable.class));
        ((ExecutorService)Mockito.verify((Object)pool)).shutdown();
        ((ExecutorService)Mockito.verify((Object)pool)).shutdownNow();
    }

    @Test
    public void testGetInputSummaryPoolAndFailure() throws ExecutionException, InterruptedException, IOException {
        ExecutorService pool = (ExecutorService)Mockito.mock(ExecutorService.class);
        Mockito.when(pool.submit((Runnable)ArgumentMatchers.any(Runnable.class))).thenReturn((Object)((Future)Mockito.mock(Future.class)));
        HashSet<Path> pathNeedProcess = new HashSet<Path>();
        pathNeedProcess.add(new Path("dummy-path1"));
        pathNeedProcess.add(new Path("dummy-path2"));
        pathNeedProcess.add(new Path("dummy-path3"));
        Context context = new Context((Configuration)this.jobConf);
        Utilities.getInputSummaryWithPool((Context)context, pathNeedProcess, (MapWork)((MapWork)Mockito.mock(MapWork.class)), (long[])new long[3], (ExecutorService)pool);
        ((ExecutorService)Mockito.verify((Object)pool, (VerificationMode)Mockito.times((int)3))).submit((Runnable)ArgumentMatchers.any(Runnable.class));
        ((ExecutorService)Mockito.verify((Object)pool)).shutdown();
        ((ExecutorService)Mockito.verify((Object)pool)).shutdownNow();
    }

    private ContentSummary runTestGetInputSummary(JobConf jobConf, Properties properties, Collection<Path> testPaths, int bytesPerFile, Class<? extends InputFormat> inputFormatClass, Map<Path, ContentSummary> cache) throws IOException {
        return this.runTestGetInputSummary(jobConf, properties, testPaths, bytesPerFile, Collections.emptyList(), inputFormatClass, cache);
    }

    private ContentSummary runTestGetInputSummary(JobConf jobConf, Properties properties, Collection<Path> testPaths, int bytesPerFile, Collection<Path> providedPaths, Class<? extends InputFormat> inputFormatClass, Map<Path, ContentSummary> cache) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
        MapWork mapWork = new MapWork();
        Context context = new Context((Configuration)jobConf);
        for (Map.Entry<Path, ContentSummary> entry : cache.entrySet()) {
            Path partitionPath = new Path(TEST_TABLE_PATH, entry.getKey());
            context.addCS(partitionPath.toString(), entry.getValue());
        }
        LinkedHashMap<Path, PartitionDesc> pathToPartitionInfo = new LinkedHashMap<Path, PartitionDesc>();
        LinkedHashMap<Path, ArrayList> pathToAliasTable = new LinkedHashMap<Path, ArrayList>();
        TableScanOperator scanOp = new TableScanOperator();
        PartitionDesc partitionDesc = new PartitionDesc(new TableDesc(inputFormatClass, null, properties), null);
        for (Path path : testPaths) {
            Path fullPath = new Path(TEST_TABLE_PATH, path);
            Path partitionPath = fullPath.getParent();
            if (!providedPaths.contains(path)) {
                byte[] data = new byte[bytesPerFile];
                fs.mkdirs(partitionPath);
                FSDataOutputStream out = fs.create(fullPath);
                out.write(data);
                out.close();
            }
            pathToPartitionInfo.put(partitionPath, partitionDesc);
            pathToAliasTable.put(partitionPath, Lists.newArrayList((Object[])new String[]{partitionPath.getName()}));
            mapWork.getAliasToWork().put(partitionPath.getName(), scanOp);
        }
        mapWork.setPathToAliases(pathToAliasTable);
        mapWork.setPathToPartitionInfo(pathToPartitionInfo);
        return Utilities.getInputSummary((Context)context, (MapWork)mapWork, null);
    }

    static class ContentSummaryInputFormatTestClass
    extends FileInputFormat
    implements ContentSummaryInputFormat {
        private static ContentSummary summary = new ContentSummary.Builder().build();

        ContentSummaryInputFormatTestClass() {
        }

        public static void setContentSummary(ContentSummary contentSummary) {
            summary = contentSummary;
        }

        public RecordReader getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
            return null;
        }

        public ContentSummary getContentSummary(Path p, JobConf job) throws IOException {
            return summary;
        }
    }
}

