/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.MethodUtils;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCurrentTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFExplode;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFunctionRegistry {
    TypeInfo varchar5;
    TypeInfo varchar10;
    TypeInfo maxVarchar;
    TypeInfo char5;
    TypeInfo char10;

    @Before
    public void setUp() {
        String maxVarcharTypeName = "varchar(65535)";
        this.maxVarchar = TypeInfoFactory.getPrimitiveTypeInfo((String)maxVarcharTypeName);
        this.varchar10 = TypeInfoFactory.getPrimitiveTypeInfo((String)"varchar(10)");
        this.varchar5 = TypeInfoFactory.getPrimitiveTypeInfo((String)"varchar(5)");
        this.char10 = TypeInfoFactory.getPrimitiveTypeInfo((String)"char(10)");
        this.char5 = TypeInfoFactory.getPrimitiveTypeInfo((String)"char(5)");
        HiveConfForTest conf = new HiveConfForTest(this.getClass());
        SessionState.start((HiveConf)conf);
    }

    private void implicit(TypeInfo a, TypeInfo b, boolean convertible) {
        Assert.assertEquals((Object)convertible, (Object)TypeInfoUtils.implicitConvertible((TypeInfo)a, (TypeInfo)b));
    }

    @Test
    public void testImplicitConversion() {
        this.implicit((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, true);
        this.implicit((TypeInfo)TypeInfoFactory.longTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, true);
        this.implicit((TypeInfo)TypeInfoFactory.floatTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, false);
        this.implicit((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, false);
        this.implicit((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, false);
        this.implicit((TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, false);
        this.implicit((TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, false);
        this.implicit(this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
        this.implicit((TypeInfo)TypeInfoFactory.stringTypeInfo, this.varchar10, true);
        PrimitiveTypeInfo varchar10 = TypeInfoFactory.getPrimitiveTypeInfo((String)"varchar(10)");
        PrimitiveTypeInfo varchar20 = TypeInfoFactory.getPrimitiveTypeInfo((String)"varchar(20)");
        this.implicit((TypeInfo)varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
        this.implicit((TypeInfo)varchar20, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
        this.implicit((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)varchar10, true);
        this.implicit((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)varchar20, true);
        this.implicit((TypeInfo)varchar20, (TypeInfo)varchar10, true);
        this.implicit(this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
        this.implicit((TypeInfo)TypeInfoFactory.stringTypeInfo, this.char10, true);
        this.implicit(this.char5, this.char10, true);
        this.implicit(this.char5, (TypeInfo)varchar10, true);
        this.implicit(this.varchar5, this.char10, true);
        this.implicit((TypeInfo)TypeInfoFactory.intTypeInfo, this.char10, true);
        this.implicit((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)varchar10, true);
        this.implicit((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
    }

    private static List<Method> getMethods(Class<?> udfClass, String methodName) {
        ArrayList<Method> mlist = new ArrayList<Method>();
        for (Method m : udfClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            mlist.add(m);
        }
        return mlist;
    }

    private void typeAffinity(String methodName, TypeInfo inputType, int expectedNumFoundMethods, Class expectedFoundType) {
        List<Method> mlist = TestFunctionRegistry.getMethods(TestUDF.class, methodName);
        Assert.assertEquals((Object)true, (Object)(1 < mlist.size() ? 1 : 0));
        ArrayList<TypeInfo> inputTypes = new ArrayList<TypeInfo>();
        inputTypes.add(inputType);
        MethodUtils.filterMethodsByTypeAffinity(mlist, inputTypes);
        Assert.assertEquals((long)expectedNumFoundMethods, (long)mlist.size());
        if (expectedNumFoundMethods == 1) {
            Assert.assertEquals((Object)expectedFoundType, mlist.get(0).getParameterTypes()[0]);
        }
    }

    @Test
    public void testTypeAffinity() {
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.shortTypeInfo, 1, DoubleWritable.class);
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.intTypeInfo, 1, DoubleWritable.class);
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.floatTypeInfo, 1, DoubleWritable.class);
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.dateTypeInfo, 1, DateWritableV2.class);
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.timestampTypeInfo, 1, DateWritableV2.class);
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.stringTypeInfo, 1, Text.class);
        this.typeAffinity("typeaffinity1", this.char5, 1, Text.class);
        this.typeAffinity("typeaffinity1", this.varchar5, 1, Text.class);
        this.typeAffinity("typeaffinity2", (TypeInfo)TypeInfoFactory.shortTypeInfo, 2, null);
        this.typeAffinity("typeaffinity2", (TypeInfo)TypeInfoFactory.dateTypeInfo, 2, null);
    }

    private void verify(Class udf, String name, TypeInfo ta, TypeInfo tb, Class a, Class b, boolean throwException) {
        LinkedList<TypeInfo> args = new LinkedList<TypeInfo>();
        args.add(ta);
        args.add(tb);
        Method result = null;
        try {
            result = MethodUtils.getMethodInternal((Class)udf, (String)name, (boolean)false, args);
        }
        catch (UDFArgumentException e) {
            assert (throwException);
            return;
        }
        assert (!throwException);
        Assert.assertEquals((long)2L, (long)result.getParameterTypes().length);
        Assert.assertEquals((Object)a, result.getParameterTypes()[0]);
        Assert.assertEquals((Object)b, result.getParameterTypes()[1]);
    }

    @Test
    public void testGetMethodInternal() {
        this.verify(TestUDF.class, "same", (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo, HiveDecimalWritable.class, HiveDecimalWritable.class, false);
        this.verify(TestUDF.class, "same", (TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo, DoubleWritable.class, DoubleWritable.class, false);
        this.verify(TestUDF.class, "same", (TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, DoubleWritable.class, DoubleWritable.class, false);
        this.verify(TestUDF.class, "same", (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo, DoubleWritable.class, DoubleWritable.class, false);
        this.verify(TestUDF.class, "same", (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, HiveDecimalWritable.class, HiveDecimalWritable.class, false);
        this.verify(TestUDF.class, "one", (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, IntWritable.class, HiveDecimalWritable.class, false);
        this.verify(TestUDF.class, "one", (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.floatTypeInfo, IntWritable.class, DoubleWritable.class, false);
        this.verify(TestUDF.class, "one", (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo, IntWritable.class, IntWritable.class, false);
        this.verify(TestUDF.class, "same", this.varchar5, this.varchar10, Text.class, Text.class, false);
        this.verify(TestUDF.class, "same", this.char5, this.char10, Text.class, Text.class, false);
        this.verify(TestUDF.class, "mismatch", (TypeInfo)TypeInfoFactory.voidTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo, null, null, true);
    }

    private void common(TypeInfo a, TypeInfo b, TypeInfo result) {
        Assert.assertEquals((Object)result, (Object)FunctionRegistry.getCommonClass((TypeInfo)a, (TypeInfo)b));
    }

    @Test
    public void testCommonClass() {
        this.common((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo);
        this.common((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.common((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common((TypeInfo)TypeInfoFactory.stringTypeInfo, this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common(this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common((TypeInfo)TypeInfoFactory.stringTypeInfo, this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common(this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common(this.char5, this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
    }

    private void comparison(TypeInfo a, TypeInfo b, TypeInfo result) {
        Assert.assertEquals((Object)result, (Object)FunctionRegistry.getCommonClassForComparison((TypeInfo)a, (TypeInfo)b));
    }

    @Test
    public void testCommonClassComparison() {
        this.comparison((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.stringTypeInfo, this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.comparison(this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.comparison(this.varchar5, this.varchar10, this.varchar10);
        this.comparison((TypeInfo)TypeInfoFactory.stringTypeInfo, this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.comparison(this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.comparison(this.char5, this.char10, this.char10);
        this.comparison(this.char10, this.varchar5, (TypeInfo)TypeInfoFactory.stringTypeInfo);
    }

    @Test
    public void testPrintTypeCompatibility() {
    }

    private void unionAll(TypeInfo a, TypeInfo b, TypeInfo result) {
        Assert.assertEquals((Object)result, (Object)FunctionRegistry.getCommonClassForUnionAll((TypeInfo)a, (TypeInfo)b));
    }

    @Test
    public void testCommonClassUnionAll() {
        this.unionAll((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.unionAll(this.varchar5, this.varchar10, this.varchar10);
        this.unionAll(this.varchar10, this.varchar5, this.varchar10);
        this.unionAll(this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.stringTypeInfo, this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.unionAll(this.char5, this.char10, this.char10);
        this.unionAll(this.char10, this.char5, this.char10);
        this.unionAll(this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.stringTypeInfo, this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, null);
        this.unionAll((TypeInfo)TypeInfoFactory.doubleTypeInfo, this.varchar10, null);
    }

    @Test
    public void testGetTypeInfoForPrimitiveCategory() {
        Assert.assertEquals((Object)this.varchar10, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar5), (PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar10), (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR));
        Assert.assertEquals((Object)this.varchar10, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar10), (PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar5), (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR));
        Assert.assertEquals((Object)this.char10, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.char5), (PrimitiveTypeInfo)((PrimitiveTypeInfo)this.char10), (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.CHAR));
        Assert.assertEquals((Object)this.char10, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.char10), (PrimitiveTypeInfo)((PrimitiveTypeInfo)this.char5), (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.CHAR));
        Assert.assertEquals((Object)this.varchar10, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar5), (PrimitiveTypeInfo)((PrimitiveTypeInfo)this.char10), (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR));
        Assert.assertEquals((Object)TypeInfoFactory.stringTypeInfo, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar10), (PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING));
        Assert.assertEquals((Object)TypeInfoFactory.stringTypeInfo, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING));
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)TypeInfoFactory.doubleTypeInfo, (PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE));
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testIsRankingFunction() throws Exception {
        Assert.assertTrue((boolean)FunctionRegistry.isRankingFunction((String)"rank"));
        Assert.assertTrue((boolean)FunctionRegistry.isRankingFunction((String)"dense_rank"));
        Assert.assertTrue((boolean)FunctionRegistry.isRankingFunction((String)"percent_rank"));
        Assert.assertTrue((boolean)FunctionRegistry.isRankingFunction((String)"cume_dist"));
        Assert.assertFalse((boolean)FunctionRegistry.isRankingFunction((String)"min"));
    }

    @Test
    public void testImpliesOrder() throws Exception {
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"first_value"));
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"last_value"));
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"lead"));
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"lag"));
        Assert.assertFalse((boolean)FunctionRegistry.impliesOrder((String)"min"));
    }

    @Test
    public void testRegisterTemporaryFunctions() throws Exception {
        FunctionInfo.FunctionResource[] emptyResources = new FunctionInfo.FunctionResource[]{};
        FunctionRegistry.registerTemporaryUDF((String)"tmp_ln", UDFLn.class, (FunctionInfo.FunctionResource[])emptyResources);
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)"tmp_ln");
        Assert.assertFalse((boolean)functionInfo.isNative());
        FunctionRegistry.registerTemporaryUDF((String)"tmp_concat", GenericUDFConcat.class, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"tmp_concat");
        Assert.assertFalse((boolean)functionInfo.isNative());
        FunctionRegistry.registerTemporaryUDF((String)"tmp_max", GenericUDAFMax.class, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"tmp_max");
        Assert.assertFalse((boolean)functionInfo.isNative());
        functionInfo = FunctionRegistry.getWindowFunctionInfo((String)"tmp_max");
        Assert.assertFalse((boolean)functionInfo.isNative());
        FunctionRegistry.registerTemporaryUDF((String)"tmp_explode", GenericUDTFExplode.class, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"tmp_explode");
        Assert.assertFalse((boolean)functionInfo.isNative());
    }

    @Test
    public void testRegisterPermanentFunction() throws Exception {
        FunctionInfo.FunctionResource[] emptyResources = new FunctionInfo.FunctionResource[]{};
        FunctionRegistry.registerPermanentFunction((String)"perm_ln", (String)UDFLn.class.getName(), (boolean)true, (FunctionInfo.FunctionResource[])emptyResources);
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)"perm_ln");
        Assert.assertTrue((boolean)functionInfo.isPersistent());
        Assert.assertTrue((boolean)functionInfo.isNative());
        Assert.assertFalse((boolean)functionInfo.isBuiltIn());
        functionInfo = FunctionRegistry.getFunctionInfo((String)"default.perm_ln");
        Assert.assertTrue((boolean)functionInfo.isPersistent());
        Assert.assertTrue((boolean)functionInfo.isNative());
        Assert.assertFalse((boolean)functionInfo.isBuiltIn());
        FunctionRegistry.registerPermanentFunction((String)"default.perm_concat", (String)GenericUDFConcat.class.getName(), (boolean)true, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"default.perm_concat");
        Assert.assertTrue((boolean)functionInfo.isPersistent());
        Assert.assertTrue((boolean)functionInfo.isNative());
        Assert.assertFalse((boolean)functionInfo.isBuiltIn());
        FunctionRegistry.registerPermanentFunction((String)"default.perm_max", (String)GenericUDAFMax.class.getName(), (boolean)true, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"default.perm_max");
        Assert.assertTrue((boolean)functionInfo.isPersistent());
        functionInfo = FunctionRegistry.getWindowFunctionInfo((String)"default.perm_max");
        Assert.assertTrue((boolean)functionInfo.isPersistent());
        Assert.assertTrue((boolean)functionInfo.isNative());
        Assert.assertFalse((boolean)functionInfo.isBuiltIn());
        FunctionRegistry.registerPermanentFunction((String)"default.perm_explode", (String)GenericUDTFExplode.class.getName(), (boolean)true, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"default.perm_explode");
        Assert.assertTrue((boolean)functionInfo.isPersistent());
        Assert.assertTrue((boolean)functionInfo.isNative());
        Assert.assertFalse((boolean)functionInfo.isBuiltIn());
    }

    @Test
    public void testBuiltInFunction() throws Exception {
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)"ln");
        Assert.assertTrue((boolean)functionInfo.isBuiltIn());
        Assert.assertTrue((boolean)functionInfo.isNative());
    }

    @Test
    public void testIsPermanentFunction() throws Exception {
        GenericUDFCurrentTimestamp udf = new GenericUDFCurrentTimestamp();
        ArrayList children = new ArrayList();
        ExprNodeGenericFuncDesc fnExpr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, (GenericUDF)udf, children);
        Assert.assertFalse((String)"Function not added as permanent yet", (boolean)FunctionRegistry.isPermanentFunction((ExprNodeGenericFuncDesc)fnExpr));
        FunctionInfo.FunctionResource[] emptyResources = new FunctionInfo.FunctionResource[]{};
        FunctionRegistry.registerPermanentFunction((String)"default.perm_current_timestamp", (String)GenericUDFCurrentTimestamp.class.getName(), (boolean)true, (FunctionInfo.FunctionResource[])emptyResources);
        Assert.assertTrue((String)"Function should now be recognized as permanent function", (boolean)FunctionRegistry.isPermanentFunction((ExprNodeGenericFuncDesc)fnExpr));
    }

    private GenericUDF getUDF(String udfName) throws Exception {
        return FunctionRegistry.getFunctionInfo((String)udfName).getGenericUDF();
    }

    private void checkRuntimeConstant(GenericUDF udf) {
        Assert.assertFalse((boolean)FunctionRegistry.isDeterministic((GenericUDF)udf));
        Assert.assertTrue((boolean)FunctionRegistry.isRuntimeConstant((GenericUDF)udf));
        Assert.assertTrue((boolean)FunctionRegistry.isConsistentWithinQuery((GenericUDF)udf));
    }

    private void checkDeterministicFn(GenericUDF udf) {
        Assert.assertTrue((boolean)FunctionRegistry.isDeterministic((GenericUDF)udf));
        Assert.assertFalse((boolean)FunctionRegistry.isRuntimeConstant((GenericUDF)udf));
        Assert.assertTrue((boolean)FunctionRegistry.isConsistentWithinQuery((GenericUDF)udf));
    }

    private void checkNondeterministicFn(GenericUDF udf) {
        Assert.assertFalse((boolean)FunctionRegistry.isDeterministic((GenericUDF)udf));
        Assert.assertFalse((boolean)FunctionRegistry.isRuntimeConstant((GenericUDF)udf));
        Assert.assertFalse((boolean)FunctionRegistry.isConsistentWithinQuery((GenericUDF)udf));
    }

    @Test
    public void testDeterminism() throws Exception {
        this.checkDeterministicFn(this.getUDF("+"));
        this.checkDeterministicFn(this.getUDF("ascii"));
        this.checkNondeterministicFn(this.getUDF("rand"));
        this.checkNondeterministicFn(this.getUDF("uuid"));
        this.checkRuntimeConstant(this.getUDF("current_database"));
        this.checkRuntimeConstant(this.getUDF("current_date"));
        this.checkRuntimeConstant(this.getUDF("current_timestamp"));
        this.checkRuntimeConstant(this.getUDF("current_user"));
        this.checkRuntimeConstant(this.getUDF("logged_in_user"));
    }

    public class TestUDF {
        public void same(DoubleWritable x, DoubleWritable y) {
        }

        public void same(HiveDecimalWritable x, HiveDecimalWritable y) {
        }

        public void same(Text x, Text y) {
        }

        public void one(IntWritable x, HiveDecimalWritable y) {
        }

        public void one(IntWritable x, DoubleWritable y) {
        }

        public void one(IntWritable x, IntWritable y) {
        }

        public void mismatch(DateWritableV2 x, HiveDecimalWritable y) {
        }

        public void mismatch(TimestampWritableV2 x, HiveDecimalWritable y) {
        }

        public void mismatch(BytesWritable x, DoubleWritable y) {
        }

        public void typeaffinity1(DateWritableV2 x) {
        }

        public void typeaffinity1(DoubleWritable x) {
        }

        public void typeaffinity1(Text x) {
        }

        public void typeaffinity2(IntWritable x) {
        }

        public void typeaffinity2(DoubleWritable x) {
        }
    }
}

