/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileSinkOperator {
    private static String PARTCOL_NAME = "partval";
    private static final String tmpPrefix = "-tmp.";
    private static final Logger LOG = LoggerFactory.getLogger((String)TestFileSinkOperator.class.getName());
    private static File tmpdir;
    private static TableDesc nonAcidTableDescriptor;
    private static TableDesc acidTableDescriptor;
    private static ObjectInspector inspector;
    private static List<Row> rows;
    private Path basePath;
    private JobConf jc;

    @BeforeClass
    public static void classSetup() {
        Properties properties = new Properties();
        properties.setProperty("serialization.lib", TFSOSerDe.class.getName());
        properties.setProperty("name", "tfs");
        nonAcidTableDescriptor = new TableDesc(TFSOInputFormat.class, TFSOOutputFormat.class, properties);
        properties.setProperty("columns", "data");
        properties = new Properties(properties);
        properties.setProperty("bucket_count", "1");
        acidTableDescriptor = new TableDesc(TFSOInputFormat.class, TFSOOutputFormat.class, properties);
        tmpdir = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "testFileSinkOperator");
        tmpdir.mkdir();
        tmpdir.deleteOnExit();
    }

    @Test
    public void testNonAcidWrite() throws Exception {
        this.setBasePath("write");
        this.setupData(DataFormat.WITH_PARTITION_VALUE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.NOT_ACID, false, 0L);
        this.processRows(op);
        this.confirmOutput(DataFormat.WITH_PARTITION_VALUE);
    }

    @Test
    public void testInsert() throws Exception {
        this.setBasePath("insert");
        this.setupData(DataFormat.WITH_PARTITION_VALUE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.INSERT, false, 1L);
        this.processRows(op);
        Assert.assertEquals((Object)"10", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput(DataFormat.WITH_PARTITION_VALUE);
    }

    @Test
    public void testUpdate() throws Exception {
        this.setBasePath("update");
        this.setupData(DataFormat.WITH_RECORD_ID);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.UPDATE, false, 2L);
        this.processRows(op);
        Assert.assertEquals((Object)"0", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput(DataFormat.WITH_RECORD_ID);
    }

    @Test
    public void testDelete() throws Exception {
        this.setBasePath("delete");
        this.setupData(DataFormat.WITH_RECORD_ID);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.DELETE, false, 2L);
        this.processRows(op);
        Assert.assertEquals((Object)"-10", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput(DataFormat.WITH_RECORD_ID);
    }

    @Test
    public void testNonAcidDynamicPartitioning() throws Exception {
        this.setBasePath("writeDP");
        this.setupData(DataFormat.WITH_PARTITION_VALUE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.NOT_ACID, true, 0L);
        this.processRows(op);
        this.confirmOutput(DataFormat.WITH_PARTITION_VALUE);
    }

    @Test
    public void testNonAcidRemoveDuplicate() throws Exception {
        this.setBasePath("writeDuplicate");
        this.setupData(DataFormat.WITH_PARTITION_VALUE);
        FileSinkDesc desc = (FileSinkDesc)((FileSinkDesc)this.getFileSink(AcidUtils.Operation.NOT_ACID, true, 0L).getConf()).clone();
        Path linkedDir = desc.getDirName();
        desc.setLinkedFileSink(true);
        desc.setDirName(new Path(linkedDir, "HIVE_UNION_SUBDIR_0"));
        JobConf jobConf = new JobConf((Configuration)this.jc);
        jobConf.set("hive.execution.engine", "tez");
        jobConf.set("mapred.task.id", "000000_0");
        FileSinkOperator op1 = (FileSinkOperator)OperatorFactory.get((CompilationOpContext)new CompilationOpContext(), FileSinkDesc.class);
        op1.setConf((OperatorDesc)desc);
        op1.initialize((Configuration)jobConf, new ObjectInspector[]{inspector});
        JobConf jobConf2 = new JobConf((Configuration)jobConf);
        jobConf2.set("mapred.task.id", "000000_1");
        FileSinkOperator op2 = (FileSinkOperator)OperatorFactory.get((CompilationOpContext)new CompilationOpContext(), FileSinkDesc.class);
        op2.setConf((OperatorDesc)desc);
        op2.initialize((Configuration)jobConf2, new ObjectInspector[]{inspector});
        JobConf jobConf3 = new JobConf((Configuration)jobConf);
        jobConf3.set("mapred.task.id", "000001_0");
        FileSinkOperator op3 = (FileSinkOperator)OperatorFactory.get((CompilationOpContext)new CompilationOpContext(), FileSinkDesc.class);
        FileSinkDesc sinkDesc = (FileSinkDesc)desc.clone();
        sinkDesc.setDirName(new Path(linkedDir, "HIVE_UNION_SUBDIR_1"));
        op3.setConf((OperatorDesc)sinkDesc);
        op3.initialize((Configuration)jobConf3, new ObjectInspector[]{inspector});
        JobConf jobConf4 = new JobConf((Configuration)jobConf);
        jobConf4.set("mapred.task.id", "000001_1");
        FileSinkOperator op4 = (FileSinkOperator)OperatorFactory.get((CompilationOpContext)new CompilationOpContext(), FileSinkDesc.class);
        op4.setConf((OperatorDesc)sinkDesc);
        op4.initialize((Configuration)jobConf4, new ObjectInspector[]{inspector});
        for (Row r : rows) {
            op1.process((Object)r, 0);
            op2.process((Object)r, 0);
            op3.process((Object)r, 0);
            op4.process((Object)r, 0);
        }
        op1.close(false);
        op2.close(false);
        op3.close(false);
        op4.close(false);
        Path[] paths = this.findFilesInPath(linkedDir);
        Set fileNames = Arrays.stream(paths).filter(path -> path.getParent().toString().endsWith("partval=Monday/HIVE_UNION_SUBDIR_0")).map(path -> path.getName()).collect(Collectors.toSet());
        Assert.assertEquals((String)"Two result files are expected", (long)2L, (long)fileNames.size());
        Assert.assertTrue((String)"000000_1 file is expected", (boolean)fileNames.contains("000000_1"));
        Assert.assertTrue((String)"000000_0 file is expected", (boolean)fileNames.contains("000000_0"));
        fileNames = Arrays.stream(paths).filter(path -> path.getParent().toString().endsWith("partval=Monday/HIVE_UNION_SUBDIR_1")).map(path -> path.getName()).collect(Collectors.toSet());
        Assert.assertEquals((String)"Two result files are expected", (long)2L, (long)fileNames.size());
        Assert.assertTrue((String)"000001_0 file is expected", (boolean)fileNames.contains("000001_0"));
        Assert.assertTrue((String)"000001_1 file is expected", (boolean)fileNames.contains("000001_1"));
        op3.jobCloseOp((Configuration)jobConf, true);
        op1.jobCloseOp((Configuration)jobConf, true);
        ArrayList<Path> resultFiles = new ArrayList<Path>();
        String linkedDirPath = linkedDir.toUri().getPath();
        this.recurseOnPath(linkedDir, linkedDir.getFileSystem((Configuration)this.jc), resultFiles);
        List mondays = resultFiles.stream().filter(path -> path.getParent().toUri().getPath().equals(linkedDirPath + "/partval=Monday/HIVE_UNION_SUBDIR_0")).collect(Collectors.toList());
        Assert.assertEquals((String)"Only 1 file should be here after cleaning", (long)1L, (long)mondays.size());
        Assert.assertEquals((String)"000000_1 file is expected", (Object)"000000_1", (Object)((Path)mondays.get(0)).getName());
        List<Path> subdir1 = resultFiles.stream().filter(path -> path.getParent().getName().equals("HIVE_UNION_SUBDIR_1")).sorted().collect(Collectors.toList());
        Assert.assertEquals((String)"Two partitions expected", (long)2L, (long)subdir1.size());
        Path monday = (Path)subdir1.get(0);
        Path tuesday = (Path)subdir1.get(1);
        Assert.assertEquals((String)"Only 1 file left under the partition after deduplication", (Object)monday.toUri().getPath(), (Object)(linkedDirPath + "/partval=Monday/HIVE_UNION_SUBDIR_1/000001_1"));
        Assert.assertEquals((String)"Only 1 file left under the partition after deduplication", (Object)tuesday.toUri().getPath(), (Object)(linkedDirPath + "/partval=Tuesday/HIVE_UNION_SUBDIR_1/000001_1"));
        this.confirmOutput(DataFormat.WITH_PARTITION_VALUE, resultFiles.stream().filter(p -> p.getParent().getName().equals("HIVE_UNION_SUBDIR_0")).sorted().collect(Collectors.toList()).toArray(new Path[0]));
        this.confirmOutput(DataFormat.WITH_PARTITION_VALUE, subdir1.toArray(new Path[0]));
    }

    @Test
    public void testInsertDynamicPartitioning() throws Exception {
        this.setBasePath("insertDP");
        this.setupData(DataFormat.WITH_PARTITION_VALUE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.INSERT, true, 1L);
        this.processRows(op);
        Assert.assertEquals((Object)"5", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput(DataFormat.WITH_PARTITION_VALUE);
    }

    @Test
    public void testUpdateDynamicPartitioning() throws Exception {
        this.setBasePath("updateDP");
        this.setupData(DataFormat.WITH_RECORD_ID_AND_PARTITION_VALUE);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.UPDATE, true, 2L);
        this.processRows(op);
        Assert.assertEquals((Object)"0", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput(DataFormat.WITH_RECORD_ID_AND_PARTITION_VALUE);
    }

    @Test
    public void testDeleteDynamicPartitioning() throws Exception {
        this.setBasePath("deleteDP");
        this.setupData(DataFormat.WITH_RECORD_ID);
        FileSinkOperator op = this.getFileSink(AcidUtils.Operation.DELETE, true, 2L);
        this.processRows(op);
        Assert.assertEquals((Object)"-5", (Object)TFSOStatsPublisher.stats.get("numRows"));
        this.confirmOutput(DataFormat.WITH_RECORD_ID);
    }

    @Before
    public void setup() throws Exception {
        this.jc = new JobConf();
        this.jc.set(HiveConf.ConfVars.HIVE_STATS_DEFAULT_PUBLISHER.varname, TFSOStatsPublisher.class.getName());
        this.jc.set(HiveConf.ConfVars.HIVE_STATS_DEFAULT_AGGREGATOR.varname, TFSOStatsAggregator.class.getName());
        this.jc.set(HiveConf.ConfVars.HIVE_STATS_DBCLASS.varname, "custom");
    }

    @After
    public void afterTest() throws Exception {
        Path parent = this.basePath.getParent();
        String last = this.basePath.getName();
        FileSystem fs = this.basePath.getFileSystem((Configuration)this.jc);
        fs.delete(this.basePath, true);
        fs.delete(new Path(parent, "_tmp." + last), true);
        fs.delete(new Path(parent, "_task_tmp." + last), true);
    }

    private void setBasePath(String testName) {
        this.basePath = new Path(new File(tmpdir, testName).getPath());
    }

    private void setupData(DataFormat format) {
        inspector = ObjectInspectorFactory.getReflectionObjectInspector(switch (format) {
            case DataFormat.WITH_PARTITION_VALUE -> RowWithPartVal.class;
            case DataFormat.WITH_RECORD_ID -> RowWithRecID.class;
            case DataFormat.WITH_RECORD_ID_AND_PARTITION_VALUE -> RowWithPartNRecID.class;
            default -> throw new RuntimeException("Unknown type");
        }, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        rows = new ArrayList<Row>();
        for (int i = 0; i < 10; ++i) {
            rows.add(switch (format) {
                case DataFormat.WITH_PARTITION_VALUE -> new RowWithPartVal(new Text("mary had a little lamb"), i < 5 ? new Text("Monday") : new Text("Tuesday"));
                case DataFormat.WITH_RECORD_ID -> new RowWithRecID(new RecordIdentifier(1L, 1, (long)i), i < 5 ? new Text("Monday") : new Text("Tuesday"));
                case DataFormat.WITH_RECORD_ID_AND_PARTITION_VALUE -> new RowWithPartNRecID(new Text("its fleect was white as snow"), i < 5 ? new Text("Monday") : new Text("Tuesday"), new RecordIdentifier(1L, 1, (long)i));
                default -> throw new RuntimeException("Unknown data format");
            });
        }
    }

    private FileSinkOperator getFileSink(AcidUtils.Operation writeType, boolean dynamic, long writeId) throws IOException, HiveException {
        TableDesc tableDesc = null;
        switch (writeType) {
            case DELETE: 
            case UPDATE: 
            case INSERT: {
                tableDesc = acidTableDescriptor;
                break;
            }
            case NOT_ACID: {
                tableDesc = nonAcidTableDescriptor;
            }
        }
        FileSinkDesc desc = null;
        if (dynamic) {
            ArrayList<ExprNodeColumnDesc> partCols = new ArrayList<ExprNodeColumnDesc>(1);
            partCols.add(new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, PARTCOL_NAME, "a", true));
            LinkedHashMap<String, Object> partColMap = new LinkedHashMap<String, Object>(1);
            partColMap.put(PARTCOL_NAME, null);
            DynamicPartitionCtx dpCtx = new DynamicPartitionCtx(partColMap, "Sunday", 100);
            desc = new FileSinkDesc(this.basePath, tableDesc, false, 1, false, false, 1, 1, partCols, dpCtx, null, false, false, false, false, false, writeType, false);
        } else {
            desc = new FileSinkDesc(this.basePath, tableDesc, false);
        }
        desc.setStatsAggPrefix(this.basePath.toString());
        desc.setWriteType(writeType);
        desc.setGatherStats(true);
        if (writeId > 0L) {
            desc.setTableWriteId(writeId);
        }
        if (writeType != AcidUtils.Operation.NOT_ACID) {
            desc.setTableWriteId(1L);
        }
        FileSinkOperator op = (FileSinkOperator)OperatorFactory.get((CompilationOpContext)new CompilationOpContext(), FileSinkDesc.class);
        op.setConf((OperatorDesc)desc);
        op.initialize((Configuration)this.jc, new ObjectInspector[]{inspector});
        return op;
    }

    private void processRows(FileSinkOperator op) throws HiveException {
        for (Row r : rows) {
            op.process((Object)r, 0);
        }
        op.jobCloseOp((Configuration)this.jc, true);
        op.close(false);
    }

    private void confirmOutput(DataFormat rType) throws IOException, SerDeException, CloneNotSupportedException {
        this.confirmOutput(rType, this.findFilesInBasePath());
    }

    private void confirmOutput(DataFormat rType, Path[] paths) throws IOException, SerDeException, CloneNotSupportedException {
        int i;
        TFSOInputFormat input = new TFSOInputFormat(rType);
        FileInputFormat.setInputPaths((JobConf)this.jc, (Path[])paths);
        InputSplit[] splits = input.getSplits(this.jc, 1);
        RecordReader<NullWritable, Row> reader = input.getRecordReader(splits[0], this.jc, (Reporter)Mockito.mock(Reporter.class));
        NullWritable key = (NullWritable)reader.createKey();
        Row value = (Row)reader.createValue();
        ArrayList<Row> results = new ArrayList<Row>(rows.size());
        ArrayList<Row> sortedRows = new ArrayList<Row>(rows.size());
        for (i = 0; i < rows.size(); ++i) {
            Assert.assertTrue((boolean)reader.next((Object)key, (Object)value));
            results.add(value.clone());
            sortedRows.add(rows.get(i));
        }
        Assert.assertFalse((boolean)reader.next((Object)key, (Object)value));
        Collections.sort(results);
        Collections.sort(sortedRows);
        for (i = 0; i < rows.size(); ++i) {
            Assert.assertTrue((boolean)((Row)sortedRows.get(i)).equals(results.get(i)));
        }
    }

    private Path[] findFilesInBasePath() throws IOException {
        Path parent = this.basePath.getParent();
        String last = this.basePath.getName();
        Path tmpPath = new Path(parent, tmpPrefix + last);
        FileSystem fs = this.basePath.getFileSystem((Configuration)this.jc);
        ArrayList<Path> paths = new ArrayList<Path>();
        this.recurseOnPath(tmpPath, fs, paths);
        return paths.toArray(new Path[paths.size()]);
    }

    private Path[] findFilesInPath(Path path) throws IOException {
        FileSystem fs = path.getFileSystem((Configuration)this.jc);
        ArrayList<Path> paths = new ArrayList<Path>();
        this.recurseOnPath(path, fs, paths);
        return paths.toArray(new Path[paths.size()]);
    }

    private void recurseOnPath(Path p, FileSystem fs, List<Path> paths) throws IOException {
        if (fs.getFileStatus(p).isDir()) {
            FileStatus[] stats;
            for (FileStatus stat : stats = fs.listStatus(p)) {
                this.recurseOnPath(stat.getPath(), fs, paths);
            }
        } else {
            paths.add(p);
        }
    }

    public static class TFSOSerDe
    extends AbstractSerDe {
        public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        }

        public Class<? extends Writable> getSerializedClass() {
            return RowWithPartNRecID.class;
        }

        public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
            assert (obj instanceof Row) : "Expected Row or decendent, got " + obj.getClass().getName();
            return (Row)obj;
        }

        public Object deserialize(Writable blob) throws SerDeException {
            assert (blob instanceof Row) : "Expected Row or decendent, got " + blob.getClass().getName();
            return blob;
        }

        public ObjectInspector getObjectInspector() throws SerDeException {
            return null;
        }
    }

    private static class TFSOInputFormat
    extends FileInputFormat<NullWritable, Row>
    implements AcidInputFormat<NullWritable, Row> {
        FSDataInputStream[] in = null;
        int readingFrom = -1;
        DataFormat rType;

        public TFSOInputFormat(DataFormat rType) {
            this.rType = rType;
        }

        public RecordReader<NullWritable, Row> getRecordReader(InputSplit inputSplit, JobConf entries, Reporter reporter) throws IOException {
            if (this.in == null) {
                Path[] paths = FileInputFormat.getInputPaths((JobConf)entries);
                this.in = new FSDataInputStream[paths.length];
                FileSystem fs = paths[0].getFileSystem((Configuration)entries);
                for (int i = 0; i < paths.length; ++i) {
                    this.in[i] = fs.open(paths[i]);
                }
                this.readingFrom = 0;
            }
            return new RecordReader<NullWritable, Row>(){

                public boolean next(NullWritable nullWritable, Row tfsoRecord) throws IOException {
                    try {
                        tfsoRecord.readFields((DataInput)in[readingFrom]);
                        return true;
                    }
                    catch (EOFException e) {
                        in[readingFrom].close();
                        if (++readingFrom >= in.length) {
                            return false;
                        }
                        return this.next(nullWritable, tfsoRecord);
                    }
                }

                public NullWritable createKey() {
                    return NullWritable.get();
                }

                public Row createValue() {
                    switch (rType) {
                        case WITH_RECORD_ID_AND_PARTITION_VALUE: {
                            return new RowWithPartNRecID();
                        }
                        case WITH_PARTITION_VALUE: {
                            return new RowWithPartVal();
                        }
                        case WITH_RECORD_ID: {
                            return new RowWithRecID();
                        }
                    }
                    throw new RuntimeException("Unknown row Type");
                }

                public long getPos() throws IOException {
                    return 0L;
                }

                public void close() throws IOException {
                }

                public float getProgress() throws IOException {
                    return 0.0f;
                }
            };
        }

        public AcidInputFormat.RowReader<Row> getReader(InputSplit split, AcidInputFormat.Options options) throws IOException {
            return null;
        }

        public AcidInputFormat.RawReader<Row> getRawReader(Configuration conf, boolean collapseEvents, int bucket, ValidWriteIdList validWriteIdList, Path baseDirectory, Path[] deltaDirectory, Map<String, Integer> deltaToAttemptId) throws IOException {
            return null;
        }

        public boolean validateInput(FileSystem fs, HiveConf conf, List<FileStatus> files) throws IOException {
            return false;
        }
    }

    public static class TFSOOutputFormat
    extends FileOutputFormat<NullWritable, Row>
    implements AcidOutputFormat<NullWritable, Row> {
        List<Row> records = new ArrayList<Row>();
        long numRecordsAdded = 0L;
        FSDataOutputStream out = null;

        public RecordUpdater getRecordUpdater(final Path path, final AcidOutputFormat.Options options) throws IOException {
            return new RecordUpdater(){

                public void insert(long currentWriteId, Object row) throws IOException {
                    this.addRow(row);
                    ++numRecordsAdded;
                }

                public void update(long currentWriteId, Object row) throws IOException {
                    this.addRow(row);
                }

                public void delete(long currentWriteId, Object row) throws IOException {
                    this.addRow(row);
                    --numRecordsAdded;
                }

                private void addRow(Object row) {
                    assert (row instanceof Row) : "Expected Row but got " + row.getClass().getName();
                    records.add((Row)row);
                }

                public void flush() throws IOException {
                    if (out == null) {
                        FileSystem fs = path.getFileSystem(options.getConfiguration());
                        out = fs.create(path);
                    }
                    for (Writable writable : records) {
                        writable.write((DataOutput)out);
                    }
                    records.clear();
                    out.flush();
                }

                public void close(boolean abort) throws IOException {
                    this.flush();
                    out.close();
                }

                public SerDeStats getStats() {
                    SerDeStats stats = new SerDeStats();
                    stats.setRowCount(numRecordsAdded);
                    return stats;
                }

                public long getBufferedRowCount() {
                    return records.size();
                }

                public Path getUpdatedFilePath() {
                    return null;
                }
            };
        }

        public FileSinkOperator.RecordWriter getRawRecordWriter(Path path, AcidOutputFormat.Options options) throws IOException {
            return null;
        }

        public FileSinkOperator.RecordWriter getHiveRecordWriter(final JobConf jc, final Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
            return new FileSinkOperator.RecordWriter(){

                public void write(Writable w) throws IOException {
                    Assert.assertTrue((boolean)(w instanceof Row));
                    records.add((Row)w);
                }

                public void close(boolean abort) throws IOException {
                    if (out == null) {
                        FileSystem fs = finalOutPath.getFileSystem((Configuration)jc);
                        out = fs.create(finalOutPath);
                    }
                    for (Writable writable : records) {
                        writable.write((DataOutput)out);
                    }
                    records.clear();
                    out.flush();
                    out.close();
                }
            };
        }

        public RecordWriter<NullWritable, Row> getRecordWriter(FileSystem fileSystem, JobConf entries, String s, Progressable progressable) throws IOException {
            return null;
        }

        public void checkOutputSpecs(FileSystem fileSystem, JobConf entries) throws IOException {
        }
    }

    private static enum DataFormat {
        WITH_RECORD_ID,
        WITH_PARTITION_VALUE,
        WITH_RECORD_ID_AND_PARTITION_VALUE;

    }

    public static class TFSOStatsPublisher
    implements StatsPublisher {
        static Map<String, String> stats;

        public boolean init(StatsCollectionContext context) {
            return true;
        }

        public boolean connect(StatsCollectionContext context) {
            return true;
        }

        public boolean publishStat(String fileID, Map<String, String> stats) {
            TFSOStatsPublisher.stats = stats;
            return true;
        }

        public boolean closeConnection(StatsCollectionContext context) {
            return true;
        }
    }

    public static class TFSOStatsAggregator
    implements StatsAggregator {
        public boolean connect(StatsCollectionContext scc) {
            return true;
        }

        public String aggregateStats(String keyPrefix, String statType) {
            return null;
        }

        public boolean closeConnection(StatsCollectionContext scc) {
            return true;
        }
    }

    private static class RowWithPartVal
    implements Row {
        private Text data;
        private Text partVal;

        public RowWithPartVal(Text data, Text partVal) {
            this.data = data;
            this.partVal = partVal;
        }

        public RowWithPartVal() {
        }

        @Override
        public Row clone() throws CloneNotSupportedException {
            return new RowWithPartVal(this.data, this.partVal);
        }

        public void write(DataOutput dataOutput) throws IOException {
            this.data.write(dataOutput);
            if (this.partVal == null) {
                dataOutput.writeBoolean(false);
            } else {
                dataOutput.writeBoolean(true);
                this.partVal.write(dataOutput);
            }
        }

        public void readFields(DataInput dataInput) throws IOException {
            this.data = new Text();
            this.data.readFields(dataInput);
            boolean notNull = dataInput.readBoolean();
            if (notNull) {
                this.partVal = new Text();
                this.partVal.readFields(dataInput);
            }
        }

        public int compareTo(Row row) {
            RowWithPartVal other = (RowWithPartVal)row;
            if (this.partVal == null && other.partVal == null) {
                return this.compareData(other);
            }
            if (this.partVal == null) {
                return -1;
            }
            int rc = this.partVal.compareTo((BinaryComparable)other.partVal);
            if (rc == 0) {
                return this.compareData(other);
            }
            return rc;
        }

        private int compareData(RowWithPartVal other) {
            if (this.data == null && other.data == null) {
                return 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.compareTo((BinaryComparable)other.data);
        }

        public boolean equals(Object obj) {
            if (obj instanceof RowWithPartVal) {
                RowWithPartVal other = (RowWithPartVal)obj;
                return this.compareTo(other) == 0;
            }
            return false;
        }
    }

    private static class RowWithRecID
    implements Row {
        private RecordIdentifier recId;
        private Text partVal;

        public RowWithRecID() {
        }

        public RowWithRecID(RecordIdentifier recId, Text partVal) {
            this.recId = recId;
            this.partVal = partVal;
        }

        @Override
        public Row clone() throws CloneNotSupportedException {
            return new RowWithRecID(this.recId, this.partVal);
        }

        public void write(DataOutput dataOutput) throws IOException {
            if (this.partVal == null) {
                dataOutput.writeBoolean(false);
            } else {
                dataOutput.writeBoolean(true);
                this.partVal.write(dataOutput);
            }
            if (this.recId == null) {
                dataOutput.writeBoolean(false);
            } else {
                dataOutput.writeBoolean(true);
                this.recId.write(dataOutput);
            }
        }

        public void readFields(DataInput dataInput) throws IOException {
            boolean notNull = dataInput.readBoolean();
            if (notNull) {
                this.partVal = new Text();
                this.partVal.readFields(dataInput);
            }
            if (notNull = dataInput.readBoolean()) {
                this.recId = new RecordIdentifier();
                this.recId.readFields(dataInput);
            }
        }

        public int compareTo(Row row) {
            RowWithRecID other = (RowWithRecID)row;
            if (this.recId == null && other.recId == null) {
                return this.comparePartVal(other);
            }
            if (this.recId == null) {
                return -1;
            }
            int rc = this.recId.compareTo(other.recId);
            if (rc == 0) {
                return this.comparePartVal(other);
            }
            return rc;
        }

        private int comparePartVal(RowWithRecID other) {
            return this.partVal.compareTo((BinaryComparable)other.partVal);
        }

        public boolean equals(Object obj) {
            return this.compareTo((RowWithRecID)obj) == 0;
        }
    }

    private static class RowWithPartNRecID
    implements Row {
        private RecordIdentifier recId;
        private Text data;
        private Text partVal;

        RowWithPartNRecID() {
            this(null, null, null);
        }

        RowWithPartNRecID(Text t, Text pv, RecordIdentifier ri) {
            this.data = t;
            this.partVal = pv;
            this.recId = ri;
        }

        @Override
        public RowWithPartNRecID clone() throws CloneNotSupportedException {
            return new RowWithPartNRecID(this.data, this.partVal, this.recId);
        }

        public void write(DataOutput dataOutput) throws IOException {
            this.data.write(dataOutput);
            if (this.partVal == null) {
                dataOutput.writeBoolean(false);
            } else {
                dataOutput.writeBoolean(true);
                this.partVal.write(dataOutput);
            }
            if (this.recId == null) {
                dataOutput.writeBoolean(false);
            } else {
                dataOutput.writeBoolean(true);
                this.recId.write(dataOutput);
            }
        }

        public void readFields(DataInput dataInput) throws IOException {
            this.data = new Text();
            this.data.readFields(dataInput);
            boolean notNull = dataInput.readBoolean();
            if (notNull) {
                this.partVal = new Text();
                this.partVal.readFields(dataInput);
            }
            if (notNull = dataInput.readBoolean()) {
                this.recId = new RecordIdentifier();
                this.recId.readFields(dataInput);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof RowWithPartNRecID) {
                RowWithPartNRecID other = (RowWithPartNRecID)obj;
                if (this.data == null && other.data == null) {
                    return this.checkPartVal(other);
                }
                if (this.data == null) {
                    return false;
                }
                if (this.data.equals((Object)other.data)) {
                    return this.checkPartVal(other);
                }
                return false;
            }
            return false;
        }

        private boolean checkPartVal(RowWithPartNRecID other) {
            if (this.partVal == null && other.partVal == null) {
                return this.checkRecId(other);
            }
            if (this.partVal == null) {
                return false;
            }
            if (this.partVal.equals((Object)other.partVal)) {
                return this.checkRecId(other);
            }
            return false;
        }

        private boolean checkRecId(RowWithPartNRecID other) {
            if (this.recId == null && other.recId == null) {
                return true;
            }
            if (this.recId == null) {
                return false;
            }
            return this.recId.equals((Object)other.recId);
        }

        public int compareTo(Row row) {
            RowWithPartNRecID other = (RowWithPartNRecID)row;
            if (this.recId == null && other.recId == null) {
                return this.comparePartVal(other);
            }
            if (this.recId == null) {
                return -1;
            }
            int rc = this.recId.compareTo(other.recId);
            if (rc == 0) {
                return this.comparePartVal(other);
            }
            return rc;
        }

        private int comparePartVal(RowWithPartNRecID other) {
            if (this.partVal == null && other.partVal == null) {
                return this.compareData(other);
            }
            if (this.partVal == null) {
                return -1;
            }
            int rc = this.partVal.compareTo((BinaryComparable)other.partVal);
            if (rc == 0) {
                return this.compareData(other);
            }
            return rc;
        }

        private int compareData(RowWithPartNRecID other) {
            if (this.data == null && other.data == null) {
                return 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.compareTo((BinaryComparable)other.data);
        }
    }

    public static interface Row
    extends WritableComparable<Row> {
        public Row clone() throws CloneNotSupportedException;
    }
}

