/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.TextRecordReader;
import org.apache.hadoop.hive.ql.exec.TextRecordWriter;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.TextInputFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecDriver {
    static QueryState queryState;
    static HiveConf conf;
    private static final String TMPDIR;
    private static final Logger LOG;
    private static final Path tmppath;
    private static Hive db;
    private static FileSystem fs;
    private static CompilationOpContext ctx;
    MapredWork mr;

    @Before
    public void setUp() {
        this.mr = PlanUtils.getMapRedWork();
        ctx = new CompilationOpContext();
    }

    public static void addMapWork(MapredWork mr, Table tbl, String alias, Operator<?> work) {
        mr.getMapWork().addMapWork(tbl.getDataLocation(), alias, work, new PartitionDesc(Utilities.getTableDesc((Table)tbl), null));
    }

    private static void fileDiff(String datafile, String testdir) throws Exception {
        String testFileDir = conf.get("test.data.files");
        Path diTest = new Path(tmppath, testdir);
        if (!fs.exists(diTest)) {
            throw new RuntimeException(TMPDIR + File.separator + testdir + " does not exist");
        }
        if (!ShimLoader.getHadoopShims().isDirectory(fs.getFileStatus(diTest))) {
            throw new RuntimeException(TMPDIR + File.separator + testdir + " is not a directory");
        }
        FileInputStream fiGold = new FileInputStream(new File(testFileDir, datafile));
        FSDataInputStream fiTest = fs.open(fs.listStatus(diTest)[0].getPath());
        if (!Utilities.contentsEqual((InputStream)fiGold, (InputStream)fiTest, (boolean)false)) {
            LOG.error(diTest.toString() + " does not match " + datafile);
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    private FilterDesc getTestFilterDesc(String column) throws Exception {
        ArrayList<ExprNodeColumnDesc> children1 = new ArrayList<ExprNodeColumnDesc>();
        children1.add(new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, column, "", false));
        ExprNodeGenericFuncDesc lhs = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, FunctionRegistry.getFunctionInfo((String)"double").getGenericUDF(), children1);
        ArrayList<ExprNodeConstantDesc> children2 = new ArrayList<ExprNodeConstantDesc>();
        children2.add(new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (Object)100L));
        ExprNodeGenericFuncDesc rhs = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, FunctionRegistry.getFunctionInfo((String)"double").getGenericUDF(), children2);
        ArrayList<ExprNodeGenericFuncDesc> children3 = new ArrayList<ExprNodeGenericFuncDesc>();
        children3.add(lhs);
        children3.add(rhs);
        ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getFunctionInfo((String)"<").getGenericUDF(), children3);
        return new FilterDesc((ExprNodeDesc)desc, false);
    }

    private void populateMapPlan1(Table src) throws Exception {
        Operator op2 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)new FileSinkDesc(new Path(TMPDIR + File.separator + "mapplan1.out"), Utilities.defaultTd, true));
        Operator op1 = OperatorFactory.get((OperatorDesc)this.getTestFilterDesc("key"), (Operator)op2, (Operator[])new Operator[0]);
        TestExecDriver.addMapWork(this.mr, src, "a", op1);
    }

    private void populateMapPlan2(Table src) throws Exception {
        Operator op3 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)new FileSinkDesc(new Path(TMPDIR + File.separator + "mapplan2.out"), Utilities.defaultTd, false));
        Operator op2 = OperatorFactory.get((OperatorDesc)new ScriptDesc("cat", PlanUtils.getDefaultTableDesc((String)"9", (String)"key,value"), TextRecordWriter.class, PlanUtils.getDefaultTableDesc((String)"9", (String)"key,value"), TextRecordReader.class, TextRecordReader.class, PlanUtils.getDefaultTableDesc((String)"9", (String)"key")), (Operator)op3, (Operator[])new Operator[0]);
        Operator op1 = OperatorFactory.get((OperatorDesc)this.getTestFilterDesc("key"), (Operator)op2, (Operator[])new Operator[0]);
        TestExecDriver.addMapWork(this.mr, src, "a", op1);
    }

    private void populateMapRedPlan1(Table src) throws SemanticException {
        ArrayList<CallSite> outputColumns = new ArrayList<CallSite>();
        for (int i = 0; i < 2; ++i) {
            outputColumns.add((CallSite)((Object)("_col" + i)));
        }
        Operator op1 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)PlanUtils.getReduceSinkDesc((List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("key")}), (List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("value")}), outputColumns, (boolean)true, (int)-1, (int)1, (int)-1, (AcidUtils.Operation)AcidUtils.Operation.NOT_ACID, (NullOrdering)NullOrdering.NULLS_LAST));
        TestExecDriver.addMapWork(this.mr, src, "a", op1);
        ReduceWork rWork = new ReduceWork();
        rWork.setNumReduceTasks(Integer.valueOf(1));
        rWork.setKeyDesc(((ReduceSinkDesc)op1.getConf()).getKeySerializeInfo());
        rWork.getTagToValueDesc().add(((ReduceSinkDesc)op1.getConf()).getValueSerializeInfo());
        this.mr.setReduceWork(rWork);
        Operator op3 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)new FileSinkDesc(new Path(TMPDIR + File.separator + "mapredplan1.out"), Utilities.defaultTd, false));
        ArrayList<ExprNodeColumnDesc> cols = new ArrayList<ExprNodeColumnDesc>();
        cols.add(TestExecDriver.getStringColumn(Utilities.ReduceField.VALUE.toString() + "." + (String)outputColumns.get(1)));
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(HiveConf.getColumnInternalName((int)2));
        Operator op2 = OperatorFactory.get((OperatorDesc)new SelectDesc(cols, colNames), (Operator)op3, (Operator[])new Operator[0]);
        rWork.setReducer(op2);
    }

    private void populateMapRedPlan2(Table src) throws Exception {
        ArrayList<CallSite> outputColumns = new ArrayList<CallSite>();
        for (int i = 0; i < 2; ++i) {
            outputColumns.add((CallSite)((Object)("_col" + i)));
        }
        Operator op1 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)PlanUtils.getReduceSinkDesc((List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("key")}), (List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("key"), TestExecDriver.getStringColumn("value")}), outputColumns, (boolean)false, (int)-1, (int)1, (int)-1, (AcidUtils.Operation)AcidUtils.Operation.NOT_ACID, (NullOrdering)NullOrdering.NULLS_LAST));
        TestExecDriver.addMapWork(this.mr, src, "a", op1);
        ReduceWork rWork = new ReduceWork();
        rWork.setNumReduceTasks(Integer.valueOf(1));
        rWork.setKeyDesc(((ReduceSinkDesc)op1.getConf()).getKeySerializeInfo());
        rWork.getTagToValueDesc().add(((ReduceSinkDesc)op1.getConf()).getValueSerializeInfo());
        this.mr.setReduceWork(rWork);
        Operator op4 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)new FileSinkDesc(new Path(TMPDIR + File.separator + "mapredplan2.out"), Utilities.defaultTd, false));
        Operator op3 = OperatorFactory.get((OperatorDesc)this.getTestFilterDesc("0"), (Operator)op4, (Operator[])new Operator[0]);
        ArrayList<ExprNodeColumnDesc> cols = new ArrayList<ExprNodeColumnDesc>();
        cols.add(TestExecDriver.getStringColumn(Utilities.ReduceField.KEY + ".reducesinkkey0"));
        cols.add(TestExecDriver.getStringColumn(Utilities.ReduceField.VALUE.toString() + "." + (String)outputColumns.get(1)));
        Operator op2 = OperatorFactory.get((OperatorDesc)new SelectDesc(cols, outputColumns), (Operator)op3, (Operator[])new Operator[0]);
        rWork.setReducer(op2);
    }

    private void populateMapRedPlan3(Table src, Table src2) throws SemanticException {
        ArrayList<CallSite> outputColumns = new ArrayList<CallSite>();
        for (int i = 0; i < 2; ++i) {
            outputColumns.add((CallSite)((Object)("_col" + i)));
        }
        Operator op1 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)PlanUtils.getReduceSinkDesc((List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("key")}), (List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("value")}), outputColumns, (boolean)true, (int)Byte.valueOf((byte)0).byteValue(), (int)1, (int)-1, (AcidUtils.Operation)AcidUtils.Operation.NOT_ACID, (NullOrdering)NullOrdering.NULLS_LAST));
        TestExecDriver.addMapWork(this.mr, src, "a", op1);
        Operator op2 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)PlanUtils.getReduceSinkDesc((List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("key")}), (List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("key")}), outputColumns, (boolean)true, (int)Byte.valueOf((byte)1).byteValue(), (int)Integer.MAX_VALUE, (int)-1, (AcidUtils.Operation)AcidUtils.Operation.NOT_ACID, (NullOrdering)NullOrdering.NULLS_LAST));
        TestExecDriver.addMapWork(this.mr, src2, "b", op2);
        ReduceWork rWork = new ReduceWork();
        rWork.setNumReduceTasks(Integer.valueOf(1));
        rWork.setNeedsTagging(true);
        rWork.setKeyDesc(((ReduceSinkDesc)op1.getConf()).getKeySerializeInfo());
        rWork.getTagToValueDesc().add(((ReduceSinkDesc)op1.getConf()).getValueSerializeInfo());
        this.mr.setReduceWork(rWork);
        rWork.getTagToValueDesc().add(((ReduceSinkDesc)op2.getConf()).getValueSerializeInfo());
        Operator op4 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)new FileSinkDesc(new Path(TMPDIR + File.separator + "mapredplan3.out"), Utilities.defaultTd, false));
        Operator op5 = OperatorFactory.get((OperatorDesc)new SelectDesc((List)Utilities.makeList((Object[])new Object[]{new ExprNodeFieldDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (ExprNodeDesc)new ExprNodeColumnDesc(TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo), Utilities.ReduceField.VALUE.toString(), "", false), "0", Boolean.valueOf(false))}), (List)Utilities.makeList((Object[])new Object[]{outputColumns.get(0)})), (Operator)op4, (Operator[])new Operator[0]);
        rWork.setReducer(op5);
    }

    private void populateMapRedPlan4(Table src) throws SemanticException {
        ArrayList<CallSite> outputColumns = new ArrayList<CallSite>();
        for (int i = 0; i < 2; ++i) {
            outputColumns.add((CallSite)((Object)("_col" + i)));
        }
        Operator op1 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)PlanUtils.getReduceSinkDesc((List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("tkey")}), (List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("tkey"), TestExecDriver.getStringColumn("tvalue")}), outputColumns, (boolean)false, (int)-1, (int)1, (int)-1, (AcidUtils.Operation)AcidUtils.Operation.NOT_ACID, (NullOrdering)NullOrdering.NULLS_LAST));
        Operator op0 = OperatorFactory.get((OperatorDesc)new ScriptDesc("cat", PlanUtils.getDefaultTableDesc((String)"9", (String)"key,value"), TextRecordWriter.class, PlanUtils.getDefaultTableDesc((String)"9", (String)"tkey,tvalue"), TextRecordReader.class, TextRecordReader.class, PlanUtils.getDefaultTableDesc((String)"9", (String)"key")), (Operator)op1, (Operator[])new Operator[0]);
        Operator op4 = OperatorFactory.get((OperatorDesc)new SelectDesc((List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("key"), TestExecDriver.getStringColumn("value")}), outputColumns), (Operator)op0, (Operator[])new Operator[0]);
        TestExecDriver.addMapWork(this.mr, src, "a", op4);
        ReduceWork rWork = new ReduceWork();
        rWork.setKeyDesc(((ReduceSinkDesc)op1.getConf()).getKeySerializeInfo());
        rWork.getTagToValueDesc().add(((ReduceSinkDesc)op1.getConf()).getValueSerializeInfo());
        rWork.setNumReduceTasks(Integer.valueOf(1));
        this.mr.setReduceWork(rWork);
        Operator op3 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)new FileSinkDesc(new Path(TMPDIR + File.separator + "mapredplan4.out"), Utilities.defaultTd, false));
        ArrayList<ExprNodeColumnDesc> cols = new ArrayList<ExprNodeColumnDesc>();
        cols.add(TestExecDriver.getStringColumn(Utilities.ReduceField.KEY + ".reducesinkkey0"));
        cols.add(TestExecDriver.getStringColumn(Utilities.ReduceField.VALUE.toString() + "." + (String)outputColumns.get(1)));
        Operator op2 = OperatorFactory.get((OperatorDesc)new SelectDesc(cols, outputColumns), (Operator)op3, (Operator[])new Operator[0]);
        rWork.setReducer(op2);
    }

    public static ExprNodeColumnDesc getStringColumn(String columnName) {
        return new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, columnName, "", false);
    }

    private void populateMapRedPlan5(Table src) throws SemanticException {
        ArrayList<CallSite> outputColumns = new ArrayList<CallSite>();
        for (int i = 0; i < 2; ++i) {
            outputColumns.add((CallSite)((Object)("_col" + i)));
        }
        Operator op0 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)PlanUtils.getReduceSinkDesc((List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("0")}), (List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("0"), TestExecDriver.getStringColumn("1")}), outputColumns, (boolean)false, (int)-1, (int)1, (int)-1, (AcidUtils.Operation)AcidUtils.Operation.NOT_ACID, (NullOrdering)NullOrdering.NULLS_LAST));
        Operator op4 = OperatorFactory.get((OperatorDesc)new SelectDesc((List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("key"), TestExecDriver.getStringColumn("value")}), outputColumns), (Operator)op0, (Operator[])new Operator[0]);
        TestExecDriver.addMapWork(this.mr, src, "a", op4);
        ReduceWork rWork = new ReduceWork();
        this.mr.setReduceWork(rWork);
        rWork.setNumReduceTasks(Integer.valueOf(1));
        rWork.setKeyDesc(((ReduceSinkDesc)op0.getConf()).getKeySerializeInfo());
        rWork.getTagToValueDesc().add(((ReduceSinkDesc)op0.getConf()).getValueSerializeInfo());
        Operator op3 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)new FileSinkDesc(new Path(TMPDIR + File.separator + "mapredplan5.out"), Utilities.defaultTd, false));
        ArrayList<ExprNodeColumnDesc> cols = new ArrayList<ExprNodeColumnDesc>();
        cols.add(TestExecDriver.getStringColumn(Utilities.ReduceField.KEY + ".reducesinkkey0"));
        cols.add(TestExecDriver.getStringColumn(Utilities.ReduceField.VALUE.toString() + "." + (String)outputColumns.get(1)));
        Operator op2 = OperatorFactory.get((OperatorDesc)new SelectDesc(cols, outputColumns), (Operator)op3, (Operator[])new Operator[0]);
        rWork.setReducer(op2);
    }

    private void populateMapRedPlan6(Table src) throws Exception {
        ArrayList<CallSite> outputColumns = new ArrayList<CallSite>();
        for (int i = 0; i < 2; ++i) {
            outputColumns.add((CallSite)((Object)("_col" + i)));
        }
        Operator op1 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)PlanUtils.getReduceSinkDesc((List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("tkey")}), (List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("tkey"), TestExecDriver.getStringColumn("tvalue")}), outputColumns, (boolean)false, (int)-1, (int)1, (int)-1, (AcidUtils.Operation)AcidUtils.Operation.NOT_ACID, (NullOrdering)NullOrdering.NULLS_LAST));
        Operator op0 = OperatorFactory.get((OperatorDesc)new ScriptDesc("'cat'", PlanUtils.getDefaultTableDesc((String)"9", (String)"tkey,tvalue"), TextRecordWriter.class, PlanUtils.getDefaultTableDesc((String)"9", (String)"tkey,tvalue"), TextRecordReader.class, TextRecordReader.class, PlanUtils.getDefaultTableDesc((String)"9", (String)"key")), (Operator)op1, (Operator[])new Operator[0]);
        Operator op4 = OperatorFactory.get((OperatorDesc)new SelectDesc((List)Utilities.makeList((Object[])new Object[]{TestExecDriver.getStringColumn("key"), TestExecDriver.getStringColumn("value")}), outputColumns), (Operator)op0, (Operator[])new Operator[0]);
        TestExecDriver.addMapWork(this.mr, src, "a", op4);
        ReduceWork rWork = new ReduceWork();
        this.mr.setReduceWork(rWork);
        rWork.setNumReduceTasks(Integer.valueOf(1));
        rWork.setKeyDesc(((ReduceSinkDesc)op1.getConf()).getKeySerializeInfo());
        rWork.getTagToValueDesc().add(((ReduceSinkDesc)op1.getConf()).getValueSerializeInfo());
        Operator op3 = OperatorFactory.get((CompilationOpContext)ctx, (OperatorDesc)new FileSinkDesc(new Path(TMPDIR + File.separator + "mapredplan6.out"), Utilities.defaultTd, false));
        Operator op2 = OperatorFactory.get((OperatorDesc)this.getTestFilterDesc("0"), (Operator)op3, (Operator[])new Operator[0]);
        ArrayList<ExprNodeColumnDesc> cols = new ArrayList<ExprNodeColumnDesc>();
        cols.add(TestExecDriver.getStringColumn(Utilities.ReduceField.KEY + ".reducesinkkey0"));
        cols.add(TestExecDriver.getStringColumn(Utilities.ReduceField.VALUE.toString() + "." + (String)outputColumns.get(1)));
        Operator op5 = OperatorFactory.get((OperatorDesc)new SelectDesc(cols, outputColumns), (Operator)op2, (Operator[])new Operator[0]);
        rWork.setReducer(op5);
    }

    private void executePlan() throws Exception {
        String testName = new Exception().getStackTrace()[1].getMethodName();
        MapRedTask mrtask = new MapRedTask();
        TaskQueue taskQueue = new TaskQueue();
        mrtask.setWork((Serializable)this.mr);
        mrtask.initialize(queryState, null, taskQueue, null);
        int exitVal = mrtask.execute();
        if (exitVal != 0) {
            LOG.error(testName + " execution failed with exit status: " + exitVal);
            Assert.assertEquals((Object)true, (Object)false);
        }
        LOG.info(testName + " execution completed successfully");
    }

    @Test
    public void testMapPlan1() throws Exception {
        LOG.info("Beginning testMapPlan1");
        this.populateMapPlan1(db.getTable("default", "src"));
        this.executePlan();
        TestExecDriver.fileDiff("lt100.txt.deflate", "mapplan1.out");
    }

    @Test
    public void testMapPlan2() throws Exception {
        LOG.info("Beginning testMapPlan2");
        this.populateMapPlan2(db.getTable("default", "src"));
        this.executePlan();
        TestExecDriver.fileDiff("lt100.txt", "mapplan2.out");
    }

    @Test
    public void testMapRedPlan1() throws Exception {
        LOG.info("Beginning testMapRedPlan1");
        this.populateMapRedPlan1(db.getTable("default", "src"));
        this.executePlan();
        TestExecDriver.fileDiff("kv1.val.sorted.txt", "mapredplan1.out");
    }

    @Test
    public void testMapRedPlan2() throws Exception {
        LOG.info("Beginning testMapPlan2");
        this.populateMapRedPlan2(db.getTable("default", "src"));
        this.executePlan();
        TestExecDriver.fileDiff("lt100.sorted.txt", "mapredplan2.out");
    }

    @Test
    public void testMapRedPlan3() throws Exception {
        LOG.info("Beginning testMapPlan3");
        this.populateMapRedPlan3(db.getTable("default", "src"), db.getTable("default", "src2"));
        this.executePlan();
        TestExecDriver.fileDiff("kv1kv2.cogroup.txt", "mapredplan3.out");
    }

    @Test
    public void testMapRedPlan4() throws Exception {
        LOG.info("Beginning testMapPlan4");
        this.populateMapRedPlan4(db.getTable("default", "src"));
        this.executePlan();
        TestExecDriver.fileDiff("kv1.string-sorted.txt", "mapredplan4.out");
    }

    @Test
    public void testMapRedPlan5() throws Exception {
        LOG.info("Beginning testMapPlan5");
        this.populateMapRedPlan5(db.getTable("default", "src"));
        this.executePlan();
        TestExecDriver.fileDiff("kv1.string-sorted.txt", "mapredplan5.out");
    }

    @Test
    public void testMapRedPlan6() throws Exception {
        LOG.info("Beginning testMapPlan6");
        this.populateMapRedPlan6(db.getTable("default", "src"));
        this.executePlan();
        TestExecDriver.fileDiff("lt100.sorted.txt", "mapredplan6.out");
    }

    static {
        LOG = LoggerFactory.getLogger(TestExecDriver.class);
        ctx = null;
        try {
            queryState = new QueryState.Builder().withHiveConf(new HiveConf(ExecDriver.class)).build();
            conf = queryState.getConf();
            conf.set(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, "mr");
            conf.setBoolVar(HiveConf.ConfVars.SUBMIT_VIA_CHILD, true);
            conf.setBoolVar(HiveConf.ConfVars.SUBMIT_LOCAL_TASK_VIA_CHILD, true);
            conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
            SessionState.start((HiveConf)conf);
            TMPDIR = System.getProperty("test.tmp.dir");
            tmppath = new Path(TMPDIR);
            fs = FileSystem.get((Configuration)conf);
            if (fs.exists(tmppath) && !ShimLoader.getHadoopShims().isDirectory(fs.getFileStatus(tmppath))) {
                throw new RuntimeException(TMPDIR + " exists but is not a directory");
            }
            if (!fs.exists(tmppath) && !fs.mkdirs(tmppath)) {
                throw new RuntimeException("Could not make scratch directory " + TMPDIR);
            }
            LOG.info("Directory of actual files: " + tmppath);
            for (Object one : Utilities.makeList((Object[])new Object[]{"mapplan1.out", "mapplan2.out", "mapredplan1.out", "mapredplan2.out", "mapredplan3.out", "mapredplan4.out", "mapredplan5.out", "mapredplan6.out"})) {
                Path onedir = new Path(tmppath, (String)one);
                if (!fs.exists(onedir)) continue;
                fs.delete(onedir, true);
            }
            int i = 0;
            Path[] hadoopDataFile = new Path[2];
            String[] testFiles = new String[]{"kv1.txt", "kv2.txt"};
            String testFileDir = new Path(conf.get("test.data.files")).toUri().getPath();
            LOG.info("Directory of expected files: " + testFileDir);
            for (String oneFile : testFiles) {
                Path localDataFile = new Path(testFileDir, oneFile);
                hadoopDataFile[i] = new Path(tmppath, oneFile);
                fs.copyFromLocalFile(false, true, localDataFile, hadoopDataFile[i]);
                ++i;
            }
            i = 0;
            db = Hive.get((HiveConf)conf);
            String[] srctables = new String[]{"src", "src2"};
            LinkedList<String> cols = new LinkedList<String>();
            cols.add("key");
            cols.add("value");
            for (String src : srctables) {
                db.dropTable("default", src, true, true);
                db.createTable(src, cols, null, TextInputFormat.class, HiveIgnoreKeyTextOutputFormat.class);
                db.loadTable(hadoopDataFile[i], src, LoadTableDesc.LoadFileType.KEEP_EXISTING, true, false, false, true, null, 0, false, false);
                ++i;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Encountered throwable", e);
        }
    }
}

