/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.CheckResult;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;

public class PartitionUtil {
    public static Table createPartitionedTable(IMetaStoreClient db, String catName, String dbName, String tableName) throws Exception {
        try {
            db.dropTable(catName, dbName, tableName);
            Table table = new Table();
            table.setCatName(catName);
            table.setDbName(dbName);
            table.setTableName(tableName);
            FieldSchema col1 = new FieldSchema("key", "string", "");
            FieldSchema col2 = new FieldSchema("value", "int", "");
            FieldSchema col3 = new FieldSchema("city", "string", "");
            StorageDescriptor sd = new StorageDescriptor();
            sd.setSerdeInfo(new SerDeInfo());
            sd.setInputFormat(TextInputFormat.class.getCanonicalName());
            sd.setOutputFormat(HiveIgnoreKeyTextOutputFormat.class.getCanonicalName());
            sd.setCols(Arrays.asList(col1, col2));
            table.setPartitionKeys(Arrays.asList(col3));
            table.setSd(sd);
            db.createTable(table);
            return db.getTable(catName, dbName, tableName);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unable to drop and create table " + StatsUtils.getFullyQualifiedTableName((String)dbName, (String)tableName) + " because " + StringUtils.stringifyException((Throwable)exception)));
            throw exception;
        }
    }

    public static void cleanUpTableQuietly(IMetaStoreClient db, String catName, String dbName, String tableName) {
        try {
            db.dropTable(catName, dbName, tableName);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)exception)));
        }
    }

    public static Set<CheckResult.PartitionResult> createPartsNotInMs(int numOfParts) {
        HashSet<CheckResult.PartitionResult> partsNotInMs = new HashSet<CheckResult.PartitionResult>();
        for (int i = 0; i < numOfParts; ++i) {
            CheckResult.PartitionResult result = new CheckResult.PartitionResult();
            result.setPartitionName("city=dummyCity_" + i);
            result.setTableName("dummyTable");
            partsNotInMs.add(result);
        }
        return partsNotInMs;
    }

    public static void addPartitions(IMetaStoreClient db, String dbName, String tableName, String location, HiveConf hiveConf, int numPartitions) throws Exception {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (int i = 0; i < numPartitions; ++i) {
            partitions.add(PartitionUtil.buildPartition(dbName, tableName, String.valueOf(i), location + "/city=" + i, hiveConf));
        }
        db.add_partitions(partitions, true, true);
    }

    protected static Partition buildPartition(String dbName, String tableName, String value, String location, HiveConf hiveConf) throws MetaException {
        return ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(dbName).setTableName(tableName).addValue(value).addCol("test_id", "int", "test col id")).addCol("test_value", "string", "test col value")).setLocation(location)).build((Configuration)hiveConf);
    }
}

