/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.hive.ql.exec.ParsedOutputFileName;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.junit.Assert;
import org.junit.Test;

public class ParsedOutputFileNameTest {
    @Test
    public void testStandardNoAttemptId() {
        ParsedOutputFileName p = ParsedOutputFileName.parse((String)"00001");
        Assert.assertTrue((boolean)p.matches());
        Assert.assertNull((Object)p.getTaskIdPrefix());
        Assert.assertEquals((Object)"00001", (Object)p.getTaskId());
        Assert.assertEquals((Object)"00001", (Object)p.getPrefixedTaskId());
        Assert.assertNull((Object)p.getAttemptId());
        Assert.assertNull((Object)p.getCopyIndex());
        Assert.assertFalse((boolean)p.isCopyFile());
        Assert.assertNull((Object)p.getSuffix());
    }

    @Test
    public void testStandard() throws Exception {
        ParsedOutputFileName p = ParsedOutputFileName.parse((String)"00001_02");
        Assert.assertTrue((boolean)p.matches());
        Assert.assertNull((Object)p.getTaskIdPrefix());
        Assert.assertEquals((Object)"00001", (Object)p.getTaskId());
        Assert.assertEquals((Object)"00001", (Object)p.getPrefixedTaskId());
        Assert.assertEquals((Object)"02", (Object)p.getAttemptId());
        Assert.assertNull((Object)p.getCopyIndex());
        Assert.assertFalse((boolean)p.isCopyFile());
        Assert.assertNull((Object)p.getSuffix());
        Assert.assertEquals((Object)"00001_02_copy_3", (Object)p.makeFilenameWithCopyIndex(3));
    }

    @Test
    public void testStandardPrefix() throws Exception {
        ParsedOutputFileName p = ParsedOutputFileName.parse((String)"(prefix)00001_02");
        Assert.assertTrue((boolean)p.matches());
        Assert.assertEquals((Object)"(prefix)", (Object)p.getTaskIdPrefix());
        Assert.assertEquals((Object)"00001", (Object)p.getTaskId());
        Assert.assertEquals((Object)"(prefix)00001", (Object)p.getPrefixedTaskId());
        Assert.assertEquals((Object)"02", (Object)p.getAttemptId());
        Assert.assertNull((Object)p.getCopyIndex());
        Assert.assertFalse((boolean)p.isCopyFile());
        Assert.assertNull((Object)p.getSuffix());
        Assert.assertEquals((Object)"(prefix)00001_02_copy_3", (Object)p.makeFilenameWithCopyIndex(3));
    }

    @Test
    public void testStandardSuffix() throws Exception {
        ParsedOutputFileName p = ParsedOutputFileName.parse((String)"00001_02.snappy.orc");
        Assert.assertTrue((boolean)p.matches());
        Assert.assertNull((Object)p.getTaskIdPrefix());
        Assert.assertEquals((Object)"00001", (Object)p.getTaskId());
        Assert.assertEquals((Object)"00001", (Object)p.getPrefixedTaskId());
        Assert.assertEquals((Object)"02", (Object)p.getAttemptId());
        Assert.assertNull((Object)p.getCopyIndex());
        Assert.assertFalse((boolean)p.isCopyFile());
        Assert.assertEquals((Object)".snappy.orc", (Object)p.getSuffix());
        Assert.assertEquals((Object)"00001_02_copy_3", (Object)p.makeFilenameWithCopyIndex(3));
    }

    @Test
    public void testPrefixAndSuffix() throws Exception {
        ParsedOutputFileName p = ParsedOutputFileName.parse((String)"tmp_(prefix)00001_02.snappy.orc");
        Assert.assertTrue((boolean)p.matches());
        Assert.assertEquals((Object)"(prefix)", (Object)p.getTaskIdPrefix());
        Assert.assertEquals((Object)"00001", (Object)p.getTaskId());
        Assert.assertEquals((Object)"(prefix)00001", (Object)p.getPrefixedTaskId());
        Assert.assertEquals((Object)"02", (Object)p.getAttemptId());
        Assert.assertNull((Object)p.getCopyIndex());
        Assert.assertFalse((boolean)p.isCopyFile());
        Assert.assertEquals((Object)".snappy.orc", (Object)p.getSuffix());
        Assert.assertEquals((Object)"tmp_(prefix)00001_02_copy_3", (Object)p.makeFilenameWithCopyIndex(3));
    }

    @Test
    public void testCopy() throws Exception {
        ParsedOutputFileName p = ParsedOutputFileName.parse((String)"00001_02_copy_3");
        Assert.assertTrue((boolean)p.matches());
        Assert.assertNull((Object)p.getTaskIdPrefix());
        Assert.assertEquals((Object)"00001", (Object)p.getTaskId());
        Assert.assertEquals((Object)"00001", (Object)p.getPrefixedTaskId());
        Assert.assertEquals((Object)"02", (Object)p.getAttemptId());
        Assert.assertEquals((Object)"3", (Object)p.getCopyIndex());
        Assert.assertTrue((boolean)p.isCopyFile());
        Assert.assertNull((Object)p.getSuffix());
        Assert.assertEquals((Object)"00001_02_copy_4", (Object)p.makeFilenameWithCopyIndex(4));
    }

    @Test
    public void testCopyAllParts() throws Exception {
        ParsedOutputFileName p = ParsedOutputFileName.parse((String)"tmp_(prefix)00001_02_copy_3.snappy.orc");
        Assert.assertTrue((boolean)p.matches());
        Assert.assertEquals((Object)"(prefix)", (Object)p.getTaskIdPrefix());
        Assert.assertEquals((Object)"00001", (Object)p.getTaskId());
        Assert.assertEquals((Object)"(prefix)00001", (Object)p.getPrefixedTaskId());
        Assert.assertEquals((Object)"02", (Object)p.getAttemptId());
        Assert.assertEquals((Object)"3", (Object)p.getCopyIndex());
        Assert.assertTrue((boolean)p.isCopyFile());
        Assert.assertEquals((Object)".snappy.orc", (Object)p.getSuffix());
        Assert.assertEquals((Object)"tmp_(prefix)00001_02_copy_4", (Object)p.makeFilenameWithCopyIndex(4));
    }

    @Test
    public void testNoMatch() {
        ParsedOutputFileName p = ParsedOutputFileName.parse((String)"ZfsLke");
        Assert.assertFalse((boolean)p.matches());
        Assert.assertNull((Object)p.getTaskId());
        Assert.assertNull((Object)p.getPrefixedTaskId());
        Assert.assertNull((Object)p.getTaskIdPrefix());
        Assert.assertNull((Object)p.getAttemptId());
        Assert.assertNull((Object)p.getCopyIndex());
        Assert.assertFalse((boolean)p.isCopyFile());
        Assert.assertNull((Object)p.getSuffix());
        try {
            p.makeFilenameWithCopyIndex(1);
            Assert.fail((String)"Expected HiveException");
        }
        catch (HiveException hiveException) {
            // empty catch block
        }
    }
}

