/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.show;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.table.partition.show.ShowPartitionAnalyzer;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestShowPartitionAnalyzer {
    private HiveConf conf;

    @Before
    public void before() throws Exception {
        this.conf = new HiveConfForTest(this.getClass());
        SessionState.start((HiveConf)this.conf);
    }

    @After
    public void after() throws Exception {
        SessionState.get().close();
    }

    @Test
    public void testGetShowPartitionsFilter() throws Exception {
        ArrayList<FieldSchema> partColumns = new ArrayList<FieldSchema>();
        partColumns.add(new FieldSchema("ds", TypeInfoFactory.dateTypeInfo.getTypeName(), null));
        partColumns.add(new FieldSchema("hr", TypeInfoFactory.intTypeInfo.getTypeName(), null));
        partColumns.add(new FieldSchema("rs", TypeInfoFactory.stringTypeInfo.getTypeName(), null));
        RowResolver rwsch = new RowResolver();
        rwsch.put("tableBar", "ds", new ColumnInfo("ds", (TypeInfo)TypeInfoFactory.dateTypeInfo, null, true));
        rwsch.put("tableBar", "hr", new ColumnInfo("hr", (TypeInfo)TypeInfoFactory.intTypeInfo, null, true));
        rwsch.put("tableBar", "rs", new ColumnInfo("rs", (TypeInfo)TypeInfoFactory.stringTypeInfo, null, true));
        TypeCheckCtx tcCtx = new TypeCheckCtx(rwsch);
        String showPart1 = "show partitions databaseFoo.tableBar where ds > '2010-03-03' and rs <= 421021";
        ASTNode command = ParseUtils.parse((String)showPart1, (Context)new Context((Configuration)this.conf));
        ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)this.genExprNodeByDefault(tcCtx, command);
        ExprNodeGenericFuncDesc child = (ExprNodeGenericFuncDesc)funcDesc.getChildren().get(1);
        Assert.assertEquals((Object)"rs", (Object)((ExprNodeColumnDesc)child.getChildren().get(0)).getColumn());
        Assert.assertEquals((Object)421021, (Object)((ExprNodeConstantDesc)child.getChildren().get(1)).getValue());
        Table table = new Table(new org.apache.hadoop.hive.metastore.api.Table("databaseFoo", "tableBar", "foo", 1, 1, -1, null, partColumns, null, null, null, TableType.MANAGED_TABLE.name()));
        ShowPartitionAnalyzer analyzer = new ShowPartitionAnalyzer(QueryState.getNewQueryState((HiveConf)new HiveConf(), null));
        funcDesc = (ExprNodeGenericFuncDesc)analyzer.getShowPartitionsFilter(table, command);
        Assert.assertTrue((funcDesc.getChildren().size() == 2 ? 1 : 0) != 0);
        child = (ExprNodeGenericFuncDesc)funcDesc.getChildren().get(0);
        Assert.assertEquals((Object)"ds", (Object)((ExprNodeColumnDesc)child.getChildren().get(0)).getColumn());
        Assert.assertEquals((Object)TypeInfoFactory.dateTypeInfo, (Object)((ExprNodeDesc)child.getChildren().get(0)).getTypeInfo());
        Assert.assertEquals((Object)((ExprNodeDesc)child.getChildren().get(0)).getTypeString(), (Object)((ExprNodeDesc)child.getChildren().get(1)).getTypeString());
        child = (ExprNodeGenericFuncDesc)funcDesc.getChildren().get(1);
        Assert.assertEquals((Object)"rs", (Object)((ExprNodeColumnDesc)child.getChildren().get(0)).getColumn());
        Assert.assertEquals((Object)TypeInfoFactory.stringTypeInfo, (Object)((ExprNodeDesc)child.getChildren().get(0)).getTypeInfo());
        Assert.assertEquals((Object)((ExprNodeDesc)child.getChildren().get(0)).getTypeString(), (Object)((ExprNodeDesc)child.getChildren().get(1)).getTypeString());
        String showPart2 = "show partitions databaseFoo.tableBar where hr > 'a123' and hr <= '2346b'";
        command = ParseUtils.parse((String)showPart2, (Context)new Context((Configuration)this.conf));
        try {
            analyzer.getShowPartitionsFilter(table, command);
            Assert.fail((String)"show throw semantic exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot convert to int from string"));
        }
        funcDesc = (ExprNodeGenericFuncDesc)this.genExprNodeByDefault(tcCtx, command);
        ArrayList<String> partColumnNames = new ArrayList<String>();
        ArrayList<PrimitiveTypeInfo> partColumnTypeInfos = new ArrayList<PrimitiveTypeInfo>();
        for (FieldSchema fs : partColumns) {
            partColumnNames.add(fs.getName());
            partColumnTypeInfos.add(TypeInfoFactory.getPrimitiveTypeInfo((String)fs.getType()));
        }
        LinkedList<String> partNames = new LinkedList<String>();
        partNames.add("ds=2010-11-10/hr=12/rs=NA");
        partNames.add("ds=2010-11-10/hr=13/rs=AS");
        partNames.add("ds=2010-11-10/hr=23/rs=AE");
        PartitionPruner.prunePartitionNames(partColumnNames, partColumnTypeInfos, (ExprNodeDesc)funcDesc, (String)"__HIVE_DEFAULT_PARTITION__", partNames);
        Assert.assertTrue((boolean)partNames.contains("ds=2010-11-10/hr=12/rs=NA"));
        Assert.assertTrue((boolean)partNames.contains("ds=2010-11-10/hr=13/rs=AS"));
        Assert.assertTrue((boolean)partNames.contains("ds=2010-11-10/hr=23/rs=AE"));
    }

    private ExprNodeDesc genExprNodeByDefault(TypeCheckCtx tcCtx, ASTNode command) throws Exception {
        for (int childIndex = 0; childIndex < command.getChildCount(); ++childIndex) {
            ASTNode astChild = (ASTNode)command.getChild(childIndex);
            if (astChild.getType() != 1316) continue;
            ASTNode conds = (ASTNode)astChild.getChild(0);
            Map nodeOutputs = ExprNodeTypeCheck.genExprNode((ASTNode)conds, (TypeCheckCtx)tcCtx);
            return (ExprNodeDesc)nodeOutputs.get(conds);
        }
        return null;
    }
}

