/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.cleanup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.cleanup.CleanupService;
import org.apache.hadoop.hive.ql.cleanup.EventualCleanupService;
import org.apache.hadoop.hive.ql.cleanup.SyncCleanupService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestCleanupService {
    private static final String TEMP_DIR = TestCleanupService.class.getName() + "-tempdir";
    private CleanupService cleanupService;

    @After
    public void tearDown() throws IOException {
        if (this.cleanupService != null) {
            this.cleanupService.shutdownNow();
        }
        Path p = new Path(TEMP_DIR);
        FileSystem fs = p.getFileSystem(new Configuration());
        fs.delete(p, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEventualCleanupService_throwsWhenMisconfigured() {
        this.cleanupService = new EventualCleanupService(10, 4);
    }

    @Test
    public void testEventualCleanupService_deletesManyFiles() throws IOException, InterruptedException {
        this.testDeleteManyFiles((CleanupService)new EventualCleanupService(4, 1000), 1000);
    }

    @Test
    public void testEventualCleanupService_deletesManyFilesWithQueueSize4() throws IOException, InterruptedException {
        this.testDeleteManyFiles((CleanupService)new EventualCleanupService(4, 4), 100);
    }

    @Test
    public void testSyncCleanupService_deletesManyFiles() throws IOException, InterruptedException {
        this.testDeleteManyFiles((CleanupService)SyncCleanupService.INSTANCE, 10);
    }

    @Test
    public void testEventualCleanupService_finishesCleanupBeforeExit() throws IOException, InterruptedException {
        EventualCleanupService cleanupService = new EventualCleanupService(4, 400);
        this.testDeleteManyFiles((CleanupService)cleanupService, 400, true);
        Assert.assertTrue((boolean)cleanupService.await(1L, TimeUnit.MINUTES));
    }

    private void testDeleteManyFiles(CleanupService cleanupService, int n) throws IOException, InterruptedException {
        this.testDeleteManyFiles(cleanupService, n, false);
    }

    private void testDeleteManyFiles(CleanupService cleanupService, int n, boolean shutdownAfterQueueing) throws IOException, InterruptedException {
        this.cleanupService = cleanupService;
        Configuration conf = new Configuration();
        cleanupService.start();
        Collection<Path> files = this.createManyFiles(n);
        for (Path p : files) {
            cleanupService.deleteRecursive(p, p.getFileSystem(conf));
        }
        if (shutdownAfterQueueing) {
            cleanupService.shutdown();
        }
        this.assertTrueEventually(() -> {
            try {
                for (Path p : files) {
                    FileSystem fs = p.getFileSystem(conf);
                    Assert.assertNotNull((Object)fs);
                    Assert.assertFalse((String)(p + " should not exist"), (boolean)fs.exists(p));
                }
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    private Path createFile(String name) throws IOException {
        Path p = new Path(TEMP_DIR, name);
        FileSystem fs = p.getFileSystem(new Configuration());
        fs.create(p);
        return p;
    }

    private Collection<Path> createManyFiles(int n) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        for (int i = 0; i < n; ++i) {
            files.add(this.createFile("many_" + i));
        }
        return files;
    }

    private void assertTrueEventually(AssertTask assertTask) throws InterruptedException {
        this.assertTrueEventually(assertTask, 100000);
    }

    private void assertTrueEventually(AssertTask assertTask, int timeoutMillis) throws InterruptedException {
        long endTime = System.currentTimeMillis() + (long)timeoutMillis;
        AssertionError assertionError = null;
        while (System.currentTimeMillis() < endTime) {
            try {
                assertTask.call();
                return;
            }
            catch (AssertionError e) {
                assertionError = e;
                Thread.sleep(50L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw assertionError;
    }

    private static interface AssertTask {
        public void call() throws AssertionError;
    }
}

