/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnNoBuckets
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnNoBuckets.class);
    private static final String NO_BUCKETS_TBL_NAME = "nobuckets";
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnNoBuckets.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    @Rule
    public TestName testName = new TestName();

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.setUpInternal();
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
    }

    @Test
    public void testNoBuckets() throws Exception {
        int[][] sourceVals1 = new int[][]{{0, 0, 0}, {3, 3, 3}};
        int[][] sourceVals2 = new int[][]{{1, 1, 1}, {2, 2, 2}};
        this.dropTables(NO_BUCKETS_TBL_NAME, "tmp");
        this.runStatementOnDriver("create table tmp (c1 integer, c2 integer, c3 integer) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into tmp " + TestTxnNoBuckets.makeValuesClause(sourceVals1));
        this.runStatementOnDriver("insert into tmp " + TestTxnNoBuckets.makeValuesClause(sourceVals2));
        this.runStatementOnDriver("create table nobuckets (c1 integer, c2 integer, c3 integer) stored as orc tblproperties('transactional'='true', 'transactional_properties'='default')");
        String stmt = String.format("insert into %s select * from tmp", NO_BUCKETS_TBL_NAME);
        this.runStatementOnDriver(stmt);
        List<String> rs = this.runStatementOnDriver(String.format("select ROW__ID, c1, c2, c3, INPUT__FILE__NAME from %s order by ROW__ID", NO_BUCKETS_TBL_NAME));
        Assert.assertEquals((String)"", (long)4L, (long)rs.size());
        LOG.warn("after insert");
        for (String string : rs) {
            LOG.warn(string);
        }
        Assert.assertTrue((String)rs.get(0), (boolean)rs.get(0).startsWith("{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t0\t0\t0\t"));
        Assert.assertTrue((String)rs.get(0), (boolean)rs.get(0).endsWith("nobuckets/delta_0000001_0000001_0000/bucket_00000_0"));
        Assert.assertTrue((String)rs.get(1), (boolean)rs.get(1).startsWith("{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t3\t3\t"));
        Assert.assertTrue((String)rs.get(1), (boolean)rs.get(1).endsWith("nobuckets/delta_0000001_0000001_0000/bucket_00000_0"));
        Assert.assertTrue((String)rs.get(2), (boolean)rs.get(2).startsWith("{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t1\t1\t1\t"));
        Assert.assertTrue((String)rs.get(2), (boolean)rs.get(2).endsWith("nobuckets/delta_0000001_0000001_0000/bucket_00001_0"));
        Assert.assertTrue((String)rs.get(3), (boolean)rs.get(3).startsWith("{\"writeid\":1,\"bucketid\":536936448,\"rowid\":1}\t2\t2\t2\t"));
        Assert.assertTrue((String)rs.get(3), (boolean)rs.get(3).endsWith("nobuckets/delta_0000001_0000001_0000/bucket_00001_0"));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_EXPLAIN_USER, false);
        rs = this.runStatementOnDriver(String.format("explain  update %s set c3 = 17 where c3 in(0,1)", NO_BUCKETS_TBL_NAME));
        LOG.warn("Query Plan: ");
        for (String string : rs) {
            LOG.warn(string);
        }
        this.runStatementOnDriver(String.format("update %s set c3 = 17 where c3 in(0,1)", NO_BUCKETS_TBL_NAME));
        rs = this.runStatementOnDriver(String.format("select ROW__ID, c1, c2, c3, INPUT__FILE__NAME from %s order by INPUT__FILE__NAME, ROW__ID", NO_BUCKETS_TBL_NAME));
        LOG.warn("after update");
        for (String string : rs) {
            LOG.warn(string);
        }
        Assert.assertTrue((String)rs.get(0), (boolean)rs.get(0).startsWith("{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t3\t3\t"));
        Assert.assertTrue((String)rs.get(0), (boolean)rs.get(0).endsWith("nobuckets/delta_0000001_0000001_0000/bucket_00000_0"));
        Assert.assertTrue((String)rs.get(1), (boolean)rs.get(1).startsWith("{\"writeid\":1,\"bucketid\":536936448,\"rowid\":1}\t2\t2\t2\t"));
        Assert.assertTrue((String)rs.get(1), (boolean)rs.get(1).endsWith("nobuckets/delta_0000001_0000001_0000/bucket_00001_0"));
        Assert.assertTrue((String)rs.get(2), (boolean)rs.get(2).startsWith("{\"writeid\":2,\"bucketid\":536870913,\"rowid\":0}\t1\t1\t17\t"));
        Assert.assertTrue((String)rs.get(2), (boolean)rs.get(2).endsWith("nobuckets/delta_0000002_0000002_0001/bucket_00000_0"));
        Assert.assertTrue((String)rs.get(3), (boolean)rs.get(3).startsWith("{\"writeid\":2,\"bucketid\":536936449,\"rowid\":0}\t0\t0\t17\t"));
        Assert.assertTrue((String)rs.get(3), (boolean)rs.get(3).endsWith("nobuckets/delta_0000002_0000002_0001/bucket_00001_0"));
        HashSet<String> expectedFiles = new HashSet<String>();
        expectedFiles.add("nobuckets/delete_delta_0000002_0000002_0000/bucket_00000_0");
        expectedFiles.add("nobuckets/delete_delta_0000002_0000002_0000/bucket_00001_0");
        expectedFiles.add("nobuckets/delta_0000001_0000001_0000/bucket_00000_0");
        expectedFiles.add("nobuckets/delta_0000001_0000001_0000/bucket_00001_0");
        expectedFiles.add("nobuckets/delta_0000002_0000002_0001/bucket_00000_0");
        expectedFiles.add("nobuckets/delta_0000002_0000002_0001/bucket_00001_0");
        this.assertExpectedFileSet(expectedFiles, this.getWarehouseDir() + "/nobuckets", NO_BUCKETS_TBL_NAME);
        this.runStatementOnDriver(String.format("alter table %s compact 'major'", NO_BUCKETS_TBL_NAME));
        TestTxnCommands2.runWorker(this.hiveConf);
        rs = this.runStatementOnDriver(String.format("select ROW__ID, c1, c2, c3, INPUT__FILE__NAME from %s order by INPUT__FILE__NAME, ROW__ID", NO_BUCKETS_TBL_NAME));
        LOG.warn("after major compact");
        for (String s : rs) {
            LOG.warn(s);
        }
        String[][] stringArray = new String[][]{{"{\"writeid\":2,\"bucketid\":536936449,\"rowid\":0}\t0\t0\t17", "nobuckets/base_0000002_v0000011/bucket_00001"}, {"{\"writeid\":2,\"bucketid\":536870913,\"rowid\":0}\t1\t1\t17", "nobuckets/base_0000002_v0000011/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":1}\t2\t2\t2", "nobuckets/base_0000002_v0000011/bucket_00001"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t3\t3", "nobuckets/base_0000002_v0000011/bucket_00000"}};
        this.checkResultAndVectorization(stringArray, "select ROW__ID, c1, c2, c3, INPUT__FILE__NAME from nobuckets order by c1, c2, c3", "After Major Compaction", LOG);
        expectedFiles.clear();
        expectedFiles.add("nobuckets/delete_delta_0000002_0000002_0000/bucket_00000_0");
        expectedFiles.add("nobuckets/delete_delta_0000002_0000002_0000/bucket_00001_0");
        expectedFiles.add("nobuckets/delta_0000001_0000001_0000/bucket_00000_0");
        expectedFiles.add("nobuckets/delta_0000001_0000001_0000/bucket_00001_0");
        expectedFiles.add("nobuckets/delta_0000002_0000002_0001/bucket_00000_0");
        expectedFiles.add("nobuckets/delta_0000002_0000002_0001/bucket_00001_0");
        expectedFiles.add("nobuckets/base_0000002_v0000011/bucket_00000");
        expectedFiles.add("nobuckets/base_0000002_v0000011/bucket_00001");
        this.assertExpectedFileSet(expectedFiles, this.getWarehouseDir() + "/nobuckets", NO_BUCKETS_TBL_NAME);
        TestTxnCommands2.runCleaner(this.hiveConf);
        rs = this.runStatementOnDriver(String.format("select c1, c2, c3 from %s order by c1, c2, c3", NO_BUCKETS_TBL_NAME));
        int[][] result = new int[][]{{0, 0, 17}, {1, 1, 17}, {2, 2, 2}, {3, 3, 3}};
        Assert.assertEquals((String)"Unexpected result after clean", TestTxnNoBuckets.stringifyValues(result), rs);
        expectedFiles.clear();
        expectedFiles.add("nobuckets/base_0000002_v0000011/bucket_00000");
        expectedFiles.add("nobuckets/base_0000002_v0000011/bucket_00001");
        this.assertExpectedFileSet(expectedFiles, this.getWarehouseDir() + "/nobuckets", NO_BUCKETS_TBL_NAME);
    }

    @Test
    public void testNoBucketsDP() throws Exception {
        int[][] sourceVals1 = new int[][]{{0, 0, 0}, {3, 3, 3}};
        int[][] sourceVals2 = new int[][]{{1, 1, 1}, {2, 2, 2}};
        int[][] sourceVals3 = new int[][]{{3, 3, 3}, {4, 4, 4}};
        int[][] sourceVals4 = new int[][]{{5, 5, 5}, {6, 6, 6}};
        this.dropTables(NO_BUCKETS_TBL_NAME, "tmp");
        this.runStatementOnDriver("create table tmp (c1 integer, c2 integer) partitioned by (c3 integer) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into tmp " + TestTxnNoBuckets.makeValuesClause(sourceVals1));
        this.runStatementOnDriver("insert into tmp " + TestTxnNoBuckets.makeValuesClause(sourceVals2));
        this.runStatementOnDriver("insert into tmp " + TestTxnNoBuckets.makeValuesClause(sourceVals3));
        this.runStatementOnDriver("insert into tmp " + TestTxnNoBuckets.makeValuesClause(sourceVals4));
        this.runStatementOnDriver(String.format("create table %s (c1 integer, c2 integer) partitioned by (c3 integer) stored as orc tblproperties('transactional'='true', 'transactional_properties'='default')", NO_BUCKETS_TBL_NAME));
        String stmt = String.format("insert into %s partition(c3) select * from tmp", NO_BUCKETS_TBL_NAME);
        this.runStatementOnDriver(stmt);
        List<String> rs = this.runStatementOnDriver(String.format("select ROW__ID, c1, c2, c3, INPUT__FILE__NAME from %s order by ROW__ID", NO_BUCKETS_TBL_NAME));
        Assert.assertEquals((String)"", (long)8L, (long)rs.size());
        LOG.warn("after insert");
        for (String s : rs) {
            LOG.warn(s);
        }
        rs = this.runStatementOnDriver(String.format("select * from %s where c2 in (0,3)", NO_BUCKETS_TBL_NAME));
        Assert.assertEquals((long)3L, (long)rs.size());
        this.runStatementOnDriver(String.format("update %s set c2 = 17 where c2 in(0,3)", NO_BUCKETS_TBL_NAME));
        rs = this.runStatementOnDriver(String.format("select ROW__ID, c1, c2, c3, INPUT__FILE__NAME from %s order by INPUT__FILE__NAME, ROW__ID", NO_BUCKETS_TBL_NAME));
        LOG.warn("after update");
        for (String s : rs) {
            LOG.warn(s);
        }
        rs = this.runStatementOnDriver(String.format("select * from %s where c2=17", NO_BUCKETS_TBL_NAME));
        Assert.assertEquals((long)3L, (long)rs.size());
    }

    @Test
    public void testCTAS() throws Exception {
        this.dropTables("myctas");
        int[][] values = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + TestTxnNoBuckets.makeValuesClause(values));
        this.runStatementOnDriver("create table myctas stored as ORC TBLPROPERTIES ('transactional'='true', 'transactional_properties'='default') as select a, b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL);
        List<String> rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from myctas order by ROW__ID");
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t3\t4", "warehouse/myctas/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t1\t2", "warehouse/myctas/delta_0000001_0000001_0000/bucket_00001_0"}};
        this.checkExpected(rs, expected, "Unexpected row count after ctas from non acid table");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + TestTxnNoBuckets.makeValuesClause(values));
        this.runStatementOnDriver("create table myctas2 stored as ORC TBLPROPERTIES ('transactional'='true', 'transactional_properties'='default') as select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL);
        rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from myctas2 order by ROW__ID");
        String[][] expected2 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "warehouse/myctas2/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t3\t4", "warehouse/myctas2/delta_0000001_0000001_0000/bucket_00001_0"}};
        this.checkExpected(rs, expected2, "Unexpected row count after ctas from acid table");
        this.runStatementOnDriver("create table myctas3 stored as ORC TBLPROPERTIES ('transactional'='true', 'transactional_properties'='default') as select a, b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " union all select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL);
        rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from myctas3 order by ROW__ID");
        String[][] expected3 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870913,\"rowid\":0}\t3\t4", "warehouse/myctas3/delta_0000001_0000001_0001/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870914,\"rowid\":0}\t1\t2", "warehouse/myctas3/delta_0000001_0000001_0002/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536936449,\"rowid\":0}\t1\t2", "warehouse/myctas3/delta_0000001_0000001_0001/bucket_00001_0"}, {"{\"writeid\":1,\"bucketid\":536936450,\"rowid\":0}\t3\t4", "warehouse/myctas3/delta_0000001_0000001_0002/bucket_00001_0"}};
        this.checkExpected(rs, expected3, "Unexpected row count after ctas from union all query");
        this.runStatementOnDriver("create table myctas4 stored as ORC TBLPROPERTIES ('transactional'='true', 'transactional_properties'='default') as select a, b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " union distinct select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL);
        rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from myctas4 order by ROW__ID");
        String[][] expected4 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "/delta_0000001_0000001_0000/bucket_00000_0"}};
        this.checkExpected(rs, expected4, "Unexpected row count after ctas from union distinct query");
    }

    @Test
    public void testCtasEmpty() throws Exception {
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID, (boolean)true);
        this.dropTables("myctas");
        this.runStatementOnDriver("create table myctas stored as ORC as select a, b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL);
        List<String> rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from myctas order by ROW__ID");
    }

    @Test
    public void testInsertToAcidWithUnionRemove() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_UNION_REMOVE, true);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, "none");
        this.d.close();
        this.d = new Driver(this.hiveConf);
        int[][] values = new int[][]{{1, 2}, {3, 4}, {5, 6}, {7, 8}, {9, 10}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + TestTxnNoBuckets.makeValuesClause(values));
        this.dropTables("T");
        this.runStatementOnDriver("create table T (a int, b int) stored as ORC  TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into T(a,b) select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a between 1 and 3 group by a, b union all select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a between 5 and 7 union all select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a >= 9");
        List<String> rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from T order by ROW__ID");
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870913,\"rowid\":0}\t1\t2", "/delta_0000001_0000001_0001/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870913,\"rowid\":1}\t3\t4", "/delta_0000001_0000001_0001/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870914,\"rowid\":0}\t5\t6", "/delta_0000001_0000001_0002/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870915,\"rowid\":0}\t9\t10", "/delta_0000001_0000001_0003/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536936450,\"rowid\":0}\t7\t8", "/delta_0000001_0000001_0002/bucket_00001_0"}};
        this.checkExpected(rs, expected, "Unexpected row count after ctas");
    }

    @Test
    public void testInsertOverwriteToAcidWithUnionRemove() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_UNION_REMOVE, true);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, "none");
        this.d.close();
        this.d = new Driver(this.hiveConf);
        this.dropTables("T");
        this.runStatementOnDriver("create table T (a int, b int) stored as ORC  TBLPROPERTIES ('transactional'='true')");
        CommandProcessorException e = this.runStatementOnDriverNegative("insert overwrite table T select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a between 1 and 3 group by a, b union all select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a between 5 and 7 union all select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a >= 9");
        Assert.assertTrue((String)"", (boolean)e.getMessage().contains("not supported due to OVERWRITE and UNION ALL"));
    }

    @Test
    public void testToAcidConversionMultiBucket() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_MERGE_MAPFILES, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_MERGE_MAPRED_FILES, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_MERGE_TEZ_FILES, false);
        this.d.close();
        this.d = new Driver(this.hiveConf);
        int[][] values = new int[][]{{1, 2}, {2, 4}, {5, 6}, {6, 8}, {9, 10}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + TestTxnNoBuckets.makeValuesClause(values));
        this.dropTables("T");
        this.runStatementOnDriver("create table T (a int, b int) stored as ORC  TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("insert into T(a,b) select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a between 1 and 3 group by a, b union all select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a between 5 and 7 union all select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a >= 9");
        this.runStatementOnDriver("insert into T values(12,12)");
        List<String> rs = this.runStatementOnDriver("select a, b, INPUT__FILE__NAME from T order by a, b, INPUT__FILE__NAME");
        String[][] expected = new String[][]{{"1\t2", "warehouse/t/HIVE_UNION_SUBDIR_1/000000_0"}, {"2\t4", "warehouse/t/HIVE_UNION_SUBDIR_1/000000_0"}, {"5\t6", "warehouse/t/HIVE_UNION_SUBDIR_2/000000_0"}, {"6\t8", "warehouse/t/HIVE_UNION_SUBDIR_2/000001_0"}, {"9\t10", "warehouse/t/HIVE_UNION_SUBDIR_3/000000_0"}, {"12\t12", "warehouse/t/000000_0"}};
        this.checkExpected(rs, expected, "before converting to acid");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_UNION_REMOVE, true);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, "none");
        this.d.close();
        this.d = new Driver(this.hiveConf);
        this.runStatementOnDriver("insert into T(a,b) select a * 10, b * 10 from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a between 1 and 3 group by a, b union all select a * 10, b * 10 from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a between 5 and 7");
        String[][] expected1 = new String[][]{{"1\t2", "warehouse/t/HIVE_UNION_SUBDIR_1/000000_0"}, {"2\t4", "warehouse/t/HIVE_UNION_SUBDIR_1/000000_0"}, {"5\t6", "warehouse/t/HIVE_UNION_SUBDIR_2/000000_0"}, {"6\t8", "warehouse/t/HIVE_UNION_SUBDIR_2/000001_0"}, {"9\t10", "warehouse/t/HIVE_UNION_SUBDIR_3/000000_0"}, {"10\t20", "warehouse/t/HIVE_UNION_SUBDIR_15/000000_0"}, {"12\t12", "warehouse/t/000000_0"}, {"20\t40", "warehouse/t/HIVE_UNION_SUBDIR_15/000000_0"}, {"50\t60", "warehouse/t/HIVE_UNION_SUBDIR_16/000000_0"}, {"60\t80", "warehouse/t/HIVE_UNION_SUBDIR_16/000001_0"}};
        rs = this.runStatementOnDriver("select a, b, INPUT__FILE__NAME from T order by a, b, INPUT__FILE__NAME");
        this.checkExpected(rs, expected1, "before converting to acid (with multi level data layout)");
        this.runStatementOnDriver("alter table T SET TBLPROPERTIES ('transactional'='true')");
        rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from T order by a, b, INPUT__FILE__NAME");
        String[][] expected2 = new String[][]{{"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":1}\t1\t2", "warehouse/t/HIVE_UNION_SUBDIR_1/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":2}\t2\t4", "warehouse/t/HIVE_UNION_SUBDIR_1/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":6}\t5\t6", "warehouse/t/HIVE_UNION_SUBDIR_2/000000_0"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":1}\t6\t8", "warehouse/t/HIVE_UNION_SUBDIR_2/000001_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":7}\t9\t10", "warehouse/t/HIVE_UNION_SUBDIR_3/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":3}\t10\t20", "warehouse/t/HIVE_UNION_SUBDIR_15/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":0}\t12\t12", "warehouse/t/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":4}\t20\t40", "warehouse/t/HIVE_UNION_SUBDIR_15/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":5}\t50\t60", "warehouse/t/HIVE_UNION_SUBDIR_16/000000_0"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":0}\t60\t80", "warehouse/t/HIVE_UNION_SUBDIR_16/000001_0"}};
        this.checkExpected(rs, expected2, "after converting to acid (no compaction)");
        Assert.assertEquals((long)0L, (long)BucketCodec.determineVersion((int)0x20000000).decodeWriterId(0x20000000));
        Assert.assertEquals((long)2L, (long)BucketCodec.determineVersion((int)0x20020000).decodeWriterId(0x20020000));
        Assert.assertEquals((long)1L, (long)BucketCodec.determineVersion((int)0x20010000).decodeWriterId(0x20010000));
        this.assertMappersAreVectorized("update T set b = 88 where b = 80 or b = 60");
        this.runStatementOnDriver("update T set b = 88 where b = 80 or b = 60");
        this.assertMappersAreVectorized("delete from T where b = 8");
        this.runStatementOnDriver("delete from T where b = 8");
        String[][] expected3 = new String[][]{{"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":1}\t1\t2", "warehouse/t/HIVE_UNION_SUBDIR_1/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":2}\t2\t4", "warehouse/t/HIVE_UNION_SUBDIR_1/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":6}\t5\t6", "warehouse/t/HIVE_UNION_SUBDIR_2/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":7}\t9\t10", "warehouse/t/HIVE_UNION_SUBDIR_3/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":3}\t10\t20", "warehouse/t/HIVE_UNION_SUBDIR_15/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":0}\t12\t12", "warehouse/t/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":4}\t20\t40", "warehouse/t/HIVE_UNION_SUBDIR_15/000000_0"}, {"{\"writeid\":10000001,\"bucketid\":537067521,\"rowid\":0}\t50\t88", "warehouse/t/delta_10000001_10000001_0001/bucket_00003_0"}, {"{\"writeid\":10000001,\"bucketid\":536870913,\"rowid\":0}\t60\t88", "warehouse/t/delta_10000001_10000001_0001/bucket_00000_0"}};
        rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from T order by a, b, INPUT__FILE__NAME");
        this.checkExpected(rs, expected3, "after converting to acid (no compaction with updates)");
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from T order by a, b, INPUT__FILE__NAME");
        String[][] expected4 = new String[][]{{"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":1}\t1\t2", "warehouse/t/base_10000002_v0000015/bucket_00000"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":2}\t2\t4", "warehouse/t/base_10000002_v0000015/bucket_00000"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":6}\t5\t6", "warehouse/t/base_10000002_v0000015/bucket_00000"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":7}\t9\t10", "warehouse/t/base_10000002_v0000015/bucket_00000"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":3}\t10\t20", "warehouse/t/base_10000002_v0000015/bucket_00000"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":0}\t12\t12", "warehouse/t/base_10000002_v0000015/bucket_00000"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":4}\t20\t40", "warehouse/t/base_10000002_v0000015/bucket_00000"}, {"{\"writeid\":10000001,\"bucketid\":537067521,\"rowid\":0}\t50\t88", "warehouse/t/base_10000002_v0000015/bucket_00003"}, {"{\"writeid\":10000001,\"bucketid\":536870913,\"rowid\":0}\t60\t88", "warehouse/t/base_10000002_v0000015/bucket_00000"}};
        this.checkExpected(rs, expected4, "after major compact");
    }

    @Test
    public void testInsertFromUnion() throws Exception {
        int[][] values = new int[][]{{1, 2}, {2, 4}, {5, 6}, {6, 8}, {9, 10}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + TestTxnNoBuckets.makeValuesClause(values));
        this.dropTables("T");
        this.runStatementOnDriver("create table T (a int, b int) stored as ORC  TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into T(a,b) select a, b from " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + " where a between 1 and 3 group by a, b union all select a, b from " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + " where a between 5 and 7 union all select a, b from " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + " where a >= 9");
        List<String> rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from T order by a, b, INPUT__FILE__NAME");
        LOG.warn("before converting to acid");
        for (String s : rs) {
            LOG.warn(s);
        }
        rs = this.runStatementOnDriver("select a, b from T order by a, b");
        Assert.assertEquals(TestTxnNoBuckets.stringifyValues(values), rs);
        rs = this.runStatementOnDriver("select ROW__ID from T group by ROW__ID having count(*) > 1");
        if (rs.size() > 0) {
            Assert.assertEquals((String)("Duplicate ROW__IDs: " + rs.get(0)), (long)0L, (long)rs.size());
        }
    }

    @Test
    public void testToAcidConversion02() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + "(a,b) values(1,2),(1,3)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + "(a,b) values(0,12),(0,13),(1,4),(1,5)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + "(a,b) values(1,6)");
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='default')");
        List<String> rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + " order by ROW__ID");
        LOG.warn("before acid ops (after convert)");
        for (String s : rs) {
            LOG.warn(s);
        }
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + "(a,b) values(0,15),(1,16)");
        this.runStatementOnDriver("update " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + " set b = 120 where a = 0 and b = 12");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + "(a,b) values(0,17)");
        this.runStatementOnDriver("delete from " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + " where a = 1 and b = 3");
        rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + " order by a,b");
        LOG.warn("before compact");
        for (String s : rs) {
            LOG.warn(s);
        }
        Assert.assertEquals((long)0L, (long)BucketCodec.determineVersion((int)0x20000000).decodeWriterId(0x20000000));
        String[][] expected = new String[][]{{"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":3}\t0\t13", "bucket_00000", "000000_0_copy_1"}, {"{\"writeid\":10000001,\"bucketid\":536870912,\"rowid\":0}\t0\t15", "bucket_00000", "bucket_00000_0"}, {"{\"writeid\":10000003,\"bucketid\":536870912,\"rowid\":0}\t0\t17", "bucket_00000", "bucket_00000_0"}, {"{\"writeid\":10000002,\"bucketid\":536936449,\"rowid\":0}\t0\t120", "bucket_00001", "bucket_00001_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "bucket_00000", "000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":4}\t1\t4", "bucket_00000", "000000_0_copy_1"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":5}\t1\t5", "bucket_00000", "000000_0_copy_1"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":6}\t1\t6", "bucket_00000", "000000_0_copy_2"}, {"{\"writeid\":10000001,\"bucketid\":536870912,\"rowid\":1}\t1\t16", "bucket_00000", "bucket_00000_0"}};
        Assert.assertEquals((String)"Unexpected row count before compaction", (long)expected.length, (long)rs.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((String)("Actual line " + i + " bc: " + rs.get(i)), (boolean)rs.get(i).startsWith(expected[i][0]));
            Assert.assertTrue((String)("Actual line(file) " + i + " bc: " + rs.get(i)), (boolean)rs.get(i).endsWith(expected[i][2]));
        }
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + " compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + " order by a,b");
        LOG.warn("after compact");
        for (String s : rs) {
            LOG.warn(s);
        }
        Assert.assertEquals((String)"Unexpected row count after compaction", (long)expected.length, (long)rs.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((String)("Actual line " + i + " ac: " + rs.get(i)), (boolean)rs.get(i).startsWith(expected[i][0]));
            Assert.assertTrue((String)("Actual line(file) " + i + " ac: " + rs.get(i)), (boolean)rs.get(i).endsWith(expected[i][1]));
        }
    }

    @Test
    public void testCtasBucketed() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + "(a,b) values(1,2),(1,3)");
        CommandProcessorException e = this.runStatementOnDriverNegative("create table myctas clustered by (a) into 2 buckets stored as ORC TBLPROPERTIES ('transactional'='true') as select a, b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL);
        ErrorMsg.CTAS_PARCOL_COEXISTENCE.getErrorCode();
        Assert.assertTrue((boolean)e.getMessage().contains("CREATE-TABLE-AS-SELECT does not support"));
    }

    @Test
    public void testCtasPartitioned() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDNONBUCKET + "(a,b) values(1,2),(1,3)");
        CommandProcessorException e = this.runStatementOnDriverNegative("create table myctas partitioned by (b int) stored as ORC TBLPROPERTIES ('transactional'='true') as select a, b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL);
        ErrorMsg.CTAS_PARCOL_COEXISTENCE.getErrorCode();
        Assert.assertTrue((boolean)e.getMessage().contains("CREATE-TABLE-AS-SELECT does not support partitioning in the target table"));
    }

    @Test
    public void testNonAcidToAcidVectorzied() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, "none");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ROW_IDENTIFIER_ENABLED, true);
        this.dropTables("T");
        this.runStatementOnDriver("create table T(a int, b int) stored as orc tblproperties('transactional'='false')");
        int[][] values = new int[][]{{1, 2}, {2, 4}, {5, 6}, {6, 8}, {9, 10}};
        this.runStatementOnDriver("insert into T(a, b) " + TestTxnNoBuckets.makeValuesClause(values));
        this.runStatementOnDriver("alter table T SET TBLPROPERTIES ('transactional'='true')");
        String query = "select a from T where b > 6 order by a";
        List<String> rs = this.runStatementOnDriver(query);
        String[][] expected = new String[][]{{"6", ""}, {"9", ""}};
        this.checkExpected(rs, expected, "After conversion");
        Assert.assertEquals((Object)Integer.toString(6), (Object)rs.get(0));
        Assert.assertEquals((Object)Integer.toString(9), (Object)rs.get(1));
        this.assertMappersAreVectorized(query);
        query = "select ROW__ID, a from T where b > 6 order by a";
        rs = this.runStatementOnDriver(query);
        String[][] expected1 = new String[][]{{"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":3}", "6"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":4}", "9"}};
        this.checkExpected(rs, expected1, "After conversion with VC1");
        this.assertMappersAreVectorized(query);
        query = "select ROW__ID, a from T where b > 0 order by a";
        rs = this.runStatementOnDriver(query);
        String[][] expected2 = new String[][]{{"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":0}", "1"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":1}", "2"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":2}", "5"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":3}", "6"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":4}", "9"}};
        this.checkExpected(rs, expected2, "After conversion with VC2");
        this.assertMappersAreVectorized(query);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        query = "select ROW__ID, a, INPUT__FILE__NAME from T where b > 6 order by a";
        rs = this.runStatementOnDriver(query);
        Assert.assertEquals((String)"", (long)2L, (long)rs.size());
        String[][] expected3 = new String[][]{{"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":3}\t6", "warehouse/t/000000_0"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":4}\t9", "warehouse/t/000000_0"}};
        this.checkExpected(rs, expected3, "After non-vectorized read");
        Assert.assertEquals((long)0L, (long)BucketCodec.determineVersion((int)0x20000000).decodeWriterId(0x20000000));
        this.assertMappersAreVectorized(query);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.runStatementOnDriver("update T set b = 17 where a = 1");
        query = "select ROW__ID, b from T where b > 0 order by a";
        rs = this.runStatementOnDriver(query);
        String[][] expected4 = new String[][]{{"{\"writeid\":10000001,\"bucketid\":536870913,\"rowid\":0}", "17"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":1}", "4"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":2}", "6"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":3}", "8"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":4}", "10"}};
        this.checkExpected(rs, expected4, "After conversion with VC4");
        this.assertMappersAreVectorized(query);
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        query = "select ROW__ID, a, b, INPUT__FILE__NAME from T where b > 0 order by a, b";
        rs = this.runStatementOnDriver(query);
        String[][] expected5 = new String[][]{{"{\"writeid\":10000001,\"bucketid\":536870913,\"rowid\":0}\t1\t17", "warehouse/t/base_10000001_v0000017/bucket_00000"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":1}\t2\t4", "warehouse/t/base_10000001_v0000017/bucket_00000"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":2}\t5\t6", "warehouse/t/base_10000001_v0000017/bucket_00000"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":3}\t6\t8", "warehouse/t/base_10000001_v0000017/bucket_00000"}, {"{\"writeid\":0,\"bucketid\":536870912,\"rowid\":4}\t9\t10", "warehouse/t/base_10000001_v0000017/bucket_00000"}};
        this.checkExpected(rs, expected5, "After major compaction");
        this.assertMappersAreVectorized(query);
    }

    private void checkExpected(List<String> rs, String[][] expected, String msg) {
        super.checkExpected(rs, expected, msg, LOG);
    }

    @Test
    public void testCompactStatsGather() throws Exception {
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_OPT_SORT_DYNAMIC_PARTITION_THRESHOLD, -1);
        this.dropTables("T");
        this.runStatementOnDriver("create table T(a int, b int) partitioned by (p int, q int) stored as orc TBLPROPERTIES ('transactional'='true')");
        int[][] targetVals = new int[][]{{4, 1, 1}, {4, 2, 2}, {4, 3, 1}, {4, 4, 2}};
        this.runStatementOnDriver("insert into T partition(p=1,q) " + TestTxnNoBuckets.makeValuesClause(targetVals));
        this.runStatementOnDriver("analyze table T  partition(p=1) compute statistics for columns");
        Table hiveTable = Hive.get().getTable("T");
        List partitions = Hive.get().getPartitions(hiveTable);
        Map parameters = partitions.stream().filter(p -> p.getName().equals("p=1/q=2")).findFirst().orElseThrow(() -> new RuntimeException("Could not get Partition")).getParameters();
        Assert.assertEquals((String)"The number of files is differing from the expected", (Object)"1", parameters.get("numFiles"));
        Assert.assertEquals((String)"The number of rows is differing from the expected", (Object)"2", parameters.get("numRows"));
        int[][] targetVals2 = new int[][]{{5, 1, 1}, {5, 2, 2}, {5, 3, 1}, {5, 4, 2}};
        this.runStatementOnDriver("insert into T partition(p=1,q) " + TestTxnNoBuckets.makeValuesClause(targetVals2));
        String query = "select ROW__ID, p, q, a, b, INPUT__FILE__NAME from T order by p, q, a, b";
        List<String> rs = this.runStatementOnDriver(query);
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t1\t4\t1", "t/p=1/q=1/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t1\t1\t4\t3", "t/p=1/q=1/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t1\t1\t5\t1", "t/p=1/q=1/delta_0000003_0000003_0000/bucket_00000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":1}\t1\t1\t5\t3", "t/p=1/q=1/delta_0000003_0000003_0000/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2\t4\t2", "t/p=1/q=2/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t1\t2\t4\t4", "t/p=1/q=2/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t1\t2\t5\t2", "t/p=1/q=2/delta_0000003_0000003_0000/bucket_00000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":1}\t1\t2\t5\t4", "t/p=1/q=2/delta_0000003_0000003_0000/bucket_00000_0"}};
        this.checkExpected(rs, expected, "insert data");
        this.runStatementOnDriver("alter table T partition(p=1,q=2) compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        query = "select ROW__ID, p, q, a, b, INPUT__FILE__NAME from T order by p, q, a, b";
        rs = this.runStatementOnDriver(query);
        String[][] expected2 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t1\t4\t1", "t/p=1/q=1/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t1\t1\t4\t3", "t/p=1/q=1/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t1\t1\t5\t1", "t/p=1/q=1/delta_0000003_0000003_0000/bucket_00000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":1}\t1\t1\t5\t3", "t/p=1/q=1/delta_0000003_0000003_0000/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2\t4\t2", "t/p=1/q=2/base_0000003_v0000010/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t1\t2\t4\t4", "t/p=1/q=2/base_0000003_v0000010/bucket_00000"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t1\t2\t5\t2", "t/p=1/q=2/base_0000003_v0000010/bucket_00000"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":1}\t1\t2\t5\t4", "t/p=1/q=2/base_0000003_v0000010/bucket_00000"}};
        this.checkExpected(rs, expected2, "after major compaction");
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        partitions = Hive.get().getPartitions(hiveTable);
        parameters = partitions.stream().filter(p -> p.getName().equals("p=1/q=2")).findFirst().orElseThrow(() -> new RuntimeException("Could not get Partition")).getParameters();
        Assert.assertEquals((String)"The number of files is differing from the expected", (Object)"1", parameters.get("numFiles"));
        Assert.assertEquals((String)"The number of rows is differing from the expected", (Object)"4", parameters.get("numRows"));
    }

    @Test
    public void testDefault() throws Exception {
        this.hiveConf.set(MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID.getVarname(), "true");
        this.dropTables("T");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc");
        this.runStatementOnDriver("insert into T values(1,2),(3,4)");
        String query = "select ROW__ID, a, b, INPUT__FILE__NAME from T order by a, b";
        List<String> rs = this.runStatementOnDriver(query);
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/delta_0000001_0000001_0000/bucket_00000_0"}};
        this.checkExpected(rs, expected, "insert data");
    }

    @Test
    public void testEmptyCompactionResult() throws Exception {
        this.hiveConf.set(MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID.getVarname(), "true");
        this.dropTables("T");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc");
        int[][] data = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into T" + TestTxnNoBuckets.makeValuesClause(data));
        this.runStatementOnDriver("insert into T" + TestTxnNoBuckets.makeValuesClause(data));
        List<String> rs = this.runStatementOnDriver("select distinct INPUT__FILE__NAME from T");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        for (String path : rs) {
            fs.delete(new Path(path), true);
        }
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        this.runStatementOnDriver("insert into T" + TestTxnNoBuckets.makeValuesClause(data));
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)2L, (long)resp.getCompactsSize());
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(i)).getState());
            Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(i)).getHadoopJobId().startsWith("job_local"));
        }
        rs = this.runStatementOnDriver("select a, b from T order by a, b");
        Assert.assertEquals(TestTxnNoBuckets.stringifyValues(data), rs);
    }

    @Test
    public void testGetPartitionsNoSession() throws Exception {
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_OPT_SORT_DYNAMIC_PARTITION_THRESHOLD, -1);
        this.dropTables("T");
        this.runStatementOnDriver("create table T(a int, b int) partitioned by (p int, q int) stored as orc TBLPROPERTIES ('transactional'='true')");
        int[][] targetVals = new int[][]{{4, 1, 1}, {4, 2, 2}, {4, 3, 1}, {4, 4, 2}};
        this.runStatementOnDriver("insert into T partition(p=1,q) " + TestTxnNoBuckets.makeValuesClause(targetVals));
        this.runStatementOnDriver("analyze table T  partition(p=1) compute statistics for columns");
        Hive hive = Hive.get();
        Table hiveTable = hive.getTable("T");
        SessionState.detachSession();
        List partitions = hive.getPartitions(hiveTable);
        Assert.assertNotNull((Object)partitions);
        this.d.close();
        this.d = null;
    }
}

