/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.TestTxnLoadData;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnConcatenate
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnConcatenate.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnLoadData.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Test
    public void testConcatenate() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(1,2),(4,5)");
        this.runStatementOnDriver("update " + TxnCommandsBaseForTests.Table.ACIDTBL + " set b = 4");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(5,6),(8,8)");
        String testQuery = "select ROW__ID, a, b, INPUT__FILE__NAME from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a, b";
        String[][] expected = new String[][]{{"{\"writeid\":2,\"bucketid\":536936449,\"rowid\":0}\t1\t4", "acidtbl/delta_0000002_0000002_0001/bucket_00001_0"}, {"{\"writeid\":2,\"bucketid\":536936449,\"rowid\":1}\t4\t4", "acidtbl/delta_0000002_0000002_0001/bucket_00001_0"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t5\t6", "acidtbl/delta_0000003_0000003_0000/bucket_00001_0"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":1}\t8\t8", "acidtbl/delta_0000003_0000003_0000/bucket_00001_0"}};
        this.checkResultAndVectorization(expected, testQuery, "check data", LOG);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.TRANSACTIONAL_CONCATENATE_NOBLOCK, true);
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBL + " concatenate");
        TxnStore txnStore = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        TestTxnConcatenate.runWorker(this.hiveConf);
        rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        String[][] expected2 = new String[][]{{"{\"writeid\":2,\"bucketid\":536936449,\"rowid\":0}\t1\t4", "acidtbl/base_0000003_v0000011/bucket_00001"}, {"{\"writeid\":2,\"bucketid\":536936449,\"rowid\":1}\t4\t4", "acidtbl/base_0000003_v0000011/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t5\t6", "acidtbl/base_0000003_v0000011/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":1}\t8\t8", "acidtbl/base_0000003_v0000011/bucket_00001"}};
        this.checkResultAndVectorization(expected2, testQuery, "check data after concatenate", LOG);
    }

    @Test
    public void testConcatenatePart() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " values(1,2,'p1'),(4,5,'p2')");
        this.runStatementOnDriver("update " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " set b = 4 where p='p1'");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " values(5,6,'p1'),(8,8,'p2')");
        String testQuery = "select ROW__ID, a, b, INPUT__FILE__NAME from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b";
        String[][] expected = new String[][]{{"{\"writeid\":2,\"bucketid\":536936449,\"rowid\":0}\t1\t4", "acidtblpart/p=p1/delta_0000002_0000002_0001/bucket_00001_0"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t4\t5", "acidtblpart/p=p2/delta_0000001_0000001_0000/bucket_00001_0"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t5\t6", "acidtblpart/p=p1/delta_0000003_0000003_0000/bucket_00001_0"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t8\t8", "acidtblpart/p=p2/delta_0000003_0000003_0000/bucket_00001_0"}};
        this.checkResultAndVectorization(expected, testQuery, "check data", LOG);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.TRANSACTIONAL_CONCATENATE_NOBLOCK, true);
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " PARTITION(p='p1') concatenate");
        TxnStore txnStore = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        TestTxnConcatenate.runWorker(this.hiveConf);
        rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        String[][] expected2 = new String[][]{{"{\"writeid\":2,\"bucketid\":536936449,\"rowid\":0}\t1\t4", "acidtblpart/p=p1/base_0000003_v0000011/bucket_00001"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t4\t5", "acidtblpart/p=p2/delta_0000001_0000001_0000/bucket_00001_0"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t5\t6", "acidtblpart/p=p1/base_0000003_v0000011/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t8\t8", "acidtblpart/p=p2/delta_0000003_0000003_0000/bucket_00001_0"}};
        this.checkResultAndVectorization(expected2, testQuery, "check data after concatenate", LOG);
    }

    @Test
    public void testConcatenateMM() throws Exception {
        this.hiveConf.set("tez.grouping.max-size", "1024");
        this.hiveConf.set("tez.grouping.min-size", "1");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CREATE_TABLES_AS_INSERT_ONLY, (boolean)true);
        this.dropTables("T");
        this.runStatementOnDriver("create table T(a int, b int)");
        this.runStatementOnDriver("insert into T values(1,2),(4,5)");
        this.runStatementOnDriver("insert into T values(5,6),(8,8)");
        String testQuery = "select a, b, INPUT__FILE__NAME from T order by a, b";
        String[][] expected = new String[][]{{"1\t2", "t/delta_0000001_0000001_0000/000000_0"}, {"4\t5", "t/delta_0000001_0000001_0000/000000_0"}, {"5\t6", "t/delta_0000002_0000002_0000/000000_0"}, {"8\t8", "t/delta_0000002_0000002_0000/000000_0"}};
        this.checkResultAndVectorization(expected, testQuery, "check data", LOG);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.TRANSACTIONAL_CONCATENATE_NOBLOCK, true);
        this.runStatementOnDriver("alter table T concatenate");
        TxnStore txnStore = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        TestTxnConcatenate.runWorker(this.hiveConf);
        rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        String[][] expected2 = new String[][]{{"1\t2", "t/base_0000003_v0000011/000000_0"}, {"4\t5", "t/base_0000003_v0000011/000000_0"}, {"5\t6", "t/base_0000003_v0000011/000000_0"}, {"8\t8", "t/base_0000003_v0000011/000000_0"}};
        this.checkResultAndVectorization(expected2, testQuery, "check data after concatenate", LOG);
    }
}

