/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.TestTxnCommands;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnCommandsForMmTable
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnCommandsForMmTable.class);
    protected static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Override
    void initHiveConf() {
        super.initHiveConf();
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_TRUNCATE_USE_BASE, (boolean)false);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUpInternal();
        this.setUpInternalExtended(false);
    }

    void setUpInternalExtended(boolean isOrcFormat) throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.DYNAMIC_PARTITIONING, true);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_MAPRED_MODE, "nonstrict");
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, "none");
        this.hiveConf.set(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname, "true");
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
        this.runStatementOnDriver("create table " + TableExtended.NONACIDPART + "(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='false')");
        if (!isOrcFormat) {
            this.runStatementOnDriver("create table " + TableExtended.MMTBL + "(a int, b int) TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
            this.runStatementOnDriver("create table " + TableExtended.MMTBL2 + "(a int, b int) TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
            this.runStatementOnDriver("create table " + TableExtended.MMTBLPART + "(a int, b int) partitioned by (p string) TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
        } else {
            this.runStatementOnDriver("create table " + TableExtended.MMTBL + "(a int, b int) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
            this.runStatementOnDriver("create table " + TableExtended.MMTBL2 + "(a int, b int) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
            this.runStatementOnDriver("create table " + TableExtended.MMTBLPART + "(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
        }
    }

    @Override
    protected void dropTables() throws Exception {
        super.dropTables();
        for (TableExtended t : TableExtended.values()) {
            this.runStatementOnDriver("drop table if exists " + t);
        }
    }

    @Test
    public void testInsertOverwriteForMmTable() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(3,4)");
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)2L, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("delta_.*"));
        }
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + "(a,b) values(5,6),(7,8)");
        this.runStatementOnDriver("insert overwrite table " + TableExtended.MMTBL + " select a,b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        int baseCount = 0;
        int deltaCount = 0;
        for (int i = 0; i < status.length; ++i) {
            String dirName = status[i].getPath().getName();
            if (dirName.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            ++baseCount;
        }
        Assert.assertEquals((long)2L, (long)deltaCount);
        Assert.assertEquals((long)1L, (long)baseCount);
        int[][] resultData = new int[][]{{5, 6}, {7, 8}};
        List<String> rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(resultData), rs);
    }

    @Test
    public void testInsertOverwriteForPartitionedMmTable() throws Exception {
        FileStatus[] status;
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        int[][] valuesOdd = new int[][]{{5, 6}, {7, 8}};
        int[][] valuesEven = new int[][]{{2, 1}, {4, 3}};
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " PARTITION(p='odd') " + TestTxnCommandsForMmTable.makeValuesClause(valuesOdd));
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " PARTITION(p='even') " + TestTxnCommandsForMmTable.makeValuesClause(valuesEven));
        String[] pStrings = new String[]{"/p=odd", "/p=even"};
        for (int i = 0; i < pStrings.length; ++i) {
            status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[i]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)status.length);
            Assert.assertTrue((boolean)status[0].getPath().getName().matches("delta_.*"));
        }
        int[][] newValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] newValsEven = new int[][]{{2, 2}};
        this.runStatementOnDriver("insert into " + TableExtended.NONACIDPART + " PARTITION(p='odd') " + TestTxnCommandsForMmTable.makeValuesClause(newValsOdd));
        this.runStatementOnDriver("insert into " + TableExtended.NONACIDPART + " PARTITION(p='even') " + TestTxnCommandsForMmTable.makeValuesClause(newValsEven));
        List<String> rs = null;
        String s = "insert overwrite table " + TableExtended.MMTBLPART + " PARTITION(p='odd')  select a,b from " + TableExtended.NONACIDPART + " where " + TableExtended.NONACIDPART + ".p='odd'";
        rs = this.runStatementOnDriver("explain formatted " + s);
        LOG.info("Explain formatted: " + rs.toString());
        this.runStatementOnDriver(s);
        s = "insert overwrite table " + TableExtended.MMTBLPART + " PARTITION(p='even')  select a,b from " + TableExtended.NONACIDPART + " where " + TableExtended.NONACIDPART + ".p='even'";
        this.runStatementOnDriver(s);
        boolean sawBase = false;
        String[] baseDirs = new String[]{"", ""};
        int deltaCount = 0;
        for (int h = 0; h < pStrings.length; ++h) {
            status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[h]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)2L, (long)status.length);
            for (int i = 0; i < status.length; ++i) {
                String dirName = status[i].getPath().getName();
                if (dirName.matches("delta_.*")) {
                    ++deltaCount;
                    continue;
                }
                sawBase = true;
                baseDirs[h] = dirName;
                Assert.assertTrue((boolean)baseDirs[h].matches("base_.*"));
            }
            Assert.assertEquals((long)1L, (long)deltaCount);
            Assert.assertTrue((boolean)sawBase);
            deltaCount = 0;
            sawBase = false;
        }
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " where p='even' order by a,b");
        int[][] rExpectedEven = new int[][]{{2, 2}};
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(rExpectedEven), rs);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " where p='odd' order by a,b");
        int[][] rExpectedOdd = new int[][]{{5, 5}, {11, 11}};
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(rExpectedOdd), rs);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBLPART + " PARTITION(p='odd')  compact 'MAJOR'");
        TestTxnCommandsForMmTable.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBLPART + " PARTITION(p='even')  compact 'MAJOR'");
        TestTxnCommandsForMmTable.runWorker(this.hiveConf);
        for (int h = 0; h < pStrings.length; ++h) {
            status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[h]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)2L, (long)status.length);
            sawBase = false;
            deltaCount = 0;
            for (int i = 0; i < status.length; ++i) {
                String dirName = status[i].getPath().getName();
                if (dirName.matches("delta_.*")) {
                    ++deltaCount;
                    continue;
                }
                sawBase = true;
                Assert.assertTrue((String)("BASE ERROR: " + dirName), (boolean)dirName.matches("base_.*"));
                Assert.assertEquals((Object)baseDirs[h], (Object)dirName);
            }
            Assert.assertEquals((long)1L, (long)deltaCount);
            Assert.assertTrue((boolean)sawBase);
            deltaCount = 0;
            sawBase = false;
        }
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " order by a,b");
        int[][] rExpected = new int[][]{{2, 2}, {5, 5}, {11, 11}};
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(rExpected), rs);
        TestTxnCommandsForMmTable.runCleaner(this.hiveConf);
        for (int h = 0; h < pStrings.length; ++h) {
            status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[h]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)status.length);
            Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
            Assert.assertEquals((Object)baseDirs[h], (Object)status[0].getPath().getName());
        }
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " order by a,b");
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(rExpected), rs);
    }

    @Test
    public void testInsertOverwriteWithDynamicPartition() throws Exception {
        FileStatus[] status;
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        int[][] valuesOdd = new int[][]{{5, 6}, {7, 8}};
        int[][] valuesEven = new int[][]{{2, 1}, {4, 3}};
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " PARTITION(p='odd') " + TestTxnCommandsForMmTable.makeValuesClause(valuesOdd));
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " PARTITION(p='even') " + TestTxnCommandsForMmTable.makeValuesClause(valuesEven));
        String[] pStrings = new String[]{"/p=odd", "/p=even"};
        for (int i = 0; i < pStrings.length; ++i) {
            status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[i]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)status.length);
            Assert.assertTrue((boolean)status[0].getPath().getName().matches("delta_.*"));
        }
        int[][] newValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] newValsEven = new int[][]{{2, 2}};
        this.runStatementOnDriver("insert into " + TableExtended.NONACIDPART + " PARTITION(p='odd') " + TestTxnCommandsForMmTable.makeValuesClause(newValsOdd));
        this.runStatementOnDriver("insert into " + TableExtended.NONACIDPART + " PARTITION(p='even') " + TestTxnCommandsForMmTable.makeValuesClause(newValsEven));
        this.runStatementOnDriver("insert overwrite table " + TableExtended.MMTBLPART + " partition(p) select a,b,p from " + TableExtended.NONACIDPART);
        boolean sawBase = false;
        String[] baseDirs = new String[]{"", ""};
        int deltaCount = 0;
        for (int h = 0; h < pStrings.length; ++h) {
            status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBLPART.toString().toLowerCase() + pStrings[h]), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)2L, (long)status.length);
            for (int i = 0; i < status.length; ++i) {
                String dirName = status[i].getPath().getName();
                if (dirName.matches("delta_.*")) {
                    ++deltaCount;
                    continue;
                }
                sawBase = true;
                baseDirs[h] = dirName;
                Assert.assertTrue((boolean)baseDirs[h].matches("base_.*"));
            }
            Assert.assertEquals((long)1L, (long)deltaCount);
            Assert.assertTrue((boolean)sawBase);
            deltaCount = 0;
            sawBase = false;
        }
        List<String> rs = null;
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " where p='even' order by a,b");
        int[][] rExpectedEven = new int[][]{{2, 2}};
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(rExpectedEven), rs);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " where p='odd' order by a,b");
        int[][] rExpectedOdd = new int[][]{{5, 5}, {11, 11}};
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(rExpectedOdd), rs);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBLPART + " order by a,b");
        int[][] rExpected = new int[][]{{2, 2}, {5, 5}, {11, 11}};
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(rExpected), rs);
    }

    @Test
    public void testInsertOverwriteWithUnionAll() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(3,4)");
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)2L, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("delta_.*"));
        }
        int[][] values = new int[][]{{1, 2}, {2, 4}, {5, 6}, {6, 8}, {9, 10}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + TestTxnCommandsForMmTable.makeValuesClause(values));
        this.runStatementOnDriver("insert overwrite table " + TableExtended.MMTBL + " select a,b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " where a between 1 and 3 union all select a,b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " where a between 5 and 7");
        boolean sawBase = false;
        String baseDir = "";
        int deltaCount = 0;
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            String dirName = status[i].getPath().getName();
            if (dirName.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            sawBase = true;
            baseDir = dirName;
            Assert.assertTrue((boolean)baseDir.matches("base_.*"));
        }
        Assert.assertEquals((long)2L, (long)deltaCount);
        Assert.assertTrue((boolean)sawBase);
        List<String> rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        int[][] rExpected = new int[][]{{1, 2}, {2, 4}, {5, 6}, {6, 8}};
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(rExpected), rs);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBL + " compact 'MAJOR'");
        TestTxnCommandsForMmTable.runWorker(this.hiveConf);
        TestTxnCommandsForMmTable.runCleaner(this.hiveConf);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(rExpected), rs);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        sawBase = false;
        deltaCount = 0;
        for (int i = 0; i < status.length; ++i) {
            String dirName = status[i].getPath().getName();
            if (dirName.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            sawBase = true;
            baseDir = dirName;
            Assert.assertTrue((boolean)baseDir.matches("base_.*"));
        }
        Assert.assertEquals((long)0L, (long)deltaCount);
        Assert.assertTrue((boolean)sawBase);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(rExpected), rs);
    }

    @Test
    public void testOperationsOnCompletedTxnComponentsForMmTable() throws Exception {
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(3,4)");
        this.verifyDirAndResult(2);
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS"));
        this.runStatementOnDriver("alter table " + TableExtended.MMTBL + " compact 'MAJOR'");
        TestTxnCommandsForMmTable.runWorker(this.hiveConf);
        this.verifyDirAndResult(2, true);
        TestTxnCommandsForMmTable.runCleaner(this.hiveConf);
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS"));
        this.verifyDirAndResult(0, true);
    }

    @Test
    public void testImpalaTruncatedMmTableVectorized() throws Exception {
        this.testImpalaTruncatedMmTable(true);
    }

    @Test
    public void testImpalaTruncatedMmTableNonVectorized() throws Exception {
        this.testImpalaTruncatedMmTable(false);
    }

    private void testImpalaTruncatedMmTable(boolean vectorized) throws Exception {
        if (!vectorized) {
            this.d.getConf().setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        }
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Path tblLocation = new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBL.toString().toLowerCase());
        this.runStatementOnDriver("drop table " + TableExtended.MMTBL);
        this.runStatementOnDriver("create table " + TableExtended.MMTBL + "(a int,b int) stored as parquet TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + "(a,b) values(3,4)");
        FileStatus[] status = fs.listStatus(tblLocation, FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)2L, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("delta_.*"));
        }
        this.runStatementOnDriver("insert overwrite  table " + TableExtended.MMTBL + " select * from " + TableExtended.MMTBL + " where 1=2");
        status = fs.listStatus(tblLocation, FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        this.verifyDir(2, true);
        Path basePath = new Path(tblLocation, "base_0000003");
        Assert.assertTrue((String)"Deleting file under base failed", (boolean)fs.delete(new Path(basePath, "000000_0")));
        fs.create(new Path(basePath, "empty"));
        List<String> rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(Collections.emptyList(), rs);
        this.runStatementOnDriver("alter table " + TableExtended.MMTBL + " compact 'MAJOR'");
        TestTxnCommandsForMmTable.runWorker(this.hiveConf);
        TestTxnCommandsForMmTable.runCleaner(this.hiveConf);
        this.verifyDir(0, true);
        rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(Collections.emptyList(), rs);
        if (!vectorized) {
            this.d.getConf().setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        }
    }

    private void verifyDirAndResult(int expectedDeltas) throws Exception {
        this.verifyDirAndResult(expectedDeltas, false);
    }

    private void verifyDirAndResult(int expectedDeltas, boolean expectBaseDir) throws Exception {
        this.verifyDir(expectedDeltas, expectBaseDir);
        int[][] resultData = new int[][]{{1, 2}, {3, 4}};
        List<String> rs = this.runStatementOnDriver("select a,b from " + TableExtended.MMTBL + " order by a,b");
        Assert.assertEquals(TestTxnCommandsForMmTable.stringifyValues(resultData), rs);
    }

    private void verifyDir(int expectedDeltas, boolean expectBaseDir) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + TableExtended.MMTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        int sawDeltaTimes = 0;
        int sawBaseTimes = 0;
        for (int i = 0; i < status.length; ++i) {
            if (status[i].getPath().getName().matches("delta_.*")) {
                ++sawDeltaTimes;
                FileStatus[] files = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Assert.assertEquals((long)1L, (long)files.length);
                Assert.assertEquals((Object)"000000_0", (Object)files[0].getPath().getName());
                continue;
            }
            ++sawBaseTimes;
        }
        Assert.assertEquals((long)expectedDeltas, (long)sawDeltaTimes);
        if (expectBaseDir) {
            Assert.assertEquals((String)"1 base directory expected", (long)1L, (long)sawBaseTimes);
        } else {
            Assert.assertEquals((String)"0 base directories expected", (long)0L, (long)sawBaseTimes);
        }
    }

    @Test
    public void testTruncateWithBase() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_TRUNCATE_USE_BASE, (boolean)true);
        this.runStatementOnDriver("insert into " + TableExtended.MMTBL + " values(1,2),(3,4)");
        this.runStatementOnDriver("truncate table " + TableExtended.MMTBL);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TableExtended.MMTBL.toString().toLowerCase()), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000002", (Object)name);
        List<String> r = this.runStatementOnDriver("select * from " + TableExtended.MMTBL);
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    public void testTruncateWithBaseAllPartition() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_TRUNCATE_USE_BASE, (boolean)true);
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " partition(p='a') values(1,2),(3,4)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " partition(p='b') values(1,2),(3,4)");
        this.runStatementOnDriver("truncate table " + TableExtended.MMTBLPART);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TableExtended.MMTBLPART.toString().toLowerCase() + "/p=a"), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000003", (Object)name);
        List<String> r = this.runStatementOnDriver("select * from " + TableExtended.MMTBLPART);
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    public void testTruncateWithBaseOnePartition() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_TRUNCATE_USE_BASE, (boolean)true);
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " partition(p='a') values(1,2),(3,4)");
        this.runStatementOnDriver("insert into " + TableExtended.MMTBLPART + " partition(p='b') values(5,5),(4,4)");
        this.runStatementOnDriver("truncate table " + TableExtended.MMTBLPART + " partition(p='b')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TableExtended.MMTBLPART.toString().toLowerCase() + "/p=b"), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000003", (Object)name);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), TableExtended.MMTBLPART.toString().toLowerCase() + "/p=a"), AcidUtils.deltaFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 delta and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        List<String> r = this.runStatementOnDriver("select * from " + TableExtended.MMTBLPART);
        Assert.assertEquals((long)2L, (long)r.size());
    }

    static enum TableExtended {
        NONACIDPART("nonAcidPart", "p"),
        MMTBL("mmTbl"),
        MMTBL2("mmTbl2"),
        MMTBLPART("mmTblPart", "p");

        final String name;
        final String partitionColumns;

        public String toString() {
            return this.name;
        }

        private TableExtended(String name) {
            this(name, null);
        }

        private TableExtended(String name, String partitionColumns) {
            this.name = name;
            this.partitionColumns = partitionColumns;
        }
    }
}

