/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AbortCompactResponse;
import org.apache.hadoop.hive.metastore.api.AbortCompactionRequest;
import org.apache.hadoop.hive.metastore.api.AbortCompactionResponseElement;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.service.AcidHouseKeeperService;
import org.apache.hadoop.hive.metastore.txn.service.AcidOpenTxnsCounterService;
import org.apache.hadoop.hive.metastore.txn.service.CompactionHouseKeeperService;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.ddl.DDLTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.scheduled.IScheduledQueryMaintenanceService;
import org.apache.hadoop.hive.ql.scheduled.ScheduledQueryExecutionContext;
import org.apache.hadoop.hive.ql.scheduled.ScheduledQueryExecutionService;
import org.apache.hadoop.hive.ql.schq.MockScheduledQueryService;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.Compactor;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorPipeline;
import org.apache.hadoop.hive.ql.txn.compactor.MRCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnCommands2
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnCommands2.class);
    protected static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands2.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Override
    void initHiveConf() {
        super.initHiveConf();
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)false);
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER, (boolean)true);
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_METADATA_QUERIES, (boolean)false);
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_TRUNCATE_USE_BASE, (boolean)false);
    }

    @Override
    protected void setUpSchema() throws Exception {
        this.runStatementOnDriver("create table " + Table.ACIDTBL + "(a int, b int) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + Table.ACIDTBLPART + "(a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + Table.NONACIDORCTBL + "(a int, b int) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + Table.NONACIDPART + "(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + Table.NONACIDPART2 + "(a2 int, b2 int) partitioned by (p2 string) stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + Table.NONACIDNESTEDPART + "(a int, b int) partitioned by (p string, q string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + Table.ACIDNESTEDPART + "(a int, b int) partitioned by (p int, q int) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + Table.MMTBL + "(a int, b int) TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
    }

    @Override
    protected void dropTables() throws Exception {
        for (Table t : Table.values()) {
            this.runStatementOnDriver("drop table if exists " + t);
        }
    }

    @Test
    public void testOrcPPD() throws Exception {
        this.testOrcPPD(true);
    }

    @Test
    public void testOrcNoPPD() throws Exception {
        this.testOrcPPD(false);
    }

    private void testOrcPPD(boolean enablePPD) throws Exception {
        List<String> explain;
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_EXPLAIN_USER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_OPT_PPD, enablePPD);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_OPT_INDEX_FILTER, enablePPD);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(new int[][]{{1, 2}, {3, 4}}));
        String query = "update " + Table.ACIDTBL + " set b = 5 where a = 3";
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain " + query);
            TestTxnCommands2.assertExplainHasString("filterExpr: (a = 3)", explain, "PPD wasn't pushed");
        }
        this.runStatementOnDriver(query);
        query = "select a,b from " + Table.ACIDTBL + " where b = 4 order by a,b";
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain " + query);
            TestTxnCommands2.assertExplainHasString("filterExpr: (b = 4)", explain, "PPD wasn't pushed");
        }
        List<String> rs0 = this.runStatementOnDriver(query);
        Assert.assertEquals((String)"Read failed", (long)0L, (long)rs0.size());
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        int[][] tableData2 = new int[][]{{1, 7}, {5, 6}, {7, 8}, {9, 10}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData2));
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain delete from " + Table.ACIDTBL + " where a=7 and b=8");
            TestTxnCommands2.assertExplainHasString("filterExpr: ((a = 7) and (b = 8))", explain, "PPD wasn't pushed");
        }
        this.runStatementOnDriver("delete from " + Table.ACIDTBL + " where a=7 and b=8");
        query = "select a,b from " + Table.ACIDTBL + " where a > 1 order by a,b";
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain " + query);
            TestTxnCommands2.assertExplainHasString("filterExpr: (a > 1)", explain, "PPD wasn't pushed");
        }
        List<String> rs1 = this.runStatementOnDriver(query);
        int[][] resultData = new int[][]{{3, 5}, {5, 6}, {9, 10}};
        Assert.assertEquals((String)"Update failed", TestTxnCommands2.stringifyValues(resultData), rs1);
    }

    static void assertExplainHasString(String string, List<String> queryPlan, String errMsg) {
        for (String line : queryPlan) {
            if (line == null || !line.contains(string)) continue;
            return;
        }
        Assert.fail((String)errMsg);
    }

    @Test
    public void testAlterTable() throws Exception {
        int[][] tableData = new int[][]{{1, 2}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData));
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        int[][] tableData2 = new int[][]{{5, 6}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " where b > 0 order by a,b");
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " add columns(c int)");
        int[][] moreTableData = new int[][]{{7, 8, 9}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b,c) " + TestTxnCommands2.makeValuesClause(moreTableData));
        List<String> rs0 = this.runStatementOnDriver("select a,b,c from " + Table.ACIDTBL + " where a > 0 order by a,b,c");
    }

    @Test
    public void testNonAcidInsert() throws Exception {
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(2,3)");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
    }

    @Test
    public void testOriginalFileReaderWhenNonAcidConvertedToAcid() throws Exception {
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(1,2),(3,4),(5,6),(7,8),(9,10)");
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='default')");
        this.runStatementOnDriver("update " + Table.NONACIDORCTBL + " set b = b*2 where b in (4,10)");
        this.runStatementOnDriver("delete from " + Table.NONACIDORCTBL + " where a = 7");
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL + " order by a,b");
        int[][] resultData = new int[][]{{1, 2}, {3, 8}, {5, 6}, {9, 20}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        ShowCompactResponse resp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        this.runStatementOnDriver("delete from " + Table.NONACIDORCTBL + " where a = 1");
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL + " order by a,b");
        resultData = new int[][]{{3, 8}, {5, 6}, {9, 20}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
    }

    @Test
    public void testNonAcidToAcidConversion02() throws Exception {
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(1,2),(1,3)");
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(0,12),(0,13),(1,4),(1,5)");
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(1,6)");
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='default')");
        List<String> rs1 = this.runStatementOnDriver("describe " + Table.NONACIDORCTBL);
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(0,15),(1,16)");
        this.runStatementOnDriver("update " + Table.NONACIDORCTBL + " set b = 120 where a = 0 and b = 12");
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(0,17)");
        this.runStatementOnDriver("delete from " + Table.NONACIDORCTBL + " where a = 1 and b = 3");
        List<String> rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from " + Table.NONACIDORCTBL + " order by a,b");
        LOG.warn("before compact");
        for (String s : rs) {
            LOG.warn(s);
        }
        Assert.assertEquals((long)0x20000000L, (long)BucketCodec.V1.encode(new AcidOutputFormat.Options((Configuration)this.hiveConf).bucket(0)));
        Assert.assertEquals((long)0x20010000L, (long)BucketCodec.V1.encode(new AcidOutputFormat.Options((Configuration)this.hiveConf).bucket(1)));
        String[][] expected = new String[][]{{"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":3}\t0\t13", "bucket_00001"}, {"{\"writeid\":10000001,\"bucketid\":536936448,\"rowid\":0}\t0\t15", "bucket_00001"}, {"{\"writeid\":10000003,\"bucketid\":536936448,\"rowid\":0}\t0\t17", "bucket_00001"}, {"{\"writeid\":10000002,\"bucketid\":536936449,\"rowid\":0}\t0\t120", "bucket_00001"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":0}\t1\t2", "bucket_00001"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":4}\t1\t4", "bucket_00001"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":5}\t1\t5", "bucket_00001"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":6}\t1\t6", "bucket_00001"}, {"{\"writeid\":10000001,\"bucketid\":536936448,\"rowid\":1}\t1\t16", "bucket_00001"}};
        Assert.assertEquals((String)"Unexpected row count before compaction", (long)expected.length, (long)rs.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((String)("Actual line " + i + " bc: " + rs.get(i) + "; expected " + expected[i][0]), (boolean)rs.get(i).startsWith(expected[i][0]));
        }
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from " + Table.NONACIDORCTBL + " order by a,b");
        LOG.warn("after compact");
        for (String s : rs) {
            LOG.warn(s);
        }
        Assert.assertEquals((String)"Unexpected row count after compaction", (long)expected.length, (long)rs.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((String)("Actual line " + i + " ac: " + rs.get(i)), (boolean)rs.get(i).startsWith(expected[i][0]));
            Assert.assertTrue((String)("Actual line(bucket) " + i + " ac: " + rs.get(i)), (boolean)rs.get(i).endsWith(expected[i][1]));
        }
    }

    @Test
    public void testFailureOnAlteringTransactionalProperties() throws Exception {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("TBLPROPERTIES with 'transactional_properties' cannot be altered after the table is created");
        this.runStatementOnDriver("create table acidTblLegacy (a int, b int) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("alter table acidTblLegacy SET TBLPROPERTIES ('transactional_properties' = 'insert_only')");
    }

    @Test
    public void testNonAcidToAcidConversion1() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(1,2)");
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("000001_0"));
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " SET TBLPROPERTIES ('transactional'='true')");
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("000001_0"));
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(3,4)");
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)2L, (long)status.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < status.length; ++i) {
            if (status[i].getPath().getName().matches("delta_.*")) {
                sawNewDelta = true;
                FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00000_0"));
                continue;
            }
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        Assert.assertTrue((boolean)sawNewDelta);
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL + " order by a,b");
        resultData = new int[][]{{1, 2}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            sawNewBase = true;
            Object[] buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
            Arrays.sort(buckets);
            Assert.assertEquals((long)2L, (long)buckets.length);
            Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{3, 4}, {1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValuesNoSort(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        String fakeFile0 = this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase() + "/subdir/000000_0";
        String fakeFile1 = this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase() + "/subdir/000000_1";
        fs.create(new Path(fakeFile0));
        fs.create(new Path(fakeFile1));
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        TestTxnCommands2.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
        Object[] buckets = fs.listStatus(status[0].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Arrays.sort(buckets);
        Assert.assertEquals((long)2L, (long)buckets.length);
        Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{3, 4}, {1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValuesNoSort(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    @Test
    public void testNonAcidToAcidConversion2() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(1,2)");
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("000001_0"));
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " SET TBLPROPERTIES ('transactional'='true')");
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("000001_0"));
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("update " + Table.NONACIDORCTBL + " set b=3 where a=1");
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        boolean sawNewDelta = false;
        boolean sawNewDeleteDelta = false;
        for (int i = 0; i < status.length; ++i) {
            FileStatus[] buckets;
            if (status[i].getPath().getName().matches("delta_.*")) {
                sawNewDelta = true;
                buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]_0"));
                continue;
            }
            if (status[i].getPath().getName().matches("delete_delta_.*")) {
                sawNewDeleteDelta = true;
                buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01_0]_0"));
                continue;
            }
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        Assert.assertTrue((boolean)sawNewDelta);
        Assert.assertTrue((boolean)sawNewDeleteDelta);
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{1, 3}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)buckets.length);
            Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00001"));
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{1, 3}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        TestTxnCommands2.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
        FileStatus[] buckets = fs.listStatus(status[0].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)buckets.length);
        Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00001"));
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{1, 3}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    @Test
    public void testNonAcidToAcidConversion3() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(1,2)");
        Object[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("000001_0"));
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " SET TBLPROPERTIES ('transactional'='true')");
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("000001_0"));
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)2L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            Assert.assertTrue((boolean)status[i].getPath().getName().startsWith("base_-9223372036854775808_v0000008"));
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)buckets.length);
            Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("update " + Table.NONACIDORCTBL + " set b=3 where a=1");
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(3,4)");
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Arrays.sort(status);
        Assert.assertEquals((long)5L, (long)status.length);
        int numDelta = 0;
        int numDeleteDelta = 0;
        sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            Object[] buckets;
            if (status[i].getPath().getName().matches("delta_.*")) {
                buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Arrays.sort(buckets);
                if (++numDelta == 1) {
                    Assert.assertEquals((Object)"delta_10000001_10000001_0001", (Object)status[i].getPath().getName());
                    Assert.assertEquals((long)1L, (long)buckets.length);
                    Assert.assertEquals((Object)"bucket_00001_0", (Object)buckets[0].getPath().getName());
                    continue;
                }
                if (numDelta != 2) continue;
                Assert.assertEquals((Object)"delta_10000002_10000002_0000", (Object)status[i].getPath().getName());
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00000_0", (Object)buckets[0].getPath().getName());
                continue;
            }
            if (status[i].getPath().getName().matches("delete_delta_.*")) {
                buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Arrays.sort(buckets);
                if (++numDeleteDelta != 1) continue;
                Assert.assertEquals((Object)"delete_delta_10000001_10000001_0000", (Object)status[i].getPath().getName());
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001_0", (Object)buckets[0].getPath().getName());
                continue;
            }
            if (status[i].getPath().getName().matches("base_.*")) {
                Assert.assertTrue((String)"base_-9223372036854775808", (boolean)status[i].getPath().getName().startsWith("base_-9223372036854775808_v0000008"));
                sawNewBase = true;
                buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                continue;
            }
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        Assert.assertEquals((long)2L, (long)numDelta);
        Assert.assertEquals((long)1L, (long)numDeleteDelta);
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{1, 3}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + Table.NONACIDORCTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Arrays.sort(status);
        Assert.assertEquals((long)6L, (long)status.length);
        int numBase = 0;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            Object[] buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
            Arrays.sort(buckets);
            if (++numBase == 1) {
                Assert.assertEquals((Object)"base_-9223372036854775808_v0000008", (Object)status[i].getPath().getName());
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                continue;
            }
            if (numBase != 2) continue;
            Assert.assertEquals((Object)"base_10000002_v0000016", (Object)status[i].getPath().getName());
            Assert.assertEquals((long)2L, (long)buckets.length);
            Assert.assertEquals((Object)"bucket_00000", (Object)buckets[0].getPath().getName());
        }
        Assert.assertEquals((long)2L, (long)numBase);
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{3, 4}, {1, 3}};
        Assert.assertEquals(TestTxnCommands2.stringifyValuesNoSort(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)6L, (long)status.length);
        TestTxnCommands2.runCleaner(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertEquals((Object)"base_10000002_v0000016", (Object)status[0].getPath().getName());
        Object[] buckets = fs.listStatus(status[0].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Arrays.sort(buckets);
        Assert.assertEquals((long)2L, (long)buckets.length);
        Assert.assertEquals((Object)"bucket_00000", (Object)buckets[0].getPath().getName());
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        resultData = new int[][]{{3, 4}, {1, 3}};
        Assert.assertEquals(TestTxnCommands2.stringifyValuesNoSort(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDORCTBL);
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    @Test
    public void testNonAcidToAcidConversion4() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        int[][] targetVals = new int[][]{{1, 2}};
        this.runStatementOnDriver("insert into " + Table.NONACIDNESTEDPART + " partition(p='p1',q='q1') " + TestTxnCommands2.makeValuesClause(targetVals));
        Object[] status = this.listFilesByTable(fs, Table.NONACIDNESTEDPART);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("000001_0"));
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDNESTEDPART);
        Assert.assertEquals(TestTxnCommands2.stringifyValues(targetVals), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDNESTEDPART);
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + Table.NONACIDNESTEDPART + " SET TBLPROPERTIES ('transactional'='true')");
        status = this.listFilesByTable(fs, Table.NONACIDNESTEDPART);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("000001_0"));
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDNESTEDPART);
        Assert.assertEquals(TestTxnCommands2.stringifyValues(targetVals), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDNESTEDPART);
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + Table.NONACIDNESTEDPART + " partition(p='p1',q='q1') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = this.listFilesByTable(fs, Table.NONACIDNESTEDPART);
        Assert.assertEquals((long)2L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            Path parent = status[i].getPath().getParent();
            if (!parent.getName().matches("base_.*")) continue;
            Assert.assertTrue((boolean)parent.getName().startsWith("base_-9223372036854775808_v0000008"));
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(parent, FileUtils.HIDDEN_FILES_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)buckets.length);
            Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDNESTEDPART);
        Assert.assertEquals(TestTxnCommands2.stringifyValues(targetVals), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDNESTEDPART);
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("update " + Table.NONACIDNESTEDPART + " set b=3 where a=1");
        this.runStatementOnDriver("insert into " + Table.NONACIDNESTEDPART + "(a,b,p,q) values(3,4,'p1','q1')");
        status = this.listFilesByTable(fs, Table.NONACIDNESTEDPART);
        Arrays.sort(status);
        Assert.assertEquals((long)5L, (long)status.length);
        int numDelta = 0;
        int numDeleteDelta = 0;
        sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            Object[] buckets;
            Path parent = status[i].getPath().getParent();
            if (parent.getName().matches("delta_.*")) {
                buckets = fs.listStatus(parent, FileUtils.HIDDEN_FILES_PATH_FILTER);
                Arrays.sort(buckets);
                if (++numDelta == 1) {
                    Assert.assertEquals((Object)"delta_10000001_10000001_0001", (Object)parent.getName());
                    Assert.assertEquals((long)1L, (long)buckets.length);
                    Assert.assertEquals((Object)"bucket_00001_0", (Object)buckets[0].getPath().getName());
                    continue;
                }
                if (numDelta != 2) continue;
                Assert.assertEquals((Object)"delta_10000002_10000002_0000", (Object)parent.getName());
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00000_0", (Object)buckets[0].getPath().getName());
                continue;
            }
            if (parent.getName().matches("delete_delta_.*")) {
                buckets = fs.listStatus(parent, FileUtils.HIDDEN_FILES_PATH_FILTER);
                Arrays.sort(buckets);
                if (++numDeleteDelta != 1) continue;
                Assert.assertEquals((Object)"delete_delta_10000001_10000001_0000", (Object)parent.getName());
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001_0", (Object)buckets[0].getPath().getName());
                continue;
            }
            if (!parent.getName().matches("base_.*")) continue;
            Assert.assertTrue((String)"base_-9223372036854775808", (boolean)parent.getName().startsWith("base_-9223372036854775808_v0000008"));
            sawNewBase = true;
            buckets = fs.listStatus(parent, FileUtils.HIDDEN_FILES_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)buckets.length);
            Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
        }
        Assert.assertEquals((long)2L, (long)numDelta);
        Assert.assertEquals((long)1L, (long)numDeleteDelta);
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDNESTEDPART);
        targetVals = new int[][]{{1, 3}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(targetVals), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDNESTEDPART);
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + Table.NONACIDNESTEDPART + " partition(p='p1',q='q1') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = this.listFilesByTable(fs, Table.NONACIDNESTEDPART);
        Arrays.sort(status);
        Assert.assertEquals((long)7L, (long)status.length);
        int numBase = 0;
        HashSet<Path> bases = new HashSet<Path>();
        for (int i = 0; i < status.length; ++i) {
            Path parent = status[i].getPath().getParent();
            if (!parent.getName().matches("base_.*")) continue;
            bases.add(parent);
            Object[] buckets = fs.listStatus(parent, FileUtils.HIDDEN_FILES_PATH_FILTER);
            Arrays.sort(buckets);
            if (++numBase == 1) {
                Assert.assertEquals((Object)"base_-9223372036854775808_v0000008", (Object)parent.getName());
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                continue;
            }
            if (numBase != 2) continue;
            Assert.assertEquals((Object)"base_10000002_v0000016", (Object)parent.getName());
            Assert.assertEquals((long)2L, (long)buckets.length);
            Assert.assertEquals((Object)"bucket_00000", (Object)buckets[0].getPath().getName());
        }
        Assert.assertEquals((long)2L, (long)bases.size());
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDNESTEDPART);
        targetVals = new int[][]{{3, 4}, {1, 3}};
        Assert.assertEquals(TestTxnCommands2.stringifyValuesNoSort(targetVals), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDNESTEDPART);
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        status = this.listFilesByTable(fs, Table.NONACIDNESTEDPART);
        Assert.assertEquals((long)7L, (long)status.length);
        TestTxnCommands2.runCleaner(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        status = this.listFilesByTable(fs, Table.NONACIDNESTEDPART);
        Assert.assertEquals((long)2L, (long)status.length);
        Assert.assertEquals((Object)"base_10000002_v0000016", (Object)status[0].getPath().getParent().getName());
        Object[] buckets = fs.listStatus(status[0].getPath().getParent(), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Arrays.sort(buckets);
        Assert.assertEquals((long)2L, (long)buckets.length);
        Assert.assertEquals((Object)"bucket_00000", (Object)buckets[0].getPath().getName());
        rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDNESTEDPART);
        targetVals = new int[][]{{3, 4}, {1, 3}};
        Assert.assertEquals(TestTxnCommands2.stringifyValuesNoSort(targetVals), rs);
        rs = this.runStatementOnDriver("select count(*) from " + Table.NONACIDNESTEDPART);
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    private FileStatus[] listFilesByTable(FileSystem fs, Table t) throws IOException {
        ArrayList<LocatedFileStatus> tmp = new ArrayList<LocatedFileStatus>();
        RemoteIterator f = fs.listFiles(new Path(this.getWarehouseDir() + "/" + t.toString().toLowerCase()), true);
        while (f.hasNext()) {
            LocatedFileStatus file = (LocatedFileStatus)f.next();
            if (!FileUtils.HIDDEN_FILES_PATH_FILTER.accept(file.getPath())) continue;
            tmp.add(file);
        }
        return tmp.toArray(new FileStatus[0]);
    }

    @Test
    public void testValidTxnsBookkeeping() throws Exception {
        this.runStatementOnDriver("select * from " + Table.NONACIDORCTBL);
        String value = this.hiveConf.get("hive.txn.tables.valid.writeids");
        Assert.assertNull((String)"The entry should be null for query that doesn't involve ACID tables", (Object)value);
    }

    @Test
    public void testSimpleRead() throws Exception {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, "more");
        int[][] tableData = new int[][]{{1, 2}, {3, 3}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " " + TestTxnCommands2.makeValuesClause(tableData));
        int[][] tableData2 = new int[][]{{5, 3}};
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " " + TestTxnCommands2.makeValuesClause(tableData2));
        assert (this.hiveConf.get("hive.txn.tables.valid.writeids") == null) : "previous txn should've cleaned it";
        List<String> rs = this.runStatementOnDriver("select * from " + Table.ACIDTBL);
        Assert.assertEquals((String)"Extra data", (long)2L, (long)rs.size());
    }

    @Test
    public void testUpdateMixedCase() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData));
        this.runStatementOnDriver("update " + Table.ACIDTBL + " set B = 7 where A=1");
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 3}, {5, 3}};
        Assert.assertEquals((String)"Update failed", TestTxnCommands2.stringifyValues(updatedData), rs);
        this.runStatementOnDriver("update " + Table.ACIDTBL + " set B = B + 1 where A=1");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] updatedData2 = new int[][]{{1, 8}, {3, 3}, {5, 3}};
        Assert.assertEquals((String)"Update failed", TestTxnCommands2.stringifyValues(updatedData2), rs2);
    }

    @Test
    public void testDeleteIn() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 2}, {5, 2}, {1, 3}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(1,7),(3,7)");
        this.runStatementOnDriver("delete from " + Table.ACIDTBL + " where a in(select a from " + Table.NONACIDORCTBL + ")");
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) select a,b from " + Table.NONACIDORCTBL);
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 7}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update failed", TestTxnCommands2.stringifyValues(updatedData), rs);
        this.runStatementOnDriver("update " + Table.ACIDTBL + " set b=19 where b in(select b from " + Table.NONACIDORCTBL + " where a = 3)");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] updatedData2 = new int[][]{{1, 19}, {3, 19}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update2 failed", TestTxnCommands2.stringifyValues(updatedData2), rs2);
    }

    @Test
    public void updateDeletePartitioned() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p=1) (a,b) " + TestTxnCommands2.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p=2) (a,b) " + TestTxnCommands2.makeValuesClause(tableData));
        CompactionRequest request = new CompactionRequest("default", Table.ACIDTBLPART.name(), CompactionType.MAJOR);
        request.setPartitionname("p=1");
        this.txnHandler.compact(request);
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("update " + Table.ACIDTBLPART + " set b = b + 1 where a = 3");
        this.txnHandler.compact(request);
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        List<String> rs = this.runStatementOnDriver("select p,a,b from " + Table.ACIDTBLPART + " order by p, a, b");
        int[][] expectedData = new int[][]{{1, 1, 2}, {1, 3, 5}, {1, 5, 6}, {2, 1, 2}, {2, 3, 5}, {2, 5, 6}};
        Assert.assertEquals((String)("Update " + Table.ACIDTBLPART + " didn't match:"), TestTxnCommands2.stringifyValues(expectedData), rs);
    }

    @Test
    public void testEmptyInTblproperties() throws Exception {
        this.runStatementOnDriver("create table t1 (a int, b int) stored as orc TBLPROPERTIES ('serialization.null.format'='', 'transactional'='true')");
        this.runStatementOnDriver("insert into t1 (a,b) values(1,7),(3,7)");
        this.runStatementOnDriver("update t1 set b = -2 where a = 1");
        this.runStatementOnDriver("alter table t1  compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        ShowCompactResponse resp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
    }

    @Test
    public void testBucketizedInputFormat() throws Exception {
        int[][] tableData = new int[][]{{1, 2}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p=1) (a,b) " + TestTxnCommands2.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) select a,b from " + Table.ACIDTBLPART + " where p = 1");
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL);
        Assert.assertEquals((String)("Insert into " + Table.ACIDTBL + " didn't match:"), TestTxnCommands2.stringifyValues(tableData), rs);
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) select a,b from " + Table.ACIDTBLPART + " where p = 1");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL);
        Assert.assertEquals((String)("Insert into " + Table.NONACIDORCTBL + " didn't match:"), TestTxnCommands2.stringifyValues(tableData), rs2);
    }

    @Test
    public void testInsertOverwriteWithSelfJoin() throws Exception {
        int[][] part1Data = new int[][]{{1, 7}};
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(part1Data));
        this.runStatementOnDriver("insert overwrite table " + Table.NONACIDORCTBL + " select 2, 9 from " + Table.NONACIDORCTBL + " T inner join " + Table.NONACIDORCTBL + " S on T.a=S.a");
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.NONACIDORCTBL + " order by a,b");
        int[][] joinData = new int[][]{{2, 9}};
        Assert.assertEquals((String)"Self join non-part insert overwrite failed", TestTxnCommands2.stringifyValues(joinData), rs);
        int[][] part2Data = new int[][]{{1, 8}};
        this.runStatementOnDriver("insert into " + Table.NONACIDPART + " partition(p=1) (a,b) " + TestTxnCommands2.makeValuesClause(part1Data));
        this.runStatementOnDriver("insert into " + Table.NONACIDPART + " partition(p=2) (a,b) " + TestTxnCommands2.makeValuesClause(part2Data));
        this.runStatementOnDriver("insert overwrite table " + Table.NONACIDPART + " partition(p=1) select a,b from " + Table.NONACIDPART);
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + Table.NONACIDPART + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {1, 8}, {1, 8}};
        Assert.assertEquals((String)"Insert overwrite partition failed", TestTxnCommands2.stringifyValues(updatedData), rs2);
    }

    private static void checkCompactionState(CompactionsByState expected, CompactionsByState actual) {
        Assert.assertEquals((String)"did not initiate", (long)expected.didNotInitiate, (long)actual.didNotInitiate);
        Assert.assertEquals((String)"failed", (long)expected.failed, (long)actual.failed);
        Assert.assertEquals((String)"initiated", (long)expected.initiated, (long)actual.initiated);
        Assert.assertEquals((String)"ready for cleaning", (long)expected.readyToClean, (long)actual.readyToClean);
        Assert.assertEquals((String)"succeeded", (long)expected.succeeded, (long)actual.succeeded);
        Assert.assertEquals((String)"working", (long)expected.working, (long)actual.working);
        Assert.assertEquals((String)"total", (long)expected.total, (long)actual.total);
    }

    @Test
    public void testInitiatorWithMultipleFailedCompactions() throws Exception {
        this.testInitiatorWithMultipleFailedCompactionsForVariousTblProperties("'transactional'='true'");
    }

    void testInitiatorWithMultipleFailedCompactionsForVariousTblProperties(String tblProperties) throws Exception {
        String tblName = "hive12353";
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING)  CLUSTERED BY(a) INTO 1 BUCKETS STORED AS ORC  TBLPROPERTIES ( " + tblProperties + " )");
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELTA_NUM_THRESHOLD, 4);
        for (int i = 0; i < 5; ++i) {
            this.runStatementOnDriver("insert into " + tblName + " values(" + (i + 1) + ", 'foo'),(" + (i + 2) + ", 'bar'),(" + (i + 3) + ", 'baz')");
        }
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_COMPACTION, true);
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEANER_ON, (boolean)true);
        int numFailedCompactions = MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
        AtomicBoolean stop = new AtomicBoolean(true);
        for (int i = 0; i < numFailedCompactions; ++i) {
            this.txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
            TestTxnCommands2.runWorker(this.hiveConf);
        }
        TestTxnCommands2.runInitiator(this.hiveConf);
        int numDidNotInitiateCompactions = 1;
        TestTxnCommands2.checkCompactionState(new CompactionsByState(numDidNotInitiateCompactions, numFailedCompactions, 0, 0, 0, 0, numFailedCompactions + numDidNotInitiateCompactions), TestTxnCommands2.countCompacts(this.txnHandler));
        MetastoreConf.setTimeVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ACID_HOUSEKEEPER_SERVICE_INTERVAL, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        MetastoreConf.setTimeVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTION_HOUSEKEEPER_SERVICE_INTERVAL, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        AcidHouseKeeperService houseKeeper = new AcidHouseKeeperService();
        CompactionHouseKeeperService compactionHouseKeeper = new CompactionHouseKeeperService();
        houseKeeper.setConf((Configuration)this.hiveConf);
        compactionHouseKeeper.setConf((Configuration)this.hiveConf);
        houseKeeper.run();
        compactionHouseKeeper.run();
        TestTxnCommands2.checkCompactionState(new CompactionsByState(numDidNotInitiateCompactions, numFailedCompactions, 0, 0, 0, 0, numFailedCompactions + numDidNotInitiateCompactions), TestTxnCommands2.countCompacts(this.txnHandler));
        this.txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MAJOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        this.txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runInitiator(this.hiveConf);
        ++numDidNotInitiateCompactions;
        TestTxnCommands2.runInitiator(this.hiveConf);
        TestTxnCommands2.checkCompactionState(new CompactionsByState(++numDidNotInitiateCompactions, numFailedCompactions + 2, 0, 0, 0, 0, numFailedCompactions + 2 + numDidNotInitiateCompactions), TestTxnCommands2.countCompacts(this.txnHandler));
        houseKeeper.run();
        compactionHouseKeeper.run();
        TestTxnCommands2.checkCompactionState(new CompactionsByState(MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE), MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), 0, 0, 0, 0, MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE)), TestTxnCommands2.countCompacts(this.txnHandler));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_COMPACTION, false);
        this.txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
        TestTxnCommands2.checkCompactionState(new CompactionsByState(MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE), MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), 1, 0, 0, 0, MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE) + 1), TestTxnCommands2.countCompacts(this.txnHandler));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.checkCompactionState(new CompactionsByState(MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE), MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), 0, 1, 0, 0, MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE) + 1), TestTxnCommands2.countCompacts(this.txnHandler));
        TestTxnCommands2.runCleaner(this.hiveConf);
        houseKeeper.run();
        compactionHouseKeeper.run();
        TestTxnCommands2.checkCompactionState(new CompactionsByState(MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE), MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), 0, 0, 1, 0, MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + MetastoreConf.getIntVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE) + 1), TestTxnCommands2.countCompacts(this.txnHandler));
    }

    @Test
    public void testInitiatorWithMinorCompactionForInsertOnlyTable() throws Exception {
        int i;
        String tblName = "insertOnlyTable";
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("create table " + tblName + " (a INT, b STRING) stored as orc tblproperties('transactional'='true', 'transactional_properties' = 'insert_only')");
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELTA_NUM_THRESHOLD, 4);
        this.hiveConf.setFloatVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELTA_PCT_THRESHOLD, 1.0f);
        for (i = 0; i < 20; ++i) {
            this.runStatementOnDriver("insert into " + tblName + " values(" + (i + 1) + ", 'foo'),(" + (i + 2) + ", 'bar'),(" + (i + 3) + ", 'baz')");
        }
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEANER_ON, (boolean)true);
        TestTxnCommands2.runInitiator(this.hiveConf);
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        for (i = 0; i < 5; ++i) {
            this.runStatementOnDriver("insert into " + tblName + " values(" + (i + 1) + ", 'foo'),(" + (i + 2) + ", 'bar'),(" + (i + 3) + ", 'baz')");
        }
        TestTxnCommands2.runInitiator(this.hiveConf);
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDir(1, tblName, "");
        this.verifyBaseDir(1, tblName, "");
    }

    private static CompactionsByState countCompacts(TxnStore txnHandler) throws MetaException {
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        CompactionsByState compactionsByState = new CompactionsByState();
        compactionsByState.total = resp.getCompactsSize();
        for (ShowCompactResponseElement compact : resp.getCompacts()) {
            if ("failed".equals(compact.getState())) {
                ++compactionsByState.failed;
                continue;
            }
            if ("ready for cleaning".equals(compact.getState())) {
                ++compactionsByState.readyToClean;
                continue;
            }
            if ("initiated".equals(compact.getState())) {
                ++compactionsByState.initiated;
                continue;
            }
            if ("succeeded".equals(compact.getState())) {
                ++compactionsByState.succeeded;
                continue;
            }
            if ("working".equals(compact.getState())) {
                ++compactionsByState.working;
                continue;
            }
            if ("did not initiate".equals(compact.getState())) {
                ++compactionsByState.didNotInitiate;
                continue;
            }
            throw new IllegalStateException("Unexpected state: " + compact.getState());
        }
        return compactionsByState;
    }

    @Test
    public void testDropTableAndCompactionConcurrent() throws Exception {
        this.execDDLOpAndCompactionConcurrently("DROP_TABLE", false);
    }

    @Test
    public void testTruncateTableAndCompactioConcurrent() throws Exception {
        this.execDDLOpAndCompactionConcurrently("TRUNCATE_TABLE", false);
    }

    @Test
    public void testDropPartitionAndCompactionConcurrent() throws Exception {
        this.execDDLOpAndCompactionConcurrently("DROP_PARTITION", true);
    }

    @Test
    public void testTruncatePartitionAndCompactionConcurrent() throws Exception {
        this.execDDLOpAndCompactionConcurrently("TRUNCATE_PARTITION", true);
    }

    private void execDDLOpAndCompactionConcurrently(String opType, boolean isPartioned) throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_GATHER_STATS, false);
        String tblName = "hive12352";
        String partName = "test";
        this.runStatementOnDriver("DROP TABLE if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING)" + (isPartioned ? "partitioned by (p STRING)" : "") + " STORED AS ORC  TBLPROPERTIES ( 'transactional'='true' )");
        this.runStatementOnDriver("INSERT INTO " + tblName + (String)(isPartioned ? " PARTITION (p='" + partName + "')" : "") + " VALUES (1, 'foo'),(2, 'bar'),(3, 'baz')");
        this.runStatementOnDriver("UPDATE " + tblName + " SET b = 'blah' WHERE a = 3");
        CompactionRequest req = new CompactionRequest("default", tblName, CompactionType.MAJOR);
        if (isPartioned) {
            req.setPartitionname("p=" + partName);
        }
        this.txnHandler.compact(req);
        MRCompactor mrCompactor = (MRCompactor)Mockito.spy((Object)new MRCompactor(HiveMetaStoreUtils.getHiveMetastoreClient((HiveConf)this.hiveConf)));
        CountDownLatch ddlStart = new CountDownLatch(1);
        ((MRCompactor)Mockito.doAnswer(invocationOnMock -> {
            JobConf job = (JobConf)invocationOnMock.callRealMethod();
            job.setMapperClass(SlowCompactorMap.class);
            ddlStart.countDown();
            return job;
        }).when((Object)mrCompactor)).createBaseJobConf((HiveConf)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (org.apache.hadoop.hive.metastore.api.Table)ArgumentMatchers.any(), (StorageDescriptor)ArgumentMatchers.any(), (ValidWriteIdList)ArgumentMatchers.any(), (CompactionInfo)ArgumentMatchers.any());
        CompactorFactory mockedFactory = (CompactorFactory)Mockito.mock(CompactorFactory.class);
        Mockito.when((Object)mockedFactory.getCompactorPipeline((org.apache.hadoop.hive.metastore.api.Table)ArgumentMatchers.any(), (HiveConf)ArgumentMatchers.any(), (CompactionInfo)ArgumentMatchers.any(), (IMetaStoreClient)ArgumentMatchers.any())).thenReturn((Object)new CompactorPipeline((Compactor)mrCompactor));
        Worker worker = new Worker(mockedFactory);
        worker.setConf((Configuration)this.hiveConf);
        worker.init(new AtomicBoolean(true));
        CompletableFuture<Void> compactionJob = CompletableFuture.runAsync((Runnable)worker);
        if (!ddlStart.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Waiting too long for compaction to start!");
        }
        int compHistory = 0;
        switch (opType) {
            case "DROP_TABLE": {
                this.runStatementOnDriver("DROP TABLE " + tblName);
                this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING)  STORED AS ORC  TBLPROPERTIES ( 'transactional'='true' )");
                break;
            }
            case "TRUNCATE_TABLE": {
                this.runStatementOnDriver("TRUNCATE TABLE " + tblName);
                compHistory = 1;
                break;
            }
            case "DROP_PARTITION": {
                this.runStatementOnDriver("ALTER TABLE " + tblName + " DROP PARTITION (p='" + partName + "')");
                this.runStatementOnDriver("ALTER TABLE " + tblName + " ADD PARTITION (p='" + partName + "')");
                break;
            }
            case "TRUNCATE_PARTITION": {
                this.runStatementOnDriver("TRUNCATE TABLE " + tblName + " PARTITION (p='" + partName + "')");
                compHistory = 1;
            }
        }
        compactionJob.join();
        ShowCompactResponse resp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)compHistory, (long)resp.getCompactsSize());
        if (compHistory != 0) {
            Assert.assertEquals((String)"Unexpected 0th compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        }
        GetOpenTxnsResponse openResp = this.txnHandler.getOpenTxns();
        Assert.assertEquals((String)openResp.toString(), (long)0L, (long)openResp.getOpen_txnsSize());
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + tblName + (String)(isPartioned ? "/p=" + partName : "")), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)0L, (long)status.length);
    }

    @Test
    public void writeBetweenWorkerAndCleaner() throws Exception {
        this.writeBetweenWorkerAndCleanerForVariousTblProperties("'transactional'='true'");
    }

    private void writeBetweenWorkerAndCleanerForVariousTblProperties(String tblProperties) throws Exception {
        String tblName = "hive12352";
        this.dropTables(tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING)  CLUSTERED BY(a) INTO 1 BUCKETS STORED AS ORC  TBLPROPERTIES ( " + tblProperties + " )");
        this.runStatementOnDriver("insert into " + tblName + " values(1, 'foo'),(2, 'bar'),(3, 'baz')");
        this.runStatementOnDriver("update " + tblName + " set b = 'blah' where a = 3");
        this.txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("delete from " + tblName + " where a = 1");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1\tfoo");
        expected.add("2\tbar");
        expected.add("3\tblah");
        Assert.assertEquals((String)"", expected, this.runStatementOnDriver("select a,b from " + tblName + " order by a"));
        TestTxnCommands2.runCleaner(this.hiveConf);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + tblName.toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        HashSet<String> expectedDeltas = new HashSet<String>();
        expectedDeltas.add("delete_delta_0000001_0000002_v0000008");
        expectedDeltas.add("delta_0000001_0000002_v0000008");
        expectedDeltas.add("delete_delta_0000003_0000003_0000");
        HashSet<String> actualDeltas = new HashSet<String>();
        for (FileStatus file : status) {
            actualDeltas.add(file.getPath().getName());
        }
        Assert.assertEquals(expectedDeltas, actualDeltas);
        this.runStatementOnDriver("insert into " + tblName + " values(4, 'xyz')");
        expected.add("4\txyz");
        this.txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + tblName.toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        expectedDeltas = new HashSet();
        expectedDeltas.add("delete_delta_0000001_0000004_v0000013");
        expectedDeltas.add("delta_0000001_0000004_v0000013");
        actualDeltas = new HashSet();
        for (FileStatus file : status) {
            actualDeltas.add(file.getPath().getName());
        }
        Assert.assertEquals(expectedDeltas, actualDeltas);
        TestTxnCommands2.runInitiator(this.hiveConf);
        Assert.assertEquals((String)"", expected, this.runStatementOnDriver("select a,b from " + tblName + " order by a"));
    }

    @Test
    public void testFailHeartbeater() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_HEARTBEATER, true);
        RuntimeException exception = null;
        try {
            this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(new int[][]{{1, 2}, {3, 4}}));
        }
        catch (RuntimeException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertTrue((boolean)exception.getMessage().contains("HIVE_TEST_MODE_FAIL_HEARTBEATER=true"));
    }

    @Test
    public void testOpenTxnsCounter() throws Exception {
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_MAX_OPEN_TXNS, 3);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_COUNT_OPEN_TXNS_INTERVAL, 10L, TimeUnit.MILLISECONDS);
        OpenTxnsResponse openTxnsResponse = this.txnHandler.openTxns(new OpenTxnRequest(3, "me", "localhost"));
        AcidOpenTxnsCounterService openTxnsCounterService = new AcidOpenTxnsCounterService();
        openTxnsCounterService.setConf((Configuration)this.hiveConf);
        openTxnsCounterService.run();
        MetaException exception = null;
        try {
            this.txnHandler.openTxns(new OpenTxnRequest(1, "you", "localhost"));
        }
        catch (MetaException e) {
            exception = e;
        }
        Assert.assertNotNull((String)"Opening new transaction shouldn't be allowed", (Object)((Object)exception));
        Assert.assertTrue((boolean)exception.getMessage().equals("Maximum allowed number of open transactions has been reached. See hive.max.open.txns."));
        Iterator e = openTxnsResponse.getTxn_ids().iterator();
        while (e.hasNext()) {
            long txnid = (Long)e.next();
            this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        }
        openTxnsCounterService.run();
        exception = null;
        try {
            this.txnHandler.openTxns(new OpenTxnRequest(1, "him", "localhost"));
        }
        catch (MetaException e2) {
            exception = e2;
        }
        Assert.assertNull((Object)((Object)exception));
    }

    @Test
    public void testCompactWithDelete() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData));
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("delete from " + Table.ACIDTBL + " where b = 4");
        this.runStatementOnDriver("update " + Table.ACIDTBL + " set b = -2 where b = 2");
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MINOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        ShowCompactResponse resp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)2L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertEquals((String)"Unexpected 1 compaction state", (Object)"refused", (Object)((ShowCompactResponseElement)resp.getCompacts().get(1)).getState());
    }

    @Test
    public void testNoHistory() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("select count(*) from " + Table.ACIDTBL);
    }

    @Test
    public void testACIDwithSchemaEvolutionAndCompaction() throws Exception {
        this.testACIDwithSchemaEvolutionForVariousTblProperties("'transactional'='true'");
    }

    protected void testACIDwithSchemaEvolutionForVariousTblProperties(String tblProperties) throws Exception {
        String tblName = "acidWithSchemaEvol";
        int numBuckets = 1;
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING)  CLUSTERED BY(a) INTO " + numBuckets + " BUCKETS STORED AS ORC  TBLPROPERTIES ( " + tblProperties + " )");
        this.runStatementOnDriver("insert into " + tblName + " values(1, 'foo'),(2, 'bar'),(3, 'baz')");
        this.runStatementOnDriver("update " + tblName + " set b = 'blah' where a = 3");
        this.runStatementOnDriver("alter table " + tblName + " add columns(c int, d string)");
        this.runStatementOnDriver("insert into " + tblName + " values(4, 'acid', 100, 'orc'),(5, 'llap', 200, 'tez')");
        this.runStatementOnDriver("update " + tblName + " set d = 'hive' where a <= 3");
        this.runStatementOnDriver("update " + tblName + " set c = 999 where a <= 3");
        List<String> rs = this.runStatementOnDriver("select * from " + tblName + " order by a");
        String[] expectedResult = new String[]{"1\tfoo\t999\thive", "2\tbar\t999\thive", "3\tblah\t999\thive", "4\tacid\t100\torc", "5\tllap\t200\ttez"};
        Assert.assertEquals(Arrays.asList(expectedResult), rs);
        this.runStatementOnDriver("alter table " + tblName + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.createAbortLowWaterMark();
        TestTxnCommands2.runCleaner(this.hiveConf);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + tblName.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
            Assert.assertEquals((long)numBuckets, (long)buckets.length);
            Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00000"));
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select * from " + tblName + " order by a");
        Assert.assertEquals(Arrays.asList(expectedResult), rs);
    }

    protected void createAbortLowWaterMark() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("select * from " + Table.ACIDTBL);
        Thread.sleep(1000L);
        TestTxnCommands2.runInitiator(this.hiveConf);
    }

    @Test
    public void testETLSplitStrategyForACID() throws Exception {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY, "ETL");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_OPT_INDEX_FILTER, true);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " values(1,2)");
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        List<String> rs = this.runStatementOnDriver("select * from " + Table.ACIDTBL + " where a = 1");
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
    }

    @Test
    public void testAcidWithSchemaEvolution() throws Exception {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY, "ETL");
        String tblName = "acidTblWithSchemaEvol";
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING)  CLUSTERED BY(a) INTO 2 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("INSERT INTO " + tblName + " VALUES (1, 'foo'), (2, 'bar')");
        this.runStatementOnDriver("ALTER TABLE " + tblName + " COMPACT 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("ALTER TABLE " + tblName + " ADD COLUMNS(c int)");
        List<String> rs = this.runStatementOnDriver("SELECT * FROM " + tblName + " ORDER BY a");
        String[] expectedResult = new String[]{"1\tfoo\tNULL", "2\tbar\tNULL"};
        Assert.assertEquals(Arrays.asList(expectedResult), rs);
    }

    @Test
    public void testMultiInsertStatement() throws Exception {
        int[][] sourceValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] sourceValsEven = new int[][]{{2, 2}};
        this.runStatementOnDriver("insert into " + Table.NONACIDPART2 + " PARTITION(p2='odd') " + TestTxnCommands2.makeValuesClause(sourceValsOdd));
        this.runStatementOnDriver("insert into " + Table.NONACIDPART2 + " PARTITION(p2='even') " + TestTxnCommands2.makeValuesClause(sourceValsEven));
        int[][] targetValsOdd = new int[][]{{5, 6}, {7, 8}};
        int[][] targetValsEven = new int[][]{{2, 1}, {4, 3}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " PARTITION(p='odd') " + TestTxnCommands2.makeValuesClause(targetValsOdd));
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " PARTITION(p='even') " + TestTxnCommands2.makeValuesClause(targetValsEven));
        List<String> r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBLPART + " order by a,b");
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(targetVals), r);
        String s = "from " + Table.ACIDTBLPART + "  target right outer join " + Table.NONACIDPART2 + " source on target.a = source.a2  INSERT INTO TABLE " + Table.ACIDTBLPART + " PARTITION(p='even') select source.a2, source.b2 where source.a2=target.a  insert into table " + Table.ACIDTBLPART + " PARTITION(p='odd') select source.a2,source.b2 where target.a is null";
        this.runStatementOnDriver(s);
        r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBLPART + " where p='even' order by a,b");
        int[][] rExpected = new int[][]{{2, 1}, {2, 2}, {4, 3}, {5, 5}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
        r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBLPART + " where p='odd' order by a,b");
        int[][] rExpected2 = new int[][]{{5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected2), r);
    }

    private void logResuts(List<String> r, String header, String prefix) {
        LOG.info(prefix + " " + header);
        StringBuilder sb = new StringBuilder();
        int numLines = 0;
        for (String line : r) {
            ++numLines;
            sb.append(prefix).append(line).append("\n");
        }
        LOG.info(sb.toString());
        LOG.info(prefix + " Printed " + numLines + " lines");
    }

    @Test
    public void testMerge() throws Exception {
        int[][] baseValsOdd = new int[][]{{5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + Table.NONACIDPART2 + " PARTITION(p2='odd') " + TestTxnCommands2.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " " + TestTxnCommands2.makeValuesClause(vals));
        List<String> r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(vals), r);
        String query = "merge into " + Table.ACIDTBL + " using " + Table.NONACIDPART2 + " source ON " + Table.ACIDTBL + ".a = a2 and b + 1 = source.b2 + 1 WHEN MATCHED THEN UPDATE set b = source.b2 WHEN NOT MATCHED THEN INSERT VALUES(source.a2, source.b2)";
        this.runStatementOnDriver(query);
        r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] rExpected = new int[][]{{2, 1}, {4, 3}, {5, 5}, {5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeWithPredicate() throws Exception {
        int[][] baseValsOdd = new int[][]{{2, 2}, {5, 5}, {8, 8}, {11, 11}};
        this.runStatementOnDriver("insert into " + Table.NONACIDPART2 + " PARTITION(p2='odd') " + TestTxnCommands2.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " " + TestTxnCommands2.makeValuesClause(vals));
        List<String> r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(vals), r);
        String query = "merge into " + Table.ACIDTBL + " t using " + Table.NONACIDPART2 + " s ON t.a = s.a2 WHEN MATCHED AND t.b between 1 and 3 THEN UPDATE set b = s.b2 WHEN NOT MATCHED and s.b2 >= 8 THEN INSERT VALUES(s.a2, s.b2)";
        this.runStatementOnDriver(query);
        r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] rExpected = new int[][]{{2, 2}, {4, 3}, {5, 6}, {7, 8}, {8, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
        this.assertUniqueID(Table.ACIDTBL);
    }

    @Test
    public void testMerge2() throws Exception {
        int[][] baseValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] baseValsEven = new int[][]{{2, 2}, {4, 44}};
        this.runStatementOnDriver("insert into " + Table.NONACIDPART2 + " PARTITION(p2='odd') " + TestTxnCommands2.makeValuesClause(baseValsOdd));
        this.runStatementOnDriver("insert into " + Table.NONACIDPART2 + " PARTITION(p2='even') " + TestTxnCommands2.makeValuesClause(baseValsEven));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " " + TestTxnCommands2.makeValuesClause(vals));
        List<String> r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(vals), r);
        String query = "merge into " + Table.ACIDTBL + " using " + Table.NONACIDPART2 + " source ON " + Table.ACIDTBL + ".a = source.a2 WHEN MATCHED THEN UPDATE set b = source.b2 WHEN NOT MATCHED THEN INSERT VALUES(source.a2, source.b2) ";
        r = this.runStatementOnDriver(query);
        r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] rExpected = new int[][]{{2, 2}, {4, 44}, {5, 5}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
        this.assertUniqueID(Table.ACIDTBL);
    }

    @Test
    public void testMerge3() throws Exception {
        int[][] baseValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] baseValsEven = new int[][]{{2, 2}, {4, 44}};
        this.runStatementOnDriver("insert into " + Table.NONACIDPART2 + " PARTITION(p2='odd') " + TestTxnCommands2.makeValuesClause(baseValsOdd));
        this.runStatementOnDriver("insert into " + Table.NONACIDPART2 + " PARTITION(p2='even') " + TestTxnCommands2.makeValuesClause(baseValsEven));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " " + TestTxnCommands2.makeValuesClause(vals));
        List<String> r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(vals), r);
        String query = "merge into " + Table.ACIDTBL + " using " + Table.NONACIDPART2 + " source ON " + Table.ACIDTBL + ".a = source.a2 WHEN MATCHED THEN DELETE WHEN NOT MATCHED THEN INSERT VALUES(source.a2, source.b2) ";
        this.runStatementOnDriver(query);
        r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] rExpected = new int[][]{{7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    @Test
    public void testMultiInsert() throws Exception {
        this.runStatementOnDriver("create temporary table if not exists data1 (x int)");
        this.runStatementOnDriver("insert into data1 values (1),(2),(1)");
        this.d.destroy();
        this.d = new Driver(this.hiveConf);
        this.runStatementOnDriver(" from data1 insert into " + Table.ACIDTBLPART + " partition(p) select 0, 0, 'p' || x  insert into " + Table.ACIDTBLPART + " partition(p='p1') select 0, 1");
        List<String> r = this.runStatementOnDriver("select p,a,b from " + Table.ACIDTBLPART + " order by p, a, b");
        Assert.assertEquals((Object)"[p1\t0\t0, p1\t0\t0, p1\t0\t1, p1\t0\t1, p1\t0\t1, p2\t0\t0]", (Object)r.toString());
        this.assertUniqueID(Table.ACIDTBLPART);
        this.runStatementOnDriver("delete from " + Table.ACIDTBLPART);
        r = this.runStatementOnDriver("select p,a,b from " + Table.ACIDTBLPART + " order by p, a, b");
        Assert.assertEquals((Object)"[]", (Object)r.toString());
    }

    @Test
    @Ignore
    public void testDynamicPartitions() throws Exception {
        this.d.destroy();
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1'),(4,4,'p2')");
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) select * from " + Table.ACIDTBLPART + " where p='p1'");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p2') select a,b from " + Table.ACIDTBLPART + " where p='p1'");
        this.runStatementOnDriver("update " + Table.ACIDTBLPART + " set b = 1");
        this.runStatementOnDriver("update " + Table.ACIDTBLPART + " set b = 1 where p='p1'");
    }

    @Test
    public void testDynamicPartitionsMerge() throws Exception {
        this.d.destroy();
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1'),(4,4,'p2')");
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        int[][] sourceVals = new int[][]{{2, 15}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + " " + TestTxnCommands2.makeValuesClause(sourceVals));
        this.runStatementOnDriver("merge into " + Table.ACIDTBLPART + " using " + Table.NONACIDORCTBL + " as s ON " + Table.ACIDTBLPART + ".a = s.a when matched then update set b = s.b when not matched then insert values(s.a, s.b, 'new part')");
        r1 = this.runStatementOnDriver("select p,a,b from " + Table.ACIDTBLPART + " order by p, a, b");
        String result = r1.toString();
        Assert.assertEquals((Object)"[new part\t5\t5, new part\t11\t11, p1\t1\t1, p1\t2\t15, p1\t3\t3, p2\t4\t44]", (Object)result);
        this.assertUniqueID(Table.ACIDTBLPART);
    }

    @Test
    public void testDynamicPartitionsMerge2() throws Exception {
        this.d.destroy();
        int[][] targetVals = new int[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 1}, {4, 4, 2}};
        this.runStatementOnDriver("insert into " + Table.ACIDNESTEDPART + " partition(p=1,q) " + TestTxnCommands2.makeValuesClause(targetVals));
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDNESTEDPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        int[][] sourceVals = new int[][]{{2, 15}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + " " + TestTxnCommands2.makeValuesClause(sourceVals));
        this.runStatementOnDriver("merge into " + Table.ACIDNESTEDPART + " using " + Table.NONACIDORCTBL + " as s ON " + Table.ACIDNESTEDPART + ".a = s.a when matched then update set b = s.b when not matched then insert values(s.a, s.b, 3,4)");
        r1 = this.runStatementOnDriver("select p,q,a,b from " + Table.ACIDNESTEDPART + " order by p,q, a, b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(new int[][]{{1, 1, 1, 1}, {1, 1, 3, 3}, {1, 2, 2, 15}, {1, 2, 4, 44}, {3, 4, 5, 5}, {3, 4, 11, 11}}), r1);
        this.assertUniqueID(Table.ACIDNESTEDPART);
    }

    @Ignore(value="Covered elsewhere")
    @Test
    public void testMergeAliasedTarget() throws Exception {
        int[][] baseValsOdd = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + " " + TestTxnCommands2.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " " + TestTxnCommands2.makeValuesClause(vals));
        String query = "merge into " + Table.ACIDTBL + " as target using " + Table.NONACIDORCTBL + " source ON target.a = source.a WHEN MATCHED THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(source.a, source.b) ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] rExpected = new int[][]{{2, 0}, {4, 0}, {5, 0}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    @Test
    @Ignore(value="Values clause with table constructor not yet supported")
    public void testValuesSource() throws Exception {
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " " + TestTxnCommands2.makeValuesClause(targetVals));
        String query = "merge into " + Table.ACIDTBL + " as t using (select * from (values (2,2),(4,44),(5,5),(11,11)) as F(a,b)) s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] rExpected = new int[][]{{5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    @Test
    public void testBucketCodec() throws Exception {
        this.d.destroy();
        this.hiveConf.setIntVar(HiveConf.ConfVars.TESTMODE_BUCKET_CODEC_VERSION, 0);
        this.d = new Driver(this.hiveConf);
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " " + TestTxnCommands2.makeValuesClause(targetVals));
        this.d.destroy();
        this.hiveConf.setIntVar(HiveConf.ConfVars.TESTMODE_BUCKET_CODEC_VERSION, 1);
        this.d = new Driver(this.hiveConf);
        this.runStatementOnDriver("update " + Table.ACIDTBL + " set b=11 where a in (5,7)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + " values(11,11)");
        this.runStatementOnDriver("delete from " + Table.ACIDTBL + " where a = 7");
        List<String> r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        int[][] rExpected = new int[][]{{2, 1}, {4, 3}, {5, 11}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
        this.runStatementOnDriver("ALTER TABLE " + Table.ACIDTBL + " COMPACT 'MINOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
        this.runStatementOnDriver("ALTER TABLE " + Table.ACIDTBL + " COMPACT 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        r = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a,b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    @Test
    public void testInsertOverwrite1() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(3,4)");
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.ACIDTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)2L, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("delta_.*"));
        }
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(5,6),(7,8)");
        this.runStatementOnDriver("insert overwrite table " + Table.ACIDTBL + " select a,b from " + Table.NONACIDORCTBL);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.ACIDTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        boolean sawBase = false;
        String baseDir = "";
        int deltaCount = 0;
        for (int i = 0; i < status.length; ++i) {
            String dirName = status[i].getPath().getName();
            if (dirName.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            sawBase = true;
            baseDir = dirName;
            Assert.assertTrue((boolean)baseDir.matches("base_.*"));
        }
        Assert.assertEquals((long)2L, (long)deltaCount);
        Assert.assertTrue((boolean)sawBase);
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        int[][] resultData = new int[][]{{5, 6}, {7, 8}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.ACIDTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        sawBase = false;
        deltaCount = 0;
        for (int i = 0; i < status.length; ++i) {
            String dirName = status[i].getPath().getName();
            if (dirName.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            sawBase = true;
            Assert.assertTrue((boolean)dirName.matches("base_.*"));
            Assert.assertEquals((Object)baseDir, (Object)dirName);
        }
        Assert.assertEquals((long)2L, (long)deltaCount);
        Assert.assertTrue((boolean)sawBase);
        rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        TestTxnCommands2.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.ACIDTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
        Assert.assertEquals((Object)baseDir, (Object)status[0].getPath().getName());
        rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
    }

    @Test
    public void testInsertOverwrite2() throws Exception {
        String dirName;
        int i;
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(3,4)");
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.ACIDTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)2L, (long)status.length);
        for (int i2 = 0; i2 < status.length; ++i2) {
            Assert.assertTrue((boolean)status[i2].getPath().getName().matches("delta_.*"));
        }
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.ACIDTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        boolean sawBase = false;
        int deltaCount = 0;
        for (int i3 = 0; i3 < status.length; ++i3) {
            String dirName2 = status[i3].getPath().getName();
            if (dirName2.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            sawBase = true;
            Assert.assertTrue((boolean)dirName2.matches("base_.*"));
        }
        Assert.assertEquals((long)2L, (long)deltaCount);
        Assert.assertTrue((boolean)sawBase);
        int[][] resultData = new int[][]{{1, 2}, {3, 4}};
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + "(a,b) values(5,6),(7,8)");
        this.runStatementOnDriver("insert overwrite table " + Table.ACIDTBL + " select a,b from " + Table.NONACIDORCTBL);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.ACIDTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        int baseCount = 0;
        deltaCount = 0;
        for (i = 0; i < status.length; ++i) {
            dirName = status[i].getPath().getName();
            if (dirName.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            ++baseCount;
        }
        Assert.assertEquals((long)2L, (long)deltaCount);
        Assert.assertEquals((long)2L, (long)baseCount);
        resultData = new int[][]{{5, 6}, {7, 8}};
        rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.ACIDTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        baseCount = 0;
        deltaCount = 0;
        for (i = 0; i < status.length; ++i) {
            dirName = status[i].getPath().getName();
            if (dirName.matches("delta_.*")) {
                ++deltaCount;
                continue;
            }
            Assert.assertTrue((boolean)dirName.matches("base_.*"));
            ++baseCount;
        }
        Assert.assertEquals((long)2L, (long)deltaCount);
        Assert.assertEquals((long)2L, (long)baseCount);
        rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        TestTxnCommands2.runCleaner(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(this.getWarehouseDir() + "/" + Table.ACIDTBL.toString().toLowerCase()), FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
        rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
    }

    @Test
    public void testSchemaEvolutionCompaction() throws Exception {
        String tblName = "schemaevolutioncompaction";
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT)  PARTITIONED BY(part string) STORED AS ORC TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into " + tblName + " partition (part='aa') values (1)");
        this.runStatementOnDriver("ALTER TABLE " + tblName + " ADD COLUMNS(b int)");
        this.runStatementOnDriver("insert into " + tblName + " partition (part='aa') values (2, 2000)");
        List<String> res = this.runStatementOnDriver("SELECT * FROM " + tblName + " ORDER BY a");
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertEquals((Object)"1\tNULL\taa", (Object)res.get(0));
        Assert.assertEquals((Object)"2\t2000\taa", (Object)res.get(1));
        CompactionRequest compactionRequest = new CompactionRequest("default", tblName, CompactionType.MAJOR);
        compactionRequest.setPartitionname("part=aa");
        this.txnHandler.compact(compactionRequest);
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        List compacts = this.txnHandler.showCompact(new ShowCompactRequest()).getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        res = this.runStatementOnDriver("SELECT * FROM " + tblName + " ORDER BY a");
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertEquals((Object)"1\tNULL\taa", (Object)res.get(0));
        Assert.assertEquals((Object)"2\t2000\taa", (Object)res.get(1));
    }

    @Test
    public void testCleanerForTxnToWriteId() throws Exception {
        int[][] tableData1 = new int[][]{{1, 2}};
        int[][] tableData2 = new int[][]{{2, 3}};
        int[][] tableData3 = new int[][]{{3, 4}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData1));
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData2));
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData3));
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p=1) (a,b) " + TestTxnCommands2.makeValuesClause(tableData1));
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p=2) (a,b) " + TestTxnCommands2.makeValuesClause(tableData2));
        String acidTblWhereClause = " where t2w_database = " + TestTxnCommands2.quoteString("default") + " and t2w_table = " + TestTxnCommands2.quoteString(Table.ACIDTBL.name().toLowerCase());
        String acidTblPartWhereClause = " where t2w_database = " + TestTxnCommands2.quoteString("default") + " and t2w_table = " + TestTxnCommands2.quoteString(Table.ACIDTBLPART.name().toLowerCase());
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select * from TXN_TO_WRITE_ID" + acidTblWhereClause)), (long)3L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID" + acidTblWhereClause)));
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select * from TXN_TO_WRITE_ID" + acidTblPartWhereClause)), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID" + acidTblPartWhereClause)));
        this.txnHandler.compact(new CompactionRequest("default", Table.ACIDTBL.name().toLowerCase(), CompactionType.MAJOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.txnHandler.cleanTxnToWriteIdTable();
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_TO_WRITE_ID"), (long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_TO_WRITE_ID"));
        int[][] tableData4 = new int[][]{{4, 5}};
        int[][] tableData5 = new int[][]{{5, 6}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p=3) (a,b) " + TestTxnCommands2.makeValuesClause(tableData3));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData4));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        Context ctx = new Context((Configuration)this.hiveConf);
        HiveTxnManager txnMgr = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.hiveConf);
        this.waitUntilAllTxnFinished();
        txnMgr.openTxn(ctx, "u1");
        txnMgr.getValidTxns();
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData5));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData5));
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select * from TXN_TO_WRITE_ID" + acidTblWhereClause)), (long)3L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID" + acidTblWhereClause)));
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select * from TXN_TO_WRITE_ID" + acidTblPartWhereClause)), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID" + acidTblPartWhereClause)));
        this.txnHandler.cleanEmptyAbortedAndCommittedTxns();
        this.txnHandler.cleanTxnToWriteIdTable();
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select * from TXN_TO_WRITE_ID" + acidTblWhereClause)), (long)3L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID" + acidTblWhereClause)));
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select * from TXN_TO_WRITE_ID" + acidTblPartWhereClause)), (long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID" + acidTblPartWhereClause)));
        this.txnHandler.compact(new CompactionRequest("default", Table.ACIDTBL.name().toLowerCase(), CompactionType.MAJOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.txnHandler.cleanEmptyAbortedAndCommittedTxns();
        this.txnHandler.cleanTxnToWriteIdTable();
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_TO_WRITE_ID"), (long)3L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_TO_WRITE_ID"));
        txnMgr.commitTxn();
        txnMgr.openTxn(ctx, "u1");
        txnMgr.getValidTxns();
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.txnHandler.cleanEmptyAbortedAndCommittedTxns();
        this.txnHandler.cleanTxnToWriteIdTable();
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_TO_WRITE_ID"), (long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_TO_WRITE_ID"));
    }

    @Test
    public void testMmTableAbortWithCompaction() throws Exception {
        this.runStatementOnDriver("insert into " + Table.MMTBL + "(a,b) values(1,2)");
        int[][] resultData1 = new int[][]{{1, 2}};
        this.verifyDeltaDirAndResult(1, Table.MMTBL.toString(), "", resultData1);
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + Table.MMTBL);
        Assert.assertEquals((Object)"1", (Object)r1.get(0));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.MMTBL + "(a,b) values(3,4)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.verifyDeltaDirAndResult(2, Table.MMTBL.toString(), "", resultData1);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.MMTBL);
        Assert.assertEquals((Object)"1", (Object)r1.get(0));
        int[][] resultData2 = new int[][]{{1, 2}, {5, 6}};
        this.runStatementOnDriver("insert into " + Table.MMTBL + "(a,b) values(5,6)");
        this.verifyDeltaDirAndResult(3, Table.MMTBL.toString(), "", resultData2);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.MMTBL);
        Assert.assertEquals((Object)"2", (Object)r1.get(0));
        this.runStatementOnDriver("alter table " + Table.MMTBL + " compact 'MINOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(3, Table.MMTBL.toString(), "", resultData2);
        this.verifyBaseDir(0, Table.MMTBL.toString(), "");
        TestTxnCommands2.runCleaner(this.hiveConf);
        TestTxnCommands2.runInitiator(this.hiveConf);
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.MMTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData2), rs);
        int[][] resultData3 = new int[][]{{1, 2}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + Table.MMTBL + "(a,b) values(7,8)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.MMTBL + "(a,b) values(9,10)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.runStatementOnDriver("alter table " + Table.MMTBL + " compact 'MAJOR'");
        this.verifyDeltaDirAndResult(3, Table.MMTBL.toString(), "", resultData3);
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(2, Table.MMTBL.toString(), "", resultData3);
        this.verifyBaseDir(1, Table.MMTBL.toString(), "");
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(0, Table.MMTBL.toString(), "", resultData3);
        this.verifyBaseDir(1, Table.MMTBL.toString(), "");
        TestTxnCommands2.runInitiator(this.hiveConf);
        this.verifyDeltaDirAndResult(0, Table.MMTBL.toString(), "", resultData3);
        this.verifyBaseDir(1, Table.MMTBL.toString(), "");
        rs = this.runStatementOnDriver("select a,b from " + Table.MMTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData3), rs);
    }

    @Test
    public void testMmTableAbortWithCompactionNoCleanup() throws Exception {
        this.runStatementOnDriver("insert into " + Table.MMTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + Table.MMTBL + "(a,b) values(5,6)");
        int[][] resultData1 = new int[][]{{1, 2}, {5, 6}};
        this.verifyDeltaDirAndResult(2, Table.MMTBL.toString(), "", resultData1);
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + Table.MMTBL);
        Assert.assertEquals((Object)"2", (Object)r1.get(0));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.MMTBL + " values(3,4)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.verifyDeltaDirAndResult(3, Table.MMTBL.toString(), "", resultData1);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.MMTBL);
        Assert.assertEquals((Object)"2", (Object)r1.get(0));
        this.runStatementOnDriver("alter table " + Table.MMTBL + " compact 'MINOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(3, Table.MMTBL.toString(), "", resultData1);
        this.verifyBaseDir(0, Table.MMTBL.toString(), "");
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.MMTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData1), rs);
        int[][] resultData3 = new int[][]{{1, 2}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + Table.MMTBL + "(a,b) values(7,8)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.MMTBL + "(a,b) values(9,10)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.verifyDeltaDirAndResult(5, Table.MMTBL.toString(), "", resultData3);
        this.runStatementOnDriver("alter table " + Table.MMTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(4, Table.MMTBL.toString(), "", resultData3);
        this.verifyBaseDir(1, Table.MMTBL.toString(), "");
        CompactionResponse resp = this.txnHandler.compact(new CompactionRequest("default", Table.MMTBL.name.toLowerCase(), CompactionType.MAJOR));
        Assert.assertFalse((boolean)resp.isAccepted());
        Assert.assertEquals((Object)"refused", (Object)resp.getState());
        Assert.assertEquals((Object)"Compaction is already scheduled with state='ready for cleaning' and id=2", (Object)resp.getErrormessage());
        TestTxnCommands2.runCleaner(this.hiveConf);
        rs = this.runStatementOnDriver("select a,b from " + Table.MMTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData3), rs);
    }

    @Test
    public void testDynPartInsertWithAborts() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        int[][] resultData = new int[][]{{1, 1}, {2, 2}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1')");
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, true);
        this.runStatementOnDriverWithAbort("insert into " + Table.ACIDTBLPART + " partition(p) values(3,3,'p1'),(4,4,'p1')");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, false);
        this.verifyDeltaDirAndResult(2, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        int count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS where TC_OPERATION_TYPE='i'");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_COMPONENTS"), (long)1L, (long)count);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_TIME_THRESHOLD, 0L, TimeUnit.MILLISECONDS);
        TestTxnCommands2.runInitiator(this.hiveConf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPACTION_QUEUE"), (long)(useCleanerForAbortCleanup ? 0L : 1L), (long)count);
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
    }

    @Test
    public void testDynPartInsertWithMultiPartitionAborts() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        int[][] resultData = new int[][]{{1, 1}, {2, 2}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1')");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values(1,1,'p2'),(2,2,'p2')");
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p2", resultData);
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, true);
        this.runStatementOnDriverWithAbort("insert into " + Table.ACIDTBLPART + " partition(p) values(3,3,'p1'),(4,4,'p1')");
        this.runStatementOnDriverWithAbort("insert into " + Table.ACIDTBLPART + " partition(p) values(3,3,'p2'),(4,4,'p2')");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, false);
        this.verifyDeltaDirAndResult(2, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.verifyDeltaDirAndResult(2, Table.ACIDTBLPART.toString(), "p=p2", resultData);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        int count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS where TC_OPERATION_TYPE='i'");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_COMPONENTS"), (long)2L, (long)count);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_TIME_THRESHOLD, 0L, TimeUnit.MILLISECONDS);
        TestTxnCommands2.runInitiator(this.hiveConf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPACTION_QUEUE"), (long)(useCleanerForAbortCleanup ? 0L : 1L), (long)count);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p2", resultData);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
    }

    @Test
    public void testDynPartIOWWithAborts() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        int[][] resultData = new int[][]{{1, 1}, {2, 2}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1')");
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, true);
        this.runStatementOnDriverWithAbort("insert overwrite table " + Table.ACIDTBLPART + " partition(p) values(3,3,'p1'),(4,4,'p1')");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, false);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.verifyBaseDir(1, Table.ACIDTBLPART.toString(), "p=p1");
        int count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS where TC_OPERATION_TYPE='u'");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_COMPONENTS"), (long)1L, (long)count);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_TIME_THRESHOLD, 0L, TimeUnit.MILLISECONDS);
        TestTxnCommands2.runInitiator(this.hiveConf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPACTION_QUEUE"), (long)(useCleanerForAbortCleanup ? 0L : 1L), (long)count);
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.verifyBaseDir(0, Table.ACIDTBLPART.toString(), "p=p1");
    }

    @Test
    public void testDynPartIOWWithMultiPartitionAborts() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        int[][] resultData = new int[][]{{1, 1}, {2, 2}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1')");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values(1,1,'p2'),(2,2,'p2')");
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p2", resultData);
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, true);
        this.runStatementOnDriverWithAbort("insert overwrite table " + Table.ACIDTBLPART + " partition(p) values(3,3,'p1'),(4,4,'p1')");
        this.runStatementOnDriverWithAbort("insert overwrite table " + Table.ACIDTBLPART + " partition(p) values(3,3,'p2'),(4,4,'p2')");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, false);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.verifyBaseDir(1, Table.ACIDTBLPART.toString(), "p=p1");
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p2", resultData);
        this.verifyBaseDir(1, Table.ACIDTBLPART.toString(), "p=p2");
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        int count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS where TC_OPERATION_TYPE='u'");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_COMPONENTS"), (long)2L, (long)count);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_TIME_THRESHOLD, 0L, TimeUnit.MILLISECONDS);
        TestTxnCommands2.runInitiator(this.hiveConf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPACTION_QUEUE"), (long)(useCleanerForAbortCleanup ? 0L : 1L), (long)count);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.verifyBaseDir(0, Table.ACIDTBLPART.toString(), "p=p1");
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p2", resultData);
        this.verifyBaseDir(0, Table.ACIDTBLPART.toString(), "p=p2");
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
    }

    @Test
    public void testDynPartUpdateWithAborts() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        int[][] resultData1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values (1,2,'p1')");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values (3,4,'p1')");
        this.verifyDeltaDirAndResult(2, Table.ACIDTBLPART.toString(), "p=p1", resultData1);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, true);
        this.runStatementOnDriverWithAbort("update " + Table.ACIDTBLPART + " set b=a+2 where a<5");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, false);
        this.verifyDeltaDirAndResult(3, Table.ACIDTBLPART.toString(), "p=p1", resultData1);
        this.verifyDeleteDeltaDir(1, Table.ACIDTBLPART.toString(), "p=p1");
        int count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS where TC_OPERATION_TYPE='u'");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_COMPONENTS"), (long)1L, (long)count);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_TIME_THRESHOLD, 0L, TimeUnit.MILLISECONDS);
        TestTxnCommands2.runInitiator(this.hiveConf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPACTION_QUEUE"), (long)(useCleanerForAbortCleanup ? 0L : 1L), (long)count);
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(2, Table.ACIDTBLPART.toString(), "p=p1", resultData1);
        this.verifyDeleteDeltaDir(0, Table.ACIDTBLPART.toString(), "p=p1");
    }

    @Test
    public void testDynPartMergeWithAborts() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        int[][] resultData = new int[][]{{1, 1}, {2, 2}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1')");
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"2", (Object)r1.get(0));
        int[][] sourceVals = new int[][]{{2, 15}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + Table.NONACIDORCTBL + " " + TestTxnCommands2.makeValuesClause(sourceVals));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, true);
        this.runStatementOnDriverWithAbort("merge into " + Table.ACIDTBLPART + " using " + Table.NONACIDORCTBL + " as s ON " + Table.ACIDTBLPART + ".a = s.a when matched then update set b = s.b when not matched then insert values(s.a, s.b, 'newpart')");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION, false);
        this.verifyDeltaDirAndResult(2, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.verifyDeleteDeltaDir(1, Table.ACIDTBLPART.toString(), "p=p1");
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=newpart", resultData);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"2", (Object)r1.get(0));
        int count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS where TC_OPERATION_TYPE='u'");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXN_COMPONENTS"), (long)1L, (long)count);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_TIME_THRESHOLD, 0L, TimeUnit.MILLISECONDS);
        TestTxnCommands2.runInitiator(this.hiveConf);
        count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPACTION_QUEUE"), (long)(useCleanerForAbortCleanup ? 0L : 1L), (long)count);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"2", (Object)r1.get(0));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBLPART.toString(), "p=p1", resultData);
        this.verifyDeleteDeltaDir(0, Table.ACIDTBLPART.toString(), "p=p1");
        this.verifyDeltaDirAndResult(0, Table.ACIDTBLPART.toString(), "p=newpart", resultData);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBLPART);
        Assert.assertEquals((Object)"2", (Object)r1.get(0));
    }

    @Test
    public void testFullACIDAbortWithMinorMajorCompaction() throws Exception {
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(1,2)");
        int[][] resultData1 = new int[][]{{1, 2}};
        this.verifyDeltaDirAndResult(1, Table.ACIDTBL.toString(), "", resultData1);
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBL);
        Assert.assertEquals((Object)"1", (Object)r1.get(0));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(3,4)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.verifyDeltaDirAndResult(2, Table.ACIDTBL.toString(), "", resultData1);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBL);
        Assert.assertEquals((Object)"1", (Object)r1.get(0));
        int[][] resultData2 = new int[][]{{1, 2}, {5, 6}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(5,6)");
        this.verifyDeltaDirAndResult(3, Table.ACIDTBL.toString(), "", resultData2);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBL);
        Assert.assertEquals((Object)"2", (Object)r1.get(0));
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MINOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBL.toString(), "", resultData2);
        this.verifyBaseDir(0, Table.ACIDTBL.toString(), "");
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(1, Table.ACIDTBL.toString(), "", resultData2);
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData2), rs);
        int[][] resultData3 = new int[][]{{1, 2}, {5, 6}, {7, 8}, {9, 10}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(7,8)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(9,10)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(11,12)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        this.verifyDeltaDirAndResult(4, Table.ACIDTBL.toString(), "", resultData3);
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBL.toString(), "", resultData3);
        this.verifyBaseDir(1, Table.ACIDTBL.toString(), "");
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(0, Table.ACIDTBL.toString(), "", resultData3);
        this.verifyBaseDir(1, Table.ACIDTBL.toString(), "");
        rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData3), rs);
    }

    @Test
    public void testFullACIDAbortWithMajorCompaction() throws Exception {
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(3,4)");
        int[][] resultData1 = new int[][]{{1, 2}, {3, 4}};
        this.verifyDeltaDirAndResult(2, Table.ACIDTBL.toString(), "", resultData1);
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBL);
        Assert.assertEquals((Object)"2", (Object)r1.get(0));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(5,6)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.verifyDeltaDirAndResult(3, Table.ACIDTBL.toString(), "", resultData1);
        r1 = this.runStatementOnDriver("select count(*) from " + Table.ACIDTBL);
        Assert.assertEquals((Object)"2", (Object)r1.get(0));
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(3, Table.ACIDTBL.toString(), "", resultData1);
        this.verifyBaseDir(1, Table.ACIDTBL.toString(), "");
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(0, Table.ACIDTBL.toString(), "", resultData1);
        this.verifyBaseDir(1, Table.ACIDTBL.toString(), "");
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData1), rs);
    }

    @Test
    public void testFullACIDAbortWithCompactionNoCleanup() throws Exception {
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(3,4)");
        int[][] resultData1 = new int[][]{{1, 2}, {3, 4}};
        this.verifyDeltaDirAndResult(2, Table.ACIDTBL.toString(), "", resultData1);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) values(5,6)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.verifyDeltaDirAndResult(3, Table.ACIDTBL.toString(), "", resultData1);
        this.runStatementOnDriver("alter table " + Table.ACIDTBL + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(3, Table.ACIDTBL.toString(), "", resultData1);
        this.verifyBaseDir(1, Table.ACIDTBL.toString(), "");
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBL + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData1), rs);
    }

    @Test
    public void testFullACIDAbortWithManyPartitions() throws Exception {
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p1') (a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p2') (a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p3') (a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p1') (a,b) values(3,4)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p2') (a,b) values(3,4)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p3') (a,b) values(3,4)");
        int[][] resultData1 = new int[][]{{1, 2}, {3, 4}};
        this.verifyDeltaDirAndResult(2, Table.ACIDTBLPART.toString(), "p=p1", resultData1);
        this.verifyDeltaDirAndResult(2, Table.ACIDTBLPART.toString(), "p=p2", resultData1);
        this.verifyDeltaDirAndResult(2, Table.ACIDTBLPART.toString(), "p=p3", resultData1);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p1') (a,b) values(5,6)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p2') (a,b) values(5,6)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p3') (a,b) values(5,6)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p1') (a,b) values(5,6)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p2') (a,b) values(5,6)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p3') (a,b) values(5,6)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBLPART.toString(), "p=p1", resultData1);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBLPART.toString(), "p=p2", resultData1);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBLPART.toString(), "p=p3", resultData1);
        Assert.assertEquals((long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS"), (long)6L);
        TestTxnCommands2.runCleaner(this.hiveConf);
        Assert.assertEquals((long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS"), (long)6L);
        this.runStatementOnDriver("alter table " + Table.ACIDTBLPART + " partition(p='p1') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBLPART.toString(), "p=p1", resultData1);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBLPART.toString(), "p=p2", resultData1);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBLPART.toString(), "p=p3", resultData1);
        this.verifyBaseDir(1, Table.ACIDTBLPART.toString(), "p=p1");
        TestTxnCommands2.runCleaner(this.hiveConf);
        Assert.assertEquals((long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS"), (long)4L);
        this.runStatementOnDriver("alter table " + Table.ACIDTBLPART + " partition(p='p2') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(0, Table.ACIDTBLPART.toString(), "p=p1", resultData1);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBLPART.toString(), "p=p2", resultData1);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBLPART.toString(), "p=p3", resultData1);
        this.verifyBaseDir(1, Table.ACIDTBLPART.toString(), "p=p2");
        TestTxnCommands2.runCleaner(this.hiveConf);
        Assert.assertEquals((long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS"), (long)2L);
        this.runStatementOnDriver("alter table " + Table.ACIDTBLPART + " partition(p='p3') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.verifyDeltaDirAndResult(0, Table.ACIDTBLPART.toString(), "p=p1", resultData1);
        this.verifyDeltaDirAndResult(0, Table.ACIDTBLPART.toString(), "p=p2", resultData1);
        this.verifyDeltaDirAndResult(4, Table.ACIDTBLPART.toString(), "p=p3", resultData1);
        this.verifyBaseDir(1, Table.ACIDTBLPART.toString(), "p=p3");
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.verifyDeltaDirAndResult(0, Table.ACIDTBLPART.toString(), "p=p3", resultData1);
        Assert.assertEquals((long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS"), (long)0L);
        int[][] resultData2 = new int[][]{{1, 2}, {1, 2}, {1, 2}, {3, 4}, {3, 4}, {3, 4}};
        List<String> rs = this.runStatementOnDriver("select a,b from " + Table.ACIDTBLPART + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData2), rs);
    }

    private void verifyDeltaDir(int expectedDeltas, String tblName, String partName) throws Exception {
        this.verifyDir(expectedDeltas, tblName, partName, "delta_.*");
    }

    private void verifyDeleteDeltaDir(int expectedDeltas, String tblName, String partName) throws Exception {
        this.verifyDir(expectedDeltas, tblName, partName, "delete_delta_.*");
    }

    private void verifyBaseDir(int expectedDeltas, String tblName, String partName) throws Exception {
        this.verifyDir(expectedDeltas, tblName, partName, "base_.*");
    }

    private void verifyDir(int expectedDeltas, String tblName, String partName, String pattern) throws Exception {
        Path warehouse = new Path(this.getWarehouseDir());
        tblName = tblName.toLowerCase();
        FileSystem fs = FileSystem.get((URI)warehouse.toUri(), (Configuration)this.hiveConf);
        FileStatus[] status = fs.listStatus(new Path(warehouse, tblName + "/" + partName), FileUtils.HIDDEN_FILES_PATH_FILTER);
        int sawDeltaTimes = 0;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches(pattern)) continue;
            ++sawDeltaTimes;
        }
        Assert.assertEquals((long)expectedDeltas, (long)sawDeltaTimes);
    }

    private void verifyDeltaDirAndResult(int expectedDeltas, String tblName, String partName, int[][] resultData) throws Exception {
        this.verifyDeltaDir(expectedDeltas, tblName, partName);
        if (partName.equals("p=newpart")) {
            return;
        }
        List<String> rs = this.runStatementOnDriver("select a,b from " + tblName + (String)(partName.isEmpty() ? "" : " where p='" + partName.substring(2) + "'") + " order by a");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
    }

    @Test
    public void testAcidOrcWritePreservesFieldNames() throws Exception {
        TypeDescription rowSchema;
        Reader r;
        String tableName = "acidorcwritefieldnames";
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.runStatementOnDriver("DROP TABLE IF EXISTS " + tableName);
        this.runStatementOnDriver("CREATE TABLE " + tableName + " (a INT, b STRING) CLUSTERED BY (a) INTO 2 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("INSERT INTO " + tableName + " VALUES (1, 'foo'), (2, 'bar')");
        tableName = "acidorcwritefieldnames_complex";
        this.runStatementOnDriver("DROP TABLE IF EXISTS " + tableName);
        this.runStatementOnDriver("CREATE TABLE " + tableName + " (a INT, b STRING, s STRUCT<c:int, si:STRUCT<d:double,e:float>>) CLUSTERED BY (a) INTO 2 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("INSERT INTO " + tableName + " select a, b, named_struct('c',10,'si',named_struct('d',cast(1.0 as double),'e',cast(2.0 as float))) from acidorcwritefieldnames");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] fileStatuses = fs.globStatus(new Path(this.getWarehouseDir() + "/" + tableName + "/delta_*/bucket_*"));
        Assert.assertEquals((long)2L, (long)fileStatuses.length);
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)this.hiveConf);
        for (FileStatus fileStatus : fileStatuses) {
            r = OrcFile.createReader((Path)fileStatus.getPath(), (OrcFile.ReaderOptions)readerOptions);
            rowSchema = (TypeDescription)r.getSchema().getChildren().get(5);
            Assert.assertEquals((Object)"struct<a:int,b:string,s:struct<c:int,si:struct<d:double,e:float>>>", (Object)rowSchema.toString());
        }
        tableName = "acidorcwritefieldnames";
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        this.runStatementOnDriver("DROP TABLE IF EXISTS " + tableName);
        this.runStatementOnDriver("CREATE TABLE " + tableName + " (a INT, b STRING) CLUSTERED BY (a) INTO 2 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("INSERT INTO " + tableName + " VALUES (1, 'foo'), (2, 'bar')");
        tableName = "acidorcwritefieldnames_complex";
        this.runStatementOnDriver("DROP TABLE IF EXISTS " + tableName);
        this.runStatementOnDriver("CREATE TABLE " + tableName + " (a INT, b STRING, s STRUCT<c:int, si:STRUCT<d:double,e:float>>) CLUSTERED BY (a) INTO 2 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("INSERT INTO " + tableName + " select a, b, named_struct('c',10,'si',named_struct('d',cast(1.0 as double),'e',cast(2.0 as float))) from acidorcwritefieldnames");
        fs = FileSystem.get((Configuration)this.hiveConf);
        fileStatuses = fs.globStatus(new Path(this.getWarehouseDir() + "/" + tableName + "/delta_*/bucket_*"));
        Assert.assertEquals((long)2L, (long)fileStatuses.length);
        readerOptions = OrcFile.readerOptions((Configuration)this.hiveConf);
        for (FileStatus fileStatus : fileStatuses) {
            r = OrcFile.createReader((Path)fileStatus.getPath(), (OrcFile.ReaderOptions)readerOptions);
            rowSchema = (TypeDescription)r.getSchema().getChildren().get(5);
            Assert.assertEquals((Object)"struct<a:int,b:string,s:struct<c:int,si:struct<d:double,e:float>>>", (Object)rowSchema.toString());
        }
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
    }

    public static Stream<Arguments> generateBooleanArgs() {
        return IntStream.concat(IntStream.range(0, 16), IntStream.range(24, 28)).mapToObj(i -> Arguments.of((Object[])new Object[]{(i & 1) == 0, (i >>> 1 & 1) == 0, (i >>> 2 & 1) == 0, (i >>> 3 & 1) == 0, (i >>> 4 & 1) == 0}));
    }

    @ParameterizedTest
    @MethodSource(value={"generateBooleanArgs"})
    public void testFailureScenariosCleanupCTAS(boolean isPartitioned, boolean isDirectInsertEnabled, boolean isLocklessReadsEnabled, boolean isLocationUsed, boolean isExclusiveCtas) throws Exception {
        FileStatus[] fileStatuses;
        String tableName = "atable";
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_ACID_DIRECT_INSERT_ENABLED, isDirectInsertEnabled);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED, isLocklessReadsEnabled);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.TXN_CTAS_X_LOCK, isExclusiveCtas);
        String querylocation = isLocationUsed ? " location '" + this.getWarehouseDir() + "/" + tableName + "1'" : "";
        String queryPartitions = isPartitioned ? " partitioned by (a)" : "";
        this.d.run("insert into " + Table.ACIDTBL + "(a,b) values (3,4)");
        this.d.run("drop table if exists " + tableName);
        this.d.compileAndRespond("create table " + tableName + queryPartitions + " stored as orc" + querylocation + " tblproperties ('transactional'='true') as select * from " + Table.ACIDTBL);
        long txnId = this.d.getQueryState().getTxnManager().getCurrentTxnId();
        this.mockTasksRecursively(this.d.getPlan().getRootTasks());
        int assertError = 0;
        try {
            this.d.run();
        }
        catch (Exception e) {
            assertError = 1;
        }
        TestTxnCommands2.runCleaner(this.hiveConf);
        Assert.assertEquals((long)assertError, (long)1L);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        String assertLocation = isLocationUsed ? this.getWarehouseDir() + "/" + tableName + "1" : (isLocklessReadsEnabled ? this.getWarehouseDir() + "/" + tableName + AcidUtils.getPathSuffix((long)txnId) : this.getWarehouseDir() + "/" + tableName);
        for (FileStatus fileStatus : fileStatuses = fs.globStatus(new Path(assertLocation + "/*"))) {
            Assert.assertFalse((boolean)fileStatus.getPath().getName().startsWith("delta_"));
        }
    }

    public void mockTasksRecursively(List<Task<?>> tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            Task<?> task = tasks.get(i);
            if (task instanceof DDLTask) {
                DDLTask ddltask = (DDLTask)Mockito.spy((Object)new DDLTask());
                ((DDLTask)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)ddltask)).execute();
                tasks.set(i, (Task<?>)ddltask);
            }
            if (task.getNumChild() == 0) continue;
            this.mockTasksRecursively(task.getChildTasks());
        }
    }

    @Test
    public void testDeleteEventsCompaction() throws Exception {
        FileStatus[] fileStatuses;
        int[][] tableData1 = new int[][]{{1, 2}};
        int[][] tableData2 = new int[][]{{2, 3}};
        int[][] tableData3 = new int[][]{{3, 4}};
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData1));
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData2));
        this.runStatementOnDriver("insert into " + Table.ACIDTBL + "(a,b) " + TestTxnCommands2.makeValuesClause(tableData3));
        this.txnHandler.compact(new CompactionRequest("default", Table.ACIDTBL.name().toLowerCase(), CompactionType.MINOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        for (FileStatus fileStatus : fileStatuses = fs.globStatus(new Path(this.getWarehouseDir() + "/" + Table.ACIDTBL.name().toLowerCase() + "/*"))) {
            Assert.assertFalse((boolean)fileStatus.getPath().getName().startsWith("delete_delta_"));
        }
    }

    @Test
    public void testNoDeltaAfterDeleteAndMinorCompaction() throws Exception {
        FileStatus[] fileStatuses;
        String tableName = "test_major_delete_minor";
        this.runStatementOnDriver("drop table if exists " + tableName);
        this.runStatementOnDriver("create table " + tableName + " (name VARCHAR(50), age TINYINT, num_clicks BIGINT) stored as orc tblproperties ('transactional'='true')");
        this.runStatementOnDriver("insert into " + tableName + " values ('amy', 35, 12341234)");
        this.runStatementOnDriver("insert into " + tableName + " values ('bob', 66, 1234712348712)");
        this.runStatementOnDriver("insert into " + tableName + " values ('cal', 21, 431)");
        this.runStatementOnDriver("insert into " + tableName + " values ('fse', 28, 8456)");
        this.runStatementOnDriver("alter table " + tableName + " compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("delete from " + tableName + " where name='bob'");
        this.runStatementOnDriver("delete from " + tableName + " WHERE name='fse'");
        this.runStatementOnDriver("alter table " + tableName + " compact 'minor'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        for (FileStatus fileStatus : fileStatuses = fs.globStatus(new Path(this.getWarehouseDir() + "/" + tableName + "/*"))) {
            Assert.assertFalse((boolean)fileStatus.getPath().getName().startsWith("delta_"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoTxnComponentsForScheduledQueries() throws Exception {
        String tableName = "scheduledquerytable";
        int[][] tableData = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("create table " + tableName + " (a int, b int) stored as orc tblproperties ('transactional'='true')");
        int noOfTimesScheduledQueryExecuted = 4;
        for (int index = 0; index < noOfTimesScheduledQueryExecuted; ++index) {
            ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Scheduled queries for transactional tables").build());
            FileStatus[] qService = new MockScheduledQueryService("insert into " + tableName + " (a,b) " + TestTxnCommands2.makeValuesClause(tableData));
            ScheduledQueryExecutionContext ctx = new ScheduledQueryExecutionContext(executor, this.hiveConf, (IScheduledQueryMaintenanceService)qService);
            try (ScheduledQueryExecutionService sQ = ScheduledQueryExecutionService.startScheduledQueryExecutorService((ScheduledQueryExecutionContext)ctx);){
                SessionState.getConsole().logInfo("Waiting for query execution to finish ...");
                Object object = qService.notifier;
                synchronized (object) {
                    qService.notifier.wait(30000L);
                }
                SessionState.getConsole().logInfo("Done waiting for query execution!");
            }
            MatcherAssert.assertThat((Object)qService.lastProgressInfo.isSetExecutorQueryId(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)qService.lastProgressInfo.getExecutorQueryId(), (Matcher)Matchers.containsString((String)(ctx.executorHostName + "/")));
        }
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] fileStatuses = fs.globStatus(new Path(this.getWarehouseDir() + "/" + tableName + "/*"));
        Assert.assertEquals((long)fileStatuses.length, (long)noOfTimesScheduledQueryExecuted);
        for (FileStatus fileStatus : fileStatuses) {
            Assert.assertTrue((boolean)fileStatus.getPath().getName().startsWith("delta_"));
        }
        Assert.assertEquals((long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from completed_txn_components where ctc_database='__global_locks'"), (long)0L);
        this.runStatementOnDriver("alter table " + tableName + " compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        AcidHouseKeeperService houseKeeper = new AcidHouseKeeperService();
        CompactionHouseKeeperService compactionHouseKeeper = new CompactionHouseKeeperService();
        houseKeeper.setConf((Configuration)this.hiveConf);
        compactionHouseKeeper.setConf((Configuration)this.hiveConf);
        houseKeeper.run();
        compactionHouseKeeper.run();
        fileStatuses = fs.globStatus(new Path(this.getWarehouseDir() + "/" + tableName + "/*"));
        Assert.assertEquals((long)fileStatuses.length, (long)1L);
        for (FileStatus fileStatus : fileStatuses) {
            Assert.assertTrue((boolean)fileStatus.getPath().getName().startsWith("base_"));
        }
        int[][] actualData = new int[][]{{1, 2}, {1, 2}, {1, 2}, {1, 2}, {3, 4}, {3, 4}, {3, 4}, {3, 4}};
        List<String> resData = this.runStatementOnDriver("select a,b from " + tableName + " order by a");
        Assert.assertEquals(resData, TestTxnCommands2.stringifyValues(actualData));
    }

    @Test
    public void testCompactionOutputDirectoryNamesOnPartitionsAndOldDeltasDeleted() throws Exception {
        String p1 = "p=p1";
        String p2 = "p=p2";
        String oldDelta1 = "delta_0000001_0000001_0000";
        String oldDelta2 = "delta_0000002_0000002_0000";
        String oldDelta3 = "delta_0000003_0000003_0000";
        String oldDelta4 = "delta_0000004_0000004_0000";
        String expectedDelta1 = p1 + "/delta_0000001_0000002_v0000009";
        String expectedDelta2 = p2 + "/delta_0000003_0000004_v0000011";
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p1') (a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p1') (a,b) values(3,4)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p2') (a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + Table.ACIDTBLPART + " partition(p='p2') (a,b) values(3,4)");
        this.compactPartition(Table.ACIDTBLPART.name().toLowerCase(), CompactionType.MINOR, p1);
        this.compactPartition(Table.ACIDTBLPART.name().toLowerCase(), CompactionType.MINOR, p2);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        String tablePath = this.getWarehouseDir() + "/" + Table.ACIDTBLPART.name().toLowerCase() + "/";
        Assert.assertTrue((boolean)fs.exists(new Path(tablePath + expectedDelta1)));
        Assert.assertTrue((boolean)fs.exists(new Path(tablePath + expectedDelta2)));
        Assert.assertFalse((boolean)fs.exists(new Path(tablePath + oldDelta1)));
        Assert.assertFalse((boolean)fs.exists(new Path(tablePath + oldDelta2)));
        Assert.assertFalse((boolean)fs.exists(new Path(tablePath + oldDelta3)));
        Assert.assertFalse((boolean)fs.exists(new Path(tablePath + oldDelta4)));
    }

    @Test
    public void testShowCompactionOrder() throws Exception {
        this.d.destroy();
        this.hiveConf.setVar(HiveConf.ConfVars.DYNAMIC_PARTITIONING_MODE, "nonstrict");
        this.d = new Driver(this.hiveConf);
        this.runStatementOnDriver("drop database if exists mydb1 cascade");
        this.runStatementOnDriver("create database mydb1");
        this.runStatementOnDriver("create table mydb1.tbl0 (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(1,2,'p1'),(3,4,'p1'),(1,2,'p2'),(3,4,'p2'),(1,2,'p3'),(3,4,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p1') compact 'MAJOR'");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p2') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p3') compact 'MAJOR'");
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(4,5,'p1'),(6,7,'p1'),(4,5,'p2'),(6,7,'p2'),(4,5,'p3'),(6,7,'p3')");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(11,12,'p1'),(13,14,'p1'),(11,12,'p2'),(13,14,'p2'),(11,12,'p3'),(13,14,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION (p='p1')  compact 'MINOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("create table mydb1.tbl1 (a int, b int) partitioned by (ds string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb1.tbl1 PARTITION(ds)  values(1,2,'today'),(3,4,'today'),(1,2,'tomorrow'),(3,4,'tomorrow'),(1,2,'yesterday'),(3,4,'yesterday')");
        this.runStatementOnDriver("alter table mydb1.tbl1 PARTITION(ds='today') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("create table T (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into T values(0,2)");
        this.runStatementOnDriver("insert into T values(1,4)");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_COMPACTION, (boolean)true);
        this.runStatementOnDriver("alter table T compact 'minor'");
        TestTxnCommands2.runWorker(this.hiveConf);
        List compacts = this.txnHandler.showCompact(new ShowCompactRequest()).getCompacts();
        Assert.assertEquals((long)6L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"refused", (Object)((ShowCompactResponseElement)compacts.get(1)).getState());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(2)).getState());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(3)).getState());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)compacts.get(4)).getState());
        Assert.assertEquals((Object)"refused", (Object)((ShowCompactResponseElement)compacts.get(5)).getState());
    }

    @Test
    public void testAbortCompaction() throws Exception {
        this.d.destroy();
        this.hiveConf.setVar(HiveConf.ConfVars.DYNAMIC_PARTITIONING_MODE, "nonstrict");
        this.d = new Driver(this.hiveConf);
        this.runStatementOnDriver("drop database if exists mydb1 cascade");
        this.runStatementOnDriver("create database mydb1");
        this.runStatementOnDriver("create table mydb1.tbl0 (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(1,2,'p1'),(3,4,'p1'),(1,2,'p2'),(3,4,'p2'),(1,2,'p3'),(3,4,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p1') compact 'MAJOR'");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p2') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p3') compact 'MAJOR'");
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(4,5,'p1'),(6,7,'p1'),(4,5,'p2'),(6,7,'p2'),(4,5,'p3'),(6,7,'p3')");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(11,12,'p1'),(13,14,'p1'),(11,12,'p2'),(13,14,'p2'),(11,12,'p3'),(13,14,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION (p='p1')  compact 'MINOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("create table mydb1.tbl1 (a int, b int) partitioned by (ds string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb1.tbl1 PARTITION(ds)  values(1,2,'today'),(3,4,'today'),(1,2,'tomorrow'),(3,4,'tomorrow'),(1,2,'yesterday'),(3,4,'yesterday')");
        this.runStatementOnDriver("alter table mydb1.tbl1 PARTITION(ds='today') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("drop table if exists myT1");
        this.runStatementOnDriver("create table myT1 (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into myT1 values(0,2)");
        this.runStatementOnDriver("insert into myT1 values(1,4)");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_COMPACTION, (boolean)true);
        this.runStatementOnDriver("alter table myT1 compact 'minor'");
        TestTxnCommands2.runWorker(this.hiveConf);
        List compacts = this.txnHandler.showCompact(new ShowCompactRequest()).getCompacts();
        Assert.assertEquals((long)6L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"refused", (Object)((ShowCompactResponseElement)compacts.get(1)).getState());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(2)).getState());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(3)).getState());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)compacts.get(4)).getState());
        Assert.assertEquals((Object)"refused", (Object)((ShowCompactResponseElement)compacts.get(5)).getState());
        HashMap<Long, AbortCompactionResponseElement> expectedResponseMap = new HashMap<Long, AbortCompactionResponseElement>(){
            {
                this.put(Long.parseLong("6"), TestTxnCommands2.this.getAbortCompactionResponseElement(Long.parseLong("6"), "Success", "Successfully aborted compaction"));
                this.put(Long.parseLong("1"), TestTxnCommands2.this.getAbortCompactionResponseElement(Long.parseLong("1"), "Error", "Error while aborting compaction as compaction is in state-refused"));
                this.put(Long.parseLong("2"), TestTxnCommands2.this.getAbortCompactionResponseElement(Long.parseLong("2"), "Error", "Error while aborting compaction as compaction is in state-succeeded"));
                this.put(Long.parseLong("3"), TestTxnCommands2.this.getAbortCompactionResponseElement(Long.parseLong("3"), "Error", "Error while aborting compaction as compaction is in state-ready for cleaning"));
                this.put(Long.parseLong("4"), TestTxnCommands2.this.getAbortCompactionResponseElement(Long.parseLong("4"), "Error", "Error while aborting compaction as compaction is in state-ready for cleaning"));
                this.put(Long.parseLong("5"), TestTxnCommands2.this.getAbortCompactionResponseElement(Long.parseLong("5"), "Error", "Error while aborting compaction as compaction is in state-refused"));
                this.put(Long.parseLong("12"), TestTxnCommands2.this.getAbortCompactionResponseElement(Long.parseLong("12"), "Error", "No Such Compaction Id Available"));
            }
        };
        List<Long> compactionsToAbort = Arrays.asList(Long.parseLong("12"), ((ShowCompactResponseElement)compacts.get(0)).getId(), ((ShowCompactResponseElement)compacts.get(1)).getId(), ((ShowCompactResponseElement)compacts.get(2)).getId(), ((ShowCompactResponseElement)compacts.get(3)).getId(), ((ShowCompactResponseElement)compacts.get(4)).getId(), ((ShowCompactResponseElement)compacts.get(5)).getId());
        AbortCompactionRequest rqst = new AbortCompactionRequest();
        rqst.setCompactionIds(compactionsToAbort);
        AbortCompactResponse resp = this.txnHandler.abortCompactions(rqst);
        Assert.assertEquals((long)7L, (long)resp.getAbortedcompactsSize());
        Map testResp = resp.getAbortedcompacts();
        Assert.assertEquals((Object)expectedResponseMap, (Object)testResp);
        compacts = this.txnHandler.showCompact(new ShowCompactRequest()).getCompacts();
        Assert.assertEquals((long)6L, (long)compacts.size());
        Assert.assertEquals((Object)"aborted", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"refused", (Object)((ShowCompactResponseElement)compacts.get(1)).getState());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(2)).getState());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(3)).getState());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)compacts.get(4)).getState());
        Assert.assertEquals((Object)"refused", (Object)((ShowCompactResponseElement)compacts.get(5)).getState());
    }

    private AbortCompactionResponseElement getAbortCompactionResponseElement(long compactionId, String status, String message) {
        AbortCompactionResponseElement resEle = new AbortCompactionResponseElement(compactionId);
        resEle.setMessage(message);
        resEle.setStatus(status);
        return resEle;
    }

    private void compactPartition(String table, CompactionType type, String partition) throws Exception {
        CompactionRequest compactionRequest = new CompactionRequest("default", table, type);
        compactionRequest.setPartitionname(partition);
        this.txnHandler.compact(compactionRequest);
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
    }

    private static List<String> stringifyValuesNoSort(int[][] rowsIn) {
        assert (rowsIn.length > 0);
        int[][] rows = (int[][])rowsIn.clone();
        ArrayList<String> rs = new ArrayList<String>();
        for (int[] row : rows) {
            assert (row.length > 0);
            StringBuilder sb = new StringBuilder();
            for (int value : row) {
                sb.append(value).append("\t");
            }
            sb.setLength(sb.length() - 1);
            rs.add(sb.toString());
        }
        return rs;
    }

    private void runStatementOnDriverWithAbort(String stmt) {
        LOG.info("+runStatementOnDriver(" + stmt + ")");
        try {
            this.d.run(stmt);
        }
        catch (CommandProcessorException commandProcessorException) {
            // empty catch block
        }
    }

    @Test
    public void testShowCompactWithFilterOption() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        rqst.setPoolName("mypool");
        this.txnHandler.compact(rqst);
        CompactionRequest rqst1 = new CompactionRequest("foo", "bar1", CompactionType.MAJOR);
        rqst1.setPartitionname("ds=today");
        this.txnHandler.compact(rqst1);
        CompactionRequest rqst2 = new CompactionRequest("bar", "bar1", CompactionType.MAJOR);
        rqst2.setPartitionname("ds=today");
        this.txnHandler.compact(rqst2);
        CompactionRequest rqst3 = new CompactionRequest("xxx", "yyy", CompactionType.MINOR);
        rqst3.setPartitionname("ds=today");
        this.txnHandler.compact(rqst3);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)4L, (long)compacts.size());
        ShowCompactRequest scr = new ShowCompactRequest();
        scr.setDbName("bar");
        Assert.assertEquals((long)1L, (long)this.txnHandler.showCompact(scr).getCompacts().size());
        scr = new ShowCompactRequest();
        scr.setTbName("bar");
        scr.setPoolName("mypool");
        List compRsp = this.txnHandler.showCompact(scr).getCompacts();
        Assert.assertEquals((long)1L, (long)compRsp.size());
        Assert.assertEquals((Object)"mypool", (Object)((ShowCompactResponseElement)compRsp.get(0)).getPoolName());
        scr = new ShowCompactRequest();
        scr.setTbName("bar1");
        Assert.assertEquals((long)2L, (long)this.txnHandler.showCompact(scr).getCompacts().size());
        scr = new ShowCompactRequest();
        scr.setDbName("bar22");
        scr.setTbName("bar1");
        Assert.assertEquals((long)0L, (long)this.txnHandler.showCompact(scr).getCompacts().size());
        scr = new ShowCompactRequest();
        scr.setDbName("bar");
        scr.setTbName("bar1");
        Assert.assertEquals((long)1L, (long)this.txnHandler.showCompact(scr).getCompacts().size());
        scr = new ShowCompactRequest();
        scr.setState("i");
        Assert.assertEquals((long)4L, (long)this.txnHandler.showCompact(scr).getCompacts().size());
        scr = new ShowCompactRequest();
        scr.setState("f");
        Assert.assertEquals((long)0L, (long)this.txnHandler.showCompact(scr).getCompacts().size());
        scr = new ShowCompactRequest();
        scr.setType(CompactionType.MAJOR);
        Assert.assertEquals((long)3L, (long)this.txnHandler.showCompact(scr).getCompacts().size());
        scr = new ShowCompactRequest();
        scr.setType(CompactionType.MINOR);
        Assert.assertEquals((long)1L, (long)this.txnHandler.showCompact(scr).getCompacts().size());
        scr = new ShowCompactRequest();
        scr.setPartName("ds=today");
        Assert.assertEquals((long)4L, (long)this.txnHandler.showCompact(scr).getCompacts().size());
    }

    private void assertUniqueID(Table table) throws Exception {
        String partCols = table.getPartitionColumns();
        StringBuilder sb = new StringBuilder("select ");
        if (partCols != null && partCols.length() > 0) {
            sb.append(partCols).append(",");
        }
        sb.append(" ROW__ID, count(*) from ").append((Object)table).append(" group by ");
        if (partCols != null && partCols.length() > 0) {
            sb.append(partCols).append(",");
        }
        sb.append("ROW__ID having count(*) > 1");
        List<String> r = this.runStatementOnDriver(sb.toString());
        Assert.assertEquals((String)("Duplicate ROW__ID: " + r.toString()), (long)0L, (long)r.size());
    }

    private static String quoteString(String input) {
        return "'" + input + "'";
    }

    static enum Table {
        ACIDTBL("acidTbl"),
        ACIDTBLPART("acidTblPart", "p"),
        NONACIDORCTBL("nonAcidOrcTbl"),
        NONACIDPART("nonAcidPart", "p"),
        NONACIDPART2("nonAcidPart2", "p2"),
        NONACIDNESTEDPART("nonAcidNestedPart", "p,q"),
        ACIDNESTEDPART("acidNestedPart", "p,q"),
        MMTBL("mmTbl");

        final String name;
        final String partitionColumns;

        public String toString() {
            return this.name;
        }

        String getPartitionColumns() {
            return this.partitionColumns;
        }

        private Table(String name) {
            this(name, null);
        }

        private Table(String name, String partitionColumns) {
            this.name = name;
            this.partitionColumns = partitionColumns;
        }
    }

    private static class CompactionsByState {
        private int didNotInitiate;
        private int failed;
        private int initiated;
        private int readyToClean;
        private int succeeded;
        private int working;
        private int total;

        CompactionsByState() {
            this(0, 0, 0, 0, 0, 0, 0);
        }

        CompactionsByState(int didNotInitiate, int failed, int initiated, int readyToClean, int succeeded, int working, int total) {
            this.didNotInitiate = didNotInitiate;
            this.failed = failed;
            this.initiated = initiated;
            this.readyToClean = readyToClean;
            this.succeeded = succeeded;
            this.working = working;
            this.total = total;
        }
    }

    static class SlowCompactorMap<V extends Writable>
    extends MRCompactor.CompactorMap<V> {
        SlowCompactorMap() {
        }

        public void cleanupTmpLocationOnTaskRetry(AcidOutputFormat.Options options, Path rootDir) throws IOException {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            super.cleanupTmpLocationOnTaskRetry(options, rootDir);
        }
    }
}

