/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.service.AcidHouseKeeperService;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTestUtilities;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnCommands
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnCommands.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Override
    void initHiveConf() {
        super.initHiveConf();
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)false);
        HiveConf.setVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMIC_PARTITIONING_MODE, (String)"nonstrict");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_DROP_PARTITION_USE_BASE, (boolean)false);
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_RENAME_PARTITION_MAKE_COPY, (boolean)false);
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX, (boolean)false);
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_TRUNCATE_USE_BASE, (boolean)false);
        MetastoreConf.setClass((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FILTER_HOOK, DummyMetaStoreFilterHookImpl.class, MetaStoreFilterHook.class);
        HiveConf.setVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_METASTORE_WAREHOUSE_EXTERNAL, (String)new Path(this.getWarehouseDir(), "ext").toUri().getPath());
    }

    @Test
    public void testInsertOverwrite() throws Exception {
        this.runStatementOnDriver("insert overwrite table " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " select a,b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL2);
        this.runStatementOnDriver("create table " + TxnCommandsBaseForTests.Table.NONACIDORCTBL2 + "3(a int, b int) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where b = 2");
        Assert.assertEquals((long)1L, (long)rs.size());
        Assert.assertEquals((Object)"1", (Object)rs.get(0));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, true);
        this.runStatementOnDriver("insert overwrite table " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(3,2)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE_ROLLBACK_TXN, false);
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(5,6)");
        rs = this.runStatementOnDriver("select a from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a");
        Assert.assertEquals((long)2L, (long)rs.size());
        Assert.assertEquals((Object)"1", (Object)rs.get(0));
        Assert.assertEquals((Object)"5", (Object)rs.get(1));
    }

    @Ignore(value="not needed but useful for testing")
    @Test
    public void testNonAcidInsert() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + "(a,b) values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL);
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + "(a,b) values(2,3)");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL);
    }

    private void dumpBucketData(TxnCommandsBaseForTests.Table table, long writeId, int stmtId, int bucketNum) throws Exception {
    }

    private void dumpTableData(TxnCommandsBaseForTests.Table table, long writeId, int stmtId) throws Exception {
        for (int bucketNum = 0; bucketNum < 2; ++bucketNum) {
            this.dumpBucketData(table, writeId, stmtId, bucketNum);
        }
    }

    @Test
    public void testSimpleAcidInsert() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows1));
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows2));
        List<String> allData = TestTxnCommands.stringifyValues(rows1);
        allData.addAll(TestTxnCommands.stringifyValues(rows2));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Data didn't match inside tx (rs0)", allData, rs0);
        this.runStatementOnDriver("COMMIT WORK");
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 1L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 0);
        this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        CommandProcessorException e = this.runStatementOnDriverNegative("COMMIT");
        Assert.assertEquals((String)("Error didn't match: " + e), (long)ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN.getErrorCode(), (long)e.getErrorCode());
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Data didn't match inside tx (rs0)", allData, rs1);
    }

    @Test
    public void testMmExim() throws Exception {
        String tableName = "mm_table";
        String importName = tableName + "_import";
        this.runStatementOnDriver("drop table if exists " + tableName);
        this.runStatementOnDriver(String.format("create table %s (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver(String.format("insert into %s (a,b) %s", tableName, TestTxnCommands.makeValuesClause(rows1)));
        this.runStatementOnDriver(String.format("insert into %s (a,b) %s", tableName, TestTxnCommands.makeValuesClause(rows1)));
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        Table table = msClient.getTable("default", tableName);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Path exportPath = new Path(table.getSd().getLocation() + "_export");
        fs.delete(exportPath, true);
        this.runStatementOnDriver(String.format("export table %s to '%s'", tableName, exportPath));
        List<String> paths = this.listPathsRecursive(fs, exportPath);
        this.verifyMmExportPaths(paths, 2);
        this.runStatementOnDriver(String.format("import table %s from '%s'", importName, exportPath));
        Table imported = msClient.getTable("default", importName);
        Assert.assertEquals((String)imported.toString(), (Object)"insert_only", imported.getParameters().get("transactional_properties"));
        Path importPath = new Path(imported.getSd().getLocation());
        Object[] stat = fs.listStatus(importPath, FileUtils.HIDDEN_FILES_PATH_FILTER);
        Assert.assertEquals((String)Arrays.toString(stat), (long)1L, (long)stat.length);
        this.assertIsDelta((FileStatus)stat[0]);
        List<String> allData = TestTxnCommands.stringifyValues(rows1);
        allData.addAll(TestTxnCommands.stringifyValues(rows1));
        allData.sort(null);
        Collections.sort(allData);
        List<String> rs = this.runStatementOnDriver(String.format("select a,b from %s order by a,b", importName));
        Assert.assertEquals((String)("After import: " + rs), allData, rs);
        this.runStatementOnDriver("drop table if exists " + importName);
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver(String.format("insert overwrite table %s %s", tableName, TestTxnCommands.makeValuesClause(rows2)));
        fs.delete(exportPath, true);
        this.runStatementOnDriver(String.format("export table %s to '%s'", tableName, exportPath));
        paths = this.listPathsRecursive(fs, exportPath);
        this.verifyMmExportPaths(paths, 1);
        this.runStatementOnDriver(String.format("create table %s (a int, b int) stored as orc TBLPROPERTIES ('transactional'='false')", importName));
        this.runStatementOnDriver(String.format("import table %s from '%s'", importName, exportPath));
        imported = msClient.getTable("default", importName);
        Assert.assertNull((String)imported.toString(), imported.getParameters().get("transactional"));
        Assert.assertNull((String)imported.toString(), imported.getParameters().get("transactional_properties"));
        importPath = new Path(imported.getSd().getLocation());
        stat = fs.listStatus(importPath, FileUtils.HIDDEN_FILES_PATH_FILTER);
        allData = TestTxnCommands.stringifyValues(rows2);
        Collections.sort(allData);
        rs = this.runStatementOnDriver(String.format("select a,b from %s order by a,b", importName));
        Assert.assertEquals((String)("After import: " + rs), allData, rs);
        this.runStatementOnDriver("drop table if exists " + importName);
        this.runStatementOnDriver("drop table if exists " + tableName);
        msClient.close();
    }

    private static void syncThreadStart(CountDownLatch cdlIn, CountDownLatch cdlOut) {
        cdlIn.countDown();
        try {
            cdlOut.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testParallelInsertStats() throws Exception {
        boolean hasStats;
        int TASK_COUNT = 4;
        String tableName = "mm_table";
        IMetaStoreClient msClient = this.prepareParallelTest(tableName, 0);
        String[] queries = new String[4];
        for (int i = 0; i < queries.length; ++i) {
            queries[i] = String.format("insert into %s (a) values (" + i + ")", tableName);
        }
        this.runParallelQueries(queries);
        List<ColumnStatisticsObj> stats = this.getTxnTableStats(msClient, tableName);
        boolean bl = hasStats = 0 != stats.size();
        if (hasStats) {
            this.verifyLongStats(4, 0, 3, stats);
        }
        this.runStatementOnDriver(String.format("insert into %s (a) values (4)", tableName));
        if (!hasStats) {
            stats = this.getTxnTableStats(msClient, tableName);
            Assert.assertEquals((long)0L, (long)stats.size());
        }
        this.runStatementOnDriver(String.format("analyze table %s compute statistics for columns", tableName));
        this.verifyLongStats(5, 0, 4, this.getTxnTableStats(msClient, tableName));
    }

    private void verifyLongStats(int dvCount, int min, int max, List<ColumnStatisticsObj> stats) {
        Assert.assertEquals((long)1L, (long)stats.size());
        LongColumnStatsData data = stats.get(0).getStatsData().getLongStats();
        Assert.assertEquals((long)min, (long)data.getLowValue());
        Assert.assertEquals((long)max, (long)data.getHighValue());
        Assert.assertEquals((long)dvCount, (long)data.getNumDVs());
    }

    private void runParallelQueries(String[] queries) throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(queries.length);
        CountDownLatch cdlIn = new CountDownLatch(queries.length);
        CountDownLatch cdlOut = new CountDownLatch(1);
        Future[] tasks = new Future[queries.length];
        for (i = 0; i < tasks.length; ++i) {
            tasks[i] = executor.submit(new QueryRunnable(this.hiveConf, queries[i], cdlIn, cdlOut));
        }
        cdlIn.await();
        cdlOut.countDown();
        for (i = 0; i < tasks.length; ++i) {
            tasks[i].get();
        }
    }

    private IMetaStoreClient prepareParallelTest(String tableName, int val) throws Exception, MetaException, TException, NoSuchObjectException {
        this.hiveConf.setBoolean("hive.stats.autogather", true);
        this.hiveConf.setBoolean("hive.stats.column.autogather", true);
        this.hiveConf.setBoolean("hive.txn.xlock.write", true);
        Hive.closeCurrent();
        this.runStatementOnDriver("drop table if exists " + tableName);
        this.runStatementOnDriver(String.format("create table %s (a int) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        this.runStatementOnDriver(String.format("insert into %s (a) values (" + val + ")", tableName));
        this.runStatementOnDriver(String.format("insert into %s (a) values (" + val + ")", tableName));
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        List<ColumnStatisticsObj> stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)1L, (long)stats.size());
        return msClient;
    }

    @Test
    public void testAddAndDropConstraintAdvancingWriteIds() throws Exception {
        String tableName = "constraints_table";
        this.hiveConf.setBoolean("hive.stats.autogather", true);
        this.hiveConf.setBoolean("hive.stats.column.autogather", true);
        Hive.closeCurrent();
        this.runStatementOnDriver("drop table if exists " + tableName);
        this.runStatementOnDriver(String.format("create table %s (a int, b string) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        this.runStatementOnDriver(String.format("insert into %s (a) values (0)", tableName));
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        String validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        LOG.info("ValidWriteIds before add constraint::" + validWriteIds);
        Assert.assertEquals((Object)"default.constraints_table:1:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s  ADD CONSTRAINT a_PK PRIMARY KEY (`a`) DISABLE NOVALIDATE", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        LOG.info("ValidWriteIds after add constraint primary key::" + validWriteIds);
        Assert.assertEquals((Object)"default.constraints_table:2:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s CHANGE COLUMN b b STRING NOT NULL", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        LOG.info("ValidWriteIds after add constraint not null::" + validWriteIds);
        Assert.assertEquals((Object)"default.constraints_table:3:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s ADD CONSTRAINT check1 CHECK (a <= 25)", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        LOG.info("ValidWriteIds after add constraint check::" + validWriteIds);
        Assert.assertEquals((Object)"default.constraints_table:4:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s ADD CONSTRAINT unique1 UNIQUE (a, b) DISABLE", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        LOG.info("ValidWriteIds after add constraint unique::" + validWriteIds);
        Assert.assertEquals((Object)"default.constraints_table:5:9223372036854775807::", (Object)validWriteIds);
        LOG.info("ValidWriteIds before drop constraint::" + validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s  DROP CONSTRAINT a_PK", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.constraints_table:6:9223372036854775807::", (Object)validWriteIds);
        LOG.info("ValidWriteIds after drop constraint primary key::" + validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s  DROP CONSTRAINT check1", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.constraints_table:7:9223372036854775807::", (Object)validWriteIds);
        LOG.info("ValidWriteIds after drop constraint check::" + validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s  DROP CONSTRAINT unique1", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.constraints_table:8:9223372036854775807::", (Object)validWriteIds);
        LOG.info("ValidWriteIds after drop constraint unique::" + validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s CHANGE COLUMN b b STRING", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.constraints_table:9:9223372036854775807::", (Object)validWriteIds);
    }

    @Test
    public void exchangePartitionShouldNotWorkForTransactionalTables() throws Exception {
        this.runStatementOnDriver("create database IF NOT EXISTS db1");
        this.runStatementOnDriver("create database IF NOT EXISTS db2");
        this.runStatementOnDriver("CREATE TABLE db1.exchange_part_test1 (f1 string) PARTITIONED BY (ds STRING)");
        String tableName = "db2.exchange_part_test2";
        this.runStatementOnDriver(String.format("CREATE TABLE %s (f1 string) PARTITIONED BY (ds STRING) TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        this.runStatementOnDriver("ALTER TABLE db2.exchange_part_test2 ADD PARTITION (ds='2013-04-05')");
        try {
            this.runStatementOnDriver("ALTER TABLE db1.exchange_part_test1 EXCHANGE PARTITION (ds='2013-04-05') WITH TABLE db2.exchange_part_test2");
            Assert.fail((String)"Exchange partition should not be allowed for transaction tables");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Exchange partition is not allowed with transactional tables"));
        }
    }

    @Test
    public void truncateTableAdvancingWriteId() throws Exception {
        this.runStatementOnDriver("create database IF NOT EXISTS trunc_db");
        String tableName = "trunc_db.trunc_table";
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.runStatementOnDriver(String.format("CREATE TABLE %s (f1 string) PARTITIONED BY (ds STRING) TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        String validWriteIds = msClient.getValidWriteIds(tableName).toString();
        LOG.info("ValidWriteIds before truncate table::" + validWriteIds);
        Assert.assertEquals((Object)"trunc_db.trunc_table:0:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver("TRUNCATE TABLE trunc_db.trunc_table");
        validWriteIds = msClient.getValidWriteIds(tableName).toString();
        LOG.info("ValidWriteIds after truncate table::" + validWriteIds);
        Assert.assertEquals((Object)"trunc_db.trunc_table:1:9223372036854775807::", (Object)validWriteIds);
    }

    @Test
    public void testAddAndDropPartitionAdvancingWriteIds() throws Exception {
        this.runStatementOnDriver("create database IF NOT EXISTS db1");
        String tableName = "db1.add_drop_partition";
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.runStatementOnDriver(String.format("CREATE TABLE %s (f1 string) PARTITIONED BY (ds STRING) TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        String validWriteIds = msClient.getValidWriteIds(tableName).toString();
        LOG.info("ValidWriteIds before add partition::" + validWriteIds);
        Assert.assertEquals((Object)"db1.add_drop_partition:0:9223372036854775807::", (Object)validWriteIds);
        validWriteIds = msClient.getValidWriteIds(tableName).toString();
        this.runStatementOnDriver("ALTER TABLE db1.add_drop_partition ADD PARTITION (ds='2013-04-05')");
        validWriteIds = msClient.getValidWriteIds(tableName).toString();
        LOG.info("ValidWriteIds after add partition::" + validWriteIds);
        Assert.assertEquals((Object)"db1.add_drop_partition:1:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver("ALTER TABLE db1.add_drop_partition DROP PARTITION (ds='2013-04-05')");
        validWriteIds = msClient.getValidWriteIds(tableName).toString();
        LOG.info("ValidWriteIds after drop partition::" + validWriteIds);
        Assert.assertEquals((Object)"db1.add_drop_partition:2:9223372036854775807::", (Object)validWriteIds);
    }

    @Test
    public void testDDLsAdvancingWriteIds() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.TRANSACTIONAL_CONCATENATE_NOBLOCK, true);
        String tableName = "alter_table";
        this.runStatementOnDriver("drop table if exists " + tableName);
        this.runStatementOnDriver(String.format("create table %s (a int, b string, c BIGINT, d INT) PARTITIONED BY (ds STRING)TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        this.runStatementOnDriver(String.format("insert into %s (a) values (0)", tableName));
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        String validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:1:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s SET OWNER USER user_name", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:2:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s CLUSTERED BY(c) SORTED BY(d) INTO 32 BUCKETS", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:3:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("ALTER TABLE %s ADD PARTITION (ds='2013-04-05')", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:4:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("ALTER TABLE %s SET SERDEPROPERTIES ('field.delim'='\\u0001')", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:5:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("ALTER TABLE %s PARTITION (ds='2013-04-05') SET FILEFORMAT PARQUET", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:6:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("ALTER TABLE %s PARTITION (ds='2013-04-05') COMPACT 'minor'", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:6:9223372036854775807::", (Object)validWriteIds);
        TestTxnCommands.runWorker(this.hiveConf);
        TestTxnCommands.runCleaner(this.hiveConf);
        this.runStatementOnDriver(String.format("ALTER TABLE %s PARTITION (ds='2013-04-05') CONCATENATE", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:7:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("ALTER TABLE %s SKEWED BY (a) ON (1,2)", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:8:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("ALTER TABLE %s SET SKEWED LOCATION (1='hdfs://%s/abcd/1')", tableName, IPStackUtils.concatLoopbackAddressPort((int)8020)));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:9:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("ALTER TABLE %s NOT SKEWED", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:10:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("ALTER TABLE %s UNSET SERDEPROPERTIES ('field.delim')", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.alter_table:11:9223372036854775807::", (Object)validWriteIds);
    }

    @Test
    public void testParallelInsertAnalyzeStats() throws Exception {
        boolean hasStats;
        String tableName = "mm_table";
        IMetaStoreClient msClient = this.prepareParallelTest(tableName, 0);
        String[] queries = new String[]{String.format("insert into %s (a) values (999)", tableName), String.format("analyze table %s compute statistics for columns", tableName)};
        this.runParallelQueries(queries);
        List<ColumnStatisticsObj> stats = this.getTxnTableStats(msClient, tableName);
        boolean bl = hasStats = 0 != stats.size();
        if (hasStats) {
            this.verifyLongStats(2, 0, 999, stats);
        }
        this.runStatementOnDriver(String.format("insert into %s (a) values (1000)", tableName));
        if (!hasStats) {
            stats = this.getTxnTableStats(msClient, tableName);
            Assert.assertEquals((long)0L, (long)stats.size());
        }
        this.runStatementOnDriver(String.format("analyze table %s compute statistics for columns", tableName));
        this.verifyLongStats(3, 0, 1000, this.getTxnTableStats(msClient, tableName));
    }

    @Test
    public void testParallelTruncateAnalyzeStats() throws Exception {
        boolean hasStats;
        String tableName = "mm_table";
        IMetaStoreClient msClient = this.prepareParallelTest(tableName, 0);
        String[] queries = new String[]{String.format("truncate table %s", tableName), String.format("analyze table %s compute statistics for columns", tableName)};
        this.runParallelQueries(queries);
        List<ColumnStatisticsObj> stats = this.getTxnTableStats(msClient, tableName);
        boolean bl = hasStats = 0 != stats.size();
        if (hasStats) {
            if (stats.get(0).getStatsData().getLongStats().getNumDVs() > 0L) {
                this.verifyLongStats(1, 0, 0, stats);
            } else {
                this.verifyLongStats(0, 0, 0, stats);
            }
        }
        this.runStatementOnDriver(String.format("analyze table %s compute statistics for columns", tableName));
        this.verifyLongStats(0, 0, 0, this.getTxnTableStats(msClient, tableName));
    }

    @Test
    public void testTxnStatsOnOff() throws Exception {
        String tableName = "mm_table";
        this.hiveConf.setBoolean("hive.stats.autogather", true);
        this.hiveConf.setBoolean("hive.stats.column.autogather", true);
        Hive.closeCurrent();
        this.runStatementOnDriver("drop table if exists " + tableName);
        this.runStatementOnDriver(String.format("create table %s (a int) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        this.runStatementOnDriver(String.format("insert into %s (a) values (1)", tableName));
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        List<ColumnStatisticsObj> stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)1L, (long)stats.size());
        this.runStatementOnDriver(String.format("insert into %s (a) values (1)", tableName));
        stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)1L, (long)stats.size());
        msClient.close();
        this.hiveConf.setBoolean(MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED.getVarname(), false);
        msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)0L, (long)stats.size());
        msClient.close();
        this.hiveConf.setBoolean(MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED.getVarname(), true);
        msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)1L, (long)stats.size());
        msClient.close();
        this.hiveConf.setBoolean(MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED.getVarname(), false);
        Hive.closeCurrent();
        this.runStatementOnDriver(String.format("insert into %s (a) values (1)", tableName));
        this.hiveConf.setBoolean(MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED.getVarname(), true);
        msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)0L, (long)stats.size());
        msClient.close();
    }

    public List<ColumnStatisticsObj> getTxnTableStats(IMetaStoreClient msClient, String tableName) throws TException, NoSuchObjectException, MetaException {
        String validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        List stats = msClient.getTableColumnStatistics("default", tableName, (List)Lists.newArrayList((Object[])new String[]{"a"}), "hive", validWriteIds);
        return stats;
    }

    private void assertIsDelta(FileStatus stat) {
        Assert.assertTrue((String)stat.toString(), (boolean)stat.getPath().getName().startsWith("delta_"));
    }

    private void verifyMmExportPaths(List<String> paths, int deltasOrBases) {
        Assert.assertEquals((String)paths.toString(), (long)(2 * deltasOrBases + 1), (long)paths.size());
        for (String path : paths) {
            Assert.assertFalse((String)path, (boolean)path.startsWith("delta_"));
            Assert.assertFalse((String)path, (boolean)path.startsWith("base_"));
        }
    }

    private List<String> listPathsRecursive(FileSystem fs, Path path) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        LinkedList<Path> queue = new LinkedList<Path>();
        queue.add(path);
        while (!queue.isEmpty()) {
            FileStatus[] stats;
            Path next = (Path)queue.pollFirst();
            for (FileStatus stat : stats = fs.listStatus(next, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                Path child = stat.getPath();
                paths.add(child.toString());
                if (!stat.isDirectory()) continue;
                queue.add(child);
            }
        }
        return paths;
    }

    @Test
    public void testErrors() throws Exception {
        this.runStatementOnDriver("start transaction");
        CommandProcessorException e1 = this.runStatementOnDriverNegative("create table foo(x int, y int)");
        Assert.assertEquals((String)"Expected DDL to fail in an open txn", (long)ErrorMsg.OP_NOT_ALLOWED_IN_TXN.getErrorCode(), (long)e1.getErrorCode());
        CommandProcessorException e2 = this.runStatementOnDriverNegative("update " + TxnCommandsBaseForTests.Table.ACIDTBL + " set a = 1 where b != 1");
        Assert.assertEquals((String)"Expected update of bucket column to fail", (Object)"FAILED: SemanticException [Error 10302]: Updating values of bucketing columns is not supported.  Column a.", (Object)e2.getMessage());
        Assert.assertEquals((String)"Expected update of bucket column to fail", (long)ErrorMsg.UPDATE_CANNOT_UPDATE_BUCKET_VALUE.getErrorCode(), (long)e2.getErrorCode());
        CommandProcessorException e3 = this.runStatementOnDriverNegative("commit");
        Assert.assertEquals((String)("Error didn't match: " + e3), (long)ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN.getErrorCode(), (long)e3.getErrorCode());
        CommandProcessorException e4 = this.runStatementOnDriverNegative("rollback");
        Assert.assertEquals((String)("Error didn't match: " + e4), (long)ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN.getErrorCode(), (long)e4.getErrorCode());
        this.runStatementOnDriver("start transaction");
        CommandProcessorException e5 = this.runStatementOnDriverNegative("start transaction");
        Assert.assertEquals((String)"Expected start transaction to fail", (long)ErrorMsg.OP_NOT_ALLOWED_IN_TXN.getErrorCode(), (long)e5.getErrorCode());
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        this.runStatementOnDriver("commit work");
        rs0 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
    }

    @Test
    public void testReadMyOwnInsert() throws Exception {
        this.runStatementOnDriver("START TRANSACTION");
        List<String> rs = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBL);
        Assert.assertEquals((String)("Expected empty " + TxnCommandsBaseForTests.Table.ACIDTBL), (long)0L, (long)rs.size());
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("START TRANSACTION");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        this.runStatementOnDriver("rollback work");
        Assert.assertEquals((String)"Can't see write after commit", (long)1L, (long)rs1.size());
    }

    @Test
    public void testImplicitRollback() throws Exception {
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        CommandProcessorException e = this.runStatementOnDriverNegative("select * from no_such_table");
        Assert.assertEquals((String)"Txn didn't fail?", (Object)"FAILED: SemanticException [Error 10001]: Line 1:14 Table not found 'no_such_table'", (Object)e.getMessage());
        this.runStatementOnDriver("start transaction");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        this.runStatementOnDriver("commit");
        Assert.assertEquals((String)"Didn't rollback as expected", (long)0L, (long)rs1.size());
    }

    @Test
    public void testExplicitRollback() throws Exception {
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("ROLLBACK");
        List<String> rs = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Rollback didn't rollback", (long)0L, (long)rs.size());
    }

    @Test
    public void testMultipleInserts() throws Exception {
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows1));
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows2));
        List<String> allData = TestTxnCommands.stringifyValues(rows1);
        allData.addAll(TestTxnCommands.stringifyValues(rows2));
        List<String> rs = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Content didn't match before commit rs", allData, rs);
        this.runStatementOnDriver("commit");
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 1L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 1L, 1);
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Content didn't match after commit rs1", allData, rs1);
    }

    @Test
    public void testDeleteOfMultipleInserts() throws Exception {
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows1));
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows2));
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("delete from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where b = 2");
        this.runStatementOnDriver("delete from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where b = 8");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        int[][] remain = new int[][]{{3, 4}, {5, 6}};
        Assert.assertEquals((String)"Content didn't match after delete ", TestTxnCommands.stringifyValues(remain), rs2);
    }

    @Test
    public void testDelete() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", TestTxnCommands.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("delete from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where b = 4");
        int[][] updatedData2 = new int[][]{{1, 2}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", TestTxnCommands.stringifyValues(updatedData2), rs3);
        this.runStatementOnDriver("commit");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", TestTxnCommands.stringifyValues(updatedData2), rs4);
    }

    @Test
    public void testUpdateOfInserts() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", TestTxnCommands.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        List<String> allData = TestTxnCommands.stringifyValues(rows1);
        allData.addAll(TestTxnCommands.stringifyValues(rows2));
        Assert.assertEquals((String)"Content didn't match rs1", allData, rs1);
        this.runStatementOnDriver("update " + TxnCommandsBaseForTests.Table.ACIDTBL + " set b = 1 where b != 1");
        int[][] updatedData = new int[][]{{1, 1}, {3, 1}, {5, 1}, {7, 1}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Wrong data after update", TestTxnCommands.stringifyValues(updatedData), rs2);
        this.runStatementOnDriver("commit");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", TestTxnCommands.stringifyValues(updatedData), rs4);
    }

    @Test
    public void testUpdateDeleteOfInserts() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", TestTxnCommands.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        List<String> allData = TestTxnCommands.stringifyValues(rows1);
        allData.addAll(TestTxnCommands.stringifyValues(rows2));
        Assert.assertEquals((String)"Content didn't match rs1", allData, rs1);
        this.runStatementOnDriver("update " + TxnCommandsBaseForTests.Table.ACIDTBL + " set b = 1 where b != 1");
        int[][] updatedData = new int[][]{{1, 1}, {3, 1}, {5, 1}, {7, 1}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Wrong data after update", TestTxnCommands.stringifyValues(updatedData), rs2);
        this.runStatementOnDriver("delete from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a = 7 and b = 1");
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 1L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 2);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 4);
        int[][] updatedData2 = new int[][]{{1, 1}, {3, 1}, {5, 1}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", TestTxnCommands.stringifyValues(updatedData2), rs3);
        this.runStatementOnDriver("commit");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", TestTxnCommands.stringifyValues(updatedData2), rs4);
    }

    @Test
    public void testMultipleDelete() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", TestTxnCommands.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("delete from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where b = 8");
        int[][] updatedData2 = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", TestTxnCommands.stringifyValues(updatedData2), rs2);
        this.runStatementOnDriver("delete from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where b = 4");
        int[][] updatedData3 = new int[][]{{1, 2}, {5, 6}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete2", TestTxnCommands.stringifyValues(updatedData3), rs3);
        this.runStatementOnDriver("update " + TxnCommandsBaseForTests.Table.ACIDTBL + " set b=3");
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 1L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 2);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 4);
        List<String> rs5 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        int[][] updatedData4 = new int[][]{{1, 3}, {5, 3}};
        Assert.assertEquals((String)"Wrong data after delete", TestTxnCommands.stringifyValues(updatedData4), rs5);
        this.runStatementOnDriver("commit");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", TestTxnCommands.stringifyValues(updatedData4), rs4);
    }

    @Test
    public void testDeleteIn() throws Exception {
        this.runStatementOnDriver("delete from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a IN (SELECT A.a from " + TxnCommandsBaseForTests.Table.ACIDTBL + "  A)");
        int[][] tableData = new int[][]{{1, 2}, {3, 2}, {5, 2}, {1, 3}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) " + TestTxnCommands.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL2 + "(a,b,c) values(1,7,17),(3,7,17)");
        this.runStatementOnDriver("delete from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a in(select a from " + TxnCommandsBaseForTests.Table.ACIDTBL2 + ")");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + "(a,b) select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL2);
        List<String> rs = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 7}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update failed", TestTxnCommands.stringifyValues(updatedData), rs);
    }

    @Test
    public void testTimeOutReaper() throws Exception {
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("delete from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a = 5");
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_TXN_TIMEOUT, 2L, TimeUnit.MILLISECONDS);
        AcidHouseKeeperService houseKeeperService = new AcidHouseKeeperService();
        houseKeeperService.setConf((Configuration)this.hiveConf);
        houseKeeperService.run();
        CommandProcessorException e = this.runStatementOnDriverNegative("delete from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a = 5");
        Assert.assertTrue((String)("Actual: " + e.getMessage()), (boolean)e.getMessage().contains("Transaction manager has aborted the transaction txnid:5"));
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_TXN_TIMEOUT, 1L, TimeUnit.SECONDS);
        houseKeeperService.setConf((Configuration)this.hiveConf);
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("select count(*) from " + TxnCommandsBaseForTests.Table.ACIDTBL + " where a = 17");
        TestTxnCommands.pause(750);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        GetOpenTxnsInfoResponse txnsInfoResponse = txnHandler.getOpenTxnsInfo();
        Assert.assertEquals((long)2L, (long)txnsInfoResponse.getOpen_txns().size());
        TxnInfo txnInfo = null;
        for (TxnInfo ti : txnsInfoResponse.getOpen_txns()) {
            if (ti.getState() != TxnState.OPEN) continue;
            txnInfo = ti;
            break;
        }
        Assert.assertNotNull(txnInfo);
        Assert.assertEquals((long)6L, (long)txnInfo.getId());
        Assert.assertEquals((Object)TxnState.OPEN, (Object)txnInfo.getState());
        String s = TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select TXN_STARTED, TXN_LAST_HEARTBEAT from TXNS where TXN_ID = " + txnInfo.getId()), (boolean)false);
        String[] vals = s.split("\\s+");
        Assert.assertEquals((String)"Didn't get expected timestamps", (long)2L, (long)vals.length);
        long lastHeartbeat = Long.parseLong(vals[1]);
        Assert.assertNotEquals((String)"Didn't see heartbeat happen", (long)Long.parseLong(vals[0]), (long)lastHeartbeat);
        ShowLocksResponse slr = txnHandler.showLocks(new ShowLocksRequest());
        TestTxnDbUtil.checkLock((LockType)LockType.SHARED_READ, (LockState)LockState.ACQUIRED, (String)"default", (String)TxnCommandsBaseForTests.Table.ACIDTBL.name, null, (List)slr.getLocks());
        TestTxnCommands.pause(750);
        houseKeeperService.run();
        TestTxnCommands.pause(750);
        slr = txnHandler.showLocks(new ShowLocksRequest());
        Assert.assertEquals((String)("Unexpected lock count: " + slr), (long)1L, (long)slr.getLocks().size());
        TestTxnDbUtil.checkLock((LockType)LockType.SHARED_READ, (LockState)LockState.ACQUIRED, (String)"default", (String)TxnCommandsBaseForTests.Table.ACIDTBL.name, null, (List)slr.getLocks());
        TestTxnCommands.pause(750);
        houseKeeperService.run();
        slr = txnHandler.showLocks(new ShowLocksRequest());
        Assert.assertEquals((String)("Unexpected lock count: " + slr), (long)1L, (long)slr.getLocks().size());
        TestTxnDbUtil.checkLock((LockType)LockType.SHARED_READ, (LockState)LockState.ACQUIRED, (String)"default", (String)TxnCommandsBaseForTests.Table.ACIDTBL.name, null, (List)slr.getLocks());
        s = TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select TXN_STARTED, TXN_LAST_HEARTBEAT from TXNS where TXN_ID = " + txnInfo.getId()), (boolean)false);
        vals = s.split("\\s+");
        Assert.assertEquals((String)"Didn't get expected timestamps", (long)2L, (long)vals.length);
        Assert.assertTrue((String)("Heartbeat didn't progress: (old,new) (" + lastHeartbeat + "," + vals[1] + ")"), (lastHeartbeat < Long.parseLong(vals[1]) ? 1 : 0) != 0);
        this.runStatementOnDriver("rollback");
        slr = txnHandler.showLocks(new ShowLocksRequest());
        Assert.assertEquals((String)"Unexpected lock count", (long)0L, (long)slr.getLocks().size());
    }

    private static void pause(int timeMillis) {
        try {
            Thread.sleep(timeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void exchangePartition() throws Exception {
        this.runStatementOnDriver("create database ex1");
        this.runStatementOnDriver("create database ex2");
        this.runStatementOnDriver("CREATE TABLE ex1.exchange_part_test1 (f1 string) PARTITIONED BY (ds STRING)");
        this.runStatementOnDriver("CREATE TABLE ex2.exchange_part_test2 (f1 string) PARTITIONED BY (ds STRING)");
        this.runStatementOnDriver("ALTER TABLE ex2.exchange_part_test2 ADD PARTITION (ds='2013-04-05')");
        this.runStatementOnDriver("ALTER TABLE ex1.exchange_part_test1 EXCHANGE PARTITION (ds='2013-04-05') WITH TABLE ex2.exchange_part_test2");
    }

    @Test
    public void testMergeNegative() throws Exception {
        CommandProcessorException e = this.runStatementOnDriverNegative("MERGE INTO " + TxnCommandsBaseForTests.Table.ACIDTBL + " target\nUSING " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " source ON target.a = source.a\nWHEN MATCHED THEN UPDATE set b = 1\nWHEN MATCHED THEN DELETE\nWHEN NOT MATCHED AND a < 1 THEN INSERT VALUES(1,2)");
        Assert.assertEquals((Object)ErrorMsg.MERGE_PREDIACTE_REQUIRED, (Object)((HiveException)e.getCause()).getCanonicalErrorMsg());
    }

    @Test
    public void testMergeNegative2() throws Exception {
        CommandProcessorException e = this.runStatementOnDriverNegative("MERGE INTO " + TxnCommandsBaseForTests.Table.ACIDTBL + " target USING " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + "\n source ON target.pk = source.pk \nWHEN MATCHED THEN UPDATE set b = 1 \nWHEN MATCHED THEN UPDATE set b=a");
        Assert.assertEquals((Object)ErrorMsg.MERGE_TOO_MANY_UPDATE, (Object)((HiveException)e.getCause()).getCanonicalErrorMsg());
    }

    @Test
    public void testQuotedIdentifier() throws Exception {
        String target = "`aci/d_u/ami`";
        String src = "`src/name`";
        this.runStatementOnDriver("drop table if exists " + target);
        this.runStatementOnDriver("drop table if exists " + src);
        this.runStatementOnDriver("create table " + target + "(i int,`d?*de e` decimal(5,2),vc varchar(128)) clustered by (i) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + src + "(gh int, j decimal(5,2), k varchar(128))");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='blah' \nwhen not matched then insert values(1,2.1,'baz')");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='blah',  `d?*de e` = current_timestamp()  \nwhen not matched then insert values(1,2.1, concat('baz', current_timestamp()))");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='blah' \nwhen not matched then insert values(1,2.1,'a\\b')");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='\u2206\u220b'\nwhen not matched then insert values(`a/b`.gh,`a/b`.j,'c\\t')");
    }

    @Test
    public void testQuotedIdentifier2() throws Exception {
        String target = "`aci/d_u/ami`";
        String src = "`src/name`";
        this.runStatementOnDriver("drop table if exists " + target);
        this.runStatementOnDriver("drop table if exists " + src);
        this.runStatementOnDriver("create table " + target + "(i int,`d?*de e` decimal(5,2),vc varchar(128)) clustered by (i) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + src + "(`g/h` int, j decimal(5,2), k varchar(128))");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=`g/h`\nwhen matched and `g/h` > 5 then delete \nwhen matched and `g/h` < 0 then update set vc='\u2206\u220b', `d?*de e` =  `d?*de e` * j + 1\nwhen not matched and `d?*de e` <> 0 then insert values(`a/b`.`g/h`,`a/b`.j,`a/b`.k)");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=`g/h`\nwhen matched and `g/h` > 5 then delete\n when matched and `g/h` < 0 then update set vc='\u2206\u220b'  , `d?*de e` =  `d?*de e` * j + 1  \n when not matched and `d?*de e` <> 0 then insert values(`a/b`.`g/h`,`a/b`.j,`a/b`.k)");
    }

    @Test
    public void testMergeType2SCD01() throws Exception {
        this.runStatementOnDriver("drop table if exists target");
        this.runStatementOnDriver("drop table if exists source");
        this.runStatementOnDriver("drop table if exists splitTable");
        this.runStatementOnDriver("create table splitTable(op int)");
        this.runStatementOnDriver("insert into splitTable values (0),(1)");
        this.runStatementOnDriver("create table source (key int, data int)");
        this.runStatementOnDriver("create table target (key int, data int, cur int) clustered by (key) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        int[][] targetVals = new int[][]{{1, 5, 1}, {2, 6, 1}, {1, 18, 0}};
        this.runStatementOnDriver("insert into target " + TestTxnCommands.makeValuesClause(targetVals));
        int[][] sourceVals = new int[][]{{1, 7}, {3, 8}};
        this.runStatementOnDriver("insert into source " + TestTxnCommands.makeValuesClause(sourceVals));
        String curMatch = "select s.*, case when t.cur is null then 0 else 1 end m from source s left outer join (select * from target where target.cur=1) t on s.key=t.key";
        String teeCurMatch = "select curMatch.*, case when splitTable.op is null or splitTable.op = 0 then 0 else 1 end `o/p\\n` from (" + curMatch + ") curMatch left outer join splitTable on curMatch.m=1";
        String stmt = "merge into target t using (" + teeCurMatch + ") s on t.key=s.key and t.cur=1 and s.`o/p\\n`=1 when matched then update set cur=0 when not matched then insert values(s.key,s.data,1)";
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STRICT_CHECKS_CARTESIAN, false);
        this.runStatementOnDriver(stmt);
        int[][] resultVals = new int[][]{{1, 5, 0}, {1, 7, 1}, {1, 18, 0}, {2, 6, 1}, {3, 8, 1}};
        List<String> r = this.runStatementOnDriver("select * from target order by key,data,cur");
        Assert.assertEquals(TestTxnCommands.stringifyValues(resultVals), r);
    }

    @Test
    public void testMergeType2SCD02() throws Exception {
        this.runStatementOnDriver("drop table if exists target");
        this.runStatementOnDriver("drop table if exists source");
        this.runStatementOnDriver("create table source (key int, data int)");
        this.runStatementOnDriver("create table target (key int, data int, cur int) clustered by (key) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        int[][] targetVals = new int[][]{{1, 5, 1}, {2, 6, 1}, {1, 18, 0}};
        this.runStatementOnDriver("insert into target " + TestTxnCommands.makeValuesClause(targetVals));
        int[][] sourceVals = new int[][]{{1, 7}, {3, 8}};
        this.runStatementOnDriver("insert into source " + TestTxnCommands.makeValuesClause(sourceVals));
        String baseSrc = "select source.*, 0 c from source union all select source.*, 1 c from source inner join target on source.key=target.key where target.cur=1";
        String stmt = "merge into target t using (" + baseSrc + ") s on t.key=s.key and t.cur=s.c and t.cur=1 when matched then update set cur=0 when not matched then insert values(s.key,s.data,1)";
        this.runStatementOnDriver(stmt);
        int[][] resultVals = new int[][]{{1, 5, 0}, {1, 7, 1}, {1, 18, 0}, {2, 6, 1}, {3, 8, 1}};
        List<String> r = this.runStatementOnDriver("select * from target order by key,data,cur");
        Assert.assertEquals(TestTxnCommands.stringifyValues(resultVals), r);
    }

    @Test
    public void testMergeOnTezEdges() throws Exception {
        String query = "merge into " + TxnCommandsBaseForTests.Table.ACIDTBL + " as t using " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " s ON t.a = s.a WHEN MATCHED AND s.a > 8 THEN DELETE WHEN MATCHED THEN UPDATE SET b = 7 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.d.destroy();
        HiveConf hc = new HiveConf(this.hiveConf);
        hc.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "tez");
        hc.setBoolVar(HiveConf.ConfVars.HIVE_EXPLAIN_USER, false);
        this.d = new Driver(hc);
        this.d.setMaxRows(10000);
        List<String> explain = this.runStatementOnDriver("explain " + query);
        StringBuilder sb = new StringBuilder();
        for (String s : explain) {
            sb.append(s).append('\n');
        }
        LOG.info("Explain1: " + sb);
        for (int i = 0; i < explain.size(); ++i) {
            if (!explain.get(i).contains("Edges:")) continue;
            Assert.assertTrue((String)("At i+1=" + (i + 1) + explain.get(i + 1)), (boolean)explain.get(i + 1).contains("Reducer 2 <- Map 1 (SIMPLE_EDGE), Map 8 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 2) + explain.get(i + 2)), (boolean)explain.get(i + 2).contains("Reducer 3 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 3) + explain.get(i + 3)), (boolean)explain.get(i + 3).contains("Reducer 4 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 4) + explain.get(i + 4)), (boolean)explain.get(i + 4).contains("Reducer 5 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 5) + explain.get(i + 5)), (boolean)explain.get(i + 5).contains("Reducer 6 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 6) + explain.get(i + 6)), (boolean)explain.get(i + 6).contains("Reducer 7 <- Reducer 2 (SIMPLE_EDGE)"));
            break;
        }
    }

    @Test
    public void testMergeUpdateDelete() throws Exception {
        int[][] baseValsOdd = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " " + TestTxnCommands.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " " + TestTxnCommands.makeValuesClause(vals));
        String query = "merge into " + TxnCommandsBaseForTests.Table.ACIDTBL + " as t using " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " s ON t.a = s.a WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN MATCHED and t.a > 3 and t.a < 5 THEN DELETE WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        int[][] rExpected = new int[][]{{2, 0}, {5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeUpdateDeleteNoCardCheck() throws Exception {
        this.d.destroy();
        HiveConf hc = new HiveConf(this.hiveConf);
        hc.setBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK, false);
        this.d = new Driver(hc);
        this.d.setMaxRows(10000);
        int[][] baseValsOdd = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " " + TestTxnCommands.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " " + TestTxnCommands.makeValuesClause(vals));
        String query = "merge into " + TxnCommandsBaseForTests.Table.ACIDTBL + " as t using " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " s ON t.a = s.a WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN MATCHED and t.a > 3 and t.a < 5 THEN DELETE ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        int[][] rExpected = new int[][]{{2, 0}, {5, 6}, {7, 8}};
        Assert.assertEquals(TestTxnCommands.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeDeleteUpdate() throws Exception {
        int[][] sourceVals = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " " + TestTxnCommands.makeValuesClause(sourceVals));
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " " + TestTxnCommands.makeValuesClause(targetVals));
        String query = "merge into " + TxnCommandsBaseForTests.Table.ACIDTBL + " as t using " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a,b");
        int[][] rExpected = new int[][]{{5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeCardinalityViolation() throws Exception {
        int[][] sourceVals = new int[][]{{2, 2}, {2, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " " + TestTxnCommands.makeValuesClause(sourceVals));
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " " + TestTxnCommands.makeValuesClause(targetVals));
        String query = "merge into " + TxnCommandsBaseForTests.Table.ACIDTBL + " as t using " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriverNegative(query);
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1'),(4,4,'p2')");
        query = "merge into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " as t using " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b, 'p1') ";
        this.runStatementOnDriverNegative(query);
    }

    @Test
    public void testSetClauseFakeColumn() throws Exception {
        CommandProcessorException e1 = this.runStatementOnDriverNegative("MERGE INTO " + TxnCommandsBaseForTests.Table.ACIDTBL + " target\nUSING " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + "\n source ON target.a = source.a\nWHEN MATCHED THEN UPDATE set t = 1");
        Assert.assertEquals((Object)ErrorMsg.INVALID_TARGET_COLUMN_IN_SET_CLAUSE, (Object)((HiveException)e1.getCause()).getCanonicalErrorMsg());
        CommandProcessorException e2 = this.runStatementOnDriverNegative("update " + TxnCommandsBaseForTests.Table.ACIDTBL + " set t = 1");
        Assert.assertEquals((Object)ErrorMsg.INVALID_TARGET_COLUMN_IN_SET_CLAUSE, (Object)((HiveException)e2.getCause()).getCanonicalErrorMsg());
    }

    @Test
    public void testBadOnClause() throws Exception {
        CommandProcessorException e = this.runStatementOnDriverNegative("merge into " + TxnCommandsBaseForTests.Table.ACIDTBL + " trgt\nusing (select *\n       from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " src) sub on sub.a = target.a\nwhen not matched then insert values (sub.a,sub.b)");
        Assert.assertTrue((String)("Error didn't match: " + e), (boolean)e.getMessage().contains("No columns from target table 'trgt' found in ON clause '`sub`.`a` = `target`.`a`' of MERGE statement."));
    }

    @Test
    public void testCompactionBlocking() throws Exception {
        Timer cancelCompact = new Timer("CancelCompactionTimer", false);
        final Thread threadToInterrupt = Thread.currentThread();
        cancelCompact.schedule(new TimerTask(){

            @Override
            public void run() {
                threadToInterrupt.interrupt();
            }
        }, 5000L);
        long start = System.currentTimeMillis();
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBL + " compact 'major' AND WAIT");
        Assert.assertTrue((System.currentTimeMillis() > start + 2L ? 1 : 0) != 0);
    }

    @Test
    public void testMergeCase() throws Exception {
        this.runStatementOnDriver("create table merge_test (c1 integer, c2 integer, c3 integer) CLUSTERED BY (c1) into 2 buckets stored as orc tblproperties(\"transactional\"=\"true\")");
        this.runStatementOnDriver("create table if not exists e011_02 (c1 float, c2 double, c3 float)");
        this.runStatementOnDriver("merge into merge_test using e011_02 on (merge_test.c1 = e011_02.c1) when not matched then insert values (case when e011_02.c1 > 0 then e011_02.c1 + 1 else e011_02.c1 end, e011_02.c2 + e011_02.c3, coalesce(e011_02.c3, 1))");
    }

    @Test
    public void testNonAcidToAcidConversion01() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + "(a,b) values(0,12),(1,5)");
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " SET TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + "(a,b) values(1,17)");
        String query = "select ROW__ID, a, b, INPUT__FILE__NAME from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " order by ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":0}\t1\t2", "nonacidorctbl/000001_0"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":1}\t0\t12", "nonacidorctbl/000001_0_copy_1"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":2}\t1\t5", "nonacidorctbl/000001_0_copy_1"}, {"{\"writeid\":10000001,\"bucketid\":536936448,\"rowid\":0}\t1\t17", "nonacidorctbl/delta_10000001_10000001_0000/bucket_00001_0"}};
        this.checkResultAndVectorization(expected, query, "before compact", LOG);
        Assert.assertEquals((long)0x20000000L, (long)BucketCodec.V1.encode(new AcidOutputFormat.Options((Configuration)this.hiveConf).bucket(0)));
        Assert.assertEquals((long)0x20010000L, (long)BucketCodec.V1.encode(new AcidOutputFormat.Options((Configuration)this.hiveConf).bucket(1)));
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " compact 'major'");
        TestTxnCommands.runWorker(this.hiveConf);
        query = "select ROW__ID, a, b, INPUT__FILE__NAME from " + TxnCommandsBaseForTests.Table.NONACIDORCTBL + " order by ROW__ID";
        String[][] expected2 = new String[][]{{"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":0}\t1\t2", "nonacidorctbl/base_10000001_v0000009/bucket_00001"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":1}\t0\t12", "nonacidorctbl/base_10000001_v0000009/bucket_00001"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":2}\t1\t5", "nonacidorctbl/base_10000001_v0000009/bucket_00001"}, {"{\"writeid\":10000001,\"bucketid\":536936448,\"rowid\":0}\t1\t17", "nonacidorctbl/base_10000001_v0000009/bucket_00001"}};
        this.checkResultAndVectorization(expected2, query, "after major compact", LOG);
    }

    @Test
    public void testMoreBucketsThanReducers() throws Exception {
        this.d.destroy();
        HiveConf hc = new HiveConf(this.hiveConf);
        hc.setIntVar(HiveConf.ConfVars.MAX_REDUCERS, 1);
        hc.setIntVar(HiveConf.ConfVars.HADOOP_NUM_REDUCERS, 1);
        hc.setBoolVar(HiveConf.ConfVars.HIVE_EXPLAIN_USER, false);
        this.d = new Driver(hc);
        this.d.setMaxRows(10000);
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(1,1)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(0,0),(3,3)");
        this.runStatementOnDriver("update " + TxnCommandsBaseForTests.Table.ACIDTBL + " set b = -1");
        List<String> r = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a, b");
        int[][] expected = new int[][]{{0, -1}, {1, -1}, {3, -1}};
        Assert.assertEquals(TestTxnCommands.stringifyValues(expected), r);
    }

    @Ignore(value="Moved to Tez")
    @Test
    public void testMoreBucketsThanReducers2() throws Exception {
        this.d.destroy();
        HiveConf hc = new HiveConf(this.hiveConf);
        hc.setIntVar(HiveConf.ConfVars.MAX_REDUCERS, 2);
        hc.setIntVar(HiveConf.ConfVars.HADOOP_NUM_REDUCERS, 2);
        this.d = new Driver(hc);
        this.d.setMaxRows(10000);
        this.runStatementOnDriver("create table fourbuckets (a int, b int) clustered by (a) into 4 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into fourbuckets values(0,1),(1,1)");
        this.runStatementOnDriver("insert into fourbuckets values(2,2),(3,2)");
        this.runStatementOnDriver("insert into fourbuckets values(0,3),(1,3)");
        this.runStatementOnDriver("insert into fourbuckets values(2,4),(3,4)");
        this.runStatementOnDriver("update fourbuckets set b = -1");
        List<String> r = this.runStatementOnDriver("select * from fourbuckets order by a, b");
        int[][] expected = new int[][]{{0, -1}, {0, -1}, {1, -1}, {1, -1}, {2, -1}, {2, -1}, {3, -1}, {3, -1}};
        Assert.assertEquals(TestTxnCommands.stringifyValues(expected), r);
    }

    @Test
    public void testVersioningVersionFileEnabled() throws Exception {
        this.acidVersionTest(true);
    }

    @Test
    public void testVersioningVersionFileDisabled() throws Exception {
        this.acidVersionTest(false);
    }

    private void acidVersionTest(boolean enableVersionFile) throws Exception {
        boolean originalEnableVersionFile = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_WRITE_ACID_VERSION_FILE);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_WRITE_ACID_VERSION_FILE, enableVersionFile);
        this.hiveConf.set(MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID.getVarname(), "true");
        Hive.closeCurrent();
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc");
        int[][] data = new int[][]{{1, 2}};
        this.runStatementOnDriver("insert into T" + TestTxnCommands.makeValuesClause(data));
        this.runStatementOnDriver("update T set a=3 where b=2");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        RemoteIterator files = fs.listFiles(new Path(this.getWarehouseDir(), "t"), true);
        CompactorTestUtilities.checkAcidVersion((RemoteIterator<LocatedFileStatus>)files, fs, enableVersionFile, new String[]{"delta_", "delete_delta_"});
        this.runStatementOnDriver("alter table T compact 'minor'");
        TestTxnCommands.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getType().equals((Object)CompactionType.MINOR));
        files = fs.listFiles(new Path(this.getWarehouseDir(), "t"), true);
        CompactorTestUtilities.checkAcidVersion((RemoteIterator<LocatedFileStatus>)files, fs, enableVersionFile, new String[]{"delta_", "delete_delta_"});
        this.runStatementOnDriver("insert into T" + TestTxnCommands.makeValuesClause(data));
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands.runWorker(this.hiveConf);
        txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)2L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 1 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(1)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(1)).getHadoopJobId().startsWith("job_local"));
        files = fs.listFiles(new Path(this.getWarehouseDir(), "t"), true);
        CompactorTestUtilities.checkAcidVersion((RemoteIterator<LocatedFileStatus>)files, fs, enableVersionFile, new String[]{"delta_", "delete_delta_", "base_"});
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_WRITE_ACID_VERSION_FILE, originalEnableVersionFile);
    }

    @Test
    public void testTruncateWithBase() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_TRUNCATE_USE_BASE, (boolean)true);
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(1,2),(3,4)");
        this.runStatementOnDriver("truncate table " + TxnCommandsBaseForTests.Table.ACIDTBL);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBL.toString().toLowerCase()), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000002", (Object)name);
        List<String> r = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBL);
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    public void testTruncateWithBaseAllPartition() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_TRUNCATE_USE_BASE, (boolean)true);
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p='a') values(1,2),(3,4)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p='b') values(1,2),(3,4)");
        this.runStatementOnDriver("truncate table " + TxnCommandsBaseForTests.Table.ACIDTBLPART);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=a"), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000003", (Object)name);
        List<String> r = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBLPART);
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    public void testTruncateWithBaseOnePartition() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_TRUNCATE_USE_BASE, (boolean)true);
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p='a') values(1,2),(3,4)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p='b') values(5,5),(4,4)");
        this.runStatementOnDriver("truncate table " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p='b')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=b"), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000003", (Object)name);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=a"), AcidUtils.deltaFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 delta and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        List<String> r = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBLPART);
        Assert.assertEquals((long)2L, (long)r.size());
    }

    @Test
    public void testDropWithBaseAndRecreateOnePartition() throws Exception {
        this.dropWithBaseOnePartition(true);
    }

    @Test
    public void testDropWithBaseOnePartition() throws Exception {
        this.dropWithBaseOnePartition(false);
    }

    private void dropWithBaseOnePartition(boolean reCreate) throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition (p='a') values (1,2),(3,4)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition (p='b') values (5,5),(4,4)");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_DROP_PARTITION_USE_BASE, (boolean)true);
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " drop partition (p='b')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=b"), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000003", (Object)name);
        List<String> r = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBLPART);
        Assert.assertEquals((long)2L, (long)r.size());
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(r, Arrays.asList("1\t2\ta", "3\t4\ta")));
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertTrue((boolean)resp.getCompacts().stream().anyMatch(ci -> "ready for cleaning".equals(ci.getState()) && "p=b".equals(ci.getPartitionname())));
        if (reCreate) {
            this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition (p='b') values (3,3)");
        }
        TestTxnCommands.runCleaner(this.hiveConf);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase()), path -> path.getName().equals("p=b"));
        if ((reCreate ? 1 : 0) != stat.length) {
            Assert.fail((String)("Partition data was " + (reCreate ? "" : "not") + " removed from FS"));
        }
        if (reCreate) {
            r = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBLPART);
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(r, Arrays.asList("1\t2\ta", "3\t4\ta", "3\t3\tb")));
        }
    }

    @Test
    public void testDropWithBaseMultiplePartitions() throws Exception {
        Object[] stat;
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART + " partition (p1='a', p2='a', p3='a') values (1,1),(2,2)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART + " partition (p1='a', p2='a', p3='b') values (3,3),(4,4)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART + " partition (p1='a', p2='b', p3='c') values (7,7),(8,8)");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_DROP_PARTITION_USE_BASE, (boolean)true);
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART + " drop partition (p2='a')");
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)2L, (long)resp.getCompactsSize());
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        for (char p : Arrays.asList(Character.valueOf('a'), Character.valueOf('b'))) {
            String partName = "p1=a/p2=a/p3=" + p;
            Assert.assertTrue((boolean)resp.getCompacts().stream().anyMatch(ci -> "ready for cleaning".equals(ci.getState()) && partName.equals(ci.getPartitionname())));
            stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART.toString().toLowerCase() + "/" + partName), AcidUtils.baseFileFilter);
            if (1 != stat.length) {
                Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
            }
            String name = stat[0].getPath().getName();
            Assert.assertEquals((Object)"base_0000004", (Object)name);
        }
        stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART.toString().toLowerCase() + "/p1=a/p2=b/p3=c"), AcidUtils.baseFileFilter);
        if (0 != stat.length) {
            Assert.fail((String)("Expecting no base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        List<String> r = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART);
        Assert.assertEquals((long)2L, (long)r.size());
        TestTxnCommands.runCleaner(this.hiveConf);
        for (char p : Arrays.asList(Character.valueOf('a'), Character.valueOf('b'))) {
            stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART.toString().toLowerCase() + "/p1=a/p2=a"), path -> path.getName().equals("p3=" + p));
            if (0 == stat.length) continue;
            Assert.fail((String)"Partition data was not removed from FS");
        }
    }

    @Test
    public void testDropDatabaseCascadePerTableNonBlocking() throws Exception {
        MetastoreConf.setLongVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX, (long)1L);
        this.dropDatabaseCascadeNonBlocking();
    }

    @Test
    public void testDropDatabaseCascadePerDbNonBlocking() throws Exception {
        this.dropDatabaseCascadeNonBlocking();
    }

    @Test
    public void testDropDatabaseCascadePerDbNonBlockingFilterTableNames() throws Exception {
        DummyMetaStoreFilterHookImpl.blockResults = true;
        this.dropDatabaseCascadeNonBlocking();
    }

    private void dropDatabaseCascadeNonBlocking() throws Exception {
        String database = "mydb";
        String tableName = "tab_acid";
        this.runStatementOnDriver("drop database if exists " + database + " cascade");
        this.runStatementOnDriver("create database " + database);
        this.runStatementOnDriver("create table " + database + "." + tableName + "1 (a int, b int) partitioned by (ds string) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into " + database + "." + tableName + "1 partition(ds) values(1,2,'foo'),(3,4,'bar')");
        this.runStatementOnDriver("create materialized view " + database + ".mv_" + tableName + "1 partitioned on (ds) stored as orc TBLPROPERTIES ('transactional'='true')as select a, ds from " + database + "." + tableName + "1 where b > 1");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED, (boolean)true);
        this.runStatementOnDriver("create table " + database + "." + tableName + "2 (a int, b int) partitioned by (ds string) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into " + database + "." + tableName + "2 partition(ds) values(1,2,'foo'),(3,4,'bar')");
        this.runStatementOnDriver("create materialized view " + database + ".mv_" + tableName + "2 partitioned on (ds) stored as orc TBLPROPERTIES ('transactional'='true')as select a, ds from " + database + "." + tableName + "2 where b > 1");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(0,2),(0,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/2'");
        this.runStatementOnDriver("create external table " + database + ".tab_ext (a int, b int) partitioned by (ds string) stored as parquet");
        this.runStatementOnDriver("insert into " + database + ".tab_ext partition(ds) values(1,2,'foo'),(3,4,'bar')");
        this.runStatementOnDriver("alter table " + database + ".tab_ext add partition (ds='baz') location '" + this.getWarehouseDir() + "/1/data'");
        this.runStatementOnDriver("create table " + database + ".tab_nonacid (a int, b int) partitioned by (ds string) stored as parquet");
        this.runStatementOnDriver("insert into " + database + ".tab_nonacid partition(ds) values(1,2,'foo'),(3,4,'bar')");
        this.runStatementOnDriver("alter table " + database + ".tab_nonacid add partition (ds='baz') location '" + this.getWarehouseDir() + "/2/data'");
        this.runStatementOnDriver("drop database " + database + " cascade");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] stat = fs.listStatus(new Path(this.getWarehouseDir(), database + ".db"), t -> t.getName().matches("(mv_)?" + tableName + "2\\.v\\d+"));
        if (2 != stat.length) {
            Assert.fail((String)"Table data was removed from FS");
        }
        stat = fs.listStatus(new Path(this.getWarehouseDir(), database + ".db"));
        Assert.assertEquals((long)2L, (long)stat.length);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), "ext"));
        Assert.assertEquals((long)0L, (long)stat.length);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), "1"), t -> t.getName().equals("data"));
        Assert.assertEquals((long)1L, (long)stat.length);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), "2"), t -> t.getName().equals("data"));
        Assert.assertEquals((long)0L, (long)stat.length);
        TestTxnCommands.runCleaner(this.hiveConf);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), database + ".db"), t -> t.getName().matches("(mv_)?" + tableName + "2\\.v\\d+"));
        if (stat.length != 0) {
            Assert.fail((String)"Table data was not removed from FS");
        }
    }

    @Test
    public void testDropTableWithSuffix() throws Exception {
        String tableName = "tab_acid";
        this.runStatementOnDriver("drop table if exists " + tableName);
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX, (boolean)true);
        this.runStatementOnDriver("create table " + tableName + "(a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into " + tableName + " values(1,2),(3,4)");
        this.runStatementOnDriver("drop table " + tableName);
        int count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID where T2W_TABLE = '" + tableName + "'"));
        Assert.assertEquals((long)1L, (long)count);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] stat = fs.listStatus(new Path(this.getWarehouseDir()), t -> t.getName().matches(tableName + "\\.v\\d+"));
        if (1 != stat.length) {
            Assert.fail((String)"Table data was removed from FS");
        }
        AcidHouseKeeperService houseKeeperService = new AcidHouseKeeperService();
        houseKeeperService.setConf((Configuration)this.hiveConf);
        houseKeeperService.run();
        count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID where T2W_TABLE = '" + tableName + "'"));
        Assert.assertEquals((long)0L, (long)count);
        try {
            this.runStatementOnDriver("select * from " + tableName);
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains(ErrorMsg.INVALID_TABLE.getMsg(StringUtils.wrap((String)tableName, (String)"'"))));
        }
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        TestTxnCommands.runCleaner(this.hiveConf);
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir()), t -> t.getName().matches(tableName + "\\.v\\d+"));
        Assert.assertEquals((long)0L, (long)status.length);
    }

    @Test
    public void testDropTableWithoutSuffix() throws Exception {
        String tableName = "tab_acid";
        this.runStatementOnDriver("drop table if exists " + tableName);
        for (boolean enabled : Arrays.asList(false, true)) {
            HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX, (boolean)enabled);
            this.runStatementOnDriver("create table " + tableName + "(a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
            this.runStatementOnDriver("insert into " + tableName + " values(1,2),(3,4)");
            HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX, (!enabled ? 1 : 0) != 0);
            this.runStatementOnDriver("drop table " + tableName);
            int count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID where T2W_TABLE = '" + tableName + "'"));
            Assert.assertEquals((long)0L, (long)count);
            FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
            FileStatus[] stat = fs.listStatus(new Path(this.getWarehouseDir()), t -> t.getName().equals(tableName));
            Assert.assertEquals((long)0L, (long)stat.length);
            try {
                this.runStatementOnDriver("select * from " + tableName);
            }
            catch (Exception ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains(ErrorMsg.INVALID_TABLE.getMsg(StringUtils.wrap((String)tableName, (String)"'"))));
            }
            TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
            ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
            Assert.assertEquals((String)"Unexpected number of compactions in history", (long)0L, (long)resp.getCompactsSize());
        }
    }

    @Test
    public void testDropMaterializedViewWithSuffix() throws Exception {
        String tableName = "tab_acid";
        String mviewName = "mv_" + tableName;
        this.runStatementOnDriver("drop materialized view if exists " + mviewName);
        this.runStatementOnDriver("drop table if exists " + tableName);
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX, (boolean)true);
        this.runStatementOnDriver("create table " + tableName + "(a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into " + tableName + " values(1,2),(3,4)");
        this.runStatementOnDriver("create materialized view " + mviewName + " stored as orc TBLPROPERTIES ('transactional'='true') as select a from tab_acid where b > 1");
        this.runStatementOnDriver("drop materialized view " + mviewName);
        int count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID where T2W_TABLE = '" + mviewName + "'"));
        Assert.assertEquals((long)1L, (long)count);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] stat = fs.listStatus(new Path(this.getWarehouseDir()), t -> t.getName().matches(mviewName + "\\.v\\d+"));
        if (1 != stat.length) {
            Assert.fail((String)"Materialized view data was removed from FS");
        }
        AcidHouseKeeperService houseKeeperService = new AcidHouseKeeperService();
        houseKeeperService.setConf((Configuration)this.hiveConf);
        houseKeeperService.run();
        count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID where T2W_TABLE = '" + mviewName + "'"));
        Assert.assertEquals((long)0L, (long)count);
        try {
            this.runStatementOnDriver("select * from " + mviewName);
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains(ErrorMsg.INVALID_TABLE.getMsg(StringUtils.wrap((String)mviewName, (String)"'"))));
        }
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        TestTxnCommands.runCleaner(this.hiveConf);
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir()), t -> t.getName().matches(mviewName + "\\.v\\d+"));
        Assert.assertEquals((long)0L, (long)status.length);
    }

    @Test
    public void testDropMaterializedViewWithoutSuffix() throws Exception {
        String tableName = "tab_acid";
        String mviewName = "mv_" + tableName;
        this.runStatementOnDriver("drop materialized view if exists " + mviewName);
        for (boolean enabled : Arrays.asList(false, true)) {
            this.runStatementOnDriver("drop table if exists " + tableName);
            HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX, (boolean)enabled);
            this.runStatementOnDriver("create table " + tableName + "(a int, b int) stored as orc TBLPROPERTIES ('transactional'='true')");
            this.runStatementOnDriver("insert into " + tableName + " values(1,2),(3,4)");
            this.runStatementOnDriver("create materialized view " + mviewName + " stored as orc TBLPROPERTIES ('transactional'='true') as select a from tab_acid where b > 1");
            HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX, (!enabled ? 1 : 0) != 0);
            this.runStatementOnDriver("drop materialized view " + mviewName);
            int count = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_TO_WRITE_ID where T2W_TABLE = '" + mviewName + "'"));
            Assert.assertEquals((long)0L, (long)count);
            FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
            FileStatus[] stat = fs.listStatus(new Path(this.getWarehouseDir()), t -> t.getName().equals(mviewName));
            Assert.assertEquals((long)0L, (long)stat.length);
            try {
                this.runStatementOnDriver("select * from " + mviewName);
            }
            catch (Exception ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains(ErrorMsg.INVALID_TABLE.getMsg(StringUtils.wrap((String)mviewName, (String)"'"))));
            }
            TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
            ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
            Assert.assertEquals((String)"Unexpected number of compactions in history", (long)0L, (long)resp.getCompactsSize());
        }
    }

    @Test
    public void testRenameMakeCopyPartition() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition (p='a') values (1,2),(3,4)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition (p='b') values (5,5),(4,4)");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_RENAME_PARTITION_MAKE_COPY, (boolean)true);
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition (p='b') rename to partition (p='c')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=b"), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000003", (Object)name);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=a"), AcidUtils.baseFileFilter);
        if (0 != stat.length) {
            Assert.fail((String)("Expecting no base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        List<String> r = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " where p='b'");
        Assert.assertEquals((long)0L, (long)r.size());
        r = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBLPART);
        Assert.assertEquals((long)4L, (long)r.size());
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertTrue((boolean)resp.getCompacts().stream().anyMatch(ci -> "ready for cleaning".equals(ci.getState()) && "p=b".equals(ci.getPartitionname())));
        TestTxnCommands.runCleaner(this.hiveConf);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase()), path -> path.getName().equals("p=b"));
        if (0 != stat.length) {
            Assert.fail((String)"Expecting partition data to be removed from FS");
        }
    }

    @Test
    public void testRenameMakeCopyNestedPartition() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART + " partition (p1='a', p2='b', p3='c') values (1,1),(2,2)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART + " partition (p1='a', p2='b', p3='d') values (3,3),(4,4)");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_RENAME_PARTITION_MAKE_COPY, (boolean)true);
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART + " partition (p1='a', p2='b', p3='d') rename to partition (p1='a', p2='c', p3='d')");
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        String partName = "p1=a/p2=b/p3=d";
        Assert.assertTrue((boolean)resp.getCompacts().stream().anyMatch(ci -> "ready for cleaning".equals(ci.getState()) && partName.equals(ci.getPartitionname())));
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART.toString().toLowerCase() + "/" + partName), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000003", (Object)name);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART.toString().toLowerCase() + "/p1=a/p2=c/p3=d"), AcidUtils.baseFileFilter);
        if (0 != stat.length) {
            Assert.fail((String)("Expecting no base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        List<String> r = this.runStatementOnDriver("select * from " + TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART);
        Assert.assertEquals((long)4L, (long)r.size());
        TestTxnCommands.runCleaner(this.hiveConf);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLNESTEDPART.toString().toLowerCase() + "/p1=a/p2=b"), path -> path.getName().equals("p3=d"));
        if (0 != stat.length) {
            Assert.fail((String)"Expecting partition data to be removed from FS");
        }
    }

    @Test
    public void testIsRawFormatFile() throws Exception {
        this.dropTables("file_formats");
        this.runStatementOnDriver("CREATE TABLE `file_formats`(`id` int, `name` string)  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe' WITH SERDEPROPERTIES (  'field.delim'='|',  'line.delim'='\n', 'serialization.format'='|')  STORED AS  INPUTFORMAT    'org.apache.hadoop.mapred.TextInputFormat'  OUTPUTFORMAT    'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat' TBLPROPERTIES (  'transactional'='true', 'transactional_properties'='insert_only')");
        this.runStatementOnDriver("insert into file_formats (id, name) values (1, 'Avro'),(2, 'Parquet'),(3, 'ORC')");
        List<String> res = this.runStatementOnDriver("select * from file_formats");
        Assert.assertEquals((long)3L, (long)res.size());
    }

    @Test
    public void testShowCompactions() throws Exception {
        int i;
        this.runStatementOnDriver("drop database if exists mydb1 cascade");
        this.runStatementOnDriver("create database mydb1");
        this.runStatementOnDriver("create table mydb1.tbl0 (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(1,2,'p1'),(3,4,'p1'),(1,2,'p2'),(3,4,'p2'),(1,2,'p3'),(3,4,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p1') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p2') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p3') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(4,5,'p1'),(6,7,'p1'),(4,5,'p2'),(6,7,'p2'),(4,5,'p3'),(6,7,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION (p='p1') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION (p='p2') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION (p='p3')  compact 'MAJOR' pool 'pool0'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        SessionState.get().setCurrentDatabase("mydb1");
        ShowCompactResponse rsp = txnHandler.showCompact(new ShowCompactRequest());
        List<String> r = this.runStatementOnDriver("SHOW COMPACTIONS");
        Assert.assertEquals((long)(rsp.getCompacts().size() + 1), (long)r.size());
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb1 STATUS 'ready for cleaning'");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getState().equals("ready for cleaning")).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        Pattern p = Pattern.compile(".*mydb1.*\tready for cleaning.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS COMPACTIONID=1");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getId() == 1L).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile("1\t.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb1 TYPE 'MAJOR' ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb1")).filter(x -> x.getType().equals((Object)CompactionType.MAJOR)).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*mydb1.*\tMAJOR.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb1 POOL 'poolx' TYPE 'MINOR' ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb1")).filter(x -> x.getPoolName().equals("poolx")).filter(x -> x.getType().equals((Object)CompactionType.MAJOR)).count() + 1L), (long)r.size());
        Assert.assertEquals((long)1L, (long)r.size());
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb1 POOL 'pool0' TYPE 'MAJOR'");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb1")).filter(x -> x.getPoolName().equals("pool0")).filter(x -> x.getType().equals((Object)CompactionType.MAJOR)).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*mydb1.*\tMAJOR.*\tpool0.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb1 POOL 'pool0'");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb1")).filter(x -> x.getPoolName().equals("pool0")).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*mydb1.*\tpool0.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS DATABASE mydb1 POOL 'pool0'");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb1")).filter(x -> x.getPoolName().equals("pool0")).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*mydb1.*\tpool0.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i).toString()).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS tbl0 TYPE 'MAJOR' ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getTablename().equals("tbl0")).filter(x -> x.getType().equals((Object)CompactionType.MAJOR)).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*tbl0.*\tMAJOR.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS mydb1.tbl0 PARTITION (p='p3') ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb1")).filter(x -> x.getTablename().equals("tbl0")).filter(x -> x.getPartitionname().equals("p=p3")).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*mydb1\ttbl0\tp=p3.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS mydb1.tbl0 PARTITION (p='p3') pool 'pool0' TYPE 'MAJOR'");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb1")).filter(x -> x.getTablename().equals("tbl0")).filter(x -> x.getPartitionname().equals("p=p3")).filter(x -> x.getPoolName().equals("pool0")).filter(x -> x.getType().equals((Object)CompactionType.MAJOR)).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*mydb1\ttbl0\tp=p3\tMAJOR.*\tpool0.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
    }

    @Test
    public void testShowCompactionFilterWithPartition() throws Exception {
        int i;
        this.setUpCompactionRequestsData("mydb", "tbl2");
        this.executeCompactionRequest("mydb", "tbl2", "MAJOR", "ds='mon'");
        SessionState.get().setCurrentDatabase("mydb");
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List<String> r = this.runStatementOnDriver("SHOW COMPACTIONS");
        Assert.assertEquals((long)(rsp.getCompacts().size() + 1), (long)r.size());
        r = this.runStatementOnDriver("SHOW COMPACTIONS tbl2 STATUS 'refused'");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getState().equals("refused")).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        Pattern p = Pattern.compile(".*tbl2.*\trefused.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS tbl2 ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getTablename().equals("tbl2")).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*tbl2.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS mydb.tbl2 PARTITION (ds='mon') ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb")).filter(x -> x.getTablename().equals("tbl2")).filter(x -> x.getPartitionname().equals("ds=mon")).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*mydb\ttbl2\tds=mon.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS mydb.tbl2 PARTITION (ds='mon') TYPE 'MAJOR' ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb")).filter(x -> x.getTablename().equals("tbl2")).filter(x -> x.getPartitionname().equals("ds=mon")).filter(x -> x.getType().equals((Object)CompactionType.MAJOR)).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*mydb\ttbl2\tds=mon\tMAJOR.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS DATABASE mydb TYPE 'MAJOR' ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb")).filter(x -> x.getType().equals((Object)CompactionType.MAJOR)).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*mydb.*\tMAJOR.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        this.executeCompactionRequest("mydb", "tbl2", "MINOR", "ds='wed'");
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb TYPE 'MINOR' ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb")).filter(x -> x.getType().equals((Object)CompactionType.MINOR)).count() + 1L), (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        p = Pattern.compile(".*mydb.*\tMINOR.*");
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS  mydb.tbl2 PARTITION (ds='wed') ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mydb")).filter(x -> x.getTablename().equals("tbl2")).filter(x -> x.getPartitionname().equals("ds=wed")).count() + 1L), (long)r.size());
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)r.get(i).contains("mydb"));
            Assert.assertTrue((boolean)r.get(i).contains("tbl2"));
            Assert.assertTrue((boolean)r.get(i).contains("ds=wed"));
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS tbl2 ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getTablename().equalsIgnoreCase("tbl2")).count() + 1L), (long)r.size());
        for (i = 1; i < r.size(); ++i) {
            Assert.assertTrue((boolean)r.get(i).contains("tbl2"));
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mymydbdb2 TYPE 'MAJOR' ");
        Assert.assertEquals((long)(rsp.getCompacts().stream().filter(x -> x.getDbname().equals("mymydbdb2")).filter(x -> x.getType().equals((Object)CompactionType.MAJOR)).count() + 1L), (long)r.size());
        Assert.assertEquals((long)1L, (long)r.size());
    }

    @Test
    public void testShowCompactionInputValidation() throws Exception {
        this.setUpCompactionRequestsData("mydb2", "tbl2");
        this.executeCompactionRequest("mydb2", "tbl2", "MAJOR", "ds='mon'");
        SessionState.get().setCurrentDatabase("mydb2");
        this.expectedException.expect(RuntimeException.class);
        List<String> r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb POOL 'pool0' TYPE 'MAJOR'");
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb2  TYPE 'MAJR'");
        r = this.runStatementOnDriver("SHOW COMPACTIONS mydb2.tbl1 PARTITION (ds='mon') TYPE 'MINOR' STATUS 'ready for clean'");
        r = this.runStatementOnDriver("SHOW COMPACTIONS mydb2.tbl2 PARTITION (p=101,day='Monday') POOL 'pool0' TYPE 'minor' STATUS 'ready for clean'");
        r = this.runStatementOnDriver("SHOW COMPACTIONS mydb1.tbl0 PARTITION (p='p1') POOL 'pool0' TYPE 'minor' STATUS 'ready for clean'");
    }

    @Test
    public void testShowCompactionFilterSortingAndLimit() throws Exception {
        int i;
        this.runStatementOnDriver("drop database if exists mydb1 cascade");
        this.runStatementOnDriver("create database mydb1");
        this.runStatementOnDriver("create table mydb1.tbl0 (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(1,2,'p1'),(3,4,'p1'),(1,2,'p2'),(3,4,'p2'),(1,2,'p3'),(3,4,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p1') compact 'MAJOR' pool 'poolx'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p2') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("drop database if exists mydb cascade");
        this.runStatementOnDriver("create database mydb");
        this.runStatementOnDriver("create table mydb.tbl (a int, b int) partitioned by (ds string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb.tbl PARTITION(ds)  values(1,2,'mon'),(3,4,'tue'),(1,2,'mon'),(3,4,'tue'),(1,2,'wed'),(3,4,'wed')");
        this.runStatementOnDriver("alter table mydb.tbl PARTITION(ds='mon') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb.tbl PARTITION(ds='tue') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("create table mydb.tbl2 (a int, b int) partitioned by (dm string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb.tbl2 PARTITION(dm)  values(1,2,'xxx'),(3,4,'xxx'),(1,2,'yyy'),(3,4,'yyy'),(1,2,'zzz'),(3,4,'zzz')");
        this.runStatementOnDriver("alter table mydb.tbl2 PARTITION(dm='yyy') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb.tbl2 PARTITION(dm='zzz') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List<String> r = this.runStatementOnDriver("SHOW COMPACTIONS");
        Assert.assertEquals((long)(rsp.getCompacts().size() + 1), (long)r.size());
        r = this.runStatementOnDriver("SHOW COMPACTIONS LIMIT 3");
        Assert.assertEquals((long)4L, (long)r.size());
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb TYPE 'MAJOR' LIMIT 2");
        Assert.assertEquals((long)3L, (long)r.size());
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb TYPE 'MAJOR' ORDER BY 'tabname' DESC,'partname' ASC");
        Assert.assertEquals((long)5L, (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        Pattern p = Pattern.compile(".*mydb\ttbl2\tdm.*");
        for (i = 1; i < r.size() - 3; ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        p = Pattern.compile(".*mydb\ttbl\tds.*");
        for (i = 3; i < r.size() - 1; ++i) {
            Assert.assertTrue((boolean)p.matcher(r.get(i)).matches());
        }
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb1 TYPE 'MAJOR' ORDER BY 'poolname' ASC");
        Assert.assertEquals((long)3L, (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        List txnIdActualList = r.stream().skip(1L).map(x -> x.split("\t")[15]).collect(Collectors.toList());
        List txnIdExpectedList = r.stream().skip(1L).map(x -> x.split("\t")[15]).sorted(Collections.reverseOrder()).collect(Collectors.toList());
        Assert.assertEquals(txnIdExpectedList, txnIdActualList);
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb TYPE 'MAJOR' ORDER BY 'txnid' DESC");
        Assert.assertEquals((long)5L, (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        txnIdActualList = r.stream().skip(1L).map(x -> x.split("\t")[16]).collect(Collectors.toList());
        txnIdExpectedList = r.stream().skip(1L).map(x -> x.split("\t")[16]).sorted(Collections.reverseOrder()).collect(Collectors.toList());
        Collections.sort(txnIdExpectedList, Collections.reverseOrder());
        Assert.assertEquals(txnIdExpectedList, txnIdActualList);
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb TYPE 'MAJOR' ORDER BY TxnId DESC");
        Assert.assertEquals((long)5L, (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tDatabase\tTable\tPartition\tType\tState\tWorker host\tWorker\tEnqueue Time\tStart Time\tDuration(ms)\tHadoopJobId\tError message\tInitiator host\tInitiator\tPool name\tTxnId\tNext TxnId\tCommit Time\tHighest WriteId", (Object)r.get(0));
        txnIdActualList = r.stream().skip(1L).map(x -> x.split("\t")[16]).collect(Collectors.toList());
        txnIdExpectedList = r.stream().skip(1L).map(x -> x.split("\t")[16]).sorted(Collections.reverseOrder()).collect(Collectors.toList());
        Assert.assertEquals(txnIdExpectedList, txnIdActualList);
        this.expectedException.expect(RuntimeException.class);
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb TYPE 'MAJOR' ORDER BY tbl DESC,PARTITIONS ASC");
        this.expectedException.expect(RuntimeException.class);
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb TYPE 'MAJOR' ORDER BY tbl DESC,PARTITIONS ASC");
    }

    @Test
    public void testAbortCompactions() throws Exception {
        this.runStatementOnDriver("drop database if exists mydb1 cascade");
        this.runStatementOnDriver("create database mydb1");
        this.runStatementOnDriver("create table mydb1.tbl0 (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(1,2,'p1'),(3,4,'p1'),(1,2,'p2'),(3,4,'p2'),(1,2,'p3'),(3,4,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p1') compact 'MAJOR'");
        TestTxnCommands2.runInitiator(this.hiveConf);
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p2') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION(p='p3') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(4,5,'p1'),(6,7,'p1'),(4,5,'p2'),(6,7,'p2'),(4,5,'p3'),(6,7,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION (p='p1') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION (p='p2') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl0 PARTITION (p='p3')  compact 'MAJOR' pool 'pool0'");
        TestTxnCommands2.runInitiator(this.hiveConf);
        TestTxnCommands2.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        this.runStatementOnDriver("create table mydb1.tbl2 (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb1.tbl2 PARTITION(p)  values(1,2,'p1'),(3,4,'p1'),(1,2,'p2'),(3,4,'p2'),(1,2,'p3'),(3,4,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl2 PARTITION(p='p1') compact 'MAJOR'");
        this.runStatementOnDriver("alter table mydb1.tbl2 PARTITION(p='p2') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("alter table mydb1.tbl2 PARTITION(p='p3') compact 'MAJOR'");
        this.runStatementOnDriver("insert into mydb1.tbl0 PARTITION(p)  values(4,5,'p1'),(6,7,'p1'),(4,5,'p2'),(6,7,'p2'),(4,5,'p3'),(6,7,'p3')");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("insert into mydb1.tbl2 PARTITION(p)  values(11,12,'p1'),(13,14,'p1'),(11,12,'p2'),(13,14,'p2'),(11,12,'p3'),(13,14,'p3')");
        this.runStatementOnDriver("alter table mydb1.tbl2 PARTITION (p='p1')  compact 'MINOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("create table mydb1.tbl3 (a int, b int) partitioned by (ds string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into mydb1.tbl3 PARTITION(ds)  values(1,2,'today'),(3,4,'today'),(1,2,'tomorrow'),(3,4,'tomorrow'),(1,2,'yesterday'),(3,4,'yesterday')");
        this.runStatementOnDriver("alter table mydb1.tbl3 PARTITION(ds='today') compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        SessionState.get().setCurrentDatabase("mydb1");
        List<String> r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb1 STATUS 'initiated'");
        Assert.assertEquals((long)3L, (long)r.size());
        List compIdsToAbort = r.stream().skip(1L).map(x -> x.split("\t")[0]).collect(Collectors.toList());
        String abortCompactionCmd = "ABORT COMPACTIONS " + (String)compIdsToAbort.get(0) + "\t" + (String)compIdsToAbort.get(1);
        r = this.runStatementOnDriver(abortCompactionCmd);
        Assert.assertEquals((long)3L, (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tStatus\tMessage", (Object)r.get(0));
        Assert.assertTrue((boolean)r.get(1).contains("Successfully aborted compaction"));
        Assert.assertTrue((boolean)r.get(2).contains("Successfully aborted compaction"));
        abortCompactionCmd = "ABORT COMPACTIONS " + (String)compIdsToAbort.get(0) + "\t" + (String)compIdsToAbort.get(1);
        r = this.runStatementOnDriver(abortCompactionCmd);
        Assert.assertEquals((long)3L, (long)r.size());
        Assert.assertEquals((Object)"CompactionId\tStatus\tMessage", (Object)r.get(0));
        Assert.assertTrue((boolean)r.get(1).contains("Error"));
        r = this.runStatementOnDriver("SHOW COMPACTIONS SCHEMA mydb1 STATUS 'aborted'");
        Assert.assertEquals((long)3L, (long)r.size());
    }

    private void setUpCompactionRequestsData(String dbName, String tbName) throws Exception {
        this.runStatementOnDriver("drop database if exists " + dbName);
        this.runStatementOnDriver("create database " + dbName);
        this.runStatementOnDriver("create table " + dbName + "." + tbName + " (a int, b int) partitioned by (ds String)  stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into " + dbName + "." + tbName + " PARTITION (ds)  values(1,2,'mon'),(3,4,'mon'),(1,2,'tue'),(3,4,'tue'),(1,2,'wed'),(3,4,'wed')");
    }

    private void executeCompactionRequest(String dbName, String tbName, String compactiontype, String partition) throws Exception {
        this.runStatementOnDriver("alter table " + dbName + "." + tbName + " PARTITION (" + partition + ") compact '" + compactiontype + "'");
        TestTxnCommands2.runWorker(this.hiveConf);
    }

    @Test
    public void testFetchTaskCachingWithConversion() throws Exception {
        this.dropTables("fetch_task_table");
        ArrayList actualRes = new ArrayList();
        this.runStatementOnDriver("create table fetch_task_table (a INT, b INT) stored as orc tblproperties ('transactional'='true')");
        this.runStatementOnDriver("insert into table fetch_task_table values (1,2), (3,4), (5,6)");
        List<String> expectedRes = this.runStatementOnDriver("select * from fetch_task_table");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_FETCH_TASK_CACHING, true);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, "none");
        this.d.run("select * from fetch_task_table");
        Assert.assertFalse((boolean)this.d.getFetchTask().isCachingEnabled());
        this.d.getFetchTask().fetch(actualRes);
        Assert.assertEquals(actualRes, expectedRes);
        actualRes.clear();
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, "more");
        this.d.run("select * from fetch_task_table");
        Assert.assertTrue((boolean)this.d.getFetchTask().isCachingEnabled());
        this.d.getFetchTask().fetch(actualRes);
        Assert.assertEquals(actualRes, expectedRes);
    }

    public static class DummyMetaStoreFilterHookImpl
    extends DefaultMetaStoreFilterHookImpl {
        private static boolean blockResults = false;

        public DummyMetaStoreFilterHookImpl(Configuration conf) {
            super(conf);
        }

        public List<String> filterTableNames(String catName, String dbName, List<String> tableList) {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return tableList;
        }
    }

    private static final class QueryRunnable
    implements Runnable {
        private final CountDownLatch cdlIn;
        private final CountDownLatch cdlOut;
        private final String query;
        private final HiveConf hiveConf;

        QueryRunnable(HiveConf hiveConf, String query, CountDownLatch cdlIn, CountDownLatch cdlOut) {
            this.query = query;
            this.cdlIn = cdlIn;
            this.cdlOut = cdlOut;
            this.hiveConf = new HiveConf(hiveConf);
            this.hiveConf.unset(HiveConf.ConfVars.HIVE_SESSION_ID.varname);
        }

        @Override
        public void run() {
            SessionState ss = SessionState.start((HiveConf)this.hiveConf);
            try {
                ss.applyAuthorizationPolicy();
            }
            catch (HiveException e) {
                throw new RuntimeException(e);
            }
            QueryState qs = new QueryState.Builder().withHiveConf(this.hiveConf).nonIsolated().build();
            try (Driver d = new Driver(qs);){
                LOG.info("Ready to run the query: " + this.query);
                TestTxnCommands.syncThreadStart(this.cdlIn, this.cdlOut);
                try {
                    try {
                        d.run(this.query);
                    }
                    catch (CommandProcessorException e) {
                        throw new RuntimeException(this.query + " failed: " + e);
                    }
                    d.getResults(new ArrayList());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

