/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.apache.hadoop.hive.ql.reexec.ReExecDriver;
import org.apache.hadoop.hive.ql.reexec.ReExecutionStrategyType;
import org.junit.Assert;
import org.junit.Test;

public class TestDriverFactory {
    @Test
    public void testNormal() {
        HiveConf conf = new HiveConf();
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        ReExecDriver reDriver = (ReExecDriver)driver;
        List<IReExecutionPlugin> plugins = this.getPlugins(conf);
        for (IReExecutionPlugin original : plugins) {
            boolean found = false;
            for (IReExecutionPlugin instance : reDriver.getPlugins()) {
                if (!original.getClass().getName().equals(instance.getClass().getName())) continue;
                found = true;
            }
            if (found) continue;
            Assert.fail((String)"The ReExecutionPlugin defined has not been instantiated");
        }
    }

    @Test(expected=RuntimeException.class)
    public void testNormalFailed() {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, "overlay,reoptimize,reexecute_lost_am,dagsubmit,test");
        DriverFactory.newDriver((HiveConf)conf);
    }

    @Test
    public void testNormalAndCustom() {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, "overlay,reoptimize,reexecute_lost_am,dagsubmit,org.apache.hadoop.hive.ql.reexec.ReCompileWithoutCBOPlugin,org.apache.hadoop.hive.ql.reexec.ReExecuteOnWriteConflictPlugin");
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        ReExecDriver reDriver = (ReExecDriver)driver;
        List<IReExecutionPlugin> plugins = this.getPlugins(conf);
        for (IReExecutionPlugin original : plugins) {
            boolean found = false;
            for (IReExecutionPlugin instance : reDriver.getPlugins()) {
                if (!original.getClass().getName().equals(instance.getClass().getName())) continue;
                found = true;
            }
            if (found) continue;
            Assert.fail((String)"The ReExecutionPlugin defined has not been instantiated");
        }
    }

    @Test(expected=RuntimeException.class)
    public void testCustomNotInstanceOfIReExecutionPlugin() {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, "overlay,reoptimize,reexecute_lost_am,dagsubmit,org.apache.hadoop.hive.conf.HiveConf");
        DriverFactory.newDriver((HiveConf)conf);
    }

    private List<IReExecutionPlugin> getPlugins(HiveConf conf) {
        String strategies = conf.getVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES);
        ArrayList<IReExecutionPlugin> plugins = new ArrayList<IReExecutionPlugin>();
        for (String string : strategies.split(",")) {
            if (string.trim().isEmpty()) continue;
            plugins.add(TestDriverFactory.buildReExecPlugin(string));
        }
        return plugins;
    }

    private static IReExecutionPlugin buildReExecPlugin(String name) throws RuntimeException {
        Class<IReExecutionPlugin> pluginType;
        try {
            pluginType = ReExecutionStrategyType.getPluginClassByName((String)name);
        }
        catch (IllegalArgumentException e) {
            try {
                Class<IReExecutionPlugin> cls = Class.forName(name);
                if (cls.isAssignableFrom(IReExecutionPlugin.class)) {
                    throw new RuntimeException("Not re-execution plugin: " + name);
                }
                pluginType = cls;
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException("Unknown re-execution plugin: " + name + " (" + HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES.varname + ")");
            }
        }
        try {
            return (IReExecutionPlugin)pluginType.getDeclaredConstructor(null).newInstance(null);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unknown re-execution plugin: " + name + " (" + HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES.varname + ")");
        }
    }
}

