/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDriver {
    private HiveConf conf;

    @Before
    public void beforeTest() {
        this.conf = new HiveConfForTest(this.getClass());
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        this.conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDriverContextQueryErrorMessageCompileTime() {
        SessionState.start((HiveConf)this.conf);
        try (Driver driver = this.getDriver();){
            driver.run("wrong sql command");
            Assert.fail((String)"Should have thrown an exception from compile time");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDriverContextQueryErrorMessageRuntime() {
        this.conf.setInt("tez.am.counters.max.keys", 0);
        SessionState.start((HiveConf)this.conf);
        try (Driver driver = this.getDriver();){
            driver.run("create table test_table (id int)");
            driver.run("select a.id from test_table a left outer join test_table b on a.id = b.id");
            Assert.fail((String)"Should have thrown an exception from runtime");
        }
    }

    @Test
    public void testResourceMapIsClearedAfterCloseInProcess() {
        SessionState sessionState = SessionState.start((HiveConf)this.conf);
        Driver driver = this.getDriver();
        QueryState queryState = driver.getQueryState();
        String queryId = queryState.getQueryId();
        sessionState.addQueryState(queryState.getQueryId(), queryState);
        QueryState sessionQueryStateObject = SessionState.get().getQueryState(queryId);
        queryState.addResource("test_resource1", (Object)"test_value1");
        Assert.assertEquals((Object)"test_value1", (Object)driver.getQueryState().getResource("test_resource1"));
        driver.closeInProcess(false);
        Assert.assertEquals((Object)sessionQueryStateObject, (Object)driver.getQueryState());
        Assert.assertNull((Object)driver.getQueryState().getResource("test_resource1"));
    }

    private Driver getDriver() {
        QueryInfo queryInfo = new QueryInfo(null, null, null, null, null);
        return new Driver(new QueryState.Builder().withHiveConf(this.conf).build(), queryInfo, (HiveTxnManager)new DummyTxnManager());
    }
}

