/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.codahale.metrics.Counter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestCompileLock {
    private static final int CONCURRENT_COMPILATION = 15151;
    private static final String SHORT_QUERY = "<SHORT_QUERY>";
    private static final String LONG_QUERY = "<LONG_QUERY>";
    private Driver driver;
    private HiveConf conf;

    @Before
    public void init() throws Exception {
        this.conf = new HiveConf();
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED, true);
        this.conf.setVar(HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR, System.getProperty("java.io.tmpdir"));
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_SERVER2_COMPILE_LOCK_TIMEOUT, 15L, TimeUnit.SECONDS);
        MetricsFactory.close();
        MetricsFactory.init((Configuration)this.conf);
    }

    private void initDriver(HiveConf conf, int threadCount) throws Exception {
        this.driver = (Driver)Mockito.spy((Object)new Driver(conf));
        this.resetParallelCompilationLimit(conf);
        AtomicInteger count = new AtomicInteger(threadCount);
        ((Driver)Mockito.doAnswer(invocation -> {
            Thread.sleep(500L);
            this.verifyThatWaitingCompileOpsCountIsEqualTo(count.decrementAndGet());
            return null;
        }).when((Object)this.driver)).compile((String)ArgumentMatchers.eq((Object)SHORT_QUERY), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false));
        ((Driver)Mockito.doAnswer(invocation -> {
            Thread.sleep(5000L);
            this.verifyThatWaitingCompileOpsCountIsEqualTo(count.decrementAndGet());
            return null;
        }).when((Object)this.driver)).compile((String)ArgumentMatchers.eq((Object)LONG_QUERY), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testSerializableCompilation() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION, false);
        this.initDriver(this.conf, 10);
        List<Integer> responseList = this.compileAndRespond(10);
        this.verifyThatWaitingCompileOpsCountIsEqualTo(0L);
        this.verifyThatTimedOutCompileOpsCountIsZero(responseList);
        this.verifyThatNoConcurrentCompilationWasIndeed(responseList);
    }

    @Test
    public void testParallelCompilationWithSingleQuota() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION, true);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT, 1);
        this.initDriver(this.conf, 10);
        List<Integer> responseList = this.compileAndRespond(10);
        this.verifyThatWaitingCompileOpsCountIsEqualTo(0L);
        this.verifyThatTimedOutCompileOpsCountIsZero(responseList);
        this.verifyThatNoConcurrentCompilationWasIndeed(responseList);
    }

    @Test
    public void testParallelCompilationWithUnboundedQuota() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION, true);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT, -1);
        this.initDriver(this.conf, 10);
        List<Integer> responseList = this.compileAndRespond(10);
        this.verifyThatWaitingCompileOpsCountIsEqualTo(0L);
        this.verifyThatTimedOutCompileOpsCountIsZero(responseList);
        this.verifyThatConcurrentCompilationWasIndeed(responseList);
    }

    @Test
    public void testParallelCompilationWithUnboundedQuotaAndSingleSession() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION, true);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT, -1);
        this.initDriver(this.conf, 10);
        List<Integer> responseList = this.compileAndRespond(true, 10);
        this.verifyThatWaitingCompileOpsCountIsEqualTo(0L);
        this.verifyThatTimedOutCompileOpsCountIsZero(responseList);
        this.verifyThatNoConcurrentCompilationWasIndeed(responseList);
    }

    @Test
    public void testParallelCompilationTimeoutWithSingleQuota() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION, true);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT, 1);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_SERVER2_COMPILE_LOCK_TIMEOUT, 1L, TimeUnit.SECONDS);
        this.initDriver(this.conf, 10);
        List<Integer> responseList = this.compileAndRespond(10);
        this.verifyThatWaitingCompileOpsCountIsEqualTo(0L);
        this.verifyThatTimedOutCompileOpsCountIsNotZero(responseList);
    }

    @Test
    public void testParallelCompilationTimeoutWithMultipleQuota() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION, true);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT, 4);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_SERVER2_COMPILE_LOCK_TIMEOUT, 1L, TimeUnit.SECONDS);
        this.initDriver(this.conf, 10);
        List<Integer> responseList = this.compileAndRespond(LONG_QUERY, 10);
        this.verifyThatWaitingCompileOpsCountIsEqualTo(0L);
        this.verifyThatTimedOutCompileOpsCount(responseList, 6);
    }

    @Test
    public void testParallelCompilationWithSingleQuotaAndZeroTimeout() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION, true);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT, 1);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_SERVER2_COMPILE_LOCK_TIMEOUT, 0L, TimeUnit.SECONDS);
        this.initDriver(this.conf, 10);
        List<Integer> responseList = this.compileAndRespond(10);
        this.verifyThatWaitingCompileOpsCountIsEqualTo(0L);
        this.verifyThatTimedOutCompileOpsCountIsZero(responseList);
        this.verifyThatNoConcurrentCompilationWasIndeed(responseList);
    }

    @Test
    public void testParallelCompilationWithMultipleQuotas() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION, true);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT, 2);
        this.initDriver(this.conf, 10);
        List<Integer> responseList = this.compileAndRespond(10);
        this.verifyThatWaitingCompileOpsCountIsEqualTo(0L);
        this.verifyThatTimedOutCompileOpsCountIsZero(responseList);
        this.verifyThatConcurrentCompilationWasIndeed(responseList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelCompilationWithMultipleQuotasAndClientSessionConcurrency() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION, true);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT, 2);
        this.initDriver(this.conf, 10);
        ArrayList<Integer> responseList = new ArrayList<Integer>();
        ArrayList<Callable<List>> callables = new ArrayList<Callable<List>>();
        for (int i = 0; i < 5; ++i) {
            callables.add(() -> this.compileAndRespond(true, 2));
        }
        ExecutorService pool = Executors.newFixedThreadPool(callables.size());
        try {
            List futures = pool.invokeAll(callables);
            for (Future future : futures) {
                responseList.addAll((Collection)future.get());
            }
        }
        finally {
            pool.shutdown();
        }
        this.verifyThatWaitingCompileOpsCountIsEqualTo(0L);
        this.verifyThatTimedOutCompileOpsCountIsZero(responseList);
        this.verifyThatConcurrentCompilationWasIndeed(responseList);
    }

    private List<Integer> compileAndRespond(int threadCount) throws Exception {
        return this.compileAndRespond(SHORT_QUERY, false, threadCount);
    }

    private List<Integer> compileAndRespond(boolean reuseSession, int threadCount) throws Exception {
        return this.compileAndRespond(SHORT_QUERY, reuseSession, threadCount);
    }

    private List<Integer> compileAndRespond(String query, int threadCount) throws Exception {
        return this.compileAndRespond(query, false, threadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> compileAndRespond(String query, boolean reuseSession, int threadCount) throws Exception {
        ArrayList<Integer> responseList = new ArrayList<Integer>();
        SessionState sessionState = new SessionState(this.conf);
        ArrayList<Callable<CommandProcessorResponse>> callables = new ArrayList<Callable<CommandProcessorResponse>>();
        for (int i = 0; i < threadCount; ++i) {
            callables.add(() -> {
                CommandProcessorResponse response;
                SessionState ss = reuseSession ? sessionState : new SessionState(this.conf);
                SessionState.setCurrentSessionState((SessionState)ss);
                try {
                    response = this.driver.compileAndRespond(query);
                }
                finally {
                    SessionState.detachSession();
                }
                return response;
            });
        }
        ExecutorService pool = Executors.newFixedThreadPool(callables.size());
        try {
            List futures = pool.invokeAll(callables);
            for (Future future : futures) {
                try {
                    future.get();
                    responseList.add(0);
                }
                catch (ExecutionException ex) {
                    responseList.add(ex.getCause() instanceof CommandProcessorException ? ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCode() : 15151);
                }
            }
        }
        finally {
            pool.shutdown();
        }
        return responseList;
    }

    private void resetParallelCompilationLimit(HiveConf conf) throws Exception {
        Object compileLock = TestCompileLock.createEnumInstance("instance", Class.forName("org.apache.hadoop.hive.ql.lock.CompileLockFactory$SessionWithQuotaCompileLock"));
        Field field = compileLock.getClass().getDeclaredField("globalCompileQuotas");
        field.setAccessible(true);
        int compileLimit = conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT);
        field.set(compileLock, new Semaphore(compileLimit));
    }

    private static <T extends Enum<T>> T createEnumInstance(String name, Type type) {
        return Enum.valueOf((Class)type, name);
    }

    private void verifyThatTimedOutCompileOpsCountIsZero(List<Integer> responseList) {
        this.verifyErrorCount(ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCode(), (Matcher<Integer>)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)), responseList);
    }

    private void verifyThatTimedOutCompileOpsCountIsNotZero(List<Integer> responseList) {
        this.verifyErrorCount(ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCode(), (Matcher<Integer>)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0))), responseList);
    }

    private void verifyThatTimedOutCompileOpsCount(List<Integer> responseList, int count) {
        this.verifyErrorCount(ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCode(), (Matcher<Integer>)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)count)), responseList);
    }

    private void verifyThatConcurrentCompilationWasIndeed(List<Integer> responseList) {
        this.verifyErrorCount(15151, (Matcher<Integer>)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0))), responseList);
    }

    private void verifyThatNoConcurrentCompilationWasIndeed(List<Integer> responseList) {
        this.verifyErrorCount(15151, (Matcher<Integer>)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)), responseList);
    }

    private void verifyErrorCount(int code, Matcher<Integer> matcher, List<Integer> responseList) {
        int count = 0;
        for (Integer response : responseList) {
            if (code != response) continue;
            ++count;
        }
        Assert.assertThat((Object)count, matcher);
    }

    private void verifyThatWaitingCompileOpsCountIsEqualTo(long count) {
        Counter counter = this.getCounter("waiting_compile_ops");
        Assert.assertNotNull((Object)counter);
        Assert.assertThat((Object)counter.getCount(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)count)));
    }

    private Counter getCounter(String counter) {
        CodahaleMetrics metrics = (CodahaleMetrics)MetricsFactory.getInstance();
        SortedMap counters = metrics.getMetricRegistry().getCounters();
        Assert.assertNotNull((Object)counters);
        return (Counter)counters.get(counter);
    }
}

