/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.Collections;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnHandlerWithOneConnection {
    private static final String CLASS_NAME = TxnHandler.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private HiveConf conf = new HiveConf();
    private TxnStore txnHandler;

    public TestTxnHandlerWithOneConnection() throws Exception {
        TestTxnDbUtil.setConfValues((org.apache.hadoop.conf.Configuration)this.conf);
        TestTxnDbUtil.prepDb((org.apache.hadoop.conf.Configuration)this.conf);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration conf = ctx.getConfiguration();
        conf.getLoggerConfig(CLASS_NAME).setLevel(Level.DEBUG);
        ctx.updateLoggers(conf);
        this.tearDown();
    }

    @Test
    public void testGetValidWriteIds() throws Exception {
        GetValidWriteIdsRequest req = new GetValidWriteIdsRequest();
        req.setFullTableNames(Collections.singletonList("foo.bar"));
        this.txnHandler.getValidWriteIds(req);
    }

    @Before
    public void setUp() throws Exception {
        MetastoreConf.setLongVar((org.apache.hadoop.conf.Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_MAX_CONNECTIONS, (long)1L);
        String CONNECTION_TIMEOUT_PROPERTY = "hikaricp.connectionTimeout";
        this.conf.setLong(CONNECTION_TIMEOUT_PROPERTY, 250L);
        this.txnHandler = TxnUtils.getTxnStore((org.apache.hadoop.conf.Configuration)this.conf);
    }

    @After
    public void tearDown() throws Exception {
        TestTxnDbUtil.cleanDb((org.apache.hadoop.conf.Configuration)this.conf);
    }
}

