/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnHandlerNoConnectionPool {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestTxnHandlerNoConnectionPool.class.getName());
    private HiveConf conf = new HiveConf();
    private TxnStore txnHandler;

    @Before
    public void setUp() throws Exception {
        this.conf.setVar(HiveConf.ConfVars.METASTORE_CONNECTION_POOLING_TYPE, "None");
        TestTxnDbUtil.setConfValues((Configuration)this.conf);
        TestTxnDbUtil.prepDb((Configuration)this.conf);
        this.txnHandler = TxnUtils.getTxnStore((Configuration)this.conf);
    }

    @After
    public void tearDown() throws Exception {
        TestTxnDbUtil.cleanDb((Configuration)this.conf);
    }

    @Test
    public void testOpenTxn() throws Exception {
        long first = this.openTxn();
        Assert.assertEquals((long)1L, (long)first);
        long second = this.openTxn();
        Assert.assertEquals((long)2L, (long)second);
        GetOpenTxnsInfoResponse txnsInfo = this.txnHandler.getOpenTxnsInfo();
        Assert.assertEquals((long)2L, (long)txnsInfo.getTxn_high_water_mark());
        Assert.assertEquals((long)2L, (long)txnsInfo.getOpen_txns().size());
        Assert.assertEquals((long)1L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getId());
        Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(0)).getState());
        Assert.assertEquals((long)2L, (long)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getId());
        Assert.assertEquals((Object)TxnState.OPEN, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getState());
        Assert.assertEquals((Object)"me", (Object)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getUser());
        Assert.assertEquals((Object)"localhost", (Object)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getHostname());
        GetOpenTxnsResponse txns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)2L, (long)txns.getTxn_high_water_mark());
        Assert.assertEquals((long)2L, (long)txns.getOpen_txns().size());
        boolean[] saw = new boolean[3];
        for (int i = 0; i < saw.length; ++i) {
            saw[i] = false;
        }
        for (Long tid : txns.getOpen_txns()) {
            saw[tid.intValue()] = true;
        }
        for (int i = 1; i < saw.length; ++i) {
            Assert.assertTrue((boolean)saw[i]);
        }
    }

    private long openTxn() throws MetaException {
        List txns = this.txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost")).getTxn_ids();
        return (Long)txns.get(0);
    }
}

